#include "testprog.h"
#include <TelepathyQt4/Message>

TestProg::TestProg(QString addr,QString msg)
{
    qDebug() << __PRETTY_FUNCTION__ ;
  message=msg;
  address=addr;
  tps =new TpSession("ring");
  connect(tps,SIGNAL(accountReady(TpSessionAccount *)),SLOT(onAccountReady(TpSessionAccount *)));
  connect(tps,SIGNAL(messageReceived(const Tp::ReceivedMessage &,TpSessionAccount *)),
                SLOT(onMessageReceived(const Tp::ReceivedMessage &,TpSessionAccount *)));
}

void TestProg::onAccountReady(TpSessionAccount *tpsa)
{
    qDebug() << __PRETTY_FUNCTION__ ;
    tpsa->sendMessageToAddress(address,message);
};

void TestProg::onMessageReceived(const Tp::ReceivedMessage &msg,TpSessionAccount *acc)
{
    qDebug() << "TestProg::onMessageReceived " << msg.text() << "from " << msg.sender()->id();
}
