#include <QtGui/QApplication>
#include <QtSql>
QSqlDatabase db;
QString base_path;
#include "mainwindow.h"


MainWindow *w;
int main(int argc, char *argv[])
{
    QApplication app(argc, argv);
    QCoreApplication::setApplicationName("TPlayer");
    QCoreApplication::setApplicationVersion("0.0.2beta");


#ifdef Q_WS_MAEMO_5
base_path="/home/user/";
#else
#ifdef Q_OS_WIN32
base_path=qApp->applicationDirPath()+"/";
#else
#ifdef Q_WS_S60
base_path="/data/tplayer/";
#else
base_path="/usr/share/tplayer/";
#endif
#endif
#endif


db = QSqlDatabase::addDatabase("QSQLITE");
db.setDatabaseName(base_path+"tplayer-list");

if(!db.open()){
    QMessageBox::critical(0, QObject::tr("Database Error"),db.lastError().text());
    qApp->quit();
}

QStringList dbtables = db.tables(QSql::Tables);

  if (!dbtables.contains("tracks",Qt::CaseInsensitive)) {

 QSqlQuery sql = QSqlQuery(db);
 sql.exec(
              "create table tracks ( "
              "  path char(255) not null unique, "
              "  title char(255) , "
              "  artist char(255) , "
              "  genre char(255) , "
              "  album char(255) , "
              "  year char(255)  )" );
}

 if (!dbtables.contains( "settings",Qt::CaseInsensitive)) {

 QSqlQuery sql = QSqlQuery(db);
 sql.exec(
              "create table settings ( "
              "  parameter char(255) not null unique, "
              "  value char(255) , "
              "  custom1 char(255) , "
              "  custom2 char(255)  )" );
}

 // for next revision
/*
if (!dbtables.contains( "iradio",Qt::CaseInsensitive)) {

 QSqlQuery sql = QSqlQuery(db);
 sql.exec(
              "create table iradio ( "
              "  url char(255) not null unique, "
              "  title char(255) , "
              "  genre char(255) , "
              "  bitrate char(255) , "
              "  language char(255)  )" );
}*/


 w=new MainWindow();





#ifndef Q_WS_MAEMO_5
    w->show();
    w->resize(800,460);
    w->move(0,0);
#else
    w->showFullScreen();
#endif
//
    return app.exec();

}


QString get_setting(QString set){
    QString ret_val="";
    QString sql="SELECT * FROM `settings` WHERE `parameter`='"+set+"'";
    QSqlQuery query(sql);
    int fieldNo = query.record().indexOf("value");
         while (query.next()) {
             ret_val = query.value(fieldNo).toString();
         }

    return ret_val;
}


void set_setting(QString set,QString value){

    QString sql="DELETE FROM `settings` WHERE `parameter`='"+set+"'";
    db.exec(sql);
    sql="INSERT INTO `settings` (parameter,value,custom1,custom2) "
        "VALUES ('"+set+"','"+value.replace("'","''")+"','','')";

    db.exec(sql);

}
