<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" "http://www.w3.org/TR/1998/REC-html40-19980424/loose.dtd">
<html>
<head>
  <title>Tor: Instrucciones de Configuración de Servicios Ocultos</title>
  <meta name="Author" content="The Tor Project, Inc.">
  <meta http-equiv="content-type" content="text/html; charset=UTF-8">
  <link rel="stylesheet" type="text/css" href="../stylesheet-ltr.css">
  <link rel="shortcut icon" type="image/x-icon" href="../favicon.ico">
</head>
<body>
<div class="center">
<table class="banner" border="0" cellpadding="0" cellspacing="0" summary="">
    <tr>
        <td class="banner-left"><a href="https://www.torproject.org/"><img src="../images/top-left.png" alt="Click to go to home page" width="193" height="79"></a></td>
        <td class="banner-middle">
	<a href="../index.html.es">Principal</a>
<a href="../overview.html.es">Perspectiva</a>
<a href="../download.html.es">Descarga</a>
<a href="../documentation.html.es">Documentación</a>
<a href="../volunteer.html.es">Colabora</a>
<a href="../people.html.es">Gente</a>
<a href="https://blog.torproject.org/">Blog</a>
<a href="../donate.html.es">¡Dona!</a>
        </td>
    </tr>
</table>
<div class="center">
<div class="main-column">
<h1>Configurar Servicios Ocultos para <a href="../index.html.es">Tor</a></h1>
<hr>
<p>Tor permite a los clientes y a los repetidores que ofrezcan servicios ocultos.
Eso significa que puede ofrecer un servidor web, servidor SSH, etc., sin revelar
su dirección IP a sus usuarios. De hecho, como no se usa ninguna dirección pública,
puedes ejecutar un servicio oculto desde detrás de un cortafuegos.
</p>
<p>Si tiene Tor y Privoxy instalado, puede ver los servicios ocultos
en acción visitando <a href="http://duskgytldkxiuqc6.onion/">un ejemplo de
servicio oculto</a>.
</p>
<p>Este howto describe los pasos para configurar tu propio sitio web en
un servicio oculto.
</p>
<hr>
<a id="zero"></a>
<h2><a class="anchor" href="#zero">Paso Cero: Hacer que Tor y Privoxy funcionen</a></h2>
<br>
<p>Antes de empezar, necesitará asegurarse de que: </p>
<ol>
<li>Tor está activo y ejecutándose,</li>
<li>Privoxy está activo y ejecutándose,</li>
<li>Privoxy está configurado para apuntar a Tor, y </li>
<li>Lo ha configurado correctamente.</li>
</ol>
<p>Los usuarios de Windows deberían seguir el <a
href="../docs/tor-doc-windows.html.es">howto para Windows
</a>, Los usuarios de OS X deberían seguir el <a
href="../docs/tor-doc-osx.html.es">howto para OS
X</a>, y los usuarios de Linux/BSD/Unix deberían seguir el <a
href="../docs/tor-doc-unix.html.es">howto para Unix</a>.
</p>
<p>Una vez que tenga Tor y Privoxy instalados y configurados,
puede ver los servicios ocultos en acción siguiendo este enlace a <a
href="http://duskgytldkxiuqc6.onion/">un ejemplo de servicio oculto</a>.
Tardará típicamente 10-60 segundos en cargarse
(o en decidir que no se puede acceder por el momento). Si falla
inmediatamente y tu navegador muestra una alerta diciendo que
"www.duskgytldkxiuqc6.onion no se encontró, compruebe por favor el nombre e
inténtelo de nuevo" no ha configurado Tor y Privoxy correctamente; vea <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#ItDoesntWork">la
entrada Tor-o-Privoxy-no-funcionan de la FAQ</a> para ayuda.
</p>
<hr>
<a id="one"></a>
<h2><a class="anchor" href="#one">Paso Uno: Instalar un servidor web localmente</a></h2>
<br>
<p>Primero, necesitará configurar un servidor web localmente. Configurar un
servidor web puede ser complicado,
así que sólo explicaremos algunas cosas básicas. Si se atranca o
quiere hacer más, busque un amigo que pueda ayudarle. Recomendamos que
instale un nuevo servidor web separado para su servicio oculto, ya que
incluso si ya tiene uno instalado, puede estar usándolo (o querer usarlo
más tarde) para un sitio web real.
</p>
<p>Si está en Unix u OS X y está cómodo en la línea de órdenes,
la mejor forma con diferencia es instalar <a
href="http://www.acme.com/software/thttpd/">thttpd</a>. Coja el último
fichero tar, descomprímalo (creará su propio directorio), y ejecute
<kbd>./configure &amp;&amp; make</kbd>. Luego <kbd>mkdir hidserv; cd
hidserv</kbd>, y ejecute
<kbd>../thttpd -p 5222 -h localhost</kbd>. Volverá a la línea de órdenes,
y ya está usted ejecutando un servidor web en el puerto 5222. Puede poner
ficheros para servir en el directorio hidserv.
</p>
<p>Si está en Windows, podría elegir <a
href="http://savant.sourceforge.net/">Savant</a> o <a
href="http://httpd.apache.org/">Apache</a>, y asegúrese de configurarlo
para que escuche sólo a localhost. También debería averiguar en que
puerto está escuchando, porque lo usará más abajo.
</p>
<p>(La razón de que el servidor web sólo escuche a localhost es para
asegurarse de que no es accesible públicamente. Si la gente
pudiera conectarse a él directamente, podrían confirmar que su
ordenador es el que está ofreciendo el servicio oculto.)
</p>
<p>Una vez que tenga su servidor web configurado, asegúrese de que funciona:
abra su navegador y vaya a <a
href="http://localhost:5222/">http://localhost:5222/</a>, donde 5222 es
el puerto que eligió antes. Intente poner un fichero en el directorio html
principal, y asegúrese de que aparece cuando accede al sitio.
</p>
<hr>
<a id="two"></a>
<h2><a class="anchor" href="#two">Paso Dos: Configure su servicio oculto</a></h2>
<br>
<p>Para lo siguiente, necesita configurar su servicio oculto para que apunte
a su servidor web local.
</p>
<p>Primero, abra su fichero torrc en su editor de texto favorito. (Vea <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#torrc">la
entrada de la FAQ torrc</a> para aprender lo que esto significa.)
Vaya a la sección del medio y busque la línea</p>
<pre>
############### This section is just for location-hidden services ###
</pre>
<p>
Esta sección del fichero consiste en grupos de líneas, cada una representando
un servicio oculto. Ahora mismo están todas comentadas (las líneas comienzan con
consiste en una línea <var>HiddenServiceDir</var>, y una o más líneas
<var>HiddenServicePort</var>:</p>
<ul>
<li><var>HiddenServiceDir</var> es un directorio donde Tor almacenará información
acerca de ese servicio oculto. En particular, Tor creará un fichero aquí de
nombre <var>hostname</var> que le dirá la URL onion. No necesita añadir ningún
fichero a este directorio.</li>
<li><var>HiddenServicePort</var> le permite especificar un puerto virtual (eso es, qué
puerto creerán que están usando la gente que acceda al servicio oculto) y una
dirección IP y puerto para redireccionar conexiones a este puerto virtual.</li>
</ul>
<p>Añada las siguientes líneas a su torrc:
</p>
<pre>
HiddenServiceDir /Library/Tor/var/lib/tor/hidden_service/
HiddenServicePort 80 127.0.0.1:5222
</pre>
<p>Querrá cambiar la línea <var>HiddenServiceDir</var>, para que apunte
a un directorio real que sea legible/escribible por el usuario que
ejecutará Tor. La línea anterior debería funcionar si está usando el
paquete Tor para OS X. En Unix, pruebe "/home/username/hidserv/" y complete su propio
nombre de usuario en lugar de "username". En Windows puede escoger:</p>
<pre>
HiddenServiceDir C:\Documents and Settings\username\Application Data\hidden_service\
HiddenServicePort 80 127.0.0.1:5222
</pre>
<p>Ahora grabe el torrc, apague su Tor, e inícielo de nuevo.
</p>
<p>Si tor reinicia, estupendo. En caso contrario, algo está mal. Primero
mire los logs de tor para consejos. Mostrará algunos mensajes con advertencias
o errores. Eso debería darle alguna idea de qué está mal. Lo típico es que haya
palabras mal escritas o permisos erróneos en los directorios. (Vea <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#Logs">la
entrada FAQ sobre log</a> si no está seguro de cómo activar o encontrar
su fichero de log.)
</p>
<p>Cuando Tor arranque, automáticamente creará el <var>HiddenServiceDir</var>
que especificó (en caso necesario), y creará dos ficheros allí.</p>
<dl>
<dt><var>private_key</var></dt>
<dd>
Primero, Tor generará una pareja de llaves pública/privada para su servicio
oculto. Se escribe en un fichero llamado "private_key". No comparta esta
clave con otros -- si lo hace podrán impersonar su servicio oculto.
</dd>
<dt><var>hostname</var></dt>
<dd>El otro fichero que Tor creará se llama "hostname". Contiene un pequeño
resumen de su llave pública -- parecerá algo como
<tt>duskgytldkxiuqc6.onion</tt>. Este es el nombre público de su servicio,
y puede decírselo a la gente, publicarlo en sitios web, ponerlo en tarjetas
de visita, etc.</dd>
</dl>
<p>Si Tor se ejecuta como un usuario diferente de usted, por
ejemplo en OS X, Debian, o Red Hat, puede que necesite hacerse root para
poder ver esos ficheros.</p>
<p>Ahora que ha reiniciado Tor, está ocupado eligiendo puntos de introducción en
la red Tor, y generando lo que se llama un <em>descriptor de servicio oculto</em>.
Esto es una lista firmada de puntos de introducción junto con la llave pública
completa del servicio. Publica anónimamente este descriptor a los servidores
de directorio, y otra gente lo obtiene anónimamente de los servidores de
directorio cuando intentan acceder a su servicio.
</p>
<p>Pruebe ahora: pegue el contenido del fichero hostname en tu navegador
web. Si funciona, obtendrá la página html que configuró en el paso uno.
Si no funciona, mire en sus logs buscando sugerencias, y siga jugando con
él hasta que funcione.
</p>
<hr>
<a id="three"></a>
<h2><a class="anchor" href="#three">Paso Tres: Consejos más avanzados</a></h2>
<br>
<p>Si planea mantener su servicio disponible durante largo tiempo, puede que
quiera hacer una copia de seguridad del fichero <var>private_key</var> en alguna parte.
</p>
<p>Hemos evitado recomendar Apache antes, a) porque mucha gente podría
estar ya ejecutándolo para su servidor web público en su ordenador, y b)
porque es grande y tiene muchos sitios donde podría revelar su dirección
IP u otra información identificadora, por ejemplo en páginas 404. Para
la gente que necesite más funcionalidad, sin embargo, Apache puede ser la
respuesta correcta. ¿Puede alguien hacernos una lista de formas de bloquear
el Apache cuando se usa como servicio oculto? Savant probablemente también
tenga esos problemas también.
</p>
<p>Si quiere redireccionar múltiples puertos virtuales para un mismo servicio
oculto, simplemente añada más líneas <var>HiddenServicePort</var>.
Si quiere ejecutar múltiples servicios ocultos desde el mismo cliente Tor,
simplemente añada otra línea <var>HiddenServiceDir</var>. Todas las líneas
<var>HiddenServicePort</var> subsiguientes se refieren a esta línea <var>HiddenServiceDir</var>, hasta
que añada otra línea <var>HiddenServiceDir</var>:
</p>
<pre>
HiddenServiceDir /usr/local/etc/tor/hidden_service/
HiddenServicePort 80 127.0.0.1:8080

HiddenServiceDir /usr/local/etc/tor/other_hidden_service/
HiddenServicePort 6667 127.0.0.1:6667
HiddenServicePort 22 127.0.0.1:22
</pre>
<p>Hay algunas consideraciones de anonimato que debería tener en cuenta también:
</p>
<ul>
<li>Como se mencionó antes, tenga cuidado de dejar que su servidor web
revele información identificatiba sobre usted, su ordenador, o su posición.
Por ejemplo, los lectores pueden probablemente determinar si es thttpd o
Apache, y aprender algo acerca de su sistema operativo.</li>
<li>Si su ordenador no está online todo el tiempo, su servicio oculto
tampoco lo estará. Esto filtra información a un adversario observador.</li>
<!-- increased risks over time -->
</ul>
<hr>
<p>Si tiene sugerancias para mejorar este documento, por favor <a
href="../contact.html.es">envíenoslas</a>. ¡Gracias!</p>
  </div><!-- #main -->
</div>
</div>
  <div class="bottom" id="bottom">
     <p>
     <i><a href="../contact.html.es" class="smalllink">Webmaster</a></i> -
      Última modificación: Wed Jan 27 07:52:55 2010
      -
      Última compilación: Mon Mar 15 18:33:18 2010
     </p>
<p>"Tor" y el "Logo de la Cebolla" son <a href="../trademark-faq.html.es">
marcas registradas</a> de El Proyecto Tor, S.A.
</p>
     <p>
	Aviso: Esta traducción podría estar obsoleta. La revisión original en inglés es la
      21511 mientras que esta revisión está basada en la
      13768.
     </p>
     <p>
	Esta página también está disponible en los siguientes idiomas:
           <a href="tor-hidden-service.html.de">Deutsch</a>, <a href="tor-hidden-service.html.en">English</a>, <a href="tor-hidden-service.html.fr">fran&ccedil;ais</a>, <a href="tor-hidden-service.html.it">Italiano</a>, <a href="tor-hidden-service.html.pl">polski</a>, <a href="tor-hidden-service.html.ru">&#1056;&#1091;&#1089;&#1089;&#1082;&#1080;&#1081;&nbsp;(Russkij)</a>, <a href="tor-hidden-service.html.zh-cn">&#20013;&#25991;(&#31616;) (Simplified Chinese)</a>.<br>
       Cómo establecer <a href="http://www.debian.org/intro/cn#howtoset">el idioma por defecto del documento</a>.
     </p>
<p>Los desarrolladores de Tor no han revisado esta traduccion
en cuanto a exactitud o correcciones. Puede ser obsoleta o erronea.
La pagina oficial de Tor es la version en Ingles, disponible en
<a href="https://www.torproject.org/">https://www.torproject.org/</a>.
</p>
  </div>
</body>
</html>
