<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" "http://www.w3.org/TR/1998/REC-html40-19980424/loose.dtd">
<html>
<head>
  <title>Tor: MS Windows Install Instructions</title>
  <meta name="Author" content="The Tor Project, Inc.">
  <meta http-equiv="content-type" content="text/html; charset=UTF-8">
  <link rel="stylesheet" type="text/css" href="../stylesheet-ltr.css">
  <link rel="shortcut icon" type="image/x-icon" href="../favicon.ico">
</head>
<body>
<div class="center">
<table class="banner" border="0" cellpadding="0" cellspacing="0" summary="">
    <tr>
        <td class="banner-left"><a href="https://www.torproject.org/"><img src="../images/top-left.png" alt="Click to go to home page" width="193" height="79"></a></td>
        <td class="banner-middle">
	<a href="../index.html.ru">Главная</a>
<a href="../overview.html.ru">Обзор</a>
<a href="../easy-download.html.ru">Скачать</a>
<a href="../documentation.html.ru">Документация</a>
<a href="../volunteer.html">Добровольцы</a>
<a href="../people.html.ru">Люди</a>
<a href="https://blog.torproject.org/">Блог</a>
<a href="../donate.html.ru">Donate!</a>
        </td>
    </tr>
</table>
<div class="center">
<div class="main-column">
<h1>Работа с клиентом <a href="../index.html.ru">Tor</a> в операционных системах
Microsoft Windows</h1>
<br>
<p>
<b>Обратите внимание на то, что в этом тексте представлены инструкции по
установке клиента Tor в операционных системах Microsoft Windows (2000, XP,
Vista, 7, и Серверные Версии). Если вы хотите ретранслировать трафик для
других и, таким образом, поддержать рост сети (пожалуйста, сделайте это),
прочтите руководство<a href="../docs/tor-doc-relay.html.ru">Настройка
ретранслятора</a>.</b>
</p>
<p>Организация Freedom House (Дом Свободы) создала видео ролик, рассказывающий
о том, как установить Tor. Вы можете просмотреть его здесь: <a
href="http://tinyvid.tv/show/3lejztnthk2tm">TinyVid: Как установить Tor под
ОС Windows (на английском языке)</a>. Вам известно о наличии более
наглядного ролика или о переведенной на ваш язык версии? Сообщите нам!</p>
<div class="center">
<p><video id="v1" src="http://tinyvid.tv/file/3lejztnthk2tm.ogg" autobuffer="true" controls="controls"></video></p>
</div>
<hr> <a id="installing"></a>
<h2><a class="anchor" href="#installing">Шаг первый: Скачивание и Установка
Tor</a></h2>
<br>
<p>
Установочные пакеты для Microsoft Windows содержат <a href="../index.html.ru">Tor</a>, <a href="../vidalia/index.html">Vidalia</a> (графический
пользовательский интерфейс для Tor), <a
href="https://addons.mozilla.org/firefox/2275/">Torbutton</a> (плагин для
браузера Mozilla Firefox), и <a
href="http://www.pps.jussieu.fr/~jch/software/polipo/">Polipo</a> (веб
прокси), собранные в один пакет. Все четыре приложения пред-настроены для
совместной работы. Скачайте либо <a
href="../dist/vidalia-bundles/vidalia-bundle-0.2.1.24-0.2.7.exe">стабильную</a> либо <a
href="../dist/vidalia-bundles/vidalia-bundle-0.2.2.10-alpha-0.2.7.exe">экспериментальную</a> версию пакета
для Windows. Вы можете также ознакомиться с характеристиками нашего
программного обеспечения на <a href="../download.html.ru">странице закачек</a>.
</p>
<img alt="tor installer splash page"
src="../img/screenshot-win32-installer-splash.png" width="503" height="387">
<p>Если вы ранее уже установили Tor, Vidalia, или Polipo, вы можете отказаться
от установки любого из этих компонентов, как показано на рисунке ниже.
</p>
<img alt="select components to install"
src="../img/screenshot-win32-installer-components.png" width="501" height="386">
<p>После окончания процесса установки, все выбранные вами компоненты
автоматически будут запущены.
</p>
<p>Программа Tor устанавливается в качестве клиентской программы по
умолчанию. Она использует встроенный конфигурационный файл, и большинству
пользователей не придется изменять какие-либо настройки. Сейчас программа
Tor установлена.
</p>
<hr> <a id="using"></a>
<h2><a class="anchor" href="#using">Шаг второй: Настройка ваших приложений на
использование сервиса Tor</a></h2>
<br>
<p>После установки Tor и Polipo вам необходимо настроить ваши приложения на
работу через них. Первым делом нужно настроить ваш браузер (программа для
просмотра веб страниц).</p>
<p>Вам следует использовать Tor с браузером Firefox и дополнением Torbutton для
обеспечения наилучшей безопасности. Пакет установит для вас <a
href="https://addons.mozilla.org/firefox/2275/">плагин
Torbutton</a>. Перезапустите ваш браузер Firefox, и все настроено:
</p>
<img alt="Torbutton plugin for Firefox"
src="../img/screenshot-torbutton.png" border="1" width="161" height="78"> <br>
<p>
Если вы планируете использовать Firefox не на том компьютере, куда
установлен Tor, ознакомьтесь со <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#SocksListenAddress">Списком
часто задаваемых вопросов по использованию Tor на другом компьютере (FAQ for
running Tor on a different computer)</a>.
</p>
<p>Для "Торификации" других приложений, которые поддерживают HTTP прокси,
просто укажите им на Polipo (который расположен здесь: localhost порт
8118). Чтобы использовать SOCKS напрямую (для обмена мгновенными
сообщениями, Jabber, IRC, и т.д.), вы можете направить свое приложение на
Tor (localhost порт 9050), но прежде ознакомьтесь с содержимым<a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#SOCKSAndDNS">этого
Списка часто задаваемых вопросов</a>, чтобы узнать почему это может быть
опасно. Для настройки приложений, не поддерживающих ни SOCKS не HTTP,
обратите внимание на приложения SocksCap и <a
href="http://www.freecap.ru/">FreeCap</a>. (FreeCap - это бесплатное ПО;
SocksCap - платное.)</p>
<p>Чтобы получить информацию о том, как "Торифицировать" другие приложения,
ознакомьтесь с <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorifyHOWTO">Инструкцией
по "Торификации"</a>.
</p>
<hr> <a id="verify"></a>
<h2><a class="anchor" href="#verify">Шаг третий: Убедитесь в том, что все
работает корректно</a></h2>
<br>
<p>
Убедитесь, что приложение Vidalia запущено. Программа Vidalia использует
следующие индикаторы: маленькая зеленая луковица означает, что Tor работает
корректно; а черная перечеркнутая луковица означает, что Tor не работает. Вы
можете запустить или остановить работу Tor нажав правой кнопкой мыши по
иконке программы Vidalia, расположенной в системном трее и выбрав "Старт"
или "Стоп" из меню, как показано ниже:
</p>
<img alt="Vidalia Tray Icon" src="../img/screenshot-win32-vidalia.png" width="132" height="252">
<p>
Далее вам необходимо протестировать работу вашего браузера с Tor и
убедиться, что ваш IP-адрес анонимизирован (т.е. скрыт). Откройте страницу
<a href="https://check.torproject.org/">детектор Tor</a> и посмотрите,
подтверждается ли сайтом использование сервиса Tor. (Если сайт не работает,
обратитесь к <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#IsMyConnectionPrivate">содержимому
этого Списка часто задаваемых вопросов</a>, чтобы получить информацию о
других методах тестирования работы Tor.)
</p>
<p>Если у вас установлен персональный брандмауэр, который ограничивает
возможность подключения вашего компьютера к самому себе, убедитесь что вы
разрешили подключения локальных приложений к локальным портам 8118 и
9050. Если ваш брандмауэр блокирует исходящие подключения, измените
настройки так, чтобы он мог подключаться хотя бы к TCP портам 80 и 443, а
затем ознакомьтесь с <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#FirewalledClient">содержанием
этого списка часто задаваемых вопросов</a>.
</p>
<p>Если ничего из вышеперечисленного не помогло, обратитесь к <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#ItDoesntWork">содержанию
этого Списка часто задаваемых вопросов</a> для получения дополнительной
информации.</p>
<p>
Когда все заработало, узнайте больше о том <a href="../download.html.ru#Warning">что предлагает, и что не предлагает сервис Tor </a>.
</p>
<hr> <a id="server"></a> <a id="relay"></a>
<h2><a class="anchor" href="#relay">Шаг четвертый: Настройте ретранслятор
Tor</a></h2>
<br>
<p>Сеть Tor полагается на волонтеров, предоставляющих пропускную способность
своих компьютеров. Чем больше людей предоставляют ретрансляторы, тем быстрей
будет работать сеть Tor. Если у вас есть как минимум 20Кб/сек. в обоих
направлениях, пожалуйста поддержите Tor, настроив ретранслятор Tor. Мы
создали множество возможностей, делающих ретрансляторы Tor простыми и
удобными, включая ограничение предоставляемой пропускной способности,
правила вывода (с тем чтобы вы могли ограничить вашу незащищенность к
возможным жалобам), и поддержку динамических IP-адресов.</p>
<p>Наличие ретрансляторов в разных уголках сети Интернет - это то, что
обеспечивает безопасность пользователей Tor. <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#RelayAnonymity">Создавая
ретранслятор вы можете улучшить свою собственную анонимность</a>, так как
удаленные сайты не могут установить происхождение запроса, ведь он может
исходить как от вас, так и от других пользователей сети Tor, использующих
ваш ретранслятор.</p>
<p>Больше информации на эту тему можно получить из руководства <a href="../docs/tor-doc-relay.html.ru">Настройка ретранслятора</a>.</p>
<hr>
<p>Если у вас есть предложения по улучшению этого документа, пожалуйста <a
href="../contact.html.ru">отправьте их нам</a>. Спасибо!</p>
  </div>
<!-- #main -->
</div>
<hr>
</div>
  <div class="bottom" id="bottom">
     <p>"Tor" и "Onion Logo" &mdash; <a href="../trademark-faq.html">зарегистрированные торговые
     марки</a> Tor Project, Inc.
     <br>
     Содержимое сайта защищенo по условиям лицензии
     <a href="http://creativecommons.org/licenses/by/3.0/us/">Creative Commons Attribution 3.0 United States License
 	   <!--img alt="Creative Commons Attribution 3.0 United States License" style="border-width:0" src="../images/cc-by-us-80x15.png"--></a>, если явно не указано другое.
     </p>
     <p>
      Внимание! Этот перевод устарел. Английский оригинал имеет ревизию
      21511 тогда как этот перевод основан на ревизии
      (unknown).
     </p>
     <p>
       Эта страница также переведена на следующие языки:
       <a href="tor-doc-windows.html.bms">Burmese</a>, <a href="tor-doc-windows.html.de">Deutsch</a>, <a href="tor-doc-windows.html.en">English</a>, <a href="tor-doc-windows.html.es">espa&ntilde;ol</a>, <a href="tor-doc-windows.html.fa">&#1601;&#1575;&#1585;&#1587;&#1740; (F&#257;rs&#299;)</a>, <a href="tor-doc-windows.html.fr">fran&ccedil;ais</a>, <a href="tor-doc-windows.html.it">Italiano</a>, <a href="tor-doc-windows.html.ko">&#54620;&#44397;&#50612;&nbsp;(Hangul)</a>, <a href="tor-doc-windows.html.pl">polski</a>, <a href="tor-doc-windows.html.zh-cn">&#20013;&#25991;(&#31616;) (Simplified Chinese)</a>.<br>
       Как установить <a href="http://www.debian.org/intro/cn#howtoset">язык документов по умолчанию</a>.
     </p>
   <p>Разработчики Tor не проверяли этот перевод на точность и корректность.
   Перевод может быть устаревшим или просто неправильным. Официальный веб-сайт
   Tor на английском языке доступен по адресу
   <a href="https://www.torproject.org/">https://www.torproject.org/</a>.
   </p>
   <p>
   <i><a href="../contact.html.ru" class="smalllink">Webmaster</a></i> -
    Последние изменения: Mon Mar 15 15:05:46 2010
    -
    Последняя компиляция: Mon Mar 15 18:35:12 2010
   </p>
  </div>
</body>
</html>
