<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" "http://www.w3.org/TR/1998/REC-html40-19980424/loose.dtd">
<html>
<head>
  <title>Tor: MS Windows Install Instructions</title>
  <meta name="Author" content="The Tor Project, Inc.">
  <meta http-equiv="content-type" content="text/html; charset=UTF-8">
  <link rel="stylesheet" type="text/css" href="../stylesheet-ltr.css">
  <link rel="shortcut icon" type="image/x-icon" href="../favicon.ico">
</head>
<body>
<div class="center">
<table class="banner" border="0" cellpadding="0" cellspacing="0" summary="">
    <tr>
        <td class="banner-left"><a href="https://www.torproject.org/"><img src="../images/top-left.png" alt="Click to go to home page" width="193" height="79"></a></td>
        <td class="banner-middle">
	<a href="../index.html.pl">Strona główna</a>
<a href="../overview.html.pl">Wprowadzenie</a>
<a href="../easy-download.html.pl">Pobieranie plików</a>
<a href="../documentation.html.pl">Dokumentacja</a>
<a href="../volunteer.html.pl">Wolontariusze</a>
<a href="../people.html.pl">Ludzie</a>
<a href="https://blog.torproject.org/">Blog</a>
<a href="../donate.html.pl">Dotacje</a>
        </td>
    </tr>
</table>
<div class="center">
<div class="main-column">
<h1>Uruchamianie klienta <a href="../index.html.pl">Tor</a> na Microsoft Windows</h1>
<br>
<p>
<b>Note that these are the installation instructions for running a Tor
client on Microsoft Windows (2000, XP, Vista, 7, and Server Editions). If
you want to relay traffic for others to help the network grow (please do),
read the <a href="../docs/tor-doc-relay.html.pl">Configuring a relay</a>
guide.</b>
</p>
<p>Freedom House wyprodukował film o tym, jak zainstalować Tora. Możecie
zobaczyć ten film pod adresem: <a
href="http://tinyvid.tv/show/3lejztnthk2tm">TinyVid: Jak zainstalować Tora
na Windows</a>. Znasz lepszy film lub taki, który jest przetłumaczony na
Twój język? Daj nam znać!</p>
<div class="center">
<p><video id="v1" src="http://tinyvid.tv/file/3lejztnthk2tm.ogg" autobuffer="true" controls="controls"></video></p>
</div>
<hr> <a id="installing"></a>
<h2><a class="anchor" href="#installing">Krok 1: Pobranie i instalacja Tora</a></h2>
<br>
<p>
Paczki dla Microsoft Windows zawierają programy: <a href="../index.html.pl">Tor</a>, <a href="../vidalia/index.html.pl">Vidalia</a> (GUI dla Tora),
<a href="https://addons.mozilla.org/firefox/2275/">Torbutton</a> (dodatek do
Mozilla Firefox) i <a
href="http://www.pps.jussieu.fr/~jch/software/polipo/">Polipo</a> (serwer
proxy do WWW) w jednej paczce, wszystkie cztery aplikacje prekonfigurowane
do współpracy ze sobą. Pobierz albo <a
href="../dist/vidalia-bundles/vidalia-bundle-0.2.1.24-0.2.7.exe">stabilną</a> albo <a
href="../dist/vidalia-bundles/vidalia-bundle-0.2.2.10-alpha-0.2.7.exe">eksperymentalną</a> wersję paczki dla
Windows, lub poszukaj innych rozwiązań na <a href="../download.html.pl">stronie
pobierania</a>.
</p>
<img alt="Ekran instalacji Tora"
src="../img/screenshot-win32-installer-splash.png" width="503" height="387">
<p>Jeśli już wcześniej zainstalowałeś Tora, Vidalię lub Polipo, możesz
odznaczyć elementy, których nie musisz instalować w oknie dialogowym
pokazanym niżej.
</p>
<img alt="Wybór składników instalacji"
src="../img/screenshot-win32-installer-components.png" width="501" height="386">
<p>Po zakończeniu instalacji wybrane składniki zostaną automatycznie
uruchomione.
</p>
<p>Tor jest domyślnie skonfigurowany jako klient. Używa wbudowanego domyślnego
pliku konfiguracji, i większość użytkowników nie będzie musiała zmieniać
żadnych ustawień. Tor jest teraz zainstalowany.
</p>
<hr> <a id="using"></a>
<h2><a class="anchor" href="#using">Krok 2: Konfiguracja aplikacji, by używały
Tora</a></h2>
<br>
<p>Po instalacji Tora i Polipo musisz skonfigurować swoje aplikacje, by ich
używały. Pierwszym krokiem jest ustawienie sposobu przeglądania sieci WWW.</p>
<p>Powinieneś/aś używać Tora z Firefoksem i Torbuttonem, dla najlepszego
bezpieczeństwa. Instalator programu zainstaluje <a
href="https://addons.mozilla.org/firefox/2275/">rozszerzenie Torbutton</a>
za Ciebie. Uruchom ponownie Firefoksa i gotowe:
</p>
<img alt="Rozszerzenie Torbutton dla Firefoksa"
src="../img/screenshot-torbutton.png" border="1" width="161" height="78"> <br>
<p>
Jeśli masz zamiar używać Firefoksa na innym komputerze niż tam, gdzie jest
Tor, spójrz na <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#SocksListenAddress">wpis
w FAQ na temat uruchamiania Tora na innym komputerze</a>.
</p>
<p>To Torify other applications that support HTTP proxies, just point them at
Polipo (that is, localhost port 8118). To use SOCKS directly (for instant
messaging, Jabber, IRC, etc), you can point your application directly at Tor
(localhost port 9050), but see <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#SOCKSAndDNS">this
FAQ entry</a> for why this may be dangerous. For applications that support
neither SOCKS nor HTTP, take a look at SocksCap or <a
href="http://www.freecap.ru/eng/">FreeCap</a>. (FreeCap is free software;
SocksCap is proprietary.)</p>
<p>Po informacje, jak "storyfikować" inne aplikacje, spójrz na <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorifyHOWTO">Torify
HOWTO</a>.
</p>
<hr> <a id="verify"></a>
<h2><a class="anchor" href="#verify">Krok 3: Upewnij się, że wszystko działa</a></h2>
<br>
<p>
Sprawdź, czy Vidalia jest uruchomione. Vidalia używa małej zielonej cebuli,
gdy Tor działa lub ciemnej cebuli z czerwonym "X", gdy Tor nie
działa. Możesz zatrzymać lub uruchomić Tora, klikając prawym klawiszem
myszki na ikonę Vidalii w zasobniku systemowym i wybierając "Start" lub
"Stop" z menu, jak pokazano niżej:
</p>
<img alt="Ikona Vidalii w zasobniku"
src="../img/screenshot-win32-vidalia.png" width="132" height="252">
<p>
Teraz powinieneś spróbować użyć swojej przeglądarki z Torem i upewnić się,
że Twój adres IP jest anonimizowany. Kliknij na <a
href="https://check.torproject.org/">wykrywacz Tora</a> i sprawdź, czy jego
zdaniem używasz Tora czy nie. (Jeśli ta strona akurat nie działa, przeczytaj
<a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#IsMyConnectionPrivate">ten
wpis w FAQ</a>, by poznać więcej sposobów na testowanie swojego Tora.)
</p>
<p>Jeśli masz zaporę ogniową, która ogranicza możliwości Twojego komputera co
do łączenia się z samym sobą, zezwól w niej na połączenia od programów
lokalnych na porty lokalne 8118 i 9050. Jeśli zapora blokuje połączenia
wychodzące, spraw, by można się było połączyć choć z portami 80 i 433, po
czym przeczytaj <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#FirewalledClient">ten
wpis do FAQ</a>.
</p>
<p>Jeśli dalej nie działa, spójrz na <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#ItDoesntWork">ten
wpis FAQ</a>, by poszukać wskazówek.</p>
<p>
Gdy Tor już działa, poczytaj o tym, <a href="../download.html.pl#Warning">co Tor
oferuje, a czego nie</a>.
</p>
<hr> <a id="server"></a> <a id="relay"></a>
<h2><a class="anchor" href="#relay">Krok 4: Konfiguracja Tora jako przekaźnika
sieci</a></h2>
<br>
<p>The Tor network relies on volunteers to donate bandwidth. The more people
who run relays, the faster the Tor network will be. If you have at least 20
kilobytes/s each way, please help out Tor by configuring your Tor to be a
relay too. We have many features that make Tor relays easy and convenient,
including rate limiting for bandwidth, exit policies so you can limit your
exposure to abuse complaints, and support for dynamic IP addresses.</p>
<p>Posiadanie przekaźników w wielu różnych miejscach w sieci sprawia, że
użytkownicy są bezpieczni. <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#RelayAnonymity">Ty
też możesz mieć lepszą anonimowość</a>, gdyż serwery, do których się
łączysz, nie mogą stwierdzić, czy połączenie pochodzi z Twojego komputera,
czy zostało przekierowane z innych.</p>
<p>Przeczytaj szczegóły w naszym przewodniku <a href="../docs/tor-doc-relay.html.pl">Konfiguracji przekaźnika sieci Tor</a>.</p>
<hr>
<p>Jeśli masz pomysły na ulepszenie tej strony, prosimy <a href="../contact.html.pl">je do nas wysłać</a>. Dziękujemy!</p>
  </div>
<!-- #main -->
</div>
<hr>
</div>
  <div class="bottom" id="bottom">
     <p>"Tor" i "Onion Logo" (logo cebuli) są <a href="../trademark-faq.html.pl">zarejestrowanymi znakami handlowymi</a> The Tor Project, Inc.<br>
	Zawartość tej strony jest pod licencją
	<a href="http://creativecommons.org/licenses/by/3.0/us/">Creative Commons Attribution
	3.0 United States License</a>, chyba że napisano inaczej.
	</p>
     <p>
      Uwaga: To tłumaczenie może być nieaktualne. Oryginał po angielsku
      ma numer wersji
      21511 podczas gdy to tłumaczenie
      jest oparte na wersji
      (unknown).
     </p>
     <p>
       Ta strona jest także dostępna w następujących językach:
       <a href="tor-doc-windows.html.bms">Burmese</a>, <a href="tor-doc-windows.html.de">Deutsch</a>, <a href="tor-doc-windows.html.en">English</a>, <a href="tor-doc-windows.html.es">espa&ntilde;ol</a>, <a href="tor-doc-windows.html.fa">&#1601;&#1575;&#1585;&#1587;&#1740; (F&#257;rs&#299;)</a>, <a href="tor-doc-windows.html.fr">fran&ccedil;ais</a>, <a href="tor-doc-windows.html.it">Italiano</a>, <a href="tor-doc-windows.html.ko">&#54620;&#44397;&#50612;&nbsp;(Hangul)</a>, <a href="tor-doc-windows.html.ru">&#1056;&#1091;&#1089;&#1089;&#1082;&#1080;&#1081;&nbsp;(Russkij)</a>, <a href="tor-doc-windows.html.zh-cn">&#20013;&#25991;(&#31616;) (Simplified Chinese)</a>.<br>
       Jak ustawić <a href="http://www.debian.org/intro/cn.pl.html#howtoset">domyślny język dokumentu</a>.
     </p>
 <p>
 Deweloperzy Tora nie sprawdzili tłumaczenia tej strony pod względem dokładności
  i poprawności. Tłumaczenie może być przestarzałe lub niepoprawne. Oficjalna strona Tora jest
  po angielsku, pod adresem <a href="https://www.torproject.org/">https://www.torproject.org/</a>.
 </p>
     <p>
     <i><a href="../contact.html.pl" class="smalllink">Webmaster</a></i> -
      Ostatnio zmodyfikowane: Mon Mar 15 15:05:50 2010
      -
      Ostatnio wygenerowane: Mon Mar 15 18:34:50 2010
     </p>
  </div>
</body>
</html>
