<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" "http://www.w3.org/TR/1998/REC-html40-19980424/loose.dtd">
<html>
<head>
  <title>Tor: Linux/BSD/Unix Install Instructions</title>
  <meta name="Author" content="The Tor Project, Inc.">
  <meta http-equiv="content-type" content="text/html; charset=UTF-8">
  <link rel="stylesheet" type="text/css" href="../stylesheet-ltr.css">
  <link rel="shortcut icon" type="image/x-icon" href="../favicon.ico">
</head>
<body>
<div class="center">
<table class="banner" border="0" cellpadding="0" cellspacing="0" summary="">
    <tr>
        <td class="banner-left"><a href="https://www.torproject.org/"><img src="../images/top-left.png" alt="Click to go to home page" width="193" height="79"></a></td>
        <td class="banner-middle">
	<a href="../index.html.fr">Accueil</a>
<a href="../overview.html.fr">Vue d'ensemble</a>
<a href="../easy-download.html.fr">Téléchargement</a>
<a href="../documentation.html.fr">Docs</a>
<a href="../volunteer.html.fr">Contribuer</a>
<a href="../people.html.fr">Auteurs</a>
<a href="https://blog.torproject.org/">Blog</a>
<a href="../donate.html.fr">Faites un Don!</a>
        </td>
    </tr>
</table>
<div class="center">
<div class="main-column">
<h1>Installer un client <a href="../index.html.fr">Tor</a> sur système
Linux/BSD/Unix</h1>
<br>
<p>
<b>Ces instructions ne s'appliquent qu'à l'installation d'un client Tor. Si
vous voulez aider à la croissance du réseau Tor en relayant du trafic pour
les autres (ce qui est une très bonne idée), lisez <a href="../docs/tor-doc-relay.html.fr">le guide sur la configuration d'un noeud</a>.</b>
</p>
<hr> <a id="installing"></a>
<h2><a class="anchor" href="#installing">Étape 1 : Télécharger et Installer
Tor</a></h2>
<br>
<p>
Vous pouvez trouver la dernière version de Tor sur la page de <a href="../download-unix.html.fr">téléchargement</a>. Des paquets pour Debian, Red Hat,
Gentoo, *BSD, etc... y sont également présents. Si vous utilisez Ubuntu,
n'utilisez pas les paquets officiels de l'archive Ubuntu: utilisez <a
href="../docs/debian.html.fr#ubuntu">notre répertoire deb</a> à la place.
</p>
<p>Si vous compilez Tor à partir du code source, installez d'abord <a
href="http://www.monkey.org/~provos/libevent/">libevent</a>, et assurez-vous
de disposer d'openssl et de zlib (avec les paquets -devel si
possible). Tapez ensuite :<br> <tt>tar xzf tor-0.2.1.24.tar.gz; cd
tor-0.2.1.24<br> ./configure &amp;&amp; make</tt><br> Vous
pouvez maintenant lancer tor depuis <tt>src/or/tor</tt>, ou bien vous pouvez
l'installer dans /usr/local/ avec <tt>make install</tt> (en root si
nécessaire), ce qui vous permettra de le lancer en tapant simplement
<tt>tor</tt>.
</p>
<p>Tor est préconfiguré par défaut en tant que client. Le fichier de
configuration qu'il utilise par défaut conviendra à la plupart des
utilisateurs. Tor est maintenant installé.
</p>
<hr> <a id="privoxy"></a> <a id="polipo"></a>
<h2><a class="anchor" href="#polipo">Étape 2 : Installer Polipo pour la
navigation web</a></h2>
<br>
<p>Une fois Tor installé, vous devez configurer vos applications pour
l'utiliser.
</p>
<p>
Il faut tout d'abord s'occuper de la navigation web. Commencez par installer
<a href="http://www.pps.jussieu.fr/~jch/software/polipo/">Polipo</a> depuis
votre dépôt préféré. Polipo est un proxy cache web filtrant qui gère
correctement les files http; il est bien adapté à la latence de
Tor. Assurez-vous de disposer d'au moins la version 1.0.4 de Polipo car les
versions antérieures ne gère pas le protocole SOCKS indispensable pour que
Polipo puisse fonctionner avec Tor. Vous devriez dès maintenant désinstaller
privoxy (e.g. apt-get remove privoxy ou yum remove privoxy) de manière à ce
qu'ils n'y ait pas de conflit entre les deux.
</p>
<p>Une fois Polipo installé (par un paquet, ou par les sources), <b>il vous
faudra configurer Polipo pour utiliser Tor</b>. Récupérez notre <a
href="https://svn.torproject.org/svn/torbrowser/trunk/build-scripts/config/polipo.conf">configuration
de Polipo pour Tor</a> et copiez la dans votre fichier de configuration de
polipo (ex: /etc/polipo/config ou ~/.polipo). Vous aurez besoin de
redémarrer Polipo pour les changements prennent effet. Par exemple:<br>
<tt>/etc/init.d/polipo restart</tt>
</p>
<p>Si vous le préférez, vous pouvez utiliser Privoxy à la place avec <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/PrivoxyConfig">cet
exemple de fichier de configuration</a>. Mais étant donné que les fichiers
de configuration de Polipo et de Privoxy font appel au port 8118, vous ne
devriez pas les faire tourner tous les deux en même temps.</p>
<hr> <a id="using"></a>
<h2><a class="anchor" href="#using">Étape 3 : Configurer vos applications pour
utiliser Tor</a></h2>
<br>
<p>Une fois Tor installé, vous devez configurer vos applications pour
l'utiliser.</p>
<p>Vous devriez utiliser Tor avec Firefox et Torbutton pour plus de sécurité.
Installez tout simplement <a
href="https://addons.mozilla.org/firefox/2275/">l'extension Torbutton</a>,
redémarrer Firefox et c'est terminé :
</p>
<img alt="Torbutton plugin for Firefox"
src="../img/screenshot-torbutton.png" border="1" width="161" height="78"> <br>
<p>
Si vous envisagez d'utiliser Firefox sur un ordinateur différent de Tor,
jetez un œil à <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#SocksListenAddress">l'entrée
FAQ traitant de l'utilisation de Tor sur un ordinateur différent</a>.
</p>
<p>Pour Torréfier d'autres applications qui gèrent les proxies HTTP, faites les
simplement utiliser Polipo (c'est à dire, localhost port 8118). Pour
utiliser SOCKS directement (pour la messagerie instantanée, Jabber, IRC,
etc), faites pointer votre application directement sur Tor (localhost port
9050), mais consultez <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#SOCKSAndDNS">cet
article de la FAQ</a> pour comprendre en quoi cela peut être dangereux. Pour
les applications qui ne gèrent ni SOCKS, ni le HTTP, vous pouvez utiliser <a
href="http://tsocks.sourceforge.net/">tsocks</a> ou <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorifyHOWTO#socat">socat</a>.
</p>
<p>Vous pouvez trouver des informations sur la Torréfaction d'autres
applications sur <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorifyHOWTO">le
HOWTO Torréfaction</a.
</p>
<hr> <a id="verify"></a>
<h2><a class="anchor" href="#verify">Étape 4 : Vérifier que ça fonctionne</a></h2>
<br>
<p>
Vous devriez ensuite essayer d'utiliser votre navigateur avec Tor, et
vérifier que votre adresse IP est anonyme. Rendez vous sur <a
href="https://check.torproject.org/">le détecteur Tor</a>, vous verrez s'il
pense que vous utilisez Tor ou non. (Si ce site ne marche pas, voyez <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#IsMyConnectionPrivate">cet
article de la FAQ</a> pour des suggestions supplémentaires sur la manière de
tester Tor.)
</p>
<p>Si vous avez un pare-feu personnel qui limite la possibilité de votre
ordinateur à se connecter en local (par exemple SELinux sur Fedora Core 4),
assurez vous de permettre les connexions de vos applications vers Polipo
(local port 8118) et Tor (local port 9050). Si votre pare-feu bloque les
connexions sortantes, faites une brèche dedans pour pouvoir vous connecter
au moins sur les ports 80 et 443, et consultez ensuite <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#FirewalledClient">cet
article de la FAQ</a>. Si votre configuration de SELinux ne permet pas à
tor ou privoxy de fonctionner correctement, créez un fichier nommé
booleans.local dans votre répertoire /etc/selinux/targeted. Éditez le avec
votre éditeur de texte favori, et écrivez "allow_ypbind=1". Redémarrez
votre machine pour que cette modification prenne effet.
</p>
<p>Si cela ne fonctionne toujours pas, consultez <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#ItDoesntWork">cet
article de la FAQ</a>.</p>
<hr> <a id="server"></a> <a id="relay"></a>
<h2><a class="anchor" href="#relay">Étape 5 : Configurer Tor en tant que
relais</a></h2>
<br>
<p>Le réseau Tor se base sur des volontaires qui fournissent de la bande
passante. Plus il y a de personnes qui font tourner de relais, plus le
réseau Tor sera rapide. Si vous disposez d'au moins 20 Ko/s dans chaque sens
(débit montant et descendant), vous pouvez aider Tor en configurant votre
noeud Tor en tant que relais. Nous avons beaucoup de fonctionnalités qui
rendent les relais Tor simples et pratiques, comme la gestion des adresses
IP dynamiques, ou la limitation de la bande passante maximale et les
politiques de sortie afin que vous puissiez limiter votre exposition aux
possibles plaintes suite à une utilisation abusive de Tor.</p>
<p>Tor est un système dont la sécurité dépend de la diversité des lieux
géographiques où tournent les relais. Faire tourner un relais <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#RelayAnonymity">renforce
votre anonymat</a>, car les sites distants ne peuvent pas savoir si les
connexions proviennent de votre ordinateur, ou si vous les avez juste
relayées depuis un autre endroit.</p>
<p>Pour en savoir plus, consultez le guide de <a href="../docs/tor-doc-relay.html.fr">configuration d'un relais</a>.</p>
<hr>
<p>Si vous avez des suggestions pour améliorer ce document, merci de <a
href="../contact.html.fr">nous les envoyez</a>. Merci !</p>
  </div>
<!-- #main -->
</div>
<hr>
</div>
  <div class="bottom" id="bottom">
     <p>"Tor" et le Logo Onion sont des <a href="../trademark-faq.html.fr">marques déposées</a> du Projet Tor, Inc.
     </p>
     <p>
      Attention: Cette traduction peut être obsolète. La version anglaise originale est la
      21798 alors que la version traduite est basée sur la
      (unknown).
     </p>
     <p>
       Cette page est aussi disponible dans les langues suivantes :
       <a href="tor-doc-unix.html.de">Deutsch</a>, <a href="tor-doc-unix.html.en">English</a>, <a href="tor-doc-unix.html.es">espa&ntilde;ol</a>, <a href="tor-doc-unix.html.it">Italiano</a>, <a href="tor-doc-unix.html.ko">&#54620;&#44397;&#50612;&nbsp;(Hangul)</a>, <a href="tor-doc-unix.html.pl">polski</a>, <a href="tor-doc-unix.html.ru">&#1056;&#1091;&#1089;&#1089;&#1082;&#1080;&#1081;&nbsp;(Russkij)</a>, <a href="tor-doc-unix.html.zh-cn">&#20013;&#25991;(&#31616;) (Simplified Chinese)</a>.<br>
       Comment configurer la <a href="http://www.debian.org/intro/cn#howtoset">langue par défaut du document</a>.
      </p>
      <p>Les développeurs de Tor n'ont pas revu cette traduction en ce qui concerne la
      pertinence et l'exactitude. Elle peut être obsolète ou fausse. La version
      officielle du site web Tor est la version anglaise, disponible sur <a
      href="https://www.torproject.org/">https://www.torproject.org/</a>.
      </p>
      <p>
      <i><a href="../contact.html.fr" class="smalllink">Webmaster</a></i> -
  	       Dernière modification : Mon Mar 15 18:09:24 2010
  	       -
  	       Dernière mise à jour : Mon Mar 15 18:34:14 2010
  	      </p>
  </div>
</body>
</html>
