<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" "http://www.w3.org/TR/1998/REC-html40-19980424/loose.dtd">
<html>
<head>
  <title>Tor: Relay Configuration Instructions</title>
  <meta name="Author" content="The Tor Project, Inc.">
  <meta http-equiv="content-type" content="text/html; charset=UTF-8">
  <link rel="stylesheet" type="text/css" href="../stylesheet-ltr.css">
  <link rel="shortcut icon" type="image/x-icon" href="../favicon.ico">
</head>
<body>
<div class="center">
<table class="banner" border="0" cellpadding="0" cellspacing="0" summary="">
    <tr>
        <td class="banner-left"><a href="https://www.torproject.org/"><img src="../images/top-left.png" alt="Click to go to home page" width="193" height="79"></a></td>
        <td class="banner-middle">
	<a href="../index.html.ru">Главная</a>
<a href="../overview.html.ru">Обзор</a>
<a href="../easy-download.html.ru">Скачать</a>
<a href="../documentation.html.ru">Документация</a>
<a href="../volunteer.html">Добровольцы</a>
<a href="../people.html.ru">Люди</a>
<a href="https://blog.torproject.org/">Блог</a>
<a href="../donate.html.ru">Donate!</a>
        </td>
    </tr>
</table>
<div class="center">
<div class="main-column">
<h1>Настройка ретранслятора Tor</h1>
<!-- BEGIN SIDEBAR -->
<div class="sidebar-left">
<h3>Этапы настройки</h3>
<ol>
<li><a href="../docs/tor-doc-relay.html.ru#install">Скачивание и Установка</a></li>
<li><a href="../docs/tor-doc-relay.html.ru#setup">Настройка</a></li>
<li><a href="../docs/tor-doc-relay.html.ru#check">Проверка и Подтверждение</a></li>
<li><a href="../docs/tor-doc-relay.html.ru#after">Финальные шаги</a></li>
</ol>
</div>
<!-- END SIDEBAR -->
<hr>
<p>
Сеть Tor полагается на волонтеров, предоставляющих пропускную способность
своих компьютеров. Чем больше людей предоставляют ретрансляторы, тем быстрей
будет работать сеть Tor. Если у вас есть как минимум 20Кб/сек. в обоих
направлениях, пожалуйста поддержите Tor, настроив ретранслятор Tor. Мы
создали множество возможностей, делающих ретрансляторы Tor простыми и
удобными, включая <a href="../faq.html.ru#RelayFlexible">ограничение
предоставляемой пропускной способности, правила вывода (с тем чтобы вы могли
ограничить вашу незащищенность к возможным жалобам), и поддержку
динамических IP-адресов</a>.
</p>
<p>Вы можете установить ретранслятор Tor практически на <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#RelayOS">любую</a>
операционную систему. Ретрансляторы Tor лучше всего работают на Linux, OS X
Tiger или более поздних версиях, FreeBSD 5.x+, NetBSD 5.x+, и Windows Server
2003 или более поздних версиях.
</p>
<hr> <a id="zero"></a> <a id="install"></a>
<h2><a class="anchor" href="#install">Шаг первый: Скачивание и Установка Tor</a></h2>
<br>
<p>Прежде чем начать, вы должны убедиться что программа Tor запущена и
работает.
</p>
<p>Посетите нашу <a href="../easy-download.html.ru">страницу закачек</a> и
установите "Установочный Пакет" для вашей Операционной Системы.
</p>
<p>Если есть возможность, поэкспериментируйте с программой-клиентом некоторое
время, чтобы убедиться, что сервис действительно работает.</p>
<hr> <a id="setup"></a>
<h2><a class="anchor" href="#setup">Шаг второй: Установка в качестве
ретранслятора</a></h2>
<br>
<ol>
<li>Проверьте правильно ли установлены ваши часы и временная зона. Если
возможно, синхронизируйте ваши часы с публичными<a
href="http://en.wikipedia.org/wiki/Network_Time_Protocol">серверами
времени</a>.
</li>
<li><strong>Настройка Tor с использованием графического интерфейса
Vidalia</strong>:
<ol>
<li>
	<dt>Нажмите правой кнопкой мыши на иконку Vidalia, расположенную в системном
трее. Выберете <tt>Панель Управления</tt>.</dt>
	<dd><img src="../img/screenshot-win32-vidalia.png" alt="" width="132" height="252"></dd>
</li>
<li>Нажмите <tt>Настроить Ретрансляцию</tt>.</li>
<li>
	<dt>Выберете <tt>Ретранслировать трафик для сети Tor</tt> если вы хотите
предоставлять публичный ретранслятор (рекомендуется), или выберете
		<tt>Помочь заблокированным пользователям получить доступ к сети Tor</tt>
если хотите предоставлять <a href="../faq.html.ru#RelayOrBridge">мост</a> для
пользователей, находящихся в странах с Интернет цензурой.</dt>
<dd><img src="../img/screenshot-win32-configure-relay-1.png" alt="" width="624" height="558"></dd>
</li>
<li>Введите псевдоним для своего ретранслятора и свою контактную информацию на
случай, если нам понадобиться связаться с вами по поводу возникших проблем.</li>
<li>Оставьте отмеченным пункт <tt>Пытаться настроить порт маршрутизации
автоматически</tt>. Нажмите на кнопку <tt>Тест</tt>, чтобы проверить
правильность работы. Если работает, отлично. Если нет, смотрите пункт номер
3 ниже.</li>
<li><dt>Перейдите к вкладке <tt>Ограничения трафика</tt>. Выберете ширину канала,
которую вы хотите предоставить для других пользователей Tor.</dt>
<dd><img src="../img/screenshot-win32-configure-relay-2.png" alt="" width="622" height="562"></dd>
</li>
<li><dt>Выберете вкладку <tt>Правила вывода/tt>. Если вы хотите разрешить остальным
использовать ваш ретранслятор для этих сервисов, ничего не меняйте. Уберите
галочку с тех сервисов, доступ к которым с <a href="../faq.html.ru#ExitPolicies">вашего ретранслятора вы хотите запретить</a>. Если вы не
хотите предоставлять выводной ретранслятор, уберите галочки со всех
сервисов.</dt>
<dd><img src="../img/screenshot-win32-configure-relay-3.png" alt="" width="624" height="560"></dd>
</li>
<li>Нажмите на кнопку <tt>Ok</tt>. Ознакомьтесь с шагом три (см. ниже), чтобы
убедиться, что ретранслятор работает корректно.</li>
</ol>
<br> <strong>Ручная настройка</strong>:
<ul>
<li>Отредактируйте нижнюю часть <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#torrc">вашего
torrc файла</a>. Если вы хотите предоставлять публичный ретранслятор
(рекомендуется), убедитесь, что вы определили параметры ORPort и <a
href="../faq.html.ru#ExitPolicies">обратите внимание на пункт ExitPolicy</a>; в
противном случае если вы хотите предоставлять <a href="../faq.html.ru#RelayOrBridge">мост</a> для пользователей, находящихся в странах с
Интернет цензурой, используйте только<a href="../bridges.html.ru#RunningABridge">эти строки</a>.
</li>
</ul></li>
<li>Если вы используете брандмауэр, настройте его так, чтобы входящие
подключения могли дойти до выбранных вами портов(ORPort, плюс DirPort, если
вы его включили). Если у вас есть аппаратный брандмауэр (Linksys, кабельный
модем и т.д.) вам стоит зайти на сайт <a
href="http://portforward.com/">portforward.com</a>. Убедитесь также, что вы
разрешили все <em>исходящие</em> подключения, так чтобы ваш ретранслятор мог
подключаться ко всем остальным ретрансляторам сети Tor.
</li>
<li>Перезапустите ваш ретранслятор. Если он <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#Logs">записывает
предупреждения</a>, примите меры.
</li>
<li>Подпишитесь на <a
href="http://archives.seul.org/or/announce/">рассылку</a>. Она очень сжатая,
информативная и позволит вам своевременно получать информацию о выходе новых
стабильных версий программы. Возможно есть смысл подписаться также на <a
href="../documentation.html.ru#MailingLists">более объемную рассылку Tor</a>.
</li>
</ol>
<hr> <a id="check"></a>
<h2><a class="anchor" href="#check">Шаг третий: Убедитесь, что все работает</a></h2>
<br>
<p>Как только ваш ретранслятор смог подключиться к сети, он попробует
определить все ли настроенные вами порты доступны извне. Как правило, этот
этап проходит быстро, но в отдельных случаях может занять до 20
минут. Проверьте <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#Logs">содержание
лог-файла</a>, он должен примерно выглядеть так: <tt>Внутреннее тестирование
показало, что ваш ORPort доступен извне. Замечательно.</tt> Если вы не
видите этого сообщения, это означает, что ваш ретранслятор не доступен
извне; вы должны перепроверить ваши брандмауэры. Проверьте, что тестируются
именно те IP-адреса и порты, которые вы собирались тестировать и т.д.
</p>
<p>Как только он определит, что доступен, он отправит "дескриптор сервера" в
директории, чтобы распространить информацию о своем адресе, портах, ключах и
т.д. среди пользователей сети. Вы можете <a
href="http://194.109.206.212/tor/status/authority"> загрузить один из
статусов сети вручную</a> и, таким образом, найти настроенный вами псевдоним
ретранслятора и убедиться, что он в сети. Возможно вам придется подождать
несколько секунд, чтобы директория успела обновиться.</p>
<hr> <a id="after"></a>
<h2><a class="anchor" href="#after">Шаг четвертый: Когда все работает</a></h2>
<br>
<p>
Мы также рекомендуем вам пройти следующие шаги:
</p>
<p>
6. Прочитайте <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/OperationalSecurity">информацию
об операционной безопасности</a>, где вы найдете несколько идей о том, как
можно повысить безопасность вашего узла.
</p>
<p>
7. Если вы хотите установить более одного ретранслятора - это отлично, но,
пожалуйста, установите <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#MultipleRelays">опцию
МояСемья (MyFamily)</a> в конфигурационных файлах всех своих ретрансляторов.
</p>
<p>
8. Определитесь с ограничением трафика. Пользователи с кабельными модемами,
DSL, и другие пользователи с асимметричным соединением (например, скорость
скачивания выше скорости отдачи) должны установить лимиты своей нижней
пропускной способности во избежание перегруженности. Прочитайте <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#LimitBandwidth">Список
часто задаваемых вопросов по ограничению трафика</a> для получения более
подробной информации.
</p>
<p>
9. Сохраните резервную копию личного ключа вашего ретранслятора Tor
(сохранен в папке "keys/secret_id_key" в вашей DataDirectory). Это
идентификатор вашего ретранслятора и вам необходимо хранить его так, чтобы
никто не смог просматривать трафик проходящий через ваш ретранслятор. Это
очень важный файл, который нужно сохранить если вы хотите <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#UpgradeRelay">перенести
или восстановить ваш ретранслятор Tor</a>, на случай если что-то пойдет не
так.
</p>
<p>
10. Если вы контролируете DNS-сервера для вашего домена, подумайте об
изменении вашего обратного хост-имени DNS на 'anonymous-relay', 'proxy' или
'tor-proxy', так что когда другие люди увидят этот адрес в своих веб логах,
они смогут быстрее понять, что происходит. Добавление <a
href="http://gitweb.torproject.org/tor.git?a=blob_plain;hb=HEAD;f=contrib/tor-exit-notice.html">Уведомления от выводного узла
Tor</a> на виртуальных хост для этого имени позволит существенно уменьшить
количество жалоб, поступающих вам и вашему Интернет сервис провайдеру, если
вы предоставляете выводной узел.
</p>
<p>
11. Если на вашем компьютере не установлен веб сервер, пожалуйста, подумайте
о том, чтобы изменить ваш ORPort на 443, а DirPort - на 80. Многие
пользователи Tor блокируются брандмауэрами, которые позволяют им только
просматривать веб страницы, и это изменение позволит им подключиться к
вашему ретранслятору Tor. Пользователи ретрансляторов на базе Win32 могут
просто изменить свои ORPort и DirPort напрямую в torrc-файлах и
перезапустить Tor. Пользователи ретрансляторов, работающих на базе OS X или
Unix не могут напрямую связываться с этими портами (так как они не
корневые), так что им понадобится установить <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#ServerForFirewalledClients">
переадресацию портов</a>, чтобы подключения могли доходить до ретрансляторов
Tor. Если вы уже используете порты 80 и 443, но все же хотите помочь,
другими полезными портами являются 22, 110, и 143.
</p>
<p>
12. Если ваш ретранслятор Tor предоставляет другие сервисы с того же
IP-адреса, такие, например, как публичный веб сервер. Убедитесь, что
подключения к нему разрешены с локального хоста. Вам необходимо разрешить
эти подключения, потому что клиенты Tor неизбежно определят, ваш
ретранслятор как <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#ExitEavesdroppers">самый
безопасный путь подключения к этому веб серверу</a>, и при подключении к
нему будут всегда строить цепочку, в которой ваш ретранслятор будет
последним. В случае, если вы не хотите разрешать эти подключения, вы должны
полностью запретить их в ваших правилах вывода.
</p>
<p>
13. (Только для пользователей операционных систем Unix). Создайте отдельного
пользователя для предоставления услуг ретранслятора. Если вы установили
пакет для OS X, deb или rpm, это уже было сделано во время установки. В
противном случае, вы можете сделать это вручную. (Ретранслятор Tor не
обязательно должен работать из корня, так что лучше когда он работает не из
корня. Работа от пользователя 'tor' позволяет избежать проблем с identd и
другими сервисами, которые определяют имя пользователя. Если вы вроде как
параноик, вы можете спокойно <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorInChroot">поставить
Tor в рамки chroot</a>.)
</p>
<p>
14. (Только для пользователей операционных систем Unix). Ваша операционная
система скорее всего ограничивает число открытых файл дескрипторов для
процесса до 1024 (а может и меньше). Если вы планируете предоставлять
быстрый выводной узел, этого скорее всего не достаточно. На Linux, вы должны
добавить строку "toruser hard nofile 8192" в ваш конфигурационный файл,
расположенный здесь: /etc/security/limits.conf (где toruser - это
пользователь запускающий процесс Tor), а после этого перезапустить Tor, если
он установлен как пакет (или выйти из учетной записи и снова вернуться, если
вы запускаете все вручную).
</p>
<p>
15. Если вы установили Tor с помощью пакета или инсталлятора, клиент Tor
скорее всего будет запускаться автоматически при старте. Но если вы
установили его из исходника, инитскрипты (initscripts), расположенные в
contrib/tor.sh или в contrib/torctl могут оказаться для вас полезными.
</p>
<p>
Когда вы меняете настройку Tor, не забудьте проверить правильность работы
вашего ретранслятора после внесенных изменений. Убедитесь, что вы указали
контактную информацию (в строку "ContactInfo" файла torrc), с тем чтобы мы
могли связаться с вами при необходимости (апгрэйт или возникновение
проблем). Если у вас есть проблемы или вопросы, обратитесь к разделу<a
href="../documentation.html.ru#Support">Поддержка</a> или <a href="../contact.html.ru">сообщите нам</a> через tor-ops. Спасибо, что решили поддержать
рост сети Tor!
</p>
<hr>
<p>Если у вас появились предложения по улучшению этого документа, пожалуйста,
<a href="../contact.html.ru">отправьте их нам</a>. Спасибо!</p>
  </div>
<!-- #main -->
</div>
<hr>
</div>
  <div class="bottom" id="bottom">
     <p>"Tor" и "Onion Logo" &mdash; <a href="../trademark-faq.html">зарегистрированные торговые
     марки</a> Tor Project, Inc.
     <br>
     Содержимое сайта защищенo по условиям лицензии
     <a href="http://creativecommons.org/licenses/by/3.0/us/">Creative Commons Attribution 3.0 United States License
 	   <!--img alt="Creative Commons Attribution 3.0 United States License" style="border-width:0" src="../images/cc-by-us-80x15.png"--></a>, если явно не указано другое.
     </p>
     <p>
      Внимание! Этот перевод устарел. Английский оригинал имеет ревизию
      21566 тогда как этот перевод основан на ревизии
      (unknown).
     </p>
     <p>
       Эта страница также переведена на следующие языки:
       <a href="tor-doc-relay.html.de">Deutsch</a>, <a href="tor-doc-relay.html.en">English</a>, <a href="tor-doc-relay.html.es">espa&ntilde;ol</a>, <a href="tor-doc-relay.html.fr">fran&ccedil;ais</a>, <a href="tor-doc-relay.html.it">Italiano</a>, <a href="tor-doc-relay.html.ko">&#54620;&#44397;&#50612;&nbsp;(Hangul)</a>, <a href="tor-doc-relay.html.pl">polski</a>, <a href="tor-doc-relay.html.zh-cn">&#20013;&#25991;(&#31616;) (Simplified Chinese)</a>.<br>
       Как установить <a href="http://www.debian.org/intro/cn#howtoset">язык документов по умолчанию</a>.
     </p>
   <p>Разработчики Tor не проверяли этот перевод на точность и корректность.
   Перевод может быть устаревшим или просто неправильным. Официальный веб-сайт
   Tor на английском языке доступен по адресу
   <a href="https://www.torproject.org/">https://www.torproject.org/</a>.
   </p>
   <p>
   <i><a href="../contact.html.ru" class="smalllink">Webmaster</a></i> -
    Последние изменения: Mon Mar 15 15:05:46 2010
    -
    Последняя компиляция: Mon Mar 15 18:34:59 2010
   </p>
  </div>
</body>
</html>
