<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" "http://www.w3.org/TR/1998/REC-html40-19980424/loose.dtd">
<html>
<head>
  <title>Tor: Relay Configuration Instructions</title>
  <meta name="Author" content="The Tor Project, Inc.">
  <meta http-equiv="content-type" content="text/html; charset=UTF-8">
  <link rel="stylesheet" type="text/css" href="../stylesheet-ltr.css">
  <link rel="shortcut icon" type="image/x-icon" href="../favicon.ico">
</head>
<body>
<div class="center">
<table class="banner" border="0" cellpadding="0" cellspacing="0" summary="">
    <tr>
        <td class="banner-left"><a href="https://www.torproject.org/"><img src="../images/top-left.png" alt="Click to go to home page" width="193" height="79"></a></td>
        <td class="banner-middle">
	<a href="../index.html.fr">Accueil</a>
<a href="../overview.html.fr">Vue d'ensemble</a>
<a href="../easy-download.html.fr">Téléchargement</a>
<a href="../documentation.html.fr">Docs</a>
<a href="../volunteer.html.fr">Contribuer</a>
<a href="../people.html.fr">Auteurs</a>
<a href="https://blog.torproject.org/">Blog</a>
<a href="../donate.html.fr">Faites un Don!</a>
        </td>
    </tr>
</table>
<div class="center">
<div class="main-column">
<h1>Configurer un relais Tor</h1>
<!-- BEGIN SIDEBAR -->
<div class="sidebar-left">
<h3>Étapes de configuration</h3>
<ol>
<li><a href="../docs/tor-doc-relay.html.fr#install">Télécharger &amp; Installer</a></li>
<li><a href="../docs/tor-doc-relay.html.fr#setup">Configuration</a></li>
<li><a href="../docs/tor-doc-relay.html.fr#check">Vérifier &amp; Confirmer</a></li>
<li><a href="../docs/tor-doc-relay.html.fr#after">Étapes terminales</a></li>
</ol>
</div>
<!-- END SIDEBAR -->
<hr>
<p>
Le réseau Tor repose sur des contributeurs qui fournissent de la bande
passante. Plus il y aura de personnes que feront tourner un relais, plus le
réseau sera rapide. Si vous avez au moins 20 kilo-octets/s dans chaque sens,
aidez Tor en configurant votre logiciel comme relais. Nous avons plusieurs
options qui rendent les relais de Tor facile et agréable à mettre en place,
par exemple <a href="../faq.html.fr#RelayFlexible">la limitation de bande
passante consommée, le contrôle sur ports de sortie pour que vous puissiez
limiter votre exposition aux plaintes, et le support des adresses IP
dynamiques</a>.
</p>
<p>Vous pouvez faire tourner un relais Tor sur pratiquement <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#RelayOS">n'importe
quel système d'exploitation</a>. Les relais Tor fonctionnent mieux sur
Linux, OS X à partir de Tiger, FreeBSD 5.x+, NetBSD 5.x+, et Windows Server
2003 ou plus.
</p>
<hr> <a id="zero"></a> <a id="install"></a>
<h2><a class="anchor" href="#install">Première étape: télécharger et installer
Tor</a></h2>
<br>
<p>Avant de commencer, vous devez vous assurer que Tor fonctionne
correctement.
</p>
<p>Visitez notre <a href="../easy-download.html.fr">page de téléchargement</a> et
installez le paquet complet pour votre système d'exploitation.
</p>
<p>Si vous pensez que c'est utile, vous pouvez également utiliser Tor comme un
client pour être sûr qu'il fonctionne.</p>
<hr> <a id="setup"></a>
<h2><a class="anchor" href="#setup">Deuxième étape: le paramétrer comme
relais</a></h2>
<br>
<ol>
<li>Vérifiez que votre horloge est à l'heure. Si possible, synchronisez là sur
un <a href="http://en.wikipedia.org/wiki/Network_Time_Protocol">serveur de
temps</a> public.
</li>
<li><strong>Configurer Tor à l'aide de l'interface graphique de
Vidalia</strong>:
<ol>
<li>
	<dt>Faîtes un clic droit sur l'icône de Vidalia dans votre barre de tâches.
Choisissez <tt>Panneau de Contrôle</tt>.</dt>
	<dd><img src="../img/screenshot-win32-vidalia.png" alt="" width="132" height="252"></dd>
</li>
<li>Cliquez sur <tt>Configuration du Relais</tt>.</li>
<li>
	<dt>Choisir <tt>Relayer le trafic pour le réseau Tor</tt> si vous voulez devenir
un relais public (recommandé), ou choisissez <tt>Aidez les utilisateurs
censurés à se connecter au réseau Tor</tt> si vous désirez devenir une <a
href="../faq.html.fr#RelayOrBridge">passerelle</a> pour les utilisateurs situés
dans des pays qui censurent Internet.</dt>
<dd><img src="../img/screenshot-win32-configure-relay-1.png" alt="" width="624" height="558"></dd>
</li>
<li>Entrer un surnom pour votre relais, et vos informations de contact au cas où
nous aurions besoin de vous faire remonter des problèmes.</li>
<li>Choisissez <tt>Tenter de configurer automatiquement la translation de
port</tt>. Appuyez sur le bouton <tt>Test</tt> pour voir si ça fonctionne.
Si ça marche, super. Sinon, voyez le point 3 ci-dessous.</li>
<li><dt>Choisisser le panneau <tt>Limitation de bande passante</tt>. Sélectionnez
combien de bande passante vous souhaitez fournir aux utilisateurs comme à
vous même.</dt>
<dd><img src="../img/screenshot-win32-configure-relay-2.png" alt="" width="622" height="562"></dd>
</li>
<li><dt>Choisissez le panneau <tt>Politique de sortie</tt>. Si vous souhaitez
autoriser d'autres personnes à utiliser votre relais pour ces services, ne
changez rien. Décochez les services que vous ne souhaitez pas <a
href="../faq.html.fr#ExitPolicies">autoriser à travers votre relais</a>. Si
vous ne souhaitez pas être un relais de sortie décochez tous les services.</dt>
<dd><img src="../img/screenshot-win32-configure-relay-3.png" alt="" width="624" height="560"></dd>
</li>
<li>Cliquez sur le bouton <tt>Valider</tt>. Consultez la troisième étape pour
confirmer que votre relais fonctionne correctement.</li>
</ol>
<br> <strong>Configuration Manuelle</strong>:
<ul>
<li>Éditez la partie basse de votre <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#torrc">fichier
torrc</a>. Si vous désirez être un relais public (recommandé), assurez vous
de définir au moins la variable ORPort et jeter un oeil à <a href="../faq.html.fr#ExitPolicies">ExitPolicy</a>. Si vous désirez être <a href="../faq.html.fr#RelayOrBridge">une passerelle</a> pour les utilisateurs situés dans des
pays qui censurent Internet, utilisez <a href="../bridges.html.fr#RunningABridge">ces quelques lignes</a>.
</li>
</ul></li>
<li>Si vous utilisez un pare-feu, ouvrez y un trou de manière à ce que les
connexions entrantes puissent atteindre le port que vous avez configuré
(ORPort, et DirPort si vous l'avez activé). Si vous avez un pare-feu
matériel (un boitier Linksys, un modem câble, etc...) vous aurez besoin de
<a href="http://portforward.com/">portforward.com</a>. Assurez vous qu'il
autorise toutes les connexions <em>sortantes</em> pour que votre relais
puisse atteindre les autres relais Tor.
</li>
<li>Relancer votre relais. S'il <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#Logs">trace
n'importe quel dysfonctionnement</a>, faites nous en part.
</li>
<li>Inscrivez vous à la liste de diffusion <a
href="http://archives.seul.org/or/announce/">or-announce</a>. Il y a
relativement peu de messages, et elle vous tiendra informé des nouvelles
versions stables. Vous devriez aussi envisager de vous inscrire aux <a
href="../documentation.html.fr#MailingLists">listes de diffusions de Tor</a>
avec un trafic plus important.
</li>
</ol>
<hr> <a id="check"></a>
<h2><a class="anchor" href="#check">Troisième étape s'assurer que ça
fonctionne</a></h2>
<br>
<p>Dès que votre relais va tenter de se connecter au réseau, il va essayer de
déterminer si le port que vous avez configuré est joignable de
l'extérieur. Ceci peut prendre jusqu'à 20 minutes. Jetez un œil sur les <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#Logs">entrées
de logs</a> du genre <tt>Self-testing indicates your ORPort is reachable
from the outside. Excellent</tt>. Si vous ne voyez pas ce message, ça
signifie que votre relais n'est pas joignable de l'extérieur &mdash; vous
devriez revérifier vos pare-feux, vérifier qu'il teste l'adresse IP et le
port que vous pensez qu'il devrait tester, etc.
</p>
<p>Quand votre relais a décidé qu'il était joignable, il envoie un «
descripteur de relais » aux annuaires. Ceci permettra aux clients de
connaître l' adresse, les ports, la clé, etc que votre relais utilise. Vous
pouvez manuellement <a
href="http://194.109.206.212/tor/status/authority">télécharger l'un des
états du réseau</a> et voir si vous y trouvez le nom que vous avez
configuré, pour être certain de sa présence. Vous aurez probablement à
attendre quelques secondes pour avoir un rafraîchissement du répertoire.</p>
<hr> <a id="after"></a>
<h2><a class="anchor" href="#after">Quatrième étape: une fois que ça
fonctionne</a></h2>
<br>
<p>
Nous recommandons de suivre les étapes suivantes :
</p>
<p>
6. Lisez <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/OperationalSecurity">ce
document</a> pour avoir des idées sur comment accroître la sécurité de votre
relais.
</p>
<p>
7. Si vous désirez faire tourner plus d'un seul relais, c'est bien mais
merci de configurer <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#MultipleRelays">l'option
MyFamily</a> dans tous les fichiers de configuration de tous vos relais.
</p>
<p>
8. Décidez de la limitation de débit. Le câble, le xDSL, et les utilisateurs
qui ont une bande passante asymétrique (par exemple : plus de débit en
téléchargement qu'en envoi) doivent limiter leur débit à la plus petite
bande passante pour éviter les congestions. Voyez <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#LimitBandwidth">l'entrée
FAQ sur la limitation du débit</a> pour plus de détails.
</p>
<p>
9. Sauvegardez la clé privée de votre relais Tor (stockée dans
"keys/secret_id_key" de votre DataDirectory). C'est l'« identité » de votre
relais, et prenez soin de la garder en sécurité pour que personne ne puisse
lire le trafic qui passe au travers de votre nœud. C'est un fichier critique
à conserver si vous comptez <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#UpgradeRelay">déplacer
ou restorer votre relais Tor</a> si quelque chose se passe mal.
</p>
<p>
10. Si vous contrôlez le serveur de nom de votre domaine, n'hésitez pas à
paramétrer votre nom d'hôte inversé avec 'anonymous' or 'proxy' or
'tor-proxy', pour que les autres personnes voyant l'adresse dans les traces
web puissent facilement comprendre ce qui se passe. Ajoutez une <a
href="http://gitweb.torproject.org/tor.git?a=blob_plain;hb=HEAD;f=contrib/tor-exit-notice.html">Note de Sortie Tor</a> sur un
hôte virtuel du même nom peut simplement décourager l'envoi de plaintes à
vous et votre fournisseur d'accès Internet si vous utilisez un noeud de
sortie.
</p>
<p>
11. Si votre ordinateur ne fait pas tourner de serveur web, envisagez de
changer l'option ORPort à 443 et votre DirPort à 80. Un certain nombre
d'utilisateurs Tor sont cloisonnés derrière des pare-feux qui ne leur
permettent que d'aller sur le web, et ce changement leur permettra
d'atteindre votre relais Tor. Les relais Windows peuvent simplement changer
leurs options ORPort et DirPort directement dans leur configuration torrc et
relancer Tor. Les relais OS X ou Unix ne peuvent pas attacher directement
ces ports (puisqu'ils doivent être lancé en root), alors ils doivent
paramétrer une sorte de <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#ServerForFirewalledClients">translation
de port</a> pour que les connexions puissent atteindre leur relais Tor. Si
vos ports 80 et 443 sont déjà utilisés mais que vous souhaitez quand même
aider, d'autres sont intéressants comme les ports 22, 110, et 143.
</p>
<p>
12. Si votre relais Tor fournit d'autres services sur la même adresse IP
&mdash; comme par exemple un site web &mdash; assurez vous que les
connexions au serveur web sont autorisées à partir de l'hôte local
également. Cette autorisation est indispensable car les clients Tor
détecteront que le relais Tor est <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#ExitEavesdroppers">le
chemin le plus sûr pour atteindre ce serveur web</a>, et construiront
toujours un chemin qui finira par votre relais. Si vous ne souhaitez pas
autoriser les connexions, vous devrez explicitement les rejeter dans votre
politique de sortie.
</p>
<p>
13. (Uniquement pour Unix). Créez un utilisateur séparé pour faire tourner
le relais. Si vous installez le paquet OS X ou deb ou rpm, ceci est déjà
fait. Sinon, vous devez le faire à la main. (Le relais Tor ne nécessite pas
d'être lancé sous root, c'est une bonne pratique de ne pas le faire. Le
lancer sous l'utilisateur 'tor' évite les problèmes avec identd et d'autres
services qui détectent le nom d'utilisateur. Si vous êtes dans le genre
paranoïaque, rien ne vous empêche <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorInChroot">de
mettre Tor dans une prison chroot</a>.)
</p>
<p>
14. (Uniquement pour Unix). Votre système d'exploitation limite probablement
le nombre de fichiers ouverts par processus à 1024 (voir moins). Si vous
envisagez de faire tourner un nœud de sortie rapide, ceci ne sera sans doute
pas suffisant. Sous Linux, vous devriez ajouter une ligne genre "toruser
hard nofile 8192" à votre fichier /etc/security/limits.conf (ou toruser est
l'utilisateur qui fait tourner le processus Tor), et ensuite relancer Tor
s'il est installé comme paquet (ou déconnectez vous puis reconnectez vous si
vous le lancez par vous même).
</p>
<p>
15. Si vous avez installé Tor à partir d'un paquet ou d'une installation
automatisée, il est probable que Tor se le lance automatiquement au
démarrage du système. Mais si vous l'avez installé par les sources, vous
trouverez utiles les scripts de démarrage présents dans contrib/tor.sh ou
contrib/torctl.
</p>
<p>
Lorsque vous changez la configuration de Tor, assurez-vous qu'il fonctionne
encore après les modifications. Assurez-vous de bien positionner votre ligne
« ContactInfo » dans le fichier torrc pour que nous puissions vous contacter
en cas de mise à jour ou si quelque chose se passait mal. Si vous avez des
problèmes ou des questions, voyez la <a href="../documentation.html.fr#Support">section d'aide</a> ou <a href="../contact.html.fr">contactez-nous</a> sur la liste tor-ops. Merci de nous aider à
faire croître le réseau Tor !
</p>
<hr>
<p>Si vous avez des suggestions pour améliorer le contenu de ce document, merci
<a href="../contact.html.fr">de nous les faire parvenir</a>. Merci !</p>
  </div>
<!-- #main -->
</div>
<hr>
</div>
  <div class="bottom" id="bottom">
     <p>"Tor" et le Logo Onion sont des <a href="../trademark-faq.html.fr">marques déposées</a> du Projet Tor, Inc.
     </p>
     <p>
      Attention: Cette traduction peut être obsolète. La version anglaise originale est la
      21566 alors que la version traduite est basée sur la
      (unknown).
     </p>
     <p>
       Cette page est aussi disponible dans les langues suivantes :
       <a href="tor-doc-relay.html.de">Deutsch</a>, <a href="tor-doc-relay.html.en">English</a>, <a href="tor-doc-relay.html.es">espa&ntilde;ol</a>, <a href="tor-doc-relay.html.it">Italiano</a>, <a href="tor-doc-relay.html.ko">&#54620;&#44397;&#50612;&nbsp;(Hangul)</a>, <a href="tor-doc-relay.html.pl">polski</a>, <a href="tor-doc-relay.html.ru">&#1056;&#1091;&#1089;&#1089;&#1082;&#1080;&#1081;&nbsp;(Russkij)</a>, <a href="tor-doc-relay.html.zh-cn">&#20013;&#25991;(&#31616;) (Simplified Chinese)</a>.<br>
       Comment configurer la <a href="http://www.debian.org/intro/cn#howtoset">langue par défaut du document</a>.
      </p>
      <p>Les développeurs de Tor n'ont pas revu cette traduction en ce qui concerne la
      pertinence et l'exactitude. Elle peut être obsolète ou fausse. La version
      officielle du site web Tor est la version anglaise, disponible sur <a
      href="https://www.torproject.org/">https://www.torproject.org/</a>.
      </p>
      <p>
      <i><a href="../contact.html.fr" class="smalllink">Webmaster</a></i> -
  	       Dernière modification : Mon Mar 15 15:05:49 2010
  	       -
  	       Dernière mise à jour : Mon Mar 15 18:34:08 2010
  	      </p>
  </div>
</body>
</html>
