<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" "http://www.w3.org/TR/1998/REC-html40-19980424/loose.dtd">
<html>
<head>
  <title>Tor: Instrucciones de Configuración del Repetidor</title>
  <meta name="Author" content="Roger Dingledine">
  <meta http-equiv="content-type" content="text/html; charset=UTF-8">
  <link rel="stylesheet" type="text/css" href="../stylesheet-ltr.css">
  <link rel="shortcut icon" type="image/x-icon" href="../favicon.ico">
</head>
<body>
<div class="center">
<table class="banner" border="0" cellpadding="0" cellspacing="0" summary="">
    <tr>
        <td class="banner-left"><a href="https://www.torproject.org/"><img src="../images/top-left.png" alt="Click to go to home page" width="193" height="79"></a></td>
        <td class="banner-middle">
	<a href="../index.html.es">Principal</a>
<a href="../overview.html.es">Perspectiva</a>
<a href="../download.html.es">Descarga</a>
<a href="../documentation.html.es">Documentación</a>
<a href="../volunteer.html.es">Colabora</a>
<a href="../people.html.es">Gente</a>
<a href="https://blog.torproject.org/">Blog</a>
<a href="../donate.html.es">¡Dona!</a>
        </td>
        <td class="banner-right">
	<a href="tor-doc-relay.html.de"><acronym title="Deutsch"><img src="../images/de.png" alt="Deutsch" width="24" height="16"></acronym></a> <a href="tor-doc-relay.html.en"><acronym title="English"><img src="../images/en.png" alt="English" width="24" height="16"></acronym></a> <acronym title="espa&ntilde;ol"><img src="../images/es.png" alt="espa&ntilde;ol" width="24" height="16"></acronym> <img src="../images/green-flagspace.png" alt="" width="24" height="16"> <img src="../images/green-flagspace.png" alt="" width="24" height="16"> <a href="tor-doc-relay.html.fr"><acronym title="fran&ccedil;ais"><img src="../images/fr.png" alt="fran&ccedil;ais" width="24" height="16"></acronym></a> <a href="tor-doc-relay.html.it"><acronym title="Italiano"><img src="../images/it.png" alt="Italiano" width="24" height="16"></acronym></a> <img src="../images/green-flagspace.png" alt="" width="24" height="16"> <a href="tor-doc-relay.html.ko"><acronym title="&#54620;&#44397;&#50612;&nbsp;(Hangul)"><img src="../images/ko.png" alt="&#54620;&#44397;&#50612;&nbsp;(Hangul)" width="24" height="16"></acronym></a> <img src="../images/green-flagspace.png" alt="" width="24" height="16"> <img src="../images/green-flagspace.png" alt="" width="24" height="16"> <a href="tor-doc-relay.html.pl"><acronym title="polski"><img src="../images/pl.png" alt="polski" width="24" height="16"></acronym></a> <img src="../images/green-flagspace.png" alt="" width="24" height="16"> <a href="tor-doc-relay.html.ru"><acronym title="&#1056;&#1091;&#1089;&#1089;&#1082;&#1080;&#1081;&nbsp;(Russkij)"><img src="../images/ru.png" alt="&#1056;&#1091;&#1089;&#1089;&#1082;&#1080;&#1081;&nbsp;(Russkij)" width="24" height="16"></acronym></a> <img src="../images/green-flagspace.png" alt="" width="24" height="16"> <img src="../images/green-flagspace.png" alt="" width="24" height="16"> <a href="tor-doc-relay.html.zh-cn"><acronym title="&#20013;&#25991;(&#31616;) (Simplified Chinese)"><img src="../images/zh-cn.png" alt="&#20013;&#25991;(&#31616;) (Simplified Chinese)" width="24" height="16"></acronym></a>
        </td>
    </tr>
</table>
<div class="center">
<div class="main-column">
<h1>Configurar un repetidor <a href="../index.html.es">Tor</a></h1>
<br>
<p>
La red Tor se apoya en voluntarios que donen ancho de banda. Cuanta
más gente ejecute repetidores, más rápida será la red Tor. Si tiene
por lo menos 20 kilobytes/s en cada dirección, por favor ayuda a Tor
configurando su Tor para que también sea repetidor. Tenemos muchas
características que hacen a los repetidores Tor fáciles y convenientes,
incluyendo limitación de velocidad para el ancho de banda, políticas de
salida para que pueda limitar su exposición a quejas de abuso, y soporte
para direcciones IP dinámicas.
</p>
<p>Tener repetidores en muchos sitios diferentes de Internet es lo que hace
a los usuarios de Tor seguros. <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#RelayAnonymity">
También puede que usted consiga más anonimato</a>,
ya que los sitios de destino no pueden saber si las conexiones se origiraron en
su ordenador o fueron reenviadas desde otros.</p>
<p>Configurar un repetidor Tor server es fácil y práctico:
<ul>
<li>Tor tiene soporte integrado de <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#LimitBandwidth">
limitación de velocidad</a>. Además, si tiene un enlace rápido
pero quiere limitar el número de bytes por día (o semana o mes) que dona,
mire la <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#Hibernation">característica
de hibernación</a>.
</li>
<li>Cada repetidor Tor tiene una <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#RunARelayBut">política
de salida</a> que especifica qué clase de conexiones salientes se permiten
o se rechazan desde ese repetidor. Si le incomoda permitir a la gente
salir desde su repetidor, puede configurarlo para que sólo permita conexiones
a otros servidores Tor.
</li>
<li>No pasa nada si el repetidor se desconecta a veces. Los directorios
lo notan rápido y dejan de anunciar el servidor. Sólo asegúrese de
que no sea muy a menudo, ya que las conexiones que estén usando el servidor cuando
se desconecte se romperán.
</li>
<li>Podemos manejar repetidores con IPs dinámicas sin problemas &mdash;
simplemente deje la opción de configuración Address en blanco, y Tor
intentará adivinarla.
</li>
<li>Si tu repetidor está detrás de un NAT y no conoce su dirección IP pública
(e.g. tiene una IP de 192.168.x.y), tendrá que configurar el redireccionamiento
de puertos. Redireccionar conexiones TCP depende del sistema pero <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#ServerForFirewalledClients">esta
entrada de la FAQ</a> ofrece algunos ejemplos de cómo hacer esto.
</li>
<li>Su repetidor estimará y anunciará su capacidad de ancho de banda
reciente, así que los repetidores con gran ancho de banda atraerán más usuarios
que los de poco ancho de banda. Por tanto, tener repetidores con poco
ancho de banda también es útil.
</li>
</ul>
<p>Se puede ejecutar un repetidor Tor en casi cualquier sistema operativo,
pero vea <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#RelayOS">esta
entrada de la FAQ</a> para sugerencias acerca de cuáles funcionan mejor y
otros problemas que pudiera encontrarse.</p>
<hr>
<a id="zero"></a>
<h2><a class="anchor" href="#zero">Paso Cero: Descargar e Instalar Tor</a></h2>
<br>
<p>Antes de empezar, debe asegurarse de que Tor está activo y ejecutándose.
</p>
<p>Para usuarios Windows, esto significa al menos <a
href="../docs/tor-doc-windows.html.es#installing">el paso uno</a>
del howto de instalación de Tor en Windows. Los usuarios de Mac OS X deben hacer al menos
<a href="../docs/tor-doc-osx.html.es#installing">el paso uno</a>
del howto de instalación de Tor en OS X. Los usuarios de Linux/BSD/Unix deberían hacer al menos
<a href="../docs/tor-doc-unix.html.es#installing">el paso uno</a>
del howto de instalación de Tor en Unix.
</p>
<p>Si es oportuno, también puede que quiera usarlo de cliente un tiempo
para asegurarse de que realmente funciona.</p>
<hr>
<a id="setup"></a>
<h2><a class="anchor" href="#setup">Paso Uno: Configurarlo como repetidor</a></h2>
<br>
<p>
1. Verifique que su reloj está en hora. Si es posible, sincronice su
reloj con servidores de tiempo públicos.
</p>
<p>
2. Asegúrese de que la resolución de nombres funciona (eso quiere decir
que su ordenador puede resolver direcciones de Internet correctamente).
</p>
<p>
3. Edite la parte de abajo de su torrc. (Vea <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#torrc">esta
entrada en la FAQ</a> para ayuda.)
Asegúrese de definir al menos Nickname y ORPort. Cree el DataDirectory
en caso necesario, y asegúrese de que el dueño es el usuario que ejecutará
tor. <em>Si quiere ejecutar más de un repetidor estupendo, pero
por favor active <a href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#MultipleRelays">la
opción MyFamily</a> en todos los ficheros de configuración de sus repetidores.</em>
</p>
<p>
4. Si usa un cortafuegos, abra un agujero en el cortafuegos para
que las conexiones entrantes puedan alcanzar los puertos que ha configurado en el paso 3
(ORPort, más DirPort si lo ha activado). Asegúrese de permitir todas las conexiones
salientes, para que su repetidor pueda llegar a los otros repetidores Tor.
</p>
<p>
5. Rearranque su repetidor. Si en el <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#Logs">log
aparecen advertencias</a>, resuélvalas.
</p>
<p>
6. Subscríbase a la lista de correo <a
href="http://archives.seul.org/or/announce/">or-announce</a>.
Tiene muy poco tráfico, y le mantendrá informado de nuevas versiones
estables. También puede considerar subscribirse a <a
href="http://archives.seul.org/or/talk/">or-talk</a> (de más tráfico),
donde se anuncian las nuevas versiones de desarrollo.
</p>
<p>
7. Échele un vistazo al manual.
El <a href="../tor-manual.html">manual</a> de la
última versión estable da una lista de todas las posibles opciones de configuración
tanto para clientes como para repetidores.
Si ejecuta la versión de desarrollo de Tor, el manual está disponible
<a href="../tor-manual-dev.html">aquí</a>.
</p>
<hr>
<a id="check"></a>
<h2><a class="anchor" href="#check">Paso Dos: Asegurarse de que funciona</a></h2>
<br>
<p>En cuanto su repetidor consiga conectarse a la red, intentará
determinar si los puertos que configuró son accesibles desde el exterior.
Esto puede tardar hasta 20 minutos. Busque una
<a href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#Logs">entrada
en el log</a> como
<tt>Self-testing indicates your ORPort is reachable from the outside. Excellent.</tt>
Si no ve este mensaje, significa que su repetidor no es accesible desde el exterior
&mdash; debería re-revisar sus cortafuegos, comprobar que esté
comprobando la IP y el puerto que usted crea que debería estar comprobando, etc.
</p>
<p>Cuando decida que es accesible, subirá un "descripor de servidor"
a los directorios. Esto permitirá a los clientes conocer qué dirección,
puertos, llaves, etc usa su servidor. Puede <a
href="http://moria.seul.org:9032/tor/status/authority">cargar uno de los
status de red manualmente</a> y mirarlo entero para encontrar el nickname
que configuró, para asegurarse de que está allí. Puede que necesite esperar
unos segundos para darle suficiente tiempo para generar un directorio nuevo.</p>
<hr>
<a id="after"></a>
<h2><a class="anchor" href="#after">Paso Tres: Una vez que funcione</a></h2>
<br>
<p>
También recomendamos los siguientes pasos:
</p>
<p>
8. Lea
<a href="https://wiki.torproject.org/noreply/TheOnionRouter/OperationalSecurity">este documento</a>
para coger ideas de cómo aumentar la seguridad de su repetidor.
</p>
<p>
9. Decida qué política de salida quiere. Por defecto su repetidor permite
acceso a muchos servicios populares, pero restringe algunos (como el
puerto 25) debido al potencial de abuso. Puede que quiera una política
de salida que sea menos restrictiva o más restrictiva; edite su torrc
apropiadamente. Lea la entrada de la FAQ acerca de <a
href="../faq-abuse.html.es#TypicalAbuses">cuestiones con las que podría
encontrarse si usa la política de salida por defecto</a>.
Si elige una política de salida particulamente abierta, debería asegurarse
de que su ISP está de acuerdo con esa elección.
Si hay algunos recursos que su ordenador no pueda acceder (por ejemplo,
si está detrás de un cortafuegos restrictivo o un filtro de contenido),
por favor rechácelos explícitamente en su política de salida &mdash;
en caso contrario a los usuarios de Tor también les afectará.
</p>
<p>
10. Decida acerca de la limitación de velocidad. Los usuarios de cable,
DSL, y otros usuarios que tienen ancho de banda asimétrico (e.g. más
de descarga que de subida) deberían limitar la velocidad a su ancho de
banda más lento, para evitar congestión. Vea la <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#LimitBandwidth">entrada
de la FAQ sobre limitación de velocidad</a> para detalles.
</p>
<p>
11. Haga una copia de seguridad de la llave privada de su servidor Tor
(almacenada en "keys/secret_id_key" en su DataDirectory). Esta es la
"identidad" de su repetidor, y necesitará mantenerla a salvo para que nadie
pueda leer el tráfico que va a través de su repetidor. Este es el fichero
crítico a guardar si necesita <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#UpgradeRelay">mover
o restaurar su repetidor Tor</a> si algo va mal.
</p>
<p>
12. Si controla los servidores de nombres de su dominio, considere
configurar el DNS inverso de su host con el nombre 'anonymous-relay' o 'proxy' o 'tor-proxy', para que cuando
otra gente vea la dirección en sus web logs, entiendan más rápido qué
está pasando. Añadir el <a href="https://tor-svn.freehaven.net/svn/tor/trunk/contrib/tor-exit-notice.html">aviso
de salida de Tor</a> en un vhost para este nombre puede ayudar mucho a parar las quejas de abuso
destinadas a usted y a su ISP si ejecuta un nodo de salida.
</p>
<p>
13. Si su ordenador no ejecuta un servidor web, por favor
considere cambiar su ORPort a 443 y su DirPort a 80. Muchos usuarios
de Tor están atrapados detrás de cortafuegos que sólo les permiten ver
la web, y este cambio les permitirá acceder a su repetidor Tor. Los
repetidores en Win32 pueden simplemente cambiar su ORPort y DirPort directamente
en su torrc y reiniciar Tor. Los repetidores OS X y Unix servers no pueden escuchar
directamente en esos puertos (ya que no se ejecutan como root), así que
tendrán que configurar algun tipo de <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#ServerForFirewalledClients">
redirección de puertos</a> para que las conexiones puedan acceder a su servidor Tor.
Si ya usa los puertos 80 y 443 pero todavía quiere ayudar, otros puertos útiles son el
22, 110, y 143.
</p>
<p>
14. Si su repetidor Tor da otros servicios en la misma dirección IP
&mdash; como un servidor web público &mdash; asegúrese de que las conexiones al
servidor web se permiten desde el host local también. Necesitará permitir estas
conexiones porque los clientes Tor detectarán que su repetidor Tor es la <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#ExitEavesdroppers">forma
más segura de llegar a ese servidor web</a>, y siempre construirán un circuito que termine
en su repetidor. Si no quiere permitir las conexiones, debe rechazarlas explícitamente en su
política de salida.
</p>
<p>
15. (Sólo Unix). Cree un usuario separado para ejecutar el repetidor. Si
instaló el paquete OS X o el deb o el rpm, ya está hecho. En caso contrario,
puede hacerlo a mano. (El repetidor Tor no necesita ejecutarse como root,
así que es buena práctica no ejecutarlo como root. Ejecutarlo como el
usuario 'tor' evita problemas con identd y otros servicios que detectan
el nombre de usuario. Si eres del tipo paranoico, siéntase libre de <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorInChroot">poner Tor
en una cárcel chroot</a>.)
</p>
<p>
16. (Sólo Unix.) Su sistema operativo probablemente limita el número de
descriptores de fichero abiertos por proceso a 1024 (o incluso menos).
Si planea ejecutar un nodo de salida rápido, probablemente no sea suficiente.
En Linux, debería añadir una línea como "toruser hard nofile 8192" a su
fichero /etc/security/limits.conf (donde toruser es el usuario que ejecuta
el proceso Tor), y reiniciar Tor si se instaló como paquete (o salga de su
cuenta y vuelva a entrar si lo ejecuta directamente). Si eso no funciona, vea <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#FileDescriptors">esta
entrada de la FAQ</a> para otras sugerencias para ejecutar "ulimit -n 8192" antes de
ejecutar Tor.
</p>
<p>
17. Si instaló Tor usando algún paquete o instalador, probablemente ejecute Tor
automáticamente al arrancar. Pero si lo instaló desde las fuentes,
puede que encuentre los scripts de arranque en contrib/tor.sh o contrib/torctl útiles.
</p>
<p>
Cuando cambie su configuración Tor, recuerde verificar que su repetidor todavía funciona
correctamente tras el cambio. Asegúrese de rellenar su línea "ContactInfo" en el torrc
para que podamos contactar con usted si necesita actualizarse o algo va mal. Si tiene
problemas o preguntas, vea la sección de <a href="../documentation.html.es#Support">Soporte</a>
or <a href="../contact.html.es">contáctenos</a> en la lista tor-ops. ¡Gracias por ayudar a
hacer crecer la red Tor!
</p>
<hr>
<p>Si tiene sugerencias para mejorar este documento, por favor <a
href="../contact.html.es">envíenoslas</a>. ¡Gracias!</p>
  </div><!-- #main -->
</div>
</div>
  <div class="bottom" id="bottom">
     <p>
     <i><a href="../contact.html.es" class="smalllink">Webmaster</a></i> -
      Última modificación: Tue Jul 8 04:54:06 2008
      -
      Última compilación: Sat Jan 2 11:06:36 2010
     </p>
<p>"Tor" y el "Logo de la Cebolla" son <a href="../trademark-faq.html.es">
marcas registradas</a> de El Proyecto Tor, S.A.
</p>
     <p>
	Aviso: Esta traducción podría estar obsoleta. La revisión original en inglés es la
      21098 mientras que esta revisión está basada en la
      14160.
     </p>
     <p>
	Esta página también está disponible en los siguientes idiomas:
           <a href="tor-doc-relay.html.de">Deutsch</a>, <a href="tor-doc-relay.html.en">English</a>, <a href="tor-doc-relay.html.fr">fran&ccedil;ais</a>, <a href="tor-doc-relay.html.it">Italiano</a>, <a href="tor-doc-relay.html.ko">&#54620;&#44397;&#50612;&nbsp;(Hangul)</a>, <a href="tor-doc-relay.html.pl">polski</a>, <a href="tor-doc-relay.html.ru">&#1056;&#1091;&#1089;&#1089;&#1082;&#1080;&#1081;&nbsp;(Russkij)</a>, <a href="tor-doc-relay.html.zh-cn">&#20013;&#25991;(&#31616;) (Simplified Chinese)</a>.<br>
       Cómo establecer <a href="http://www.debian.org/intro/cn#howtoset">el idioma por defecto del documento</a>.
     </p>
<p>Los desarrolladores de Tor no han revisado esta traduccion
en cuanto a exactitud o correcciones. Puede ser obsoleta o erronea.
La pagina oficial de Tor es la version en Ingles, disponible en
<a href="https://www.torproject.org/">https://www.torproject.org/</a>.
</p>
  </div>
</body>
</html>
