<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" "http://www.w3.org/TR/1998/REC-html40-19980424/loose.dtd">
<html>
<head>
  <title>Tor: Настройка скрытых сервисов</title>
  <meta name="Author" content="Roger Dingledine">
  <meta http-equiv="content-type" content="text/html; charset=UTF-8">
  <link rel="stylesheet" type="text/css" href="../stylesheet-ltr.css">
  <link rel="shortcut icon" type="image/x-icon" href="../favicon.ico">
</head>
<body>
<div class="center">
<table class="banner" border="0" cellpadding="0" cellspacing="0" summary="">
    <tr>
        <td class="banner-left"><a href="https://www.torproject.org/"><img src="../images/top-left.png" alt="Click to go to home page" width="193" height="79"></a></td>
        <td class="banner-middle">
	<a href="../index.html.ru">Главная</a>
<a href="../overview.html.ru">Обзор</a>
<a href="../easy-download.html">Скачать</a>
<a href="../documentation.html.ru">Документация</a>
<a href="../volunteer.html">Добровольцы</a>
<a href="../people.html.ru">Люди</a>
<a href="https://blog.torproject.org/">Блог</a>
<a href="../donate.html.ru">Donate!</a>
        </td>
        <td class="banner-right">
	<a href="tor-hidden-service.html.de"><acronym title="Deutsch"><img src="../images/de.png" alt="Deutsch" width="24" height="16"></acronym></a> <a href="tor-hidden-service.html.en"><acronym title="English"><img src="../images/en.png" alt="English" width="24" height="16"></acronym></a> <a href="tor-hidden-service.html.es"><acronym title="espa&ntilde;ol"><img src="../images/es.png" alt="espa&ntilde;ol" width="24" height="16"></acronym></a> <img src="../images/green-flagspace.png" alt="" width="24" height="16"> <img src="../images/green-flagspace.png" alt="" width="24" height="16"> <a href="tor-hidden-service.html.fr"><acronym title="fran&ccedil;ais"><img src="../images/fr.png" alt="fran&ccedil;ais" width="24" height="16"></acronym></a> <a href="tor-hidden-service.html.it"><acronym title="Italiano"><img src="../images/it.png" alt="Italiano" width="24" height="16"></acronym></a> <img src="../images/green-flagspace.png" alt="" width="24" height="16"> <img src="../images/green-flagspace.png" alt="" width="24" height="16"> <img src="../images/green-flagspace.png" alt="" width="24" height="16"> <img src="../images/green-flagspace.png" alt="" width="24" height="16"> <a href="tor-hidden-service.html.pl"><acronym title="polski"><img src="../images/pl.png" alt="polski" width="24" height="16"></acronym></a> <img src="../images/green-flagspace.png" alt="" width="24" height="16"> <acronym title="&#1056;&#1091;&#1089;&#1089;&#1082;&#1080;&#1081;&nbsp;(Russkij)"><img src="../images/ru.png" alt="&#1056;&#1091;&#1089;&#1089;&#1082;&#1080;&#1081;&nbsp;(Russkij)" width="24" height="16"></acronym> <img src="../images/green-flagspace.png" alt="" width="24" height="16"> <img src="../images/green-flagspace.png" alt="" width="24" height="16"> <a href="tor-hidden-service.html.zh-cn"><acronym title="&#20013;&#25991;(&#31616;) (Simplified Chinese)"><img src="../images/zh-cn.png" alt="&#20013;&#25991;(&#31616;) (Simplified Chinese)" width="24" height="16"></acronym></a>
        </td>
    </tr>
</table>
<div class="center">
<div class="main-column">
<h1>Настройка скрытых сервисов <a href="../index.html.ru">Tor</a></h1>
<hr>
<p>Tor позволяет клиентам и серверам предоставлять скрытые сервисы. То есть,
вы можете предоставлять веб сервер, SSH сервер, итд. не раскрывая свой IP адрес
пользователям. И так как при этом не используется никакой публичный адрес,
вы можете запустить скрытый сервис находясь за файерволлом.
</p>
<p>Если у вас уже установлены Tor и Privoxy, вы можете посмотреть скрытый сервис
вживую посетив <a href="http://duskgytldkxiuqc6.onion/">наш демонстрационный скрытый сервис</a> или
<a href="http://gaddbiwdftapglkq.onion/">скрытый сервис Wikileaks</a>.
</p>
<p>Это руководство описывает шаги для запуска своего собственного скрытого
сервиса - вебсайта. Технические детали работы скрытых сервисов описаны на странице
<a href="../hidden-services.html">протокола скрытых сервисов</a>.
</p>
<hr>
<a id="zero"></a>
<h2><a class="anchor" href="#zero">Шаг нулевой: Запустите Tor и Privoxy</a></h2>
<br>
<p>Перед тем как приступить к настройке скрытого сервиса убедитесь что</p>
<ol>
<li>Tor запущен,</li>
<li>Privoxy запущен,</li>
<li>Privoxy перенаправляет запросы в Tor,</li>
<li>всё на самом деле работает корректно.</li>
</ol>
<p>Пользователи Windows должны прочитать
<a href="../docs/tor-doc-windows.html.ru">инструкции для Windows</a>,
пользователи OS X должны прочитать
<a href="../docs/tor-doc-osx.html">инструкции для OS X</a>,
а пользователи Linux/BSD/Unix должны прочитать
<a href="../docs/tor-doc-unix.html.ru">инструкции для Unix</a>.
</p>
<p>Как только вы установили Tor и Privoxy, вы можете посмотреть скрытый сервис
вживую посетив <a href="http://duskgytldkxiuqc6.onion/">наш демонстрационный скрытый сервис</a> или
<a href="http://gaddbiwdftapglkq.onion/">скрытый сервис Wikileaks</a>.
Скорее всего загрузка займёт 10-60 секунд
(или решит что ресурс недоступен). Если же попытка окажется неудачной моментально
и ваш браузер скажет
"duskgytldkxiuqc6.onion could not be found, please check the name and
try again", то значит вы неверно настроили Tor и Privoxy; ищите помощь в
<a href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#ItDoesntWork">"оно-не-работает"-FAQ</a>.
</p>
<hr>
<a id="one"></a>
<h2><a class="anchor" href="#one">Шаг первый: Установить локальный веб сервер</a></h2>
<br>
<p>Сначала надо установить локальный веб сервер. Установка веб-сервера
требует некоторых навыков, поэтому мы кратко опишем только основные шаги. Если
вы запутаетесь или захотите большего, найдите друга который вам поможет. Мы
рекомендуем устанавливать новый отдельный веб-сервер для скрытого сервиса, т.к.
даже если у вас уже установлен веб-сервер, вы можете использовать его (или можете
захотеть использовать его в будущем) для обычного веб-сайта.
</p>
<p>Если вы на Unix или OS X и комфортно чувствуете себя в командной строке,
наверное лучшим выбором будет установить
<a href="http://www.acme.com/software/thttpd/">thttpd</a>. Просто скачайте
самый свежий tarball, распакуйте его (будет создан новый каталог), и выполните
<kbd>./configure &amp;&amp; make</kbd>. Потом <kbd>mkdir hidserv; cd hidserv</kbd>,
и <kbd>../thttpd -p 5222 -h localhost</kbd>. Процесс будет запущен в фоне,
и теперь у вас есть веб-сервер на порту 5222. Выкладывайте файлы в каталог hidserv.
</p>
<p>Для ОС Windows можно выбрать
<a href="http://savant.sourceforge.net/">Savant</a> или
<a href="http://httpd.apache.org/">Apache</a>. Обязательно настройте сервер
принимать соединения только от localhost. Вы также должны узнать на каком порту
висит ваш сервер, так как вам понадобится эта информация позже.
</p>
<p>(Причина по которой мы привязываем веб-сервер только к localhost в том, чтобы быть
уверенным что сервер не доступен публично. Если бы пользователи могли напрямую соединиться
с вашим сервером, они смогли бы определить, что ваш сервер предоставляет этот
скрытый сервис.)
</p>
<p>После настройки веб-сервера, убедитесь что он работает: откройте браузер
и введите
<a href="http://localhost:5222/">http://localhost:5222/</a>, где 5222 это
номер порта который вы выбрали выше. После этого положите файл в главный html каталог,
и убедитесь что он появился на сайте.
</p>
<hr>
<a id="two"></a>
<h2><a class="anchor" href="#two">Шаг второй: Настройте скрытый сервис</a></h2>
<br>
<p>Далее, надо указать вашему скрытому сервису на локальный
веб-сервер.</p>
<p>Во-первых, откройте файл torrc в вашем любимом текстовом редакторе.
(См. <a href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#torrc">FAQ по torrc</a>
если вы не понимаете что это значит.) В средней секции найдите строку</p>
<pre>
############### This section is just for location-hidden services ###
</pre>
<p>
Эта секция состоит из групп строк, каждая из которых определяет один скрытый
сервис. Сейчас они все закомментированы (строки начинаются с символа #),
то есть скрытые сервисы выключены. Каждая группа строк содержит одну строку
<var>HiddenServiceDir</var>, и одну или более строк <var>HiddenServicePort</var>:</p>
<ul>
<li><var>HiddenServiceDir</var> определяет каталог где Tor будет хранить информацию
о скрытом сервисе. В частности, Tor создаст файл
<var>hostname</var> в этом каталоге который будет содержать "onion" URL этого сервиса.
Вам не следует добавлять никаких файлов в этот каталог.</li>
<li><var>HiddenServicePort</var> определяет виртуальный порт (т.е. для пользователей
скрытого сервиса будет выглядеть так, как будто они используют этот порт)
и IP адрес и порт для перенаправления соединений с виртуального порта.</li>
</ul>
<p>Добавьте такие строки в torrc:
</p>
<pre>
HiddenServiceDir /Library/Tor/var/lib/tor/hidden_service/
HiddenServicePort 80 127.0.0.1:5222
</pre>
<p>Вам следует изменить строку <var>HiddenServiceDir</var>, так чтобы она указывала
на каталог доступный по чтению и записи для пользователя от имени которого
будет запущен Tor. Строка в примере подойдёт если вы используете пакет Tor для OS X.
Под Unix, попробуйте "/home/username/hidserv/" и подставьте ваше имя пользователя вместо
"username". Под Windows вы можете выбрать:</p>
<pre>
HiddenServiceDir C:\Documents and Settings\username\Application Data\hidden_service\
HiddenServicePort 80 127.0.0.1:5222
</pre>
<p>Теперь сохраните torrc и перезапустите Tor.
<!--(См.
<a href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#Restarting">этот раздел FAQ</a>
с подсказками по перезапуску Tor.)-->
</p>
<p>Если после этого Tor запустился, отлично. Иначе, что-то не так. Сначала ищите
подсказку в логах Tor. Должно быть какое-то сообщение об ошибке или
предупреждение. Обычно причина в опечатках в torrc или неверных правах доступа на
файлы и каталоги (См.
<a href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#Logs">раздел FAQ по логам Tor</a>
если вы не знаете как включить или где найти эти логи.)
</p>
<p>При старте, Tor автоматически создаст каталог <var>HiddenServiceDir</var>
который вы указали (если требуется), и запишет туда два файла.</p>
<dl>
<dt><var>private_key</var></dt>
<dd>Во-первых, будет сгенерирована пара ключей (публичный и приватный)
для скрытого сервиса, и записана в файл "private_key". Не передавайте эти ключи
никому больше -- если вы это сделаете третье лицо сможет подменить ваш сервис.</dd>
<dt><var>hostname</var></dt>
<dd>Другой созданный файл будет называться "hostname".
В нём содержится краткая информация по вашему публичному ключу -- и будет
выглядеть как-то так : <tt>duskgytldkxiuqc6.onion</tt>. Это публичное имя
вашего сервиса, и вы можете передавать его другим людям, публиковать на вебсайте,
печатать на визитке, etc.</dd>
</dl>
<p>Если Tor запущен под другим пользователем,
как например на OS X, Debian, или Red Hat, тогда вам может понадобиться стать
root'ом чтобы прочитать эти файлы.</p>
<p>Теперь, после того как вы перезапустили Tor, он занят тем что выбирает
"точки знакомства" ("introduction points") в сети Tor, и генерирует так называемый
<em>дескриптор скрытого сервиса</em>. На самом деле это просто список точек
знакомств и полный публичный ключ сервиса. Потом Tor анонимно публикует этот
дескриптор на серверах директорий, и другие пользователи анонимно запрашивают его
оттуда когда они пытаются соединиться с вашим сервисом.
</p>
<p>Проверьте это сейчас: скопируйте содержимое файла hostname в адресную строку
браузера. Если всё работает верно, то вы получите html страницу которую вы
настроили на первом шаге. Если же результат будет отрицательный, смотрите логи и
пробуйте до тех пор пока не заработает.
</p>
<hr>
<a id="three"></a>
<h2><a class="anchor" href="#three">Шаг третий: советы</a></h2>
<br>
<p>Если вы планируете поддерживать ваш скрытый сервис в течении длительного времени,
сделайте резервную копию файла <var>private_key</var>.
</p>
<p>Мы избегаем рекомендовать Apache выше, а) потому что у многих он уже
установлен для поддержки обычного веб-сайта на их компьютере, и б)
потому что он слишком большой и может раскрыть ваш IP адрес или
другую идентифицирующую информацию многими способами, например с помощью
страниц ошибки 404. Впрочем, для тех кому существенно требуется функциональность,
Apache может быть верным выбором. Может ли кто-нибудь составить список
действий требуемых для безопасного использования Apache как
скрытого веб-сервиса? Наверное эти же проблемы есть и у Savant.
</p>
<p>Если вы хотите перенаправлять несколько портов на один скрытый сервис,
просто добавьте несколько строк <var>HiddenServicePort</var>. Если вы хотите
поддерживать несколько разных скрытых сервисов на одном клиенте Tor,
просто добавьте ещё строки <var>HiddenServiceDir</var>. Все последующие строки
<var>HiddenServicePort</var> относятся к этой строке <var>HiddenServiceDir</var>, до тех пор
пока вы не добавите ещё одну строку <var>HiddenServiceDir</var>:
</p>
<pre>
HiddenServiceDir /usr/local/etc/tor/hidden_service/
HiddenServicePort 80 127.0.0.1:8080

HiddenServiceDir /usr/local/etc/tor/other_hidden_service/
HiddenServicePort 6667 127.0.0.1:6667
HiddenServicePort 22 127.0.0.1:22
</pre>
<p>Есть несколько моментов связанных с анонимностью о которых следует помнить:
</p>
<ul>
<li>Как уже говорилось выше, будьте бдительны чтобы не дать вашему веб-серверу
выдать идентифицирующую информацию о вас, вашем компьютере, или вашем местоположении.
Например, посетители смогут наверное определить используется ли thttpd или Apache,
и узнать что-нибудь о вашей операционной системе.</li>
<li>Если ваш компьютер не доступен онлайн сутки напролёт, то ваш скрытый сервис также.
Это очевидная утечка информации для стороннего наблюдателя.</li>
<!-- increased risks over time -->
</ul>
<hr>
<p>Если у вас есть пожелания по улучшению этого документа, пожалуйста <a
href="../contact.html.ru">высылайте их нам</a>. Спасибо!</p>
  </div><!-- #main -->
</div>
<hr>
</div>
  <div class="bottom" id="bottom">
     <p>"Tor" и "Onion Logo" &mdash; <a href="../trademark-faq.html">зарегистрированные торговые
     марки</a> Tor Project, Inc.
     <br>
     Содержимое сайта защищенo по условиям лицензии
     <a href="http://creativecommons.org/licenses/by/3.0/us/">Creative Commons Attribution 3.0 United States License
 	   <!--img alt="Creative Commons Attribution 3.0 United States License" style="border-width:0" src="../images/cc-by-us-80x15.png"--></a>, если явно не указано другое.
     </p>
     <p>
      Внимание! Этот перевод устарел. Английский оригинал имеет ревизию
      20912 тогда как этот перевод основан на ревизии
      20071.
     </p>
     <p>
       Эта страница также переведена на следующие языки:
       <a href="tor-hidden-service.html.de">Deutsch</a>, <a href="tor-hidden-service.html.en">English</a>, <a href="tor-hidden-service.html.es">espa&ntilde;ol</a>, <a href="tor-hidden-service.html.fr">fran&ccedil;ais</a>, <a href="tor-hidden-service.html.it">Italiano</a>, <a href="tor-hidden-service.html.pl">polski</a>, <a href="tor-hidden-service.html.zh-cn">&#20013;&#25991;(&#31616;) (Simplified Chinese)</a>.<br>
       Как установить <a href="http://www.debian.org/intro/cn#howtoset">язык документов по умолчанию</a>.
     </p>
   <p>Разработчики Tor не проверяли этот перевод на точность и корректность.
   Перевод может быть устаревшим или просто неправильным. Официальный веб-сайт
   Tor на английском языке доступен по адресу
   <a href="https://www.torproject.org/">https://www.torproject.org/</a>.
   </p>
   <p>
   <i><a href="../contact.html.ru" class="smalllink">Webmaster</a></i> -
    Последние изменения: Wed Sep 2 15:15:50 2009
    -
    Последняя компиляция: Sat Jan 2 11:06:50 2010
   </p>
  </div>
</body>
</html>
