#ifndef EQUALIZERDIALOG_H
#define EQUALIZERDIALOG_H

#include <QDialog>
#include <QSlider>
#include <QPushButton>
#include <QCheckBox>
#include <QLabel>

class EqualizerDialog : public QDialog
{
    Q_OBJECT
public:
// Equalizer is only supported in Maemo (for now), hence the specific values and conversions
    explicit EqualizerDialog(QWidget *parent = 0,
                            const QList<int>& vals = QList<int>(),
                            const QStringList& labels = QStringList (), 
                            bool equalizerEnabled = false, 
                            int sliderCount = 10,
                            int min = -12,
                            int max = 12);

signals:
    void equalizerChanged (int ind, int val);
    void toggleEqualizer(bool);

public slots:
private slots:
    void sliderChanged (int);
    void resetAll ();
    void resetOne ();
private:
    QList<QSlider*> sliders;
    QList<QLabel*> buttons;
    QCheckBox *enabled;
    QPushButton *reset;
};

#endif // EQUALIZERDIALOG_H
