#include <QHBoxLayout>
#include <QtDebug>
#include "equalizerdialog.h"

EqualizerDialog::EqualizerDialog(QWidget *parent, const QList<int>& vals, const QStringList& labels, bool equalizerEnabled, int sliderCount, int min, int max) :
    QDialog(parent)
{
    QVBoxLayout* vb = new QVBoxLayout;
    QHBoxLayout* l = new QHBoxLayout;
    for (int i = 0; i < sliderCount; ++i)
    {
        QSlider* s = new QSlider (Qt::Vertical);
        s->setMinimum(min);
        s->setMaximum(max);
        s->setMinimumHeight(180);
        if (vals.size() > i)
            s->setValue(vals[i]);
        connect (s, SIGNAL(valueChanged(int)), this, SLOT(sliderChanged(int)));
        QVBoxLayout* tmpLay = new QVBoxLayout;
        tmpLay->addWidget(s);
#ifndef Q_WS_MAEMO_5

        if (labels.size () > i)
        {
            QLabel* tmpBut = new QLabel ("<a href=''>" + labels[i] + "</a>");
            connect (tmpBut, SIGNAL(linkActivated(QString)), this, SLOT(resetOne()));
            tmpLay->addWidget(tmpBut);
            buttons.append (tmpBut);
        }
#endif
        l->addLayout(tmpLay);
        sliders.append(s);
    }
    enabled = new QCheckBox("Enable equalizer");
    enabled->setChecked(equalizerEnabled);
    connect(enabled, SIGNAL(toggled(bool)), this, SIGNAL(toggleEqualizer(bool)));
    vb->addWidget(enabled);
    vb->addLayout(l);
    reset = new QPushButton("Reset sliders");
    connect (reset, SIGNAL(clicked()), this, SLOT(resetAll()));
    vb->addWidget(reset);
    setLayout(vb);
    setWindowTitle(tr ("TomAmp Equalizer"));
}

void EqualizerDialog::sliderChanged (int val)
{
    QSlider* s = qobject_cast<QSlider*>(sender ());
    if (s)
    {
        int ind = sliders.indexOf(s);
        emit equalizerChanged(ind, val);
    }
}

void EqualizerDialog::resetOne()
{
    QLabel* s = qobject_cast<QLabel*>(sender ());
    int ind = buttons.indexOf(s);
    if (s && ind >= 0)
    {
        sliders[ind]->setValue(0);
    }
}

void EqualizerDialog::resetAll()
{
    int ind = 0;
    foreach (QSlider* s, sliders)
    {
        s->setValue(0);
        emit equalizerChanged(ind++, 0);
    }
}

