#ifndef TODOWIDGET_H
#define TODOWIDGET_H

#include <QtCore>
#include <QtGui>

#include <QOrganizerManager>
#include <QOrganizerTodo>

using namespace QtMobility;

namespace Ui {
    class TodoWidget;
}

class TodoWidget : public QWidget
{
    Q_OBJECT

public:
    enum Status { Done,
                  NotDone };

    explicit TodoWidget(QWidget *parent = 0);
    ~TodoWidget();

    void setTitle(QString title);
    void setCollectionColor(QString color);
    void setStatus(Status newStatus);
    void setId(QString id);
    void setIconSize(int Size);
    void drawIcon(int iconSize);
    void setManagerPointer(QOrganizerManager* defaultManager);


public slots:


signals:
    void todoDeleted();


private slots:
    void on_iconButton_clicked();
    void on_deleteButton_clicked();

private:
    Ui::TodoWidget *ui;
    QOrganizerManager* defaultManager;

    Status status;
    QString collectionColor;
    QString todoId;

    int iconSize;


};

#endif // TODOWIDGET_H
