#include "todowidget.h"
#include "ui_todowidget.h"

TodoWidget::TodoWidget(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::TodoWidget)
{
    ui->setupUi(this);
}

TodoWidget::~TodoWidget()
{
    delete ui;
}

void TodoWidget::on_iconButton_clicked()
{


    if ( status == NotDone )
    {
        status = Done;

        QOrganizerTodo todoItem = defaultManager->item(QOrganizerItemId::fromString(todoId));
        todoItem.setStatus(QOrganizerTodoProgress::StatusInProgress);

        defaultManager->saveItem(&todoItem);
        drawIcon(ui->iconButton->iconSize().width());
    }
    else
    {
        status = NotDone;

        QOrganizerTodo todoItem = defaultManager->item(QOrganizerItemId::fromString(todoId));
        todoItem.setStatus(QOrganizerTodoProgress::StatusNotStarted);

        defaultManager->saveItem(&todoItem);
        drawIcon(ui->iconButton->iconSize().width());
    }
}

void TodoWidget::on_deleteButton_clicked()
{
    int ret = QMessageBox::warning(0, tr("TodoListWidget"),
                                    tr("Do you really want to delete this todo?"),
                                    QMessageBox::Yes | QMessageBox::Cancel);

    if ( ret == QMessageBox::Yes)
    {
        defaultManager->removeItem(QOrganizerItemId::fromString(todoId));
        emit todoDeleted();
    }
}

void TodoWidget::setTitle(QString title)
{
    ui->titleLabel->setText(title);
}

void TodoWidget::setCollectionColor(QString color)
{
    collectionColor = color;

    //blue = 488dff
    //green = 1aec0a
    //light pink (Dark Red) = ff54a0
    //orange = e38600
    //light purple (Violet) = d954ff
    //yellow
    //white
    //cyan
    //soft pink
    //bright yellow
}

void TodoWidget::setStatus(TodoWidget::Status newStatus)
{
    status = newStatus;
}

void TodoWidget::setId(QString id)
{
    todoId = id;
}

void TodoWidget::drawIcon(int iconSize)
{
    QString iconPath;
    QString color;
    QString checkStatus;

    if ( collectionColor == "Dark blue")
    {
        color = "blue";
    }
    else if ( collectionColor == "Dark green" )
    {
        color = "green";
    }
    else if ( collectionColor == "Dark red" )
    {
        color = "lightpink";
    }
    else if ( collectionColor == "Orange" )
    {
        color = "orange";
    }
    else if ( collectionColor == "Violet" )
    {
        color = "lightpurple";
    }
    else if ( collectionColor == "Yellow" )
    {
        color = "yellow";
    }
    else if ( collectionColor == "White" )
    {
        color = "white";
    }
    else if ( collectionColor == "Blue" )
    {
        color = "cyan";
    }
    else if ( collectionColor == "Red" )
    {
        color = "softpink";
    }
    else if ( collectionColor == "Green" )
    {
        color = "brightyellow";
    }

    if ( status == NotDone )
    {
        checkStatus = "unchecked";
    }
    else if ( status == Done )
    {
        checkStatus = "checked";
    }

    iconPath = QString(":/icons/checkbox_%1_%2.png").arg(color).arg(checkStatus);
    QPixmap iconPixmap( iconPath );

    iconPixmap = iconPixmap.scaled(iconSize, iconSize);
    ui->iconButton->setIconSize(QSize(iconSize, iconSize));
    ui->iconButton->setIcon(QIcon(iconPixmap));


}

void TodoWidget::setManagerPointer(QtMobility::QOrganizerManager *defaultManager)
{
    this->defaultManager = defaultManager;
}

void TodoWidget::setIconSize(int Size)
{
    iconSize = Size;
    ui->iconButton->setFixedSize(Size, Size);
    ui->deleteButton->setFixedSize(Size, Size);

    QPixmap iconPixmap( ":/icons/deleteButton.png" );

    iconPixmap = iconPixmap.scaled(Size-3, Size-3);
    ui->deleteButton->setIconSize(QSize(Size-3, Size-3));
    ui->deleteButton->setIcon(QIcon(iconPixmap));
}
