#ifndef TODOLISTWIDGET_H
#define TODOLISTWIDGET_H

#include <QtCore>
#include <QtGui>

#include <QOrganizerManager>
#include <QOrganizerTodo>

#include "todowidget.h"
#include "addtododialog.h"
#include "settingsdialog.h"


using namespace QtMobility;

namespace Ui {
    class TodoListWidget;
}

class TodoListWidget : public QWidget
{
    Q_OBJECT

public:
    explicit TodoListWidget(QWidget *parent = 0);
    ~TodoListWidget();


public slots:
    void settingsRequested();


private:
    Ui::TodoListWidget *ui;
    QVector<QWidget*> todoWidgetsVector;
    QOrganizerManager* defaultManager;


    bool organizerDBChanged;

    int alphaValue;
    int fontSize;
    int numberOfRows;
    int rowWidth;
    int rowHeight;
    bool autoResize;
    int widgetCornersRoundness;

    void readSettings();
    void clearList();
    void populateList();
    void fixSize();


private slots:
    void settingsChanged();
    void dataChanged();
    void todoDeleted();
    void todoAdded();
    void on_newTodoButton_clicked();

protected:
    void paintEvent(QPaintEvent *event)
    {
        QPainter p(this);
        p.setBrush(QColor(0, 0, 0, alphaValue));
        p.setPen(Qt::NoPen);
        p.drawRoundedRect(rect(), widgetCornersRoundness, widgetCornersRoundness);
        p.end();

        QWidget::paintEvent(event);
    }
};

#endif // TODOLISTWIDGET_H
