#include "settingsdialog.h"
#include "ui_settingsdialog.h"

SettingsDialog::SettingsDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::SettingsDialog)
{
    ui->setupUi(this);

    readSettings();
}

SettingsDialog::~SettingsDialog()
{
    delete ui;
}

void SettingsDialog::readSettings()
{
    int fontSize;
    int numberOfRows;
    int rowWidth;
    int rowHeight;
    bool autoResize;
    int alphaValue;
    int widgetCornersRoundness;

    QSettings settings("todolistwidget", "settings", this);
    numberOfRows = settings.value("numberOfRows", 7).toInt();
    fontSize = settings.value("fontSize", 15).toInt();
    rowHeight = settings.value("rowHeight", 40).toInt();
    rowWidth = settings.value("rowWidth", 400).toInt();
    autoResize = settings.value("autoResize", false).toBool();
    alphaValue = settings.value("alphaValue", 60).toInt();
    widgetCornersRoundness = settings.value("widgetCornersRoundness", 8).toInt();

    ui->rowHeightSpinBox->setValue(rowHeight);
    ui->alphaValueSlider->setValue(alphaValue);
    ui->rowWidthSpinBox->setValue(rowWidth);
    ui->numberOfRowsSpinBox->setValue(numberOfRows);
    ui->fontSizeSpinBox->setValue(fontSize);
    ui->widgetCornersRoundnessSpinBox->setValue(widgetCornersRoundness);

}

void SettingsDialog::saveSettings()
{
    QSettings settings("todolistwidget", "settings", this);
    settings.setValue("numberOfRows", ui->numberOfRowsSpinBox->value());
    settings.setValue("rowWidth", ui->rowWidthSpinBox->value());
    settings.setValue("rowHeight", ui->rowHeightSpinBox->value());
    settings.setValue("alphaValue", ui->alphaValueSlider->value());
    settings.setValue("fontSize", ui->fontSizeSpinBox->value());
    settings.setValue("widgetCornersRoundness", ui->widgetCornersRoundnessSpinBox->value());
}

void SettingsDialog::on_saveButton_clicked()
{
    saveSettings();
    emit saveButtonClicked();
    close();
}
