#include "addtododialog.h"
#include "ui_addtododialog.h"

AddTodoDialog::AddTodoDialog(QOrganizerManager* manager, QWidget *parent) :
    QDialog(parent), defaultManager(manager),ui(new Ui::AddTodoDialog)
{
    ui->setupUi(this);

    getCollectionsList();
    populateComboBox();

    ui->todoTitleLineEdit->setFocus();
}

AddTodoDialog::~AddTodoDialog()
{
    delete ui;
}

void AddTodoDialog::getCollectionsList()
{
    collectionsList = defaultManager->collections();
}

void AddTodoDialog::populateComboBox()
{
    for (int i = 0; i < collectionsList.size(); i++)
    {
        QPixmap iconPixmap(30, 30);

        QColor color;

        if ( collectionsList.at(i).metaData("Color").toString() == "Dark blue" )
        {
            color = QColor("#488dff");
        }
        else if ( collectionsList.at(i).metaData("Color").toString() == "Dark green" )
        {
            color = QColor("#1aec0a");
        }
        else if ( collectionsList.at(i).metaData("Color").toString() == "Dark red" )
        {
            color = QColor("#ff54a0");
        }
        else if ( collectionsList.at(i).metaData("Color").toString() == "Orange" )
        {
            color = QColor("#e38600");
        }
        else if ( collectionsList.at(i).metaData("Color").toString() == "Violet" )
        {
            color = QColor("#d954ff");
        }
        else if ( collectionsList.at(i).metaData("Color").toString() == "Yellow" )
        {
            color = QColor("Yellow");
        }
        else if ( collectionsList.at(i).metaData("Color").toString() == "White" )
        {
            color = QColor("White");
        }
        else if ( collectionsList.at(i).metaData("Color").toString() == "Blue" )
        {
            color = QColor("Cyan");
        }
        else if ( collectionsList.at(i).metaData("Color").toString() == "Red" )
        {
            color = QColor("#ff9393");
        }
        else if ( collectionsList.at(i).metaData("Color").toString() == "Green" )
        {
            color = QColor("#b4ff00");
        }

        iconPixmap.fill( color );

        QString name = collectionsList.at(i).metaData("Name").toString();
        ui->collectionsComboBox->addItem(QIcon(iconPixmap), name);
        ui->collectionsComboBox->setItemData(i, Qt::AlignCenter, Qt::TextAlignmentRole);
    }

    ui->collectionsComboBox->setItemText(0, "Private");
}

void AddTodoDialog::on_saveButton_clicked()
{
    QOrganizerTodo todoItem;

    todoItem.setDisplayLabel(ui->todoTitleLineEdit->text());
    todoItem.setDueDateTime(QDateTime::currentDateTime());
    todoItem.setCollectionId( collectionsList.at(ui->collectionsComboBox->currentIndex()).id() );
    defaultManager->saveItem(&todoItem);

    emit todoAdded();
    close();
}
