#include "artworklabel.h"
#include <QMouseEvent>
#include <QPaintEvent>
#include <QPainter>
#include <QImage>

ArtworkLabel::ArtworkLabel(QWidget *parent) :
    QWidget(parent),
    m_interactive(true),
    m_pressed(false)
{
}

ArtworkLabel::~ArtworkLabel() {}

void ArtworkLabel::setImage(const QImage &image) {
    m_image = image;
    this->update();
}

void ArtworkLabel::mousePressEvent(QMouseEvent *event) {
    if (this->interactive()) {
        event->accept();
        m_pressed = true;
        this->update();
    }
    else {
        event->ignore();
    }
}

void ArtworkLabel::mouseReleaseEvent(QMouseEvent *event) {
    if ((this->interactive()) && (this->rect().contains(event->pos()))) {
        event->accept();
        m_pressed = false;
        this->update();
        emit clicked();
    }
    else {
        event->ignore();
    }
}

void ArtworkLabel::leaveEvent(QEvent *event) {
    event->accept();
    m_pressed = false;
    this->update();
}

void ArtworkLabel::paintEvent(QPaintEvent *event) {
    QPainter painter(this);

    if (m_pressed) {
        painter.setOpacity(0.5);
    }

    if (!this->image().isNull()) {
        painter.drawImage(this->rect(), this->image());
    }

    event->accept();
}
