#ifndef PLAYLISTLISTWINDOW_H
#define PLAYLISTLISTWINDOW_H

#include "stackedwindow.h"
#include "playlist.h"

using namespace QtUbuntuOne;

class PlaylistModel;
class ListView;
class QLabel;
class QModelIndex;

class PlaylistListWindow : public StackedWindow
{
    Q_OBJECT

public:
    explicit PlaylistListWindow(QWidget *parent = 0);

    void getPlaylists();

private:
    void showEvent(QShowEvent *event);
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onLoadingChanged(bool loading);
    void onCountChanged(int count);
    void onItemClicked(const QModelIndex &index);
    void showPlaylist(Playlist *playlist);

private:
    ListView *m_view;
    PlaylistModel *m_model;

    QLabel *m_noResultsLabel;
};

#endif // PLAYLISTLISTWINDOW_H
