#ifndef TRANSFERMANAGER_H
#define TRANSFERMANAGER_H

#include "filetransfer.h"
#include <QObject>
#include <QList>
#include <QTimer>

using namespace QtUbuntuOne;

class QTimer;

class TransferManager : public QObject
{
    Q_OBJECT

    Q_PROPERTY(int count
               READ count
               NOTIFY countChanged)

public:
    ~TransferManager();

    static TransferManager* instance();

    int count() const;

    QList<FileTransfer*> transfers() const;

public slots:
    void addDownloadTransfer(const QString &contentPath, const QString &localPath);
    void addUploadTransfer(const QString &filePath, const QString &contentType, const QString &contentPath, bool isPublic);

    void restoreStoredTransfers();

private slots:
    void storeTransfers();
    void storeAndDeleteTransfers();

    void startNextTransfers();

    void onTransferStatusChanged(TransferStatus::Status status);

signals:
    void countChanged(int count);

private:
    TransferManager();

    static TransferManager *m_instance;

    QTimer m_queueTimer;

    QList<FileTransfer*> m_transfers;
    QList<FileTransfer*> m_activeTransfers;
};

#endif // TRANSFERMANAGER_H
