#ifndef FILENAMEDIALOG_H
#define FILENAMEDIALOG_H

#include "abstractdialog.h"

class QLabel;
class QLineEdit;
class QDialogButtonBox;
class QGridLayout;

class FileNameDialog : public AbstractDialog
{
    Q_OBJECT

public:
    explicit FileNameDialog(const QString &hint, const QString &name, QWidget *parent = 0);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onFileNameChanged(const QString &name);
    void accept();

signals:
    void fileNameChosen(const QString &name);

private:
    QLabel *m_hintLabel;

    QLineEdit *m_nameEdit;

    QDialogButtonBox *m_buttonBox;
    QPushButton *m_doneButton;

    QGridLayout *m_grid;
};

#endif // FILENAMEDIALOG_H
