#ifndef TRANSFERITEM_H
#define TRANSFERITEM_H

#include <QString>
#include <QObject>

class TransferItem : public QObject
{

    Q_OBJECT

public:
    enum TransferType {

        Download = 0,
        Upload
    };

    enum Status {

        Queued = 0,
        Paused,
        Active,
        Cancelled,
        Failed,
        Completed
    };

    enum Priority {

        HighPriority = 0,
        NormalPriority,
        LowPriority
    };

public:
    explicit TransferItem(QObject *parent = 0);
    explicit TransferItem(const QString &key, TransferType type = Download, Status status = Paused, Priority priority = NormalPriority, QObject *parent = 0);
    inline QString key() const { return m_key; }
    inline void setKey(const QString &key) { m_key = key; }
    inline QString contentPath() const { return m_contentPath; }
    inline void setContentPath(const QString &path) { m_contentPath = path; }
    inline QString fileName() const { return m_filename; }
    inline void setFileName(const QString &name) { m_filename = name; }
    inline QString filePath() const { return m_filepath; }
    inline void setFilePath(const QString &path) { m_filepath = path; }
    inline QString downloadPath() const { return m_downloadPath; }
    inline void setDownloadPath(const QString &path) { m_downloadPath = path; }
    inline TransferType transferType() const { return m_type; }
    inline void setTransferType(TransferType type) { m_type = type; }
    inline Status status() const { return m_status; }
    inline void setStatus(Status status) { m_status = status; }
    QString statusText() const;
    inline QString statusInfo() const { return m_statusInfo; }
    inline void setStatusInfo(const QString &info) { m_statusInfo = info; }
    inline Priority priority() const { return m_priority; }
    inline void setPriority(Priority priority) { m_priority = priority; }
    QString priorityText() const;
    inline float progress() const { return m_progress; }
    inline int eta() const { return m_eta; }
    inline void setProgress(float progress, int eta) { m_progress = progress; m_eta = eta; }
    inline qint64 size() const { return m_size; }
    inline void setSize(qint64 size) { m_size = size; }
    inline bool publish() const { return m_publish; }
    inline void setPublish(bool publish) { m_publish = publish; }
    
private:
    QString m_key;
    QString m_contentPath;
    QString m_filename;
    QString m_filepath;
    QString m_downloadPath;
    TransferType m_type;
    Status m_status;
    QString m_statusInfo;
    Priority m_priority;
    QString m_priorityText;
    float m_progress;
    int m_eta;
    qint64 m_size;
    bool m_publish;
};

#endif // TRANSFERITEM_H
