#ifndef SETTINGSDIALOG_H
#define SETTINGSDIALOG_H

#include "abstractdialog.h"
#include "session.h"
#include "screenorientationselector.h"
#include "languageselector.h"
#include <QLineEdit>
#include <QDialogButtonBox>
#include <QPushButton>
#include <QScrollArea>
#include <QGridLayout>
#include <QMaemo5ValueButton>
#include <QCheckBox>

class SettingsDialog : public AbstractDialog
{
    Q_OBJECT

public:
    explicit SettingsDialog(Session *session, QWidget *parent = 0);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onEmailChanged(const QString &email);
    void onPasswordChanged(const QString &pass);
    void signIn();
    void showFileDialog();
    void showFileHandlersDialog();
    void loadSettings();
    void saveSettings();
    
private:
    Session *m_session;
    QLineEdit *m_emailEdit;
    QLineEdit *m_passEdit;
    QPushButton *m_accountButton;
    QCheckBox *m_transferStatusCheckbox;
    QCheckBox *m_downloadCheckbox;
    QMaemo5ValueButton *m_downloadPathButton;
    QPushButton *m_handlersButton;
    ScreenOrientationSelector *m_orientationSelector;
    LanguageSelector *m_languageSelector;
    QDialogButtonBox *m_buttonBox;
    QPushButton *m_doneButton;
    QScrollArea *m_scrollArea;
    QGridLayout *m_grid;
    QString m_downloadPath;
};

#endif // SETTINGSDIALOG_H
