#ifndef FOLDERSELECTIONDIALOG_H
#define FOLDERSELECTIONDIALOG_H

#include "abstractdialog.h"
#include "session.h"
#include "listview.h"
#include "filenamedialog.h"
#include <QMaemo5ValueButton>
#include <QPushButton>
#include <QDialogButtonBox>
#include <QGridLayout>
#include <QKeyEvent>

class FolderSelectionDialog : public AbstractDialog
{
    Q_OBJECT

public:
    explicit FolderSelectionDialog(Session *session, QWidget *parent = 0);
    void setRootIndex(const QModelIndex &index);

protected:
    void keyPressEvent(QKeyEvent *event);

private:
    void setLandscapeLayout();
    void setPortraitLayout();
    void hideFiles(const QModelIndex &parent);

private slots:
    void moveUp();
    void goHome();
    void onLoadingChanged(bool loading);
    void onItemClicked(const QModelIndex &index);
    void onRootIndexChanged(const QModelIndex &index);
    void onFolderButtonClicked();
    void showNewFolderDialog();
    void createNewFolder(const QString &name);

signals:
    void folderChosen(const QModelIndex &index);
    
private:
    Session *m_session;
    ListView *m_listView;
    QPushButton *m_upButton;
    QPushButton *m_homeButton;
    QMaemo5ValueButton *m_folderButton;
    QDialogButtonBox *m_buttonBox;
    QPushButton *m_newButton;
    QGridLayout *m_grid;
};

#endif // FOLDERSELECTIONDIALOG_H
