#ifndef FILESELECTIONWINDOW_H
#define FILESELECTIONWINDOW_H

#include "stackedwindow.h"
#include "listview.h"
#include <QMaemo5EditBar>
#include <QPushButton>
#include <QVBoxLayout>


class FileSelectionWindow : public StackedWindow
{
    Q_OBJECT

public:
    explicit FileSelectionWindow(Session *session, const QString &title, const QString &buttonText, const char* slot, QWidget *parent = 0);
    ~FileSelectionWindow();
    void positionAtIndex(const QModelIndex &index);

private:
    void hideFolders(const QModelIndex &parent);

private slots:
    void onButtonClicked();
    void showMoveItemsDialog();
    void moveItems(const QModelIndex &destination);
    void deleteItems();
    void downloadItems();
    void showConfirmDeleteDialog();

signals:
    void accepted();

private:
    ListView *m_listView;
    QMaemo5EditBar *m_editBar;
    QPushButton *m_acceptButton;
    QVBoxLayout *m_vbox;
};

#endif // FILESELECTIONWINDOW_H
