#ifndef FILEHANDLERSDIALOG_H
#define FILEHANDLERSDIALOG_H

#include "abstractdialog.h"
#include "session.h"
#include <QTextEdit>
#include <QLineEdit>
#include <QPushButton>
#include <QGridLayout>

class FileHandlersDialog : public AbstractDialog
{
    Q_OBJECT

public:
    explicit FileHandlersDialog(Session *session, QWidget *parent = 0);
    
private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void addFileHandler();
    void onFileHandlersChanged(const QVariantMap &handlers);
    void onSuffixTextChanged(const QString &text);

private:
    Session *m_session;
    QTextEdit *m_handlersEdit;
    QLineEdit *m_suffixEdit;
    QLineEdit *m_commandEdit;
    QPushButton *m_addButton;
    QGridLayout *m_grid;
};

#endif // FILEHANDLERSDIALOG_H
