/*
    TipQalc - A tip, tax and total calculator for touchscreen.
    Copyright (C) 2010 Ianaré Sévi.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef TIPQALC_H
#define TIPQALC_H

#include <QMainWindow>
#include <QLineEdit>
#include <QSettings>
#include "numberpad.h"
#include "settingsdialog.h"
#include "aboutdialog.h"

namespace Ui {
    class TipQalc;
}

class TipQalc : public QMainWindow {
    Q_OBJECT
public:
    TipQalc(QWidget *parent = 0);
    ~TipQalc();

protected:
    void changeEvent(QEvent *e);

private:
    Ui::TipQalc *ui;
    int inputFieldId;
    float total;
    float personTotal;
    float personTip;
    QSettings settings;
    QLineEdit *editableLine;
    SettingsDialog settingsDialog;
    AboutDialog aboutDialog;

    bool eventFilter(QObject *object, QEvent *event);
    void insertInField(QString value);
    void adjustPersons(int);
    void adjustTip(int);
    float round(float x, int precision);
    void calculateTip();
    void adjustCursorPosition();
    void manageTaxInputWidgets();

private slots:
    void on_calculateButton_clicked();
    void on_tipMinusButton_clicked();
    void on_tipAddButton_clicked();
    void on_personsMinusButton_clicked();
    void on_personsAddButton_clicked();
    void showSettingsDialog();
    void showAboutDialog();
    void roundTotal();
    void roundTip();

public slots:
    void numberClicked(QString value);
    void periodClicked();
    void clearClicked();
    void deleteClicked();
};

#endif // TIPQALC_H
