/*
    TipQalc - A tip, tax and total calculator for touchscreen.
    Copyright (C) 2010 Ianaré Sévi.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "settingsdialog.h"
#include "ui_settingsdialog.h"

SettingsDialog::SettingsDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::SettingsDialog)
{
    ui->setupUi(this);

    QSettings settings("SeviSoft", "TipQalc");
    bool subTaxValue = settings.value("subtractTaxFromTotal").toBool();
    ui->subTaxCheckBox->setChecked(subTaxValue);
}

SettingsDialog::~SettingsDialog()
{
    delete ui;
}

void SettingsDialog::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void SettingsDialog::on_subTaxCheckBox_stateChanged(int )
{
    QSettings settings("SeviSoft", "TipQalc");
    settings.setValue("subtractTaxFromTotal", ui->subTaxCheckBox->isChecked());
}
