//  Copyright © 2010    Karl Wintermmann
//
//  TinySmbGui is distributed under the GNU GENERAL PUBLIC LICENSE (GPL)
//  Sourcecode which use TinySmbGui must be published. Commercial users
//  must published their code too.


#include "tinyshare.h"

TinyShare::TinyShare(){
    this->share_name="";
    this->path="";
    this->allow="";
    this->all_users="";
    this->access="";
}
TinyShare::TinyShare(const TinyShare &src){
    this->share_name=src.share_name;
    this->path=src.path;
    this->allow=src.allow;
    this->all_users=src.all_users;
    this->access=src.access;
}

TinyShare::TinyShare(QString sname, QString pth, QString allw="", QString allusr="yes", QString acs="ro"){
    this->share_name=sname;
    this->path=pth;
    this->all_users=allusr;
    this->access=acs;
    this->allow=allw;
    if((allusr!="") && (allw!="")) {
        this->allow="";
        this->all_users="yes";
    }
}
TinyShare::~TinyShare(){}

TinyShare &TinyShare::operator =(const TinyShare &src){
    this->share_name=src.share_name;
    this->path=src.path;
    this->allow=src.allow;
    this->all_users=src.all_users;
    this->access=src.access;
    return *this;
}

bool TinyShare::operator ==(const TinyShare &r){
    if ( (this->share_name==r.share_name) &&
         (this->path==r.path) &&
         (this->allow==r.allow) &&
         (this->all_users==r.all_users) &&
         (this->access==r.access) ){
        return true;
    }
    return false;
}

void TinyShare::set_share_name(QString sname){
    this->share_name=sname;
}
void TinyShare::set_path(QString pth){
    this->path=pth;
}
void TinyShare::set_allow(QString allw){
    this->all_users="";
    this->allow=allw;
}
void TinyShare::set_all_users(QString allusr){
    this->allow="";
    this->all_users=allusr;
}
void TinyShare::set_access(QString acs){
    this->access=acs;
}

QString TinyShare::get_share_name(){return this->share_name;}
QString TinyShare::get_path(){return this->path;}
QString TinyShare::get_allow(){return this->allow;}
QString TinyShare::get_all_users(){return this->all_users;}
QString TinyShare::get_access(){return this->access;}
