//  Copyright © 2010    Karl Wintermmann
//
//  TinySmbGui is distributed under the GNU GENERAL PUBLIC LICENSE (GPL)
//  Sourcecode which use TinySmbGui must be published. Commercial users
//  must published their code too.


#include "tinycfg.h"
#include <QDebug>

TinyCfg::TinyCfg(){
    this->tinycfgfile="/etc/tinysmb/tinysmb.conf";
    this->state="not changed";
}
TinyCfg::~TinyCfg(){

}


void TinyCfg::set_cfg(TinySmbCfg config){
    this->cfg=config;
    this->state="changed";
}
TinySmbCfg TinyCfg::get_cfg(){
    return this->cfg;
}


void TinyCfg::add_share(TinyShare share){
    this->sharelist.append(share);
}
void TinyCfg::rm_share(int idx){
    if(idx<this->sharelist.size()) this->sharelist.removeAt(idx);
}
TinyShare TinyCfg::get_share(int idx){
    if (idx<this->sharelist.size()){
        return this->sharelist[idx];
    }
    TinyShare tmp;
    return tmp;
}


void TinyCfg::add_shares(QList<TinyShare> shares){
    this->sharelist.append(shares);
}
void TinyCfg::rm_all_shares(){
    if(!this->sharelist.isEmpty()) this->sharelist.clear();
}
QList<TinyShare> TinyCfg::get_all_shares(){
    return this->sharelist;
}


void TinyCfg::read_cfg_file(){
    QString tmp="";
    bool sharefound=false;
    TinyShare tmpshare;
    QFile data(this->tinycfgfile);
    if(!this->sharelist.isEmpty()) this->sharelist.clear();
    if (data.open(QIODevice::ReadOnly | QIODevice::Text)){
        QTextStream tstream(&data);
        do {
            tmp=tstream.readLine();
            tmp=tmp.simplified();
            if((tmp[0]=='#') || (tmp=="")) continue;

            // read config parameters
            if(tmp.contains("ipaddress = ")) {
                tmp.remove("ipaddress = ");
                this->cfg.set_ipadr(tmp);
            }
            if(tmp.contains("subnetmask = ")) {
                tmp.remove("subnetmask = ");
                this->cfg.set_subnet(tmp);
            }
            if(tmp.contains("hostname = ")){
                tmp.remove("hostname = ");
                this->cfg.set_hostname(tmp);
            }
            if(tmp.contains("workgroup = ")){
                tmp.remove("workgroup = ");
                this->cfg.set_workgroup(tmp);
            }
            if(tmp.contains("passwords = ")){
                tmp.remove("passwords = ");
                this->cfg.set_passwords(tmp);
            }
            if(tmp.contains("passwd_ckeck = ")){
                tmp.remove("passwd_ckeck = ");
                this->cfg.set_passwd_check(tmp);
            }

            // read shares
            if((tmp.startsWith("[")) && (tmp.endsWith("]"))) {
                if(sharefound==true) {
                    this->sharelist.append(tmpshare);
                }
                tmpshare.set_share_name(tmp);
                if(sharefound==false) {
                    sharefound=true;
                }
            }
            if( tmp.contains("path = ") ){
                tmp.remove("path = ");
                tmpshare.set_path(tmp);
            }
            if( tmp.contains("all_users = ")  ){
                tmp.remove("all_users = ");
                tmpshare.set_all_users(tmp);
            }
            if( tmp.contains("allow = ")  ){
                tmp.remove("allow = ");
                tmpshare.set_all_users(tmp);
            }
            if( tmp.contains("access = ")  ){
                tmp.remove("access = ");
                tmpshare.set_access(tmp);
            }
        } while(!tmp.isNull());
        if(sharefound==true) {
            this->sharelist.append(tmpshare);
        }
    }
    this->state="not changed";
    data.close();
}
void TinyCfg::write_cfg_file(){
    QFile data(this->tinycfgfile);
    if (data.open(QIODevice::WriteOnly | QIODevice::Text)){
        QTextStream tstream(&data);
        tstream<<"\n";
        tstream<<"ipaddress    = "<<this->cfg.get_ipadr()<<endl;
        tstream<<"subnetmask   = "<<this->cfg.get_subnet()<<endl;
        tstream<<"hostname     = "<<this->cfg.get_hostname()<<endl;
        tstream<<"workgroup    = "<<this->cfg.get_workgroup()<<endl;
        tstream<<"passwords    = "<<this->cfg.get_passwords()<<endl;
        tstream<<"passwd_ckeck = "<<this->cfg.get_passwd_check()<<endl;
        tstream<<"\n\n";
        for (int i=0;i<this->sharelist.size();i++){
            tstream<<this->sharelist[i].get_share_name()<<endl;
            tstream<<"\n";
            tstream<<"    path         = "<<this->sharelist[i].get_path()<<endl;
            if(sharelist[i].get_allow()=="") {
                tstream<<"    all_users    = "<<this->sharelist[i].get_all_users()<<endl;
            }
            else {
                tstream<<"    allow        = "<<this->sharelist[i].get_allow()<<endl;
            }
            tstream<<"    access       = "<<this->sharelist[i].get_access()<<endl;
            tstream<<"\n\n";
        }
    }
    data.close();
    this->state="not changed";


}
void TinyCfg::debug_out(){
    qDebug()<<"Config:\n\n"<<"IP: "<<this->cfg.get_ipadr();
    qDebug()<<"Subnetmask: "<<this->cfg.get_subnet();
    qDebug()<<"Hostname: "<<this->cfg.get_hostname();
    qDebug()<<"Workgroup: "<<this->cfg.get_workgroup();
    qDebug()<<"Passwords Path: "<<this->cfg.get_passwords();
    qDebug()<<"Password Check: "<<this->cfg.get_passwd_check();
    qDebug()<<"\n\n\nShares:\n\n";
    for(int i=0;i<this->sharelist.size();i++){
        qDebug()<<this->sharelist[i].get_share_name();
        qDebug()<<this->sharelist[i].get_path();
        qDebug()<<this->sharelist[i].get_all_users();
        qDebug()<<this->sharelist[i].get_access();

    }
}

void TinyCfg::set_tinycfgfile(QString path){
    this->tinycfgfile=path;
}
QString TinyCfg::get_tinycfgfile(){
    return this->tinycfgfile;
}
