//  Copyright © 2010    Karl Wintermmann
//
//  TinySmbGui is distributed under the GNU GENERAL PUBLIC LICENSE (GPL)
//  Sourcecode which use TinySmbGui must be published. Commercial users
//  must published their code too.


#include "mainwindow.h"
#include "ui_mainwindow.h"
#include <QDebug>





MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);
    //config.set_tinycfgfile("/tinysmb.conf");
    refresh();
    dl=new Dialog;
    tinysettings = new Settings;
}

MainWindow::~MainWindow()
{
    delete ui;
    delete dl;
    delete tinysettings;
}


void MainWindow::labelrefresh(){
    ui->label_ipadr->setText(config.get_cfg().get_ipadr());
    ui->label_subnetmask->setText(config.get_cfg().get_subnet());
    ui->label_hostname->setText(config.get_cfg().get_hostname());
    ui->label_workgroup->setText(config.get_cfg().get_workgroup());
    ui->label_passwords->setText(config.get_cfg().get_passwords());
    ui->label_pw_check->setText(config.get_cfg().get_passwd_check());
    if(netadr.get_ip_adr()=="300.300.300.300"){
        ui->label_ipadr_wlan->setText("");
    }
    else{
        ui->label_ipadr_wlan->setText(netadr.get_ip_adr());
    }
    ui->label_shares->setNum(config.get_all_shares().size());
    if (tinysmb.get_server_status()) ui->label_serverstatus->setText("online");
    else ui->label_serverstatus->setText("offline");
    if(netadr.get_ip_adr()=="300.300.300.300") {
        ui->label_warnings->setText("Wlan offline?");
    }
    else if((netadr.get_ip_adr()!=config.get_cfg().get_ipadr()) && (netadr.get_ip_adr()!="300.300.300.300")) {
        ui->label_warnings->setText("Wlan IP != Server IP");
    }
    else ui->label_warnings->setText("");
}
void MainWindow::refresh(){
    config.read_cfg_file();
    netadr.set_adr();
    labelrefresh();
}


void MainWindow::on_pushButton_refresh_clicked()
{
    refresh();
}

void MainWindow::on_pushButton_start_server_clicked()
{
    tinysmb.start_server();
    refresh();
}

void MainWindow::on_pushButton_stop_server_clicked()
{
    tinysmb.stop_server();
    refresh();
}

void MainWindow::on_pushButton_shares_clicked()
{
    int i;
    dl->setshares(config.get_all_shares());
    dl->upd_label();
    i=dl->exec();
    if(i==1) {
        if(tinysmb.get_server_status()){
            tinysmb.stop_server();
            config.rm_all_shares();
            config.add_shares(dl->getshares());
            config.write_cfg_file();
            tinysmb.start_server();
        }
        else {
            config.rm_all_shares();
            config.add_shares(dl->getshares());
            config.write_cfg_file();
        }
    }
    //else qDebug()<<"Nix geaendert";
    refresh();
}

void MainWindow::on_pushButton_config_clicked()
{
    int i;
    tinysettings->set_cfg(config.get_cfg());
    i=tinysettings->exec();
    if(i==1) {
        if(tinysmb.get_server_status()){
            tinysmb.stop_server();
            config.set_cfg(tinysettings->get_cfg());
            config.write_cfg_file();
            tinysmb.start_server();
        }
        else{
            config.set_cfg(tinysettings->get_cfg());
            config.write_cfg_file();
        }
    }
    refresh();
}
