//*****************************************************************************
//*
//*
//*     BitUtility.cpp
//*
//*
//*****************************************************************************
//
//  Copyright  2003    Anton Zechner
//
//  AzSmb is distributed under the GNU GENERAL PUBLIC LICENSE (GPL)
//  Sourcecode which use AzSmb must be published. Commercial users
//  must published their code too, or make an licence agreement with me.
//
//
//  AzSmb wird unter GNU GENERAL PUBLIC LICENSE (GPL) vertreiben.
//  Sourcecode welcher AzSmb verwendet muss verffentlicht werden.
//  Kommerzielle Nutzer mssen ihren Code ebenfalls verffentlichen, oder
//  eine Nutzungsvereinbarung mit mir treffen.
//
//  az_software@inode.at
//


#include	"BitUtility.h"
#include	"System.h"


#ifdef SMB_NO_ASM


static  unsigned char   ucBitOffset[256] =
    {
    8,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,
    4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,
    5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,
    4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,
    6,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,
    4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,
    5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,
    4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,
    7,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,
    4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,
    5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,
    4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,
    6,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,
    4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,
    5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,
    4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,
    };


//*****************************************************************************
//*
//*     bit_set
//*
//*****************************************************************************
//  sets a bit in a memory area
//  pMem    : pointer to the memory area
//  iOffset : is the bit offest in the memory area
//  returns -1 if the bit was set, or 0 if it wan't set.
int bit_set(void *pMem,int iOffset)
{
char   *pPtr=(char*)pMem;
char    cBit;
int     iRet;


    pPtr += iOffset>>3;
    cBit  = 1<<(iOffset&7);

    if(*pPtr&cBit)
        {
        iRet   = -1;
        }
    else{
        *pPtr |= cBit;
        iRet   = 0;
        }


return 0;
}


//*****************************************************************************
//*
//*     bit_clear
//*
//*****************************************************************************
//  clears a bit in a memory area
//  pMem    : pointer to the memory area
//  iOffset : is the bit offest in the memory area
//  returns -1 if the bit was set, or 0 if it wan't set.
int bit_clear(void *pMem,int iOffset)
{
char   *pPtr=(char*)pMem;
char    cBit;
int     iRet;


    pPtr += iOffset>>3;
    cBit  = 1<<(iOffset&7);

    if(*pPtr&cBit)
        {
        *pPtr &= ~cBit;
        iRet   = -1;
        }
    else{
        iRet   = 0;
        }


return 0;
}



//*****************************************************************************
//*
//*     bit_read
//*
//*****************************************************************************
//  reads a bit from a memory area
//  pMem    : pointer to the memory area
//  iOffset : is the bit offest in the memory area
//  returns -1 if the bit was set, or 0 if it wan't set.
int bit_read(const void *pMem,int iOffset)
{

    return (((char*)pMem)[iOffset>>3]&(1<<(iOffset&7)))? -1:0;

}


//*****************************************************************************
//*
//*     bit_find_0_next
//*
//*****************************************************************************
//  seaches for an 0 bit in a memory area
//  pMem    : pointer to the memory area
//  uCount  : is the size of the memory area in bits
//  uOffset : is the bit in the memory area where the seach beginns
//  returns the founded bit position or the area size
int bit_find_0_next(const void *pMem,unsigned uCount,unsigned uOffset)
{
unsigned   *pPtr=(unsigned*)pMem;
unsigned	uBits;
unsigned	uPos;
unsigned	uMax;


	if(uOffset>=uCount)return uCount;

	uPos   =  uOffset&~0x1F;
	uMax   =  uCount &~0x1F;
	pPtr  +=  uPos;
	uBits  =~*pPtr;
	uBits &=  0xFFFFFFFF<<(uOffset&0x1F);


	for(;uPos<uMax;uPos+=32,pPtr++,uBits=~*pPtr)    // Durchsuche 32 Bitpakete
		{
		if(!uBits)continue;

		if(uBits&0xFF)return uPos+ucBitOffset[uBits&0xFF];
		   uBits>>=8;
		if(uBits&0xFF)return uPos+ucBitOffset[uBits&0xFF];
		   uBits>>=8;
		if(uBits&0xFF)return uPos+ucBitOffset[uBits&0xFF];
		   uBits>>=8;
					  return uPos+ucBitOffset[uBits&0xFF];
		}


	if(uCount&0x1F)                                 // Durchsuche die letzen Bits
		{
		uBits  = ~*pPtr;
		uBits |=   0xFFFFFFFF<<(uCount&0x1F);

		if(uBits&0xFF)return uPos+ucBitOffset[uBits&0xFF];
		   uBits>>=8;
		if(uBits&0xFF)return uPos+ucBitOffset[uBits&0xFF];
		   uBits>>=8;
		if(uBits&0xFF)return uPos+ucBitOffset[uBits&0xFF];
		   uBits>>=8;
					  return uPos+ucBitOffset[uBits&0xFF];
		}


return uCount;
}


//*****************************************************************************
//*
//*     bit_find_1_next
//*
//*****************************************************************************
//  seaches for an 0 bit in a memory area
//  pMem    : pointer to the memory area
//  uCount  : is the size of the memory area in bits
//  uOffset : is the bit in the memory area where the seach beginns
//  returns the founded bit position or the area size
int bit_find_1_next(const void *pMem,unsigned uCount,unsigned uOffset)
{
unsigned   *pPtr=(unsigned*)pMem;
unsigned	uBits;
unsigned	uPos;
unsigned	uMax;


	if(uOffset>=uCount)return uCount;

	uPos   =  uOffset&~0x1F;
	uMax   =  uCount &~0x1F;
	pPtr  +=  uPos;
	uBits  = *pPtr;
	uBits &=  0xFFFFFFFF<<(uOffset&0x1F);


	for(;uPos<uMax;uPos+=32,pPtr++,uBits=*pPtr)     // Durchsuche 32 Bitpakete
		{
		if(!uBits)continue;

		if(uBits&0xFF)return uPos+ucBitOffset[uBits&0xFF];
		   uBits>>=8;
		if(uBits&0xFF)return uPos+ucBitOffset[uBits&0xFF];
		   uBits>>=8;
		if(uBits&0xFF)return uPos+ucBitOffset[uBits&0xFF];
		   uBits>>=8;
					  return uPos+ucBitOffset[uBits&0xFF];
		}


	if(uCount&0x1F)                                 // Durchsuche die letzen Bits
		{
		uBits  = *pPtr;
		uBits |=  0xFFFFFFFF<<(uCount&0x1F);

		if(uBits&0xFF)return uPos+ucBitOffset[uBits&0xFF];
		   uBits>>=8;
		if(uBits&0xFF)return uPos+ucBitOffset[uBits&0xFF];
		   uBits>>=8;
		if(uBits&0xFF)return uPos+ucBitOffset[uBits&0xFF];
		   uBits>>=8;
					  return uPos+ucBitOffset[uBits&0xFF];
		}


return uCount;
}


#else

#ifdef  _MSC_VER
#pragma warning( disable :4035 )
#ifdef	_WIN64 
#include <intrin.h>
#endif		
#endif


//*****************************************************************************
//*
//*		bit_find_0_next
//*
//*****************************************************************************
//	Sucht das nchste gelschte Bit in einem Speicherbereich ab einem Offset.
//	pMem		: Ist der Zeiger auf den Speicherbereich.
//	uCount		: Ist die Gre der Speicherbereiches in Bits.
//	uOffset		: Ist die Bitposition ab der gesucht wird
//	Ergibt die Position an der das Bit gefunden wurde, bzw. die Gre des Bereiches.
int _cdecl bit_find_0_next(const void *pMem,unsigned uCount,unsigned uOffset)
{
#ifdef NO_BIT_ASM

	unsigned   *pPtr=(unsigned*)pMem;
	unsigned	uBits;
	unsigned 	uPos;
	unsigned 	uMax;


	if(uOffset>=uCount)return uCount;

	uPos   =  uOffset  &~0x1F;
	uMax   = (uCount-1)&~0x1F;
	uBits  = ~pPtr[uPos/32];
	uBits &=  0xFFFFFFFF<<(uOffset&0x1F);


	for(;uPos<uMax;uPos+=32,uBits=~pPtr[uPos/32])	// Durchsuche 32 Bitpakete
		{
		if(!uBits)continue;

		if(uBits&0xFF)return uPos+ucBitOffset[uBits&0xFF];
		   uBits>>=8;
		if(uBits&0xFF)return uPos+ucBitOffset[uBits&0xFF];
		   uBits>>=8;
		if(uBits&0xFF)return uPos+ucBitOffset[uBits&0xFF];
		   uBits>>=8;
					  return uPos+ucBitOffset[uBits&0xFF];
		}


	uBits |=   0xFFFFFFFF<<(uCount&0x1F);			// Durchsuche die letzten Bits

	if(uBits&0xFF)return uPos+ucBitOffset[uBits&0xFF];
	   uBits>>=8;
	if(uBits&0xFF)return uPos+ucBitOffset[uBits&0xFF];
	   uBits>>=8;
	if(uBits&0xFF)return uPos+ucBitOffset[uBits&0xFF];
	   uBits>>=8;
				  return uPos+ucBitOffset[uBits&0xFF];


	return uCount;

#elif defined(LINUX) && defined(__i386__)

	int     iRet;

    asm volatile(
        "movl   %%ebx,%%ecx     \n"
        "movl   %%ebx,%%eax     \n"
        "shrl   $5   ,%%ebx     \n"
        "andb   $31  ,%%cl      \n"
        "shll   $2   ,%%ebx     \n"
        "subb   %%cl ,%%al      \n"
        "addl   %1   ,%%ebx     \n"
        "cmpl   %%edi,%%eax     \n"
        "jnb    3f              \n"
        "movl   (%%ebx),%%esi   \n"
        "notl   %%esi           \n"
        "shrl   %%cl ,%%esi     \n"
        "shll   %%cl ,%%esi     \n"
        "bsfl   %%esi,%%ecx     \n"
        "jmp    2f              \n"
        "1:                     \n"
        "addl   $4   ,%%ebx     \n"
        "addl   $32  ,%%eax     \n"
        "cmpl   %%edi,%%eax     \n"
        "jnb    3f              \n"
        "movl   (%%ebx),%%esi   \n"
        "notl   %%esi           \n"
        "bsfl   %%esi,%%ecx     \n"
        "2:                     \n"
        "jz     1b              \n"
        "addl   %%ecx,%%eax     \n"
        "cmpl   %%edi,%%eax     \n"
        "jbe    4f              \n"
        "3:                     \n"
        "movl   %%edi,%%eax     \n"
        "4:                     \n"
        :"=a" (iRet)
        :"m" (pMem), "D" (uCount), "b" (uOffset)
        :"ecx","esi"
        );

    return iRet;

#elif defined(LINUX) && defined(__x86_64__)

	int     iRet;

    asm volatile(
        "movl   %%ebx,%%ecx     \n"
        "movl   %%ebx,%%eax     \n"
        "shrl   $6   ,%%ebx     \n"
        "andb   $63  ,%%cl      \n"
        "shll   $3   ,%%ebx     \n"
        "subb   %%cl ,%%al      \n"
        "andq $0xFFFFFFFF,%%rbx \n"
        "addq   %1   ,%%rbx     \n"
        "cmpl   %%edi,%%eax     \n"
        "jnb    3f              \n"
        "movq   (%%rbx),%%rsi   \n"
        "notq   %%rsi           \n"
        "shrq   %%cl ,%%rsi     \n"
        "shlq   %%cl ,%%rsi     \n"
        "bsfq   %%rsi,%%ecx     \n"
        "jmp    2f              \n"
        "1:                     \n"
        "addq   $8   ,%%rbx     \n"
        "addl   $64  ,%%eax     \n"
        "cmpl   %%edi,%%eax     \n"
        "jnb    3f              \n"
        "movq   (%%rbx),%%rsi   \n"
        "notq   %%rsi           \n"
        "bsfq   %%rsi,%%rcx     \n"
        "2:                     \n"
        "jz     1b              \n"
        "addl   %%ecx,%%eax     \n"
        "cmpl   %%edi,%%eax     \n"
        "jbe    4f              \n"
        "3:                     \n"
        "movl   %%edi,%%eax     \n"
        "4:                     \n"
        :"=a" (iRet)
        :"m" (pMem), "D" (uCount), "b" (uOffset)
        :"rcx","rsi"
        );

  	return iRet;

#elif defined(_WIN64)

	unsigned __int64 *pMem64=(unsigned __int64*)pMem;
	unsigned __int64  uValue;
	unsigned long 	  uPos;
	unsigned		  uMax;


	if(uOffset>=uCount)return uCount;

	uValue = ~pMem64[uOffset/64];
	uMax   = (uCount-1)&~0x3F;

	if(uOffset&0x3F)
		{
		uValue  &= 0xFFFFFFFFFFFFFFFF<<(uOffset&0x3F);
		uOffset	&= ~0x3F;
		}
	
	while(uOffset<uMax)
		{
		if(_BitScanForward64(&uPos,uValue))
			{
			return uOffset+uPos;
			}

		uOffset += 64;
		uValue   = ~pMem64[uOffset/64];
		}

	
	uValue <<= 64-(uOffset&0x3F); 	
	uValue >>= 64-(uOffset&0x3F); 	


	if(_BitScanForward64(&uPos,uValue))
		{
		return uOffset+uPos;
		}
	
	return uCount;

#elif !defined(_M_IX86)
	
	unsigned		 *pMem32=(unsigned*)pMem;
	unsigned		  uValue;
	unsigned long 	  uPos;
	unsigned		  uMax;


	if(uOffset>=uCount)return uCount;

	uValue = ~pMem32[uOffset/32];
	uMax   = (uCount-1)&~0x1F;

	if(uOffset&0x1F)
		{
		uValue  &= 0xFFFFFFFF<<(uOffset&0x1F);
		uOffset	&= ~0x1F;
		}
	
	while(uOffset<uMax)
		{
		if(_BitScanForward(&uPos,uValue))
			{
			return uOffset+uPos;
			}

		uOffset += 32;
		uValue   = ~pMem32[uOffset/32];
		}

	
	uValue <<= 32-(uOffset&0x1F); 	
	uValue >>= 32-(uOffset&0x1F); 	


	if(_BitScanForward(&uPos,uValue))
		{
		return uOffset+uPos;
		}
	
	return uCount;

#else

_asm	{
		mov		ebx,uOffset			;// Offset laden
		mov     ecx,ebx				;// 		*
		mov     eax,ebx				;// 		*

		shr     ebx,5				;// EBX = Byte-Offset vom Start-Bit
		and		cl ,1Fh				;// ESI = Start-Bit    auf 32 gerundet
		mov		edi,uCount			;// EDI = Bit-Anzahl
		shl     ebx,2				;// EBX = Byte-Offset vom Start-Bit
		sub     al ,cl				;// EAX = Bit-Position auf 32 gerundet
		add		ebx,pMem			;// EBX = Byte-Adresse

		cmp		eax,edi				;// berlauf ?
		jnb     ende1				;// 		*
		mov     esi,[ebx]			;// Die ersten 32-Bit laden
		not		esi					;// 		*
 		shr		esi,cl				;// 		*
		shl		esi,cl				;// 		*
		bsf	    ecx,esi				;// Suche Bit
		jmp		start				;// 		*

loop1:	add		ebx,4				;// Die nchsten 32-Bit
		add		eax,32				;// 	*
		cmp		eax,edi				;// 	*
		jnb     ende1				;// berlauf ?
		mov	    esi,[ebx]			;// Suche Bit
		not		esi					;// 		*
		bsf	    ecx,esi				;// Suche Bit
start:	jz	    loop1

		add     eax,ecx				;// Ergebnis berechen
      	cmp		eax,edi				;// 	*
		jbe     ende2				;// Gab es einen berlauf

ende1:	mov		eax,edi				;// berlauf
ende2:
		}

#endif
}


//*****************************************************************************
//*
//*		bit_find_1_next
//*
//*****************************************************************************
//	Sucht das nchste gesetzte Bit in einem Speicherbereich ab einem Offset.
//	pMem		: Ist der Zeiger auf den Speicherbereich.
//	uCount		: Ist die Gre der Speicherbereiches in Bits.
//	uOffset		: Ist die Bitposition ab der gesucht wird
//	Ergibt die Position an der das Bit gefunden wurde, bzw. die Gre des Bereiches.
int _cdecl bit_find_1_next(const void *pMem,unsigned uCount,unsigned uOffset)
{
#ifdef NO_BIT_ASM

	unsigned   *pPtr=(unsigned*)pMem;
	unsigned	uBits;
	unsigned 	uPos;
	unsigned 	uMax;


	if(uOffset>=uCount)return uCount;
	
	uPos   =  uOffset  &~0x1F;
	uMax   = (uCount-1)&~0x1F;
	uBits  =  pPtr[uPos/32];
	uBits &=  0xFFFFFFFF<<(uOffset&0x1F);


	for(;uPos<uMax;uPos+=32,uBits=pPtr[uPos/32])	// Durchsuche 32 Bitpakete
		{
		if(!uBits)continue;

		if(uBits&0xFF)return uPos+ucBitOffset[uBits&0xFF];
		   uBits>>=8;
		if(uBits&0xFF)return uPos+ucBitOffset[uBits&0xFF];
		   uBits>>=8;
		if(uBits&0xFF)return uPos+ucBitOffset[uBits&0xFF];
		   uBits>>=8;
					  return uPos+ucBitOffset[uBits&0xFF];
		}


	uBits |=  0xFFFFFFFF<<(uCount&0x1F);			// Durchsuche die letzten Bits

	if(uBits&0xFF)return uPos+ucBitOffset[uBits&0xFF];
	   uBits>>=8;
	if(uBits&0xFF)return uPos+ucBitOffset[uBits&0xFF];
	   uBits>>=8;
	if(uBits&0xFF)return uPos+ucBitOffset[uBits&0xFF];
	   uBits>>=8;
				  return uPos+ucBitOffset[uBits&0xFF];


	return uCount;

#elif defined(_WIN64)

	unsigned __int64 *pMem64=(unsigned __int64*)pMem;
	unsigned __int64  uValue;
	unsigned long 	  uPos;
	unsigned		  uMax;


	if(uOffset>=uCount)return uCount;

	uValue = pMem64[uOffset/64];
	uMax   = (uCount-1)&~0x3F;

	if(uOffset&0x3F)
		{
		uValue  &= 0xFFFFFFFFFFFFFFFF<<(uOffset&0x3F);
		uOffset	&= ~0x3F;
		}
	
	while(uOffset<uMax)
		{
		if(_BitScanForward64(&uPos,uValue))
			{
			return uOffset+uPos;
			}

		uOffset += 64;
		uValue   = pMem64[uOffset/64];
		}

	
	uValue <<= 64-(uOffset&0x3F); 	
	uValue >>= 64-(uOffset&0x3F); 	


	if(_BitScanForward64(&uPos,uValue))
		{
		return uOffset+uPos;
		}
	
	return uCount;

#elif defined(LINUX) && defined(__i386__)

	int     iRet;

    asm volatile(
        "movl   %%ebx,%%ecx     \n"
        "movl   %%ebx,%%eax     \n"
        "shrl   $5   ,%%ebx     \n"
        "andb   $31  ,%%cl      \n"
        "shll   $2   ,%%ebx     \n"
        "subb   %%cl ,%%al      \n"
        "addl   %1   ,%%ebx     \n"
        "cmpl   %%edi,%%eax     \n"
        "jnb    3f              \n"
        "movl   (%%ebx),%%esi   \n"
        "shrl   %%cl ,%%esi     \n"
        "shll   %%cl ,%%esi     \n"
        "bsfl   %%esi,%%ecx     \n"
        "jmp    2f              \n"
        "1:                     \n"
        "addl   $4   ,%%ebx     \n"
        "addl   $32  ,%%eax     \n"
        "cmpl   %%edi,%%eax     \n"
        "jnb    3f              \n"
        "bsfl   (%%ebx),%%ecx   \n"
        "2:                     \n"
        "jz     1b              \n"
        "addl   %%ecx,%%eax     \n"
        "cmpl   %%edi,%%eax     \n"
        "jbe    4f              \n"
        "3:                     \n"
        "movl   %%edi,%%eax     \n"
        "4:                     \n"
        :"=a" (iRet)
        :"m" (pMem), "D" (uCount), "b" (uOffset)
        :"ecx","esi"
        );

    return iRet;

#elif defined(LINUX) && defined(__x86_64__)

	int     iRet;

    asm volatile(
        "movl   %%ebx,%%ecx     \n"
        "movl   %%ebx,%%eax     \n"
        "shrl   $6   ,%%ebx     \n"
        "andb   $63  ,%%cl      \n"
        "shll   $3   ,%%ebx     \n"
        "subb   %%cl ,%%al      \n"
        "andq $0xFFFFFFFF,%%rbx \n"
        "addq   %1   ,%%rbx     \n"
        "cmpl   %%edi,%%eax     \n"
        "jnb    3f              \n"
        "movq   (%%rbx),%%rsi   \n"
        "shrq   %%cl ,%%rsi     \n"
        "shlq   %%cl ,%%rsi     \n"
        "bsfq   %%rsi,%%rcx     \n"
        "jmp    2f              \n"
        "1:                     \n"
        "addq   $8   ,%%rbx     \n"
        "addl   $64  ,%%eax     \n"
        "cmpl   %%edi,%%eax     \n"
        "jnb    3f              \n"
        "bsfq   (%%rbx),%%rcx   \n"
        "2:                     \n"
        "jz     1b              \n"
        "addl   %%ecx,%%eax     \n"
        "cmpl   %%edi,%%eax     \n"
        "jbe    4f              \n"
        "3:                     \n"
        "movl   %%edi,%%eax     \n"
        "4:                     \n"
        :"=a" (iRet)
        :"m" (pMem), "D" (uCount), "b" (uOffset)
        :"rcx","rsi"
        );

	return iRet;

#elif !defined(_M_IX86)
	
	unsigned		 *pMem32=(unsigned*)pMem;
	unsigned		  uValue;
	unsigned long 	  uPos;
	unsigned		  uMax;


	if(uOffset>=uCount)return uCount;

	uValue = pMem32[uOffset/32];
	uMax   = (uCount-1)&~0x1F;

	if(uOffset&0x1F)
		{
		uValue  &= 0xFFFFFFFF<<(uOffset&0x1F);
		uOffset	&= ~0x1F;
		}
	
	while(uOffset<uMax)
		{
		if(_BitScanForward(&uPos,uValue))
			{
			return uOffset+uPos;
			}

		uOffset += 32;
		uValue   = pMem32[uOffset/32];
		}

	
	uValue <<= 32-(uOffset&0x1F); 	
	uValue >>= 32-(uOffset&0x1F); 	


	if(_BitScanForward(&uPos,uValue))
		{
		return uOffset+uPos;
		}
	
	return uCount;

#else

_asm	{
		mov		ebx,uOffset			;// Offset laden
		mov     ecx,ebx				;// 		*
		mov     eax,ebx				;// 		*

		shr     ebx,5				;// EBX = DWORD-Offset vom Start-Bit
		and		cl ,1Fh				;// ESI = Start-Bit auf 32 gerundet
		mov		edi,uCount			;// EDI = Bit-Anzahl
		shl     ebx,2				;// EBX = Byte-Offset vom Start-Bit
		sub     al ,cl				;// EAX = Bit-Position auf 32 gerundet
		add		ebx,pMem			;// EBX = Byte-Adresse

		cmp		eax,edi				;// berlauf ?
		jnb     ende1				;// 		*
		mov     esi,[ebx]			;// Die ersten 32-Bit laden
 		shr		esi,cl				;// 		*
		shl		esi,cl				;// 		*
		bsf	    ecx,esi				;// Suche Bit
		jmp		start				;// 		*

loop1:	add		ebx,4				;// Die nchsten 32-Bit
		add		eax,32				;// 	*
		cmp		eax,edi				;// 	*
		jnb     ende1				;// berlauf ?
		bsf	    ecx,[ebx]			;// Suche Bit
start:	jz	    loop1

		add     eax,ecx				;// Ergebnis berechen
      	cmp		eax,edi				;// 	*
		jbe     ende2				;// Gab es einen berlauf
									;//
ende1:	mov		eax,edi				;// ;berlauf
ende2:
		}

#endif
}

#endif		
