//*****************************************************************************
//*
//*
//*     SmbReply.cpp
//*
//*
//*****************************************************************************
//
//  Copyright  2003    Anton Zechner
//
//  AzSmb is distributed under the GNU GENERAL PUBLIC LICENSE (GPL)
//  Sourcecode which use AzSmb must be published. Commercial users
//  must published their code too, or make an licence agreement with me.
//
//
//  AzSmb wird unter GNU GENERAL PUBLIC LICENSE (GPL) vertreiben.
//  Sourcecode welcher AzSmb verwendet muss verffentlicht werden.
//  Kommerzielle Nutzer mssen ihren Code ebenfalls verffentlichen, oder
//  eine Nutzungsvereinbarung mit mir treffen.
//
//  az_software@inode.at
//
//


#include "Smb.h"
#include "SmbIpc.h"
#include "SmbMisc.h"
#include "SmbCrypt.h"
#include "SmbLanman.h"
#include "SmbServer.h"
#include "SmbInline.h"
#include "SmbInclude.h"



int          _cdecl  SmbTreeCheck   (const SmbTreeData *pData){return 0;}
int          _cdecl  SmbUserLogon   (SmbUserEntry      *pUser,const char *pUsername){SmbInsertTreeEntry(pUser,"C:","C",0,SMB_MODE_READWRITE,NULL);return 1;}
int         (_cdecl *smb_tree_check)(const SmbTreeData *pData                      )=SmbTreeCheck;
int         (_cdecl *smb_user_logon)(SmbUserEntry      *pUser,const char *pUsername)=SmbUserLogon;





#if SYS_HAS_SHORT_NAME
#define     cFName      cShortName
#else
#define     cFName      cName
#endif

/* access various pService details */


int ChainReply   (SmbSession *pSession,          unsigned char *pIn,unsigned char *pOut,int iSize,int iBuffSize);
int SwitchMessage(SmbSession *pSession,int iType,unsigned char *pIn,unsigned char *pOut,int iSize,int iBuffSize);
int SmbNamedPipe (SmbSession *pSession,unsigned short wUid,unsigned char *pOut,
                    char *pPipeName,unsigned short *pSetup,char *pData,char *pParam,
                    int iSetupWordCount,int iTotalDataCount,int iTotalParamCount,
                    int iMaxSetupReturn,int iMaxDataReturn ,int iMaxParamReturn);


#define     NT_GENERIC_READ             0x80000000
#define     NT_GENERIC_WRITE            0x40000000
#define     NT_SHARE_READ               0x00000001
#define     NT_SHARE_WRITE              0x00000002
#define     NT_ATTRIBUTE_READONLY       0x00000001
#define     NT_ATTRIBUTE_HIDDEN         0x00000002
#define     NT_ATTRIBUTE_SYSTEM         0x00000004
#define     NT_ATTRIBUTE_DIRECTORY      0x00000010
#define     NT_ATTRIBUTE_ARCHIVE        0x00000020
#define     NT_ATTRIBUTE_NORMAL         0x00000080
#define     NT_ATTRIBUTE_TEMPORARY      0x00000100
#define     NT_DIRECTORY_FILE           0x00000001
#define     NT_NON_DIRECTORY_FILE       0x00000040
#define     NT_OPEN_BY_FILE_ID          0x00002000


#define HAS_IPC         0
#define SMB_MSG(a,b,c)  {a,b,c}
#define SMBxMSG(a,b,c)  {a,NULL,c}

static  SmbTreeEntry    sIpcTree={-1,0,1};
static  int             iTempNum=0;

typedef struct
    {
    const char    *pName;
    int          (*pProc)(SmbSession *pSession,unsigned char*,unsigned char*,int,int);
    int            iFlags;
    }SmbMessageStruct;


static const SmbMessageStruct sSmbMessages[256] =
    {
    /* 0x00 */ SMB_MSG( "SMBmkdir"          ,ReplyMkDir     ,F_USER|F_WRITE),
    /* 0x01 */ SMB_MSG( "SMBrmdir"          ,ReplyRmDir     ,F_USER|F_WRITE),
    /* 0x02 */ SMB_MSG( "SMBopen"           ,ReplyOpen      ,F_USER),
    /* 0x03 */ SMB_MSG( "SMBcreate"         ,ReplyMkNew     ,F_USER|F_WRITE),
    /* 0x04 */ SMB_MSG( "SMBclose"          ,ReplyClose     ,F_USER|F_FID|CAN_IPC),
    /* 0x05 */ SMB_MSG( "SMBflush"          ,ReplyFlush     ,F_USER|F_FID),
    /* 0x06 */ SMB_MSG( "SMBunlink"         ,ReplyUnlink    ,F_USER|F_WRITE),
    /* 0x07 */ SMB_MSG( "SMBmv"             ,ReplyMove      ,F_USER|F_WRITE),
    /* 0x08 */ SMB_MSG( "SMBgetatr"         ,ReplyGetAttr   ,F_USER),
    /* 0x09 */ SMB_MSG( "SMBsetatr"         ,ReplySetAttr   ,F_USER|F_WRITE),
    /* 0x0A */ SMB_MSG( "SMBread"           ,ReplyRead      ,F_USER|F_FID),
    /* 0x0B */ SMB_MSG( "SMBwrite"          ,ReplyWrite     ,F_USER|F_FID|CAN_IPC),
    /* 0x0C */ SMB_MSG( "SMBlock"           ,ReplyLock      ,F_USER|F_FID),
    /* 0x0D */ SMB_MSG( "SMBunlock"         ,ReplyUnlock    ,F_USER|F_FID),
    /* 0x0E */ SMB_MSG( "SMBctemp"          ,ReplyCTemp     ,F_USER|F_WRITE),
    /* 0x0F */ SMB_MSG( "SMBmknew"          ,ReplyMkNew     ,F_USER|F_WRITE),
    /* 0x10 */ SMB_MSG( "SMBchkpth"         ,ReplyCheckPath ,F_USER),
    /* 0x11 */ SMB_MSG( "SMBexit"           ,ReplyExit      ,0),
    /* 0x12 */ SMB_MSG( "SMBlseek"          ,ReplyLseek     ,F_USER|F_FID),
    /* 0x13 */ SMB_MSG( "SMBlockread"       ,ReplyLockRead  ,F_USER|F_FID),
    /* 0x14 */ SMB_MSG( "SMBwriteunlock"    ,ReplyWriteUnlock,F_USER|F_FID),
    /* 0x15 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x16 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x17 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x18 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x19 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x1A */ SMB_MSG( "SMBreadbraw"       ,ReplyReadBRaw  ,F_USER),
    /* 0x1B */ SMB_MSG( "SMBreadBmpx"       ,NULL,0),
    /* 0x1C */ SMB_MSG( "SMBreadBs"         ,NULL,0),
    /* 0x1D */ SMB_MSG( "SMBwritebraw"      ,ReplyWriteBRaw ,F_USER|F_FID|F_WRITE),
    /* 0x1E */ SMB_MSG( "SMBwriteBmpx"      ,NULL,0),
    /* 0x1F */ SMB_MSG( "SMBwriteBs"        ,NULL,0),
    /* 0x20 */ SMB_MSG( "SMBwritec"         ,NULL,0),
    /* 0x21 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x22 */ SMB_MSG( "SMBsetattrE"       ,ReplySetAttrE  ,F_USER|F_FID|F_WRITE),
    /* 0x23 */ SMB_MSG( "SMBgetattrE"       ,ReplyGetAttrE  ,F_USER|F_FID ),
    /* 0x24 */ SMB_MSG( "SMBlockingX"       ,ReplyLockingX  ,F_USER|F_FID2),
    /* 0x25 */ SMB_MSG( "SMBtrans"          ,ReplyTrans     ,F_USER|CAN_IPC),
    /* 0x26 */ SMB_MSG( "SMBtranss"         ,NULL           ,F_USER|CAN_IPC),
    /* 0x27 */ SMBxMSG( "SMBioctl"          ,ReplyIoctl     ,0),
    /* 0x28 */ SMBxMSG( "SMBioctls"         ,NULL           ,F_USER|F_FID),
    /* 0x29 */ SMBxMSG( "SMBcopy"           ,ReplyCopy      ,F_USER|F_WRITE),
    /* 0x2A */ SMBxMSG( "SMBmove"           ,NULL           ,F_USER|F_WRITE),
    /* 0x2B */ SMB_MSG( "SMBecho"           ,ReplyEcho      ,0),
    /* 0x2C */ SMB_MSG( "SMBwriteclose"     ,ReplyWriteClose,F_USER|F_FID|F_WRITE),
    /* 0x2D */ SMB_MSG( "SMBopenX"          ,ReplyOpenAndX  ,F_USER|CAN_IPC),
    /* 0x2E */ SMB_MSG( "SMBreadX"          ,ReplyReadAndX  ,F_USER|F_FID2|CAN_IPC),
    /* 0x2F */ SMB_MSG( "SMBwriteX"         ,ReplyWriteAndX ,F_USER|F_FID2|CAN_IPC),
    /* 0x30 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x31 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x32 */ SMB_MSG( "SMBtrans2"         ,ReplyTrans2    ,F_USER|CAN_IPC),
    /* 0x33 */ SMB_MSG( "SMBtranss2"        ,ReplyTranss2   ,F_USER),
    /* 0x34 */ SMB_MSG( "SMBfindclose"      ,ReplyFindClose ,F_USER|F_FID),
    /* 0x35 */ SMB_MSG( "SMBfindnclose"     ,ReplyFindNClose,F_USER),
    /* 0x36 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x37 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x38 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x39 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x3A */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x3B */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x3C */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x3D */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x3E */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x3F */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x40 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x41 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x42 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x43 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x44 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x45 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x46 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x47 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x48 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x49 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x4A */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x4B */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x4C */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x4D */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x4E */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x4F */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x50 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x51 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x52 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x53 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x54 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x55 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x56 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x57 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x58 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x59 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x5A */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x5B */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x5C */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x5D */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x5E */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x5F */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x60 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x61 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x62 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x63 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x64 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x65 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x66 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x67 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x68 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x69 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x6A */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x6B */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x6C */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x6D */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x6E */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x6F */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x70 */ SMB_MSG( "SMBtcon"           ,ReplyTcon          ,0),
    /* 0x71 */ SMB_MSG( "SMBtdis"           ,ReplyTdis          ,0),
    /* 0x72 */ SMB_MSG( "SMBnegprot"        ,ReplyNegprot       ,0),
    /* 0x73 */ SMB_MSG( "SMBsetupX"         ,ReplySetupAndX     ,0),
    /* 0x74 */ SMB_MSG( "SMBulogoffX"       ,ReplyULogoffX      ,0),
    /* 0x75 */ SMB_MSG( "SMBtconX"          ,ReplyTconAndX      ,0),
    /* 0x76 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x77 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x78 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x79 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x7A */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x7B */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x7C */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x7D */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x7E */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x7F */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x80 */ SMB_MSG( "SMBdskattr"        ,ReplyDiskAttr  ,F_USER),
    /* 0x81 */ SMB_MSG( "SMBsearch"         ,ReplySearch    ,F_USER),
    /* 0x82 */ SMB_MSG( "SMBffirst"         ,ReplySearch    ,F_USER),
    /* 0x83 */ SMB_MSG( "SMBfunique"        ,ReplySearch    ,F_USER),
    /* 0x84 */ SMB_MSG( "SMBfclose"         ,ReplyFClose    ,F_USER|F_FID),
    /* 0x85 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x86 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x87 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x88 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x89 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x8A */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x8B */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x8C */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x8D */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x8E */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x8F */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x90 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x91 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x92 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x93 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x94 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x95 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x96 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x97 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x98 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x99 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x9A */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x9B */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x9C */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x9D */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x9E */ SMB_MSG( NULL, NULL, 0 ),
    /* 0x9F */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xA0 */ SMBxMSG( "SMBnttrans"        , ReplyNtTrans      ,F_USER|CAN_IPC),
    /* 0xA1 */ SMBxMSG( "SMBnttranss"       , ReplyNtTranss     ,F_USER|CAN_IPC),
    /* 0xA2 */ SMBxMSG( "SMBntcreateX"      , ReplyNtCreateAndX ,F_USER|CAN_IPC),
    /* 0xA3 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xA4 */ SMBxMSG( "SMBntcancel"       , ReplyNtCancel,0),
    /* 0xA5 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xA6 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xA7 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xA8 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xA9 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xAA */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xAB */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xAC */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xAD */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xAE */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xAF */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xB0 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xB1 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xB2 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xB3 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xB4 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xB5 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xB6 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xB7 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xB8 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xB9 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xBA */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xBB */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xBC */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xBD */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xBE */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xBF */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xC0 */ SMBxMSG( "SMBsplopen"        ,ReplyPrintOpen ,F_USER),
    /* 0xC1 */ SMBxMSG( "SMBsplwr"          ,ReplyPrintWrite,F_USER|F_FID),
    /* 0xC2 */ SMBxMSG( "SMBsplclose"       ,ReplyPrintClose,F_USER|F_FID),
    /* 0xC3 */ SMBxMSG( "SMBsplretq"        ,ReplyPrintQueue,F_USER|F_FID),
    /* 0xC4 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xC5 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xC6 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xC7 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xC8 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xC9 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xCA */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xCB */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xCC */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xCD */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xCE */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xCF */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xD0 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xD1 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xD2 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xD3 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xD4 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xD5 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xD6 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xD7 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xD8 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xD9 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xDA */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xDB */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xDC */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xDD */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xDE */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xDF */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xE0 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xE1 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xE2 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xE3 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xE4 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xE5 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xE6 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xE7 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xE8 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xE9 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xEA */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xEB */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xEC */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xED */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xEE */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xEF */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xF0 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xF1 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xF2 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xF3 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xF4 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xF5 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xF6 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xF7 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xF8 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xF9 */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xFA */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xFB */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xFC */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xFD */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xFE */ SMB_MSG( NULL, NULL, 0 ),
    /* 0xFF */ SMB_MSG( NULL, NULL, 0 )
    };



//*****************************************************************************
//*
//*      ErrorPacket
//*
//*****************************************************************************/
//  Create an error packet. Normally called using the SMB_ERROR() macro.
#if     SMB_PRINT_ERR
int     ErrorPacket(unsigned char *pOut,int iErrorClass,unsigned iErrorCode,int iLine,const char *pFile,const char *pError)
#else
int     ErrorPacket(unsigned char *pOut,int iErrorClass,unsigned iErrorCode)
#endif
{
int iOutsize;
int iCmd;


    iCmd     = CVAL(pOut,smb_com);
    iOutsize = SmbSetMessage(pOut,0,0,FALSE);

    SCVAL(pOut,smb_rcls,iErrorClass);
    SSVAL(pOut,smb_err ,iErrorCode);

    #if SMB_PRINT_ERR
    PRINT_SMB_ERR((" SMB Error nr=%i cls=%i (%s) at %s(%i)\n",iErrorCode,iErrorClass,pError,pFile,iLine));
    #endif


return iOutsize;
}

//*****************************************************************************
//*
//*     SmbPacketType
//*
//*****************************************************************************
//  returns then name of a Packet
const char *SmbPacketType(int iType)
{
const char  *pName;

    if(iType<0 || iType>=256)return "???";
    pName=sSmbMessages[iType].pName;
    if(!pName)return "not supportes";


return  pName;
}

//*****************************************************************************
//*
//*     NameLen
//*
//*****************************************************************************
//  return the total storage size of a mangled cName
static int NameLen(unsigned char *pName)
{
int     iLen;



    if((pName[0]&0xC0)==0xC0)return 2;      // If the two high bits of the byte are set, return 2.


    for(iLen = 0; pName[iLen];)             // Add up the size bytes.
        {
        iLen += pName[iLen] + 1;
        }


return iLen+1;
}



//*****************************************************************************
//*
//*     NamePtr
//*
//*****************************************************************************
//  find a pointer to a netbios cName
static inline unsigned char *NamePtr(unsigned char *pName,int iOffset)
{
unsigned char   cChar;


    cChar=pName[iOffset];

    if((cChar&0xC0) == 0xC0)
        {
        iOffset = RSVAL(pName,iOffset) & 0x3FFF;
        }


return pName+iOffset;
}


//*****************************************************************************
//*
//*     NameInterpret
//*
//*****************************************************************************
//  interpret the weird netbios "cName". Return the cName type
//  returns the type of the cName
static int NameInterpret(unsigned char *pIn,char *pOut)
{
int     iRet,iLen;


    iLen = pIn[0]>>1;
    pIn++;
    pOut[0]=0;

    if(iLen>30 || iLen<1)return(0);


    while(iLen--)
        {
        if (pIn[0] < 'A' || pIn[0] > 'P' || pIn[1] < 'A' || pIn[1] > 'P')
            {
            *pOut = 0;
            return 0;
            }

        pOut[0] = ((pIn[0]-'A')<<4) + (pIn[1]-'A');
        pIn += 2;
        pOut++;
        }

    pOut[0] = 0;
    iRet = pOut[-1];


    while(pIn[0])                           // Handle any scope names
        {
        pOut[0] = '.';
        pOut++;
        iLen = *(unsigned char*)pIn++;
        memcpy(pOut, pIn, iLen);
        pOut += iLen;
        pOut[0]=0;
        pIn += iLen;
        }


return  iRet;
}

//*****************************************************************************
//*
//*     NameExtract
//*
//*****************************************************************************
//  extract a netbios cName from a buf
//  returns the type of the cName
int NameExtract(unsigned char *pBuffer,int iOffset,char *pName)
{
unsigned char  *pPtr;
int             iVal;


    pPtr = NamePtr(pBuffer,iOffset);
    iVal = pPtr-(pBuffer+iOffset);

    pName[0]=0;

    if(iVal<-50 || iVal>50)return(0);



return NameInterpret(pPtr,pName);
}

//*****************************************************************************
//*
//*     NameCut
//*
//*****************************************************************************
//  cut all right spaces
static void NameCut(char *pName)
{
int iPos;


    for(iPos=0;iPos<14;iPos++)
        {
        if(pName[iPos+1]==0)break;
        }

    for(;iPos>=0;iPos--)
        {
        if(pName[iPos]!=' ')break;
        }

    pName[iPos+1]=0;

}


//*****************************************************************************
//*
//*     Is83Name
//*
//*****************************************************************************
#if !SYS_HAS_SHORT_NAME
static int Is83Name(const char *pName)
{
char    cChar;
int     iPos;


    for(iPos=0;iPos<12;iPos++)
        {
           cChar=pName[iPos];
        if(cChar== 0  )break;
        if(cChar=='.' )break;
        if(cChar==':' )return FALSE;
        if(cChar=='/' )return FALSE;
        if(cChar=='\\')return FALSE;
        }

    if(iPos > 8)return FALSE;
    if(cChar==0)return TRUE;

    for(iPos++;iPos<13;iPos++)
        {
           cChar=pName[iPos];
        if(cChar== 0  )return TRUE;
        if(cChar=='.' )break;
        if(cChar==':' )break;
        if(cChar=='/' )break;
        if(cChar=='\\')break;
        }


return FALSE;
}
#endif


//*****************************************************************************
//*
//*     ReplySpecial
//*
//*****************************************************************************
//  reply to an special message
int ReplySpecial(SmbSession *pSession,unsigned char *pIn,unsigned char *pOut)
{
int     iOutsize = 4;
int     iType;
char    cName1[52],cName2[52];
char    cNameType = 0;
int     iLen;



    SIVAL(pOut,0,0);
    iType  = CVAL(pIn,0);


    switch(iType)
        {
    case 0x81:                              // session request

        CVAL(pOut,0) = 0x82;
        CVAL(pOut,3) = 0;

        if(NameLen(pIn+4)>50 || NameLen(pIn+4+NameLen(pIn+4))>50)
            {
            PRINT_SMB_ERR(("Invalid cName size in session request"));
            return 0;
            }

        cName1[0] = 0;
        cName2[0] = 0;
        NameExtract(pIn,4,cName1);
        NameExtract(pIn,4+NameLen(pIn+4) ,cName2);

        memcpy  (pSession->cRemoteMachine,cName2,16);
        NameCut (pSession->cRemoteMachine);
        StrLower(pSession->cRemoteMachine);

        memcpy  (pSession->cLocalMachine,cName1,16);
        NameCut (pSession->cLocalMachine);
        StrLower(pSession->cLocalMachine);

        pSession->iLMLen=strlen(pSession->cLocalMachine);

           iLen = strlen(cName1);
        if(iLen == 16) cNameType = cName1[15];

		PRINT_SMB_MSG1((" Session Request = local='%s' remote='%s'",pSession->cLocalMachine,pSession->cRemoteMachine))

        if(cNameType=='R')                  // pathworks session / no thanks!
            {
            CVAL(pOut,0) = 0x83;
            break;
            }

        break;

    case 0x89:                              // session keepalive request (some old clients produce this?)

        CVAL(pOut,0) = 0x85;
        CVAL(pOut,3) = 0;
        break;

    case 0x82:                              // positive session response
    case 0x83:                              // negative session response
    case 0x84:                              // retarget session response

        PRINT_SMB_ERR(("Unexpected session response"));
        break;

    case 0x85:                              // session keepalive

    default:

        return 0;
    }



return iOutsize;
}


//*****************************************************************************
//*
//*     TreeConnect
//*
//*****************************************************************************
//  return: -4 unknown error
//          -3 wrong server name
//          -2 wrong path
//          -1 wrong username/pasword
//           0 connect to disk
//           1 connect to pipe
static int TreeConnect(SmbSession *pSession,SmbTreeData *pTreeData,char *pPath)
{
unsigned short  wUid;
SmbUserEntry   *pUser;
SmbTreeEntry   *pTree;
unsigned        uSize;
int             i,iOk,iLen;


    /*
    PRINT_SMB_MSG1((" Svc=\"%s\"",pTreeData->cService ))
    PRINT_SMB_MSG1((" Dvc=\"%s\"",pTreeData->cDevice  ))
    PRINT_SMB_MSG1((" Usr=\"%s\"",pTreeData->cUsername))
    PRINT_SMB_MSG1((" Pwd=\"%s\"",pTreeData->cPassword))
    //*/

        pTree=pSession->pTree;                      // create tree entry
    if(!pTree)return -3;
        pUser=pSession->pUser;
        pTree->pUser=pUser;
        pTree->wUidFixed=0;


    if(pSession->iSecurityMode==SMB_USER)
    if(!pUser || !pUser->iPasswordOk)
        {
        if(!SmbPasswordCheck(   pTreeData->cUsername,
                                pTreeData->cPassword,
                                pTreeData->iPasswordLen,
                                0,0,pSession->bChallenge,pSession->iProtocol,
                                pTreeData->bEncrypt))
            {
            return -1;
            }

        if(pUser)pUser->iPasswordOk=1;
        }


    pTree->bReadOnly=0;

    if(!strcmp(pTreeData->cDevice,"IPC"))           // name pipe
        {
        pTree->iConnect     =-1;
        pTree->iConnectLen  = 0;
        pTree->iConnectType = 1;
        return 1;
        }

    if(!strcmp(pTreeData->cService,"IPC$"))         // name pipe
        {
        strcpy(pTreeData->cDevice,"IPC");
        pTree->iConnect     =-1;
        pTree->iConnectLen  = 0;
        pTree->iConnectType = 1;
        return 1;
        }

    if(pUser==0)                                    // create a fixed user
        {
            wUid=SmbCreateUser(pSession);
        if(!wUid)return -4;

        pUser=SmbGetUser(pSession,wUid);
        memset(pUser,0,sizeof(*pUser));
        strcpy(pUser->cUsername,pTreeData->cUsername);

        if(!smb_user_logon(pUser,pTreeData->cUsername))
            {
            PRINT_SMB_MSG1((" clear user %04X",wUid))
            SmbClearUser(pSession,wUid);
            return -1;
            }

        pTree->wUidFixed=wUid;
        }

    if(pUser->iCount<0)                             // no tree entrys
        {
        return -1;
        }

    if(pSession->iSecurityMode==SMB_USER)
    if(pUser->cUsername[0]==0)
        {
        return -1;
        }

        iOk=smb_tree_check(pTreeData);              // check tree connection
    if( iOk<0)return iOk;
    if( iOk>0)pTree->bReadOnly=1;


    if(!strcmp(pTreeData->cDevice,"A:") || !pTreeData->cDevice[0] ||
       !strcmp(pTreeData->cDevice,"?????"))         // disk share
        {
        if(pPath[0]!='\\')return -2;
        if(pPath[1]!='\\')return -2;

            iLen=strcspn(pPath+2,"\\");
        if(!iLen)return -2;
        if(MemCmpI(pPath+2,pSession->cLocalMachine,iLen))
            {
            if(pPath[2+iLen]!='\\' || StrCmpI(pSession->cLocalMachine,"*smbserv"))
                {
                return -3;
                }

            }

           pPath+=iLen+2;                           // create add path
        if(pPath[0]!='\\')return -2;
           pPath++;

        iLen=strcspn(pPath,"\\");

        for(i=0;i<pUser->iCount;i++)                // find device
            {
            if(!StrCmpI(pTreeData->cService,pUser->pService[i]))break;
            }

        if(i<pUser->iCount)                         // device found
            {
            pTree->iConnect=i;
            pTree->iConnectLen=strlen(pUser->pPath[i]);
            pTree->iConnectType=0;
            pTree->bReadOnly|=(pUser->cMode[i]==SMB_MODE_READONLY);
            pPath+=iLen;
            }
        else{
            if(pPath[iLen]!=0)return -2;
            i=strcspn(pPath,"*?");
            if(pPath[i]==0)return -2;
            pTree->iConnect     =-1;
            pTree->iConnectType = 4;
            pTree->iConnectLen  = 0;
            pTree->bReadOnly    = 1;
            }

        if(pUser->cMode[i]==SMB_MODE_VIEWSHARES)
            {
            return -1;
            }

           uSize=strlen(pPath);                         // add pPath
        if(uSize==2 && pPath[0]=='*' && pPath[1]=='.')uSize=1;
        if(uSize>=sizeof(pTree->cAddPath))return -2;
        memcpy(pTree->cAddPath,pPath,uSize+1);
        pTree->iAddPathLen=uSize;
        strcpy(pTreeData->cDevice,"A:");
        }



return 0;
}

//*****************************************************************************
//*
//*     ReplyCommon
//*
//*****************************************************************************
int ReplyCommon(SmbSession *pSession,unsigned char *pIn,unsigned char *pOut,int iSize)
{
int     iType,iOutsize;



    memset(pOut,0,smb_size);
    SmbSetMessage(pOut,0,0,FALSE);
    SCVAL(pOut,smb_com ,CVAL(pIn,smb_com));
    SIVAL(pOut,smb_idf ,IVAL(pIn,smb_idf));
    SCVAL(pOut,smb_rcls,SMB_SUCCESS);
    SCVAL(pOut,smb_reh ,0);
    SCVAL(pOut,smb_flg ,FLAG_REPLY | (CVAL(pIn,smb_flg) & FLAG_CASELESS_PATHNAMES)); // bit 7 set means a reply
    SSVAL(pOut,smb_flg2,FLAGS2_LONG_PATH_COMPONENTS);

    /* say we support long filenames */

    SSVAL(pOut,smb_err,SMB_SUCCESS);
    SSVAL(pOut,smb_tid,SVAL(pIn,smb_tid));
    SSVAL(pOut,smb_pid,SVAL(pIn,smb_pid));
    SSVAL(pOut,smb_uid,SVAL(pIn,smb_uid));
    SSVAL(pOut,smb_mid,SVAL(pIn,smb_mid));

    PRINT_SMB_MSG(("U:%04X T:%04X P:%04X  ",
                    SVAL(pIn,smb_uid)&0xFFFF,
                    SVAL(pIn,smb_tid)&0xFFFF,
                    SVAL(pIn,smb_pid)&0xFFFF))


    pSession->iChainSize=0;
    iType     = CVAL(pIn,smb_com);
    iOutsize  = SwitchMessage(pSession,iType,pIn,pOut,iSize,pSession->iMaxResvSize);
    
	if(iOutsize<0)return iOutsize;

	iOutsize += pSession->iChainSize;

    if(iOutsize>4)SmbSetLen(pOut,iOutsize - 4);


return iOutsize;
}


//*****************************************************************************
//*
//*     SwitchMessage
//*
//*****************************************************************************
//  do a switch on the message type, and return the response size
int SwitchMessage(SmbSession *pSession,int iType,unsigned char *pIn,unsigned char *pOut,int iSize,int iBuffSize)
{
int             iOutsize = 0;
int             iFlags;
unsigned short  wUid,wTid,wFid;




    PRINT_SMB_MSG(("  Type=%02X %-12s\t",iType,sSmbMessages[iType].pName))
    pSession->iCurrentPacket = iType;           // current handlet packet

    if(IVAL(pIn,4)!=SMB_BASE)                   // check header
        {
        PRINT_SMB_ERR(("SMB_ERROR wrong smb header"));
        SmbSessionExit(pSession);
		return -1;
        }

    if(sSmbMessages[iType].pProc == NULL)       // not supported
        {
        PRINT_SMB_ERR(("SMB_ERROR unsuportet type (%02Xh)",iType));
        return SMB_ERROR(ERRSRV,ERRunknownsmb);
        }


    iFlags = sSmbMessages[iType].iFlags;
    wUid   = SVAL(pIn,smb_uid);

    if(iFlags&F_USER)                           // check user and tree
        {
           wTid=SVAL(pIn,smb_tid);
        if(wTid!=pSession->wTid)                // has tree chaned
            {
            if(wTid==0xFFFF)
                {
                pSession->pTree=&sIpcTree;
                }
            else{
                    pSession->pTree=SmbGetTree(pSession,wTid);
                if(!pSession->pTree)wTid=0;
                }

            pSession->wTid =wTid;
            pSession->wFid =0;
            pSession->pFile=0;
            pSession->wUid =0;
            pSession->pUser=0;
            SSVAL(pIn,smb_tid,wTid);
            }

        if(!pSession->pTree)                    // is not tree connectet
            {
            PRINT_SMB_ERR(("SMB_ERROR no tree connected"));
            return SMB_ERROR(ERRSRV,ERRinvnid);
            }

        if(pSession->pTree->wUidFixed)          // has a fixed user id
            {
            wUid=pSession->pTree->wUidFixed;
            }
        }
    else{
        wTid = 0;
        }


    if(iFlags&F_FID)                            // check file id
        {
           wFid=SVAL(pIn,smb_vwv0+CVAL(&iFlags,0));
        if(wFid!=pSession->wFid)                // has tree chaned
            {
                pSession->pFile=SmbGetFile(pSession,wFid);
            if(!pSession->pFile)wFid=0;
                pSession->wFid =wFid;
            SSVAL(pIn,smb_vwv0+CVAL(&iFlags,0),wFid);
            }

        if(!pSession->pFile)
            {
            PRINT_SMB_ERR(("SMB_ERROR no valid fid %X ",wFid));
            return SMB_ERROR(ERRDOS,ERRbadfid);
            }
        }


    if(iFlags & F_WRITE)                        // need write permission
        {
        if(pSession->pTree->bReadOnly)
            {
            PRINT_SMB_ERR(("SMB_ERROR write acces"));
            return SMB_ERROR(ERRSRV,ERRaccess);
            }
        }

    if(wUid!=pSession->wUid)                    // has user chaned
        {
            pSession->pUser=SmbGetUser(pSession,wUid);
        if(!pSession->pUser)wUid=0;
            pSession->wUid =wUid;
        }

    if(!wUid && (iFlags&F_USER))                // check user and tree
        {
        PRINT_SMB_ERR(("SMB_ERROR no user logged on  U:%04X T:%04X Fixed=%X",pSession->wUid,wTid,pSession->pTree->wUidFixed));
        return SMB_ERROR(ERRSRV,ERRbaduid);
        }

    SSVAL(pIn,smb_uid,wUid);


    iOutsize = sSmbMessages[iType].pProc(pSession, pIn,pOut,iSize,iBuffSize);


return iOutsize;
}

//*****************************************************************************
//*
//*     ChainReply
//*
//*****************************************************************************
//  construct a chained reply and add it to the already made reply
int ChainReply(SmbSession *pSession,unsigned char *pIn,unsigned char *pOut,int iSize,int iBuffSize)
{
unsigned char  *pIn2,*pOut2;
char            cSavedInbuf [smb_wct];
char            cSavedOutbuf[smb_wct];
int             iWordCount,iByteCount,iOutsize,iOutsize2;
int             iSmbCom1,iSmbCom2,iSmbOff2,iSmbOff3;
int             iOffset;



    iSmbCom2   = CVAL(pIn ,smb_vwv0);
    iSmbOff2   = SVAL(pIn ,smb_vwv1);
    iWordCount = CVAL(pOut,smb_wct );
    iByteCount = SVAL(pOut,smb_vwv0+2*iWordCount);
    iOutsize   = smb_size + iWordCount*2 + iByteCount;

    if(iSmbCom2==0xFF)                          // not command added
        {
        PRINT_SMB_ERR((" <X end> "));
        SCVAL(pOut,smb_vwv0,0xFF);
        return iOutsize;
        }

    if(iSmbCom2==0xA2 && iWordCount==26)        // special case NtCreateAndX
        {
        iWordCount = 34;
        iOutsize   = smb_size + iWordCount*2 + iByteCount;
        }

    iOutsize=(iOutsize+3)&~3;

                                                // we need to tell the client where the next part of the reply will be
    iSmbOff3=smb_offset(pOut+iOutsize,pOut);
    SCVAL(pOut,smb_vwv0,iSmbCom2);
    SSVAL(pOut,smb_vwv1,iSmbOff3);

                                                // remember how much the caller added to the chain, only counting stuff after the parameter words
    pSession->iChainSize += iOutsize - smb_wct;

                                                // work out pointers into the original packets. The headers on these need to be filled in
    pIn2  = pSession->pChainIn  + iSmbOff2 + 4 - smb_wct;
    pOut2 = pSession->pChainOut + iSmbOff3 + 4 - smb_wct;

                                                // remember the original command type
    iSmbCom1 = CVAL(pSession->pChainIn,smb_com);

                                                // save the pData which will be overwritten by the new headers
    memcpy(cSavedInbuf ,pIn2 ,smb_wct);
    memcpy(cSavedOutbuf,pOut2,smb_wct);

                                                // give the new packet the same header as the last part of the SMB
    memmove(pIn2,pIn,smb_wct);


                                                // create the in buffer
    SCVAL(pIn2,smb_com,iSmbCom2);

                                                // create the out buffer
    memset(pOut2,'\0',smb_size);

    PRINT_SMB_MSG((" flg=%02X ",CVAL(pIn2,smb_flg)));

    SmbSetMessage(pOut2,0,0,FALSE);
    SCVAL(pOut2,smb_com ,CVAL(pIn2,smb_com));
    SIVAL(pOut2,smb_idf ,IVAL(pIn2,smb_idf));
    SCVAL(pOut2,smb_rcls,SMB_SUCCESS);
    SCVAL(pOut2,smb_reh ,0);
    SCVAL(pOut2,smb_flg ,FLAG_REPLY | ((CVAL(pIn2,smb_flg) & (0x10|FLAG_CASELESS_PATHNAMES)))); // bit 7 set means a reply
    SSVAL(pOut2,smb_flg2,0 /*FLAGS2_LONG_PATH_COMPONENTS*/);
                                                // say we support long filenames

    SSVAL(pOut2,smb_err,SMB_SUCCESS);
    SSVAL(pOut2,smb_tid,SVAL(pIn2,smb_tid));
    SSVAL(pOut2,smb_pid,SVAL(pIn2,smb_pid));
    SSVAL(pOut2,smb_uid,SVAL(pIn2,smb_uid));
    SSVAL(pOut2,smb_mid,SVAL(pIn2,smb_mid));


    PRINT_SMB_MSG(("\nSMB --- U:%04X T:%04X P:%04X  ",
                            SVAL(pIn2,smb_uid)&0xFFFF,
                            SVAL(pIn2,smb_tid)&0xFFFF,
                            SVAL(pIn2,smb_pid)&0xFFFF))

                                                // process the request
    iOutsize2 = SwitchMessage(  pSession,iSmbCom2,pIn2,pOut2,
                                iSize    -pSession->iChainSize ,
                                iBuffSize-pSession->iChainSize );

	if(iOutsize2<0)return iOutsize2;


                                                // copy the new reply and request headers over the old ones, but preserve the smb_com field
    memmove(pSession->pChainOut,pOut2,smb_wct);
    SCVAL  (pSession->pChainOut,smb_com,iSmbCom1);

                                                // restore the saved pData, being careful not to overwrite any pData from the reply header
    memcpy(pIn2,cSavedInbuf,smb_wct);


       iOffset = smb_wct - PTR_DIFF(pOut2,pSession->pChainOut);
    if(iOffset < 0)iOffset= 0;

    memmove(pOut2+iOffset,cSavedOutbuf+iOffset,smb_wct-iOffset);


return iOutsize2;
}


//*****************************************************************************
//*
//*     ReplyNegprot
//*
//*****************************************************************************
//  reply to a negprot, chose a protocol
int ReplyNegprot(SmbSession *pSession,unsigned char *pIn,unsigned char *pOut,int iSize,int iBuffSize)
{
unsigned    uTime;
int         iOutsize;
int         iBcc,iMode,iBuffer,iIndex,iChoice;
char       *pPos,*pEnd,*pNew;



    iMode   = (pSession->iSecurityMode==SMB_USER)? 1:0;
    iBcc    = SVAL (smb_buf(pIn),-2);
    iChoice = -1;

    pNew    = (char*)smb_buf(pIn)+1;
    pEnd    = (char*)smb_buf(pIn)+iBcc;


//******************** NT LANMAN **********************************************

    for(pPos=pNew,iIndex=0;pPos<pEnd;iIndex++)
        {
        if(!strcmp(pPos,"NT LM 0.12")){iChoice=iIndex;break;}
        pPos += strlen(pPos)+2;
        }

    if(iChoice==-1)
    for(pPos=pNew,iIndex=0;pPos<pEnd;iIndex++)
        {
        if(!strcmp(pPos,"NT LANMAN 1.0")){iChoice=iIndex;break;}
        pPos += strlen(pPos)+2;
        }

    if(iChoice>=0)                              // use NT LANMAN
        {
        int iCap,iDataLen;

        iDataLen = strlen(cMyWorkgroup)+1+8;

        PRINT_SMB_MSG1((" NT LANMAN <ok>"))
        pSession->iProtocol = PROTOCOL_NT1;
        pSession->bEncrypt  = TRUE;

        SysTimeConvertSU(SysTimeGet(),&uTime);

        iOutsize = SmbSetMessage(pOut,17,iDataLen,TRUE);
        iCap     = CAP_NT_FIND|CAP_RAW_MODE/*|CAP_NT_SMBS*/;
        iBuffer  = pSession->iMaxResvSize;

        SCVAL(pOut,smb_flg,FLAG_REPLY);
        SSVAL(pOut,smb_vwv0,iChoice);           // protocol number
        SCVAL(pOut,smb_vwv1,iMode|2);           // bit0=username/share level security bit1=encrypt passwords
        SSVAL(pOut,smb_vwv1+1,2);               // max mpx request
        SSVAL(pOut,smb_vwv2+1,1);               // max VCs per server
        SIVAL(pOut,smb_vwv3+1,iBuffer);         // max buffer size
        SIVAL(pOut,smb_vwv5+1,0x10000);         // raw size. full 64k
        SIVAL(pOut,smb_vwv7+1,pSession->ulId);  // session key
        SIVAL(pOut,smb_vwv9+1,iCap);            // capabilities
        SIVAL(pOut,smb_vwv11+1,uTime);          // current time
        SSVAL(pOut,smb_vwv15+1,0);              // timezone
        SCVAL(pOut,smb_vwv16+1,8);              // crypt length
        SSVAL(pOut,smb_vwv17,iDataLen);         // length of challenge+domain strings

        SmbGenerateKey(pSession->bChallenge);
        memcpy(smb_buf(pOut),pSession->bChallenge,8);

        strcpy((char*)smb_buf(pOut)+8,cMyWorkgroup);


        return iOutsize;
        }

//******************** LM1.2X002 **********************************************

    for(pPos=pNew,iIndex=0;pPos<pEnd;iIndex++)
        {
        if(!strcmp(pPos,"LM1.2X002")){iChoice=iIndex;break;}
        pPos += strlen(pPos)+2;
        }

    if(iChoice==-1)
    for(pPos=pNew,iIndex=0;pPos<pEnd;iIndex++)
        {
        if(!strcmp(pPos,"DOS LM1.2X002")){iChoice=iIndex;break;}
        pPos += strlen(pPos)+2;
        }

    if(iChoice>=0)                              // use LANMAN 2.0
        {
        PRINT_SMB_MSG1((" LANMAN 2.0 <ok>"))
        pSession->iProtocol = PROTOCOL_LANMAN2;
        pSession->bEncrypt  = TRUE;

        SysTimeConvertSD(SysTimeGet(),&uTime);

        iOutsize = SmbSetMessage(pOut,13,8,TRUE);
        iBuffer  = pSession->iMaxResvSize;

        SCVAL(pOut,smb_flg,FLAG_REPLY);
        SSVAL(pOut,smb_vwv0,iChoice);           // protocol number
        SSVAL(pOut,smb_vwv1,iMode|2);           // bit0=username/share level security bit1=encrypt passwords
        SSVAL(pOut,smb_vwv2,iBuffer);           // max transmit buffer size
        SSVAL(pOut,smb_vwv3,2);                 // max mpx reqest
        SSVAL(pOut,smb_vwv4,1);                 // max VCs per server
        SSVAL(pOut,smb_vwv5,3);                 // bit0=read raw bit0=write raw
        SIVAL(pOut,smb_vwv6,pSession->ulId);    // session key
        SIVAL(pOut,smb_vwv8,uTime);             // current time
        SSVAL(pOut,smb_vwv10,0);                // timezone

        SmbGenerateKey(pSession->bChallenge);
        memcpy(smb_buf(pOut),pSession->bChallenge,8);

        return iOutsize;
        }

//******************** LANMAN1.0 **********************************************

    pPos = (char*)smb_buf(pIn)+1;
    pEnd = (char*)smb_buf(pIn)+iBcc;

    for(pPos=pNew,iIndex=0;pPos<pEnd;iIndex++)
        {
        if(!strcmp(pPos,"LANMAN1.0")){iChoice=iIndex;break;}
        pPos += strlen(pPos)+2;
        }

    if(iChoice==-1)
    for(pPos=pNew,iIndex=0;pPos<pEnd;iIndex++)
        {
        if(!strcmp(pPos,"MICROSOFT NETWORKS 3.0")){iChoice=iIndex;break;}
        pPos += strlen(pPos)+2;
        }

    if(iChoice>=0)                              // use LANMAN 2.0
        {
        PRINT_SMB_MSG1((" LANMAN 1.0 <ok>"))
        pSession->iProtocol = PROTOCOL_LANMAN1;
        iBuffer = pSession->iMaxResvSize;

        SysTimeConvertSD(SysTimeGet(),&uTime);

        iOutsize=SmbSetMessage(pOut,13,0,TRUE);
        SCVAL(pOut,smb_flg,FLAG_REPLY);
        SSVAL(pOut,smb_vwv0,iChoice);           // protocol number
        SSVAL(pOut,smb_vwv1,iMode);             // bit0=username/share level security bit1=encrypt passwords
        SSVAL(pOut,smb_vwv2,iBuffer);           // max transmit buffer size
        SSVAL(pOut,smb_vwv3,2);                 // max mpx reqest
        SSVAL(pOut,smb_vwv4,1);                 // max VCs per server
        SSVAL(pOut,smb_vwv5,3);                 // bit0=read raw bit0=write raw
        SIVAL(pOut,smb_vwv6,pSession->ulId);    // session key
        SIVAL(pOut,smb_vwv8,uTime);             // current time
        SSVAL(pOut,smb_vwv10,0);                // timezone


        return iOutsize;
        }

//******************** PC NETWORK PROGRAM 1.0 *********************************

    for(pPos=pNew,iIndex=0;pPos<pEnd;iIndex++)
        {
        if(!strcmp(pPos,"PC NETWORK PROGRAM 1.0")){iChoice=iIndex;break;}
        pPos += strlen(pPos)+2;
        }

    if(iChoice<0)
        {
        PRINT_SMB_ERR(("SMB_ERROR no protocol found"));
        return SMB_ERROR(ERRSRV,ERRerror);
        }

    PRINT_SMB_MSG1((" PC NETWORK PROGRAM 1.0 <ok>"))
    iOutsize = SmbSetMessage(pOut,1,0,TRUE);
    SSVAL(pOut,smb_vwv0,iChoice);



return iOutsize;
}

//*****************************************************************************
//*
//*     ReplyTcon
//*
//*****************************************************************************
//  reply to a tcon.
//  connect tree
int ReplyTcon(SmbSession *pSession,unsigned char *pIn,unsigned char *pOut,int iSize,int iBuffSize)
{
unsigned short  wTid;
SmbTreeData     sData;
SmbUserEntry   *pUser;
char           *pPath,*pPtr;
int             iOk,iLen,iOutsize=0;



    pPath = (char*)smb_buf(pIn)+1;
    PRINT_SMB_MSG1((" tree=\"%s\"",pPath))
    wTid=SVAL(pIn,smb_tid);
    sData.bEncrypt = pSession->bEncrypt;

                                                    // \\server\service%user


    if(pPath[0]!='\\')                              // copy server name
        {
        pPtr=pPath;
        sData.cServer[0]=0;
        }
    else{
        pPtr=pPath+2;

           iLen=strcspn(pPtr,"\\");
        if(iLen>=MAX_SERVERNAME_SIZE)
            {
            PRINT_SMB_ERR(("SMB_ERROR buffer too small"))
            return SMB_ERROR(ERRDOS,ERRbuftoosmall);
            }

        memcpy(sData.cServer,pPtr,iLen);
        sData.cServer[iLen]=0;

            pPtr+=iLen;
        if(!pPtr[0])
            {
            PRINT_SMB_ERR(("SMB_ERROR share no found"))
            return SMB_ERROR(ERRDOS,ERRnosuchshare);
            }

        pPtr++;
        }

       iLen=strcspn(pPtr,"%");                      // copy service name
    if(iLen>=MAX_SERVICE_SIZE)
        {
        PRINT_SMB_ERR(("SMB_ERROR buffer too small"))
        return SMB_ERROR(ERRDOS,ERRbuftoosmall);
        }

    memcpy(sData.cService,pPtr,iLen);
    sData.cService[iLen]=0;

    if(pPtr[iLen]!='%')                             // copy username
        {
        pUser=pSession->pUser;

        if(pUser)
            {
            strncpy(sData.cUsername,pUser->cUsername,sizeof(sData.cUsername));
            }
        else{
            sData.cUsername[0]=0;
            }
        }
    else{
            pPtr+=iLen+1;
           iLen=strlen(pPtr);
        if(iLen>=MAX_USERNAME_SIZE)
            {
            PRINT_SMB_ERR(("SMB_ERROR buffer too small"))
            return SMB_ERROR(ERRDOS,ERRbuftoosmall);
            }

        memcpy(sData.cUsername,pPtr,iLen);
        sData.cUsername[iLen]=0;
        }

    pPtr+=iLen+2;                                   // copy password

       iLen=strlen(pPtr);
    if(iLen>=MAX_PASSWORD_SIZE)
        {
        PRINT_SMB_ERR(("SMB_ERROR buffer too small"))
        return SMB_ERROR(ERRDOS,ERRbuftoosmall);
        }

    memcpy(sData.cPassword,pPtr,iLen);
    sData.cPassword[iLen] = 0;
    sData.iPasswordLen    = iLen;

    pPtr+=iLen+2;                                   // copy devicename
    strncpy(sData.cDevice,pPtr,MAX_DEVICE_SIZE);
    sData.cDevice[MAX_DEVICE_SIZE-1]=0;
    sData.pChallenge=pSession->bChallenge;



        wTid = SmbCreateTree(pSession);
    if(!wTid)
        {
        PRINT_SMB_ERRS(("SYSERROR no tree created"));
        SmbSessionExit(pSession);
		return -1;
        }

    pSession->wTid  = wTid;
    pSession->pTree = SmbGetTree(pSession,wTid);

       iOk=TreeConnect(pSession,&sData,pPath);      // connect error
    if(iOk<0)
        {
        SmbClearTree(pSession,wTid);
        pSession->wTid =0;
        pSession->pTree=0;

        switch(iOk)
            {
        case -1: return SMB_ERROR(ERRSRV,ERRbadpw);     // wrong password
        case -2: return SMB_ERROR(ERRSRV,ERRinvnetname);// wrong username
        default: return SMB_ERROR(ERRSRV,ERRerror);
            }
        }

    if(iOk==1)                                      // ipc connection
        {
        SmbClearTree(pSession,wTid);
        pSession->pTree=&sIpcTree;
        pSession->wTid =0xFFFF;
                  wTid =0xFFFF;
        }


    iOutsize = SmbSetMessage(pOut,2,0,TRUE);
    SSVAL(pOut,smb_vwv0,pSession->iMaxResvSize);    // maximum transmit field size
    SSVAL(pOut,smb_vwv1,wTid);
    SSVAL(pOut,smb_tid ,wTid);

    PRINT_SMB_MSG1((" Con=\"%s\"  TID=%X <ok>",pSession->pTree->cAddPath,wTid))


return iOutsize;
}


//*****************************************************************************
//*
//*     ReplyOpen
//*
//*****************************************************************************
//  reply to an open
int ReplyOpen(SmbSession *pSession,unsigned char *pIn,unsigned char *pOut,int iSize,int iBuffSize)
{
char            cName[MAX_PATHNAME_SIZE];
char           *pName;
int             iOutsize = 0;
int             iMode,iAccess;
int             iError;
unsigned        uAttr;
unsigned short  wFid;
int             bError;
SysFile         hFile;
SysFindStruct   sInfo;



    pName=(char*)smb_buf(pIn)+1;

    if(SmbPathName(pSession,cName,pName)<0)
        {
        PRINT_SMB_ERR(("SMB_ERROR wrong file: \"%s\"",pName))
        return SMB_ERROR(ERRDOS,ERRbadpath);
        }


    PRINT_SMB_MSG1((" file=\"%s\" ",cName))
    iMode  = SVAL(pIn,smb_vwv0);
    bError = FALSE;

    if(pSession->pTree->iConnectType==4)        // base connection
        {
        return SMB_ERROR(ERRDOS,ERRaccess);
        }

    switch(iMode&0x0F)
            {
    case 0: uAttr=SYS_READ;            break;
    case 1: uAttr=SYS_WRITE;           break;
    case 2: uAttr=SYS_WRITE|SYS_READ;  break;
    default:uAttr=SYS_READ;bError=TRUE;break;
            }

    switch((iMode>>4)&0x07)
            {
    case 0:
    case 1:                                    break;
    case 2: uAttr|=SYS_SHARE_RD;               break;
    case 3: uAttr|=SYS_SHARE_WR;               break;
    case 4: uAttr|=SYS_SHARE_WR|SYS_SHARE_RD;  break;
    default:bError=TRUE;
            }

    if((uAttr&SYS_WRITE) && pSession->pTree->bReadOnly)
        {
        PRINT_SMB_ERR(("SMB_ERROR no writte access"))
        return SMB_ERROR(ERRDOS,ERRnoaccess);
        }

    switch(uAttr&(SYS_WRITE|SYS_READ))
        {
    case SYS_WRITE|SYS_READ:    iAccess=DOS_OPEN_RDWR;      break;
    case SYS_WRITE:             iAccess=DOS_OPEN_WRONLY;    break;
    case SYS_READ:              iAccess=DOS_OPEN_RDONLY;    break;
    default:bError=TRUE;
        }

    if(bError)return SMB_ERROR(ERRDOS,ERRnoaccess);


        hFile=SysOpenEx(cName,uAttr,&iError);
    if(!hFile)
        {
        PRINT_SMB_ERRS(("SMB_ERROR cant't open file '%s'",cName));

        switch(iError)
            {
        case SYS_ERR_PATH_NOTFOUND:         return SMB_ERROR(ERRDOS,ERRbadpath );
        case SYS_ERR_INVALID_FILENAME:      return SMB_ERROR(ERRDOS,ERRbadpath );
        case SYS_ERR_FILE_NOT_FOUND:        return SMB_ERROR(ERRDOS,ERRbadfile );
        case SYS_ERR_NO_HANDLES:            return SMB_ERROR(ERRDOS,ERRnofids  );
        default:                            return SMB_ERROR(ERRDOS,ERRnoaccess);
            }
        }

    if(SysGetFileInfo(hFile,&sInfo)<0)
        {
        PRINT_SMB_ERRS(("SYSERROR cant't get file info"));
        SysClose(hFile);
        return SMB_ERROR(ERRDOS,ERRnoaccess);
        }


        wFid=SmbCreateFile(pSession,hFile,0);
    if(!wFid)
        {
        PRINT_SMB_ERRS(("SYSERROR no SmbFree file id"));
        SysClose(hFile);
        return SMB_ERROR(ERRDOS,ERRnofids);
        }



    pSession->wFid  = wFid;
    pSession->pFile = SmbGetFile(pSession,wFid);

    iMode=AttrSysToDos(uAttr);
    iOutsize = SmbSetMessage(pOut,7,0,TRUE);
    SSVAL(pOut,smb_vwv0,wFid);
    SSVAL(pOut,smb_vwv1,iMode);
    SIVAL(pOut,smb_vwv2,sInfo.dwTimeWrite);
    SIVAL(pOut,smb_vwv4,sInfo.dwSize);
    SSVAL(pOut,smb_vwv6,iAccess);

    PRINT_SMB_MSG1(("FID=%i <ok>",wFid))


return  iOutsize;
}



//*****************************************************************************
//*
//*     ReplySetupAndX
//*
//*****************************************************************************
//  reply to a session setup command.
int ReplySetupAndX(SmbSession *pSession,unsigned char *pIn,unsigned char *pOut,int iSize,int iBuffSize)
{
unsigned short  wUid;
int             bEncrypt=TRUE;
SmbUserEntry   *pUser;
char           *pPtr;
char            cUsername [MAX_USERNAME_SIZE];
char            cPasswordA[MAX_PASSWORD_SIZE];
char            cPasswordU[MAX_PASSWORD_SIZE];
int             iPasswordSizeA;
int             iPasswordSizeU;
int             iClientCaps;
int             iBufferSize;
int             iAdd,iNewUser=0;


    iBufferSize = SVAL(pIn,smb_vwv2);

    if(pSession->iProtocol<PROTOCOL_NT1)
        {
           iPasswordSizeA  = SVAL(pIn,smb_vwv7);
        if(iPasswordSizeA >= MAX_PASSWORD_SIZE)
            {
            PRINT_SMB_ERR(("SMB_ERROR buffer too small"))
            return SMB_ERROR(ERRDOS,ERRbuftoosmall);
            }

        memcpy(cPasswordA,smb_buf(pIn),iPasswordSizeA);
        cPasswordA[iPasswordSizeA] = 0;

        iAdd=iPasswordSizeA;
        iPasswordSizeU=0;
        cPasswordU[0]=0;
        }
    else{
        iPasswordSizeA = SVAL(pIn,smb_vwv7);    // ansi
        iPasswordSizeU = SVAL(pIn,smb_vwv8);    // unicode
        iClientCaps    = IVAL(pIn,smb_vwv11);
        iAdd           = iPasswordSizeA+iPasswordSizeU;

        if(iPasswordSizeA >= MAX_PASSWORD_SIZE ||
           iPasswordSizeU >= MAX_PASSWORD_SIZE)
            {
            PRINT_SMB_ERR(("SMB_ERROR buffer too small"))
            return SMB_ERROR(ERRDOS,ERRbuftoosmall);
            }

        if(iPasswordSizeA!=24 && iPasswordSizeU!=24)bEncrypt=FALSE;

        memcpy(cPasswordA,smb_buf(pIn),iPasswordSizeA);
        memcpy(cPasswordU,smb_buf(pIn)+iPasswordSizeA,iPasswordSizeU);

        cPasswordA[iPasswordSizeA] = 0;
        cPasswordU[iPasswordSizeU] = 0;

        if(!bEncrypt)
            {                                   // NT bug
            if(iPasswordSizeA>  0 && iPasswordSizeU> 0 &&
               iPasswordSizeU!=24 && iPasswordSizeU!=1)
                {
                iPasswordSizeU = 0;
                }

            if(!strcmp(cPasswordA," "))
                {
                cPasswordA[0]  = 0;
                iPasswordSizeA = 0;
                }
            }
        }


    strncpy(cUsername,(char*)smb_buf(pIn)+iAdd,sizeof(cUsername)-1);
    cUsername[MAX_USERNAME_SIZE-1]=0;

    if(cUsername[0]==0)
        {
        pUser = 0;
        wUid  = 0;
        }
    else{
            wUid=SmbFindUser(pSession,cUsername);
        if(!wUid){wUid=SmbCreateUser(pSession);iNewUser=1;}
        if(!wUid)
            {
            PRINT_SMB_ERRS(("SYSERROR no SmbFree username structure"));
            return SMB_ERROR(ERRSRV,ERRerror);
            }

        pUser=SmbGetUser(pSession,wUid);
        memset(pUser,0,sizeof(*pUser));
        strcpy(pUser->cUsername,cUsername);
        }

    if(pSession->iSecurityMode==SMB_USER)
    if(!pUser || !pUser->iPasswordOk)
        {
        if(!SmbPasswordCheck(cUsername,cPasswordA,iPasswordSizeA,cPasswordU,iPasswordSizeU,pSession->bChallenge,pSession->iProtocol,bEncrypt))
            {
            return SMB_ERROR(ERRSRV,ERRbadpw);
            }
        if(pUser)pUser->iPasswordOk=1;
        }

    if(pUser && iNewUser)                           // insert tree entries
        {
        if(!smb_user_logon(pUser,pUser->cUsername))
            {
            return SMB_ERROR(ERRSRV,ERRbadpw);
            }
        }

    pSession->iMaxResvSize = iBufferSize;

    if(pSession->iProtocol<PROTOCOL_NT1)
        {
        SmbSetMessage(pOut,3,0,TRUE);
        PRINT_SMB_MSG1((" user=\"%s\" UID=%04X <ok>",cUsername,wUid))
        }
    else{
        SmbSetMessage(pOut,3,3,TRUE);
        pPtr = (char*)smb_buf(pOut);
        strcpy(pPtr,SMB_OS);        pPtr+=strlen(pPtr)+1;
        strcpy(pPtr,SMB_SERVER);    pPtr+=strlen(pPtr)+1;
        strcpy(pPtr,cMyWorkgroup);  pPtr+=strlen(pPtr)+1;
        SmbSetMessage(pOut,3,PTR_DIFF(pPtr,smb_buf(pOut)),FALSE);
        PRINT_SMB_MSG1((" user=\"%s\" UID=%04X <ok>",cUsername,wUid))
        }


    SSVAL(pOut,smb_uid,wUid);
    SSVAL(pIn ,smb_uid,wUid);
    SSVAL(pOut,smb_vwv2,(wUid==1)? 1:0);


return ChainReply(pSession,pIn,pOut,iSize,iBuffSize);
}


//*****************************************************************************
//*
//*     ReplyTconAndX
//*
//*****************************************************************************
//*  reply to a tcon and X.
int ReplyTconAndX(SmbSession *pSession,unsigned char *pIn,unsigned char *pOut,int iSize,int iBuffSize)
{
SmbUserEntry   *pUser;
SmbTreeData     sData;
unsigned short  wUid,wTid;
int             iFlags,iPassLen;
int             iLen,iOk;
char           *pPath;
char           *pPtr;



    wUid     = SVAL(pIn,smb_uid);
    wTid     = SVAL(pIn,smb_tid);
    iFlags   = SVAL(pIn,smb_vwv2);
    iPassLen = SVAL(pIn,smb_vwv3);

    sData.bEncrypt = pSession->bEncrypt;
    pPath = (char*)smb_buf(pIn) + iPassLen;         // \\server\device%user \0 device
    PRINT_SMB_MSG1((" tree connect \"%s\"",pPath))


    if(iFlags&1)                                    // close old tree
        {
        PRINT_SMB_MSG1((" clear tree,"))
        SmbClearTree(pSession,wTid);
        pSession->pTree=0;
        pSession->wTid =0;
        wTid=0;
        }

    if(iPassLen>=MAX_PASSWORD_SIZE)                 // copy password
        {
        PRINT_SMB_ERR(("SMB_ERROR buffer too small"))
        return SMB_ERROR(ERRDOS,ERRbuftoosmall);
        }


    memcpy(sData.cPassword,smb_buf(pIn),iPassLen);
           sData.cPassword[iPassLen]=0;
           sData.iPasswordLen=iPassLen;

    if(iPassLen!=24 && !strcmp(sData.cPassword," "))
        {
        sData.cPassword[0]=0;
        sData.iPasswordLen=0;
        }

    if(pPath[0]!='\\')                              // copy server name
        {
        pPtr=pPath;
        sData.cServer[0]=0;
        }
    else{
        pPtr=pPath+2;

           iLen=strcspn(pPtr,"\\");
        if(iLen>=MAX_SERVERNAME_SIZE)
            {
            PRINT_SMB_ERR(("SMB_ERROR buffer too small"))
            return SMB_ERROR(ERRDOS,ERRbuftoosmall);
            }

        memcpy(sData.cServer,pPtr,iLen);
        sData.cServer[iLen]=0;

            pPtr+=iLen;
        if(!pPtr[0])
            {
            PRINT_SMB_ERR(("SMB_ERROR share no found"))
            return SMB_ERROR(ERRDOS,ERRnosuchshare);
            }

        pPtr++;
        }

       iLen=strcspn(pPtr,"%");                      // copy service name
    if(iLen>=MAX_SERVICE_SIZE)
        {
        PRINT_SMB_ERR(("SMB_ERROR buffer too small"))
        return SMB_ERROR(ERRDOS,ERRbuftoosmall);
        }

    memcpy(sData.cService,pPtr,iLen);
    sData.cService[iLen]=0;

    if(pPtr[iLen]!='%')                             // copy username
        {
        pUser=pSession->pUser;

        if(pUser)
            {
            strncpy(sData.cUsername,pUser->cUsername,sizeof(sData.cUsername));
            }
        else{
            sData.cUsername[0]=0;
            }
        }
    else{
        pPtr+=iLen+1;

           iLen=strlen(pPtr);
        if(iLen>=MAX_USERNAME_SIZE)
            {
            PRINT_SMB_ERR(("SMB_ERROR buffer too small"))
            return SMB_ERROR(ERRDOS,ERRbuftoosmall);
            }

        memcpy(sData.cUsername,pPtr,iLen);
        sData.cUsername[iLen]=0;
        }

    pPtr+=iLen+1;                                   // copy devicename
    strncpy(sData.cDevice,pPtr,MAX_DEVICE_SIZE);
    sData.cDevice[MAX_DEVICE_SIZE-1]=0;
    sData.pChallenge=pSession->bChallenge;

        wTid = SmbCreateTree(pSession);
    if(!wTid)
        {
        PRINT_SMB_ERRS(("SYSERROR no tree created"));
        SmbSessionExit(pSession);
		return -1;
        }

    pSession->wTid  = wTid;
    pSession->pTree = SmbGetTree(pSession,wTid);


       iOk=TreeConnect(pSession,&sData,pPath);
    if(iOk<0)                                       // connect error
        {
        SmbClearTree(pSession,wTid);
        pSession->pTree=0;
        pSession->wTid =0;

        switch(iOk)
            {
        case -1: return SMB_ERROR(ERRSRV,ERRbadpw);     // wrong password
        case -2: return SMB_ERROR(ERRSRV,ERRinvnetname);// wrong username
        default: return SMB_ERROR(ERRSRV,ERRerror);
            }
        }


    if(iOk==1)                                      // ipc connection
        {
        SmbClearTree(pSession,wTid);
        pSession->pTree=&sIpcTree;
        pSession->wTid =0xFFFF;
                  wTid =0xFFFF;
        }

    iLen=strlen(sData.cDevice)+1;                   // create reply

    SmbSetMessage(pOut,3,iLen,TRUE);
    memcpy(smb_buf(pOut),sData.cDevice,iLen);
    SSVAL(pOut,smb_vwv0,0);
    SSVAL(pIn ,smb_tid,wTid);
    SSVAL(pOut,smb_tid,wTid);


    PRINT_SMB_MSG1((" Con=\"%s\"  TID=%X <ok>",(pSession->pTree)? pSession->pTree->cAddPath:"",wTid))



return ChainReply(pSession,pIn,pOut,iSize,iBuffSize);
}


//*****************************************************************************
//*
//*     ReplyGetAttr
//*
//*****************************************************************************
//  reply to a get file attributs
int ReplyGetAttr(SmbSession *pSession,unsigned char *pIn,unsigned char *pOut,int iSize,int iBuffSize)
{
int             iOutsize=0;
char            cName[MAX_PATHNAME_SIZE];
char           *pName;
int             iError;
int             iMode,i;
SmbTreeEntry   *pTree;
SmbUserEntry   *pUser;
SysFindStruct   sFind;
SysFind         hHandle;





    pName=(char*)smb_buf(pIn)+1;

    if(SmbPathName(pSession,cName,pName)<0)
        {
        PRINT_SMB_ERR(("SMB_ERROR wrong file: \"%s\"",pName))
        return SMB_ERROR(ERRDOS,ERRbadpath);
        }


    PRINT_SMB_MSG1((" file=\"%s\" ",cName))

        pUser=pSession->pUser;
        pTree=pSession->pTree;
    if( pTree->iConnectType==4)                 // base dir connection
        {
        i=(cName[0])? 0:pUser->iCount;
        for(;i<pUser->iCount;i++)
            {
            if(!StrCmpI(cName,pUser->pService[i]))break;
            }

        if(i<pUser->iCount)
            {
            PRINT_SMB_ERR(("SMB_ERROR file not found"));
            return SMB_ERROR(ERRDOS,ERRbadfile);
            }

        iMode = aHIDDEN|aDIR;
        sFind.dwSize      = 0;
        sFind.dwTimeWrite = 0;
        }
    else{                                       // normal file
            hHandle=SysFindFirstEx(cName,&sFind,&iError);
        if(!hHandle)
            {
            if(iError==SYS_ERR_PATH_NOTFOUND)
                {
                PRINT_SMB_ERR(("SMB_ERROR path not found"));
                return SMB_ERROR(ERRDOS,ERRbadpath);
                }

            PRINT_SMB_ERR(("SMB_ERROR file not found"));
            return SMB_ERROR(ERRDOS,ERRbadpath);
            //return SMB_ERROR(ERRDOS,ERRbadfile);
            }

        SysFindClose(hHandle);
        iMode=AttrSysToDos(sFind.dwAttr);
        }

    if(pTree->bReadOnly)iMode|=aRONLY;


    iOutsize = SmbSetMessage(pOut,10,0,TRUE);
    SSVAL(pOut,smb_vwv0,iMode);
    SIVAL(pOut,smb_vwv1,sFind.dwTimeWrite);
    SIVAL(pOut,smb_vwv3,sFind.dwSize);


    PRINT_SMB_MSG1((" attr=%02X size=%u time=%u <ok>",iMode,sFind.dwSize,sFind.dwTimeWrite))



return iOutsize;
}

//*****************************************************************************
//*
//*     ReplySearch
//*
//*****************************************************************************
//  reply to a search
//  Can be called from SMBsearch, SMBffirst or SMBfunique.
int ReplySearch(SmbSession *pSession,unsigned char *pIn,unsigned char *pOut,int iSize,int iBuffSize)
{
int             iOutsize=0;
char            cName[MAX_PATHNAME_SIZE];
char           *pName,*pPtr,*pStatus,cStatus[21];
int             iMode,iMaxCount,iNameLen,iLen;
int             iAttribut,iStatusLen,iNum;
SmbTreeEntry   *pTree;
SmbFileEntry   *pFile;
SysFindStruct   sFind;
unsigned short  wFid;
SmbBase         hBase;
SysFind         hFind;
int             bFail,bClose;
unsigned        uAttr;
SysDW           uTime;



    pName      = (char*)smb_buf(pIn)+1;
    iNameLen   = strlen(pName);
    iMaxCount  = SVAL(pIn,smb_vwv0);
    iAttribut  = SVAL(pIn,smb_vwv1);
    iStatusLen = SVAL(smb_buf(pIn),iNameLen+3);
    pStatus    = (char*)smb_buf(pIn)+iNameLen+5;
    bClose     = CVAL(pIn,smb_com)==SMBffirst;


    if(iStatusLen == 0)                             // first serach
        {
            iLen=SmbPathName(pSession,cName,pName);
        if( iLen<0)
            {
            PRINT_SMB_ERR(("SMB_ERROR wrong file: \"%s\"",pName))
            return SMB_ERROR(ERRDOS,ERRbadpath);
            }

        for(iNum=iLen;iNum>=0;)                     // check filer
            {
            iNum--;
            if(cName[iNum]=='\\')break;
            if(cName[iNum]==':' )break;
            }
        iNum++;
        if(iNum==iLen || !strcmp(cName+iNum,"????????.???"))
            {
            if(iNum>0 && cName[iNum-1]!='\\')
                    SIVAL(cName,iNum,0x002A5C);     // add '\*'
            else    SSVAL(cName,iNum,0x002A);       // add '*'
            }

        PRINT_SMB_MSG1((" file=\"%s\" ",cName))

        pStatus=cStatus;
        memset( cStatus+1,0,20);

        uAttr=AttrDosToSys(iAttribut);
        cStatus[0]=iAttribut;

            pTree=pSession->pTree;
        if( pTree->iConnectType==4)                 // base dir connection
            {
            if(!iAttribut || (iAttribut&aDIR))
                    hBase=SmbBaseFirst(pSession,cName,&sFind);
            else    hBase=0;

            if(!hBase)return SMB_ERROR(ERRDOS,ERRnofids);
            wFid=SmbCreateFile(pSession,hBase,2);
            cStatus[16]=1;
            PRINT_SMB_ERR((" Base"))
            }
        else{
                hFind=SysFindFirst(cName,&sFind);
            if(!hFind)
                {
                PRINT_SMB_MSG1((" found=0   "))
                iOutsize = SmbSetMessage(pOut,1,3,TRUE);
                SCVAL(pOut,smb_rcls  ,ERRDOS);
                SSVAL(pOut,smb_err   ,ERRnofiles);
                SSVAL(pOut,smb_vwv0  ,0);
                SSVAL(pOut,smb_vwv1  ,3);
                SCVAL(pOut,smb_vwv2  ,5);
                SSVAL(pOut,smb_vwv2+1,0);
                return iOutsize;
                }

            wFid=SmbCreateFile(pSession,hFind,1);
            PRINT_SMB_ERR((" Find"))
            }

        SSVAL(cStatus,12,wFid);
        bFail=FALSE;
        }
    else{
        PRINT_SMB_MSG1((" next=\"%s\" ",pName))
        iAttribut = pStatus[0]&0x1F;
        wFid      = SVAL(pStatus,12);
        bFail     = TRUE;
        cName[0]  = 0;
        }


                         uAttr =0;
    if(iAttribut&aHIDDEN)uAttr|=SYS_HIDDEN;
    if(iAttribut&aSYSTEM)uAttr|=SYS_SYSTEM;
    if(iAttribut&aDIR   )uAttr|=SYS_DIR;

    iOutsize =  SmbSetMessage(pOut,1,3,TRUE);
    pPtr     = (char*)smb_buf(pOut)+3;
    pFile    =  SmbGetFile(pSession,wFid);

    PRINT_SMB_ERR((" FID=%i ",wFid))

    if(!pFile)                                      // ckeck file
        {
        iNum=0;
        }
    else for(iNum=0;iNum<iMaxCount;iNum++)          // copy entries
        {
        if(bFail)
            {
            if(pStatus[16])
                    bFail=SmbBaseNext(pSession,pFile->hBase,&sFind);
            else    bFail=SysFindNext(         pFile->hFind,&sFind);
            }

        if(bFail)break;

        PRINT_SMB_MSG2(("\n %i\t\"%s\"",iNum,sFind.cFName))
        bFail=TRUE;

        if(iAttribut)
            {
            if(!(uAttr&sFind.dwAttr))
            if(sFind.dwAttr&(SYS_SYSTEM|SYS_HIDDEN|SYS_DIR)){iNum--;continue;}
            }
        else{
            if(sFind.dwAttr&(SYS_SYSTEM|SYS_HIDDEN|SYS_DIR)){iNum--;continue;}
            }

        #if !SYS_HAS_SHORT_NAME
        if(!Is83Name(sFind.cName)){iNum--;continue;}
        #endif

        iMode=AttrSysToDos(sFind.dwAttr);
        SysTimeConvertSD(sFind.dwTimeWrite,&uTime);

        memcpy(pPtr,pStatus,21);
        SCVAL (pPtr,21,iMode);
        SIVAL (pPtr,22,uTime);
        SIVAL (pPtr,26,sFind.dwSize);
        strcpy(pPtr+30,sFind.cFName);
        pPtr += 43;
        }


    PRINT_SMB_MSG1((" found=%i ",iNum))

    if(iNum==0)
        {
        SCVAL(pOut,smb_rcls,ERRDOS);
        SSVAL(pOut,smb_err ,ERRnofiles);
        SmbClearFile(pSession,wFid);
        wFid=0;
        }

    if(wFid && CVAL(pIn,smb_com)==SMBsearch && iNum<iMaxCount)
        {
        SSVAL(pPtr-43,12,0);                        // fid=0
        SmbClearFile(pSession,wFid);
        wFid=0;
        }

    // If we were called as SMBffirst with smb_search_id == NULL
    // and no entries were found then return error

    if(bClose && !iNum && !iStatusLen)
        {
        SCVAL(pOut,smb_rcls,ERRDOS);
        SSVAL(pOut,smb_err ,ERRnofiles);
        }

    // If we were called as SMBfunique, then we can close the handle

    if(bClose && wFid)
        {
        SmbClearFile(pSession,wFid);
        }

    SSVAL(pOut,smb_vwv0,iNum);
    SSVAL(pOut,smb_vwv1,iNum*43+3);
    SCVAL(smb_buf(pOut),0,5);
    SSVAL(smb_buf(pOut),1,iNum*43);


    iOutsize += 43*iNum;
    SmbSetLen(pOut,iOutsize-4);
    PRINT_SMB_MSG1(("<ok>"))



return iOutsize;
}


//*****************************************************************************
//*
//*     ReplyRead
//*
//*****************************************************************************
//  reply to a read , read from a file
int ReplyRead(SmbSession *pSession,unsigned char *pIn,unsigned char *pOut,int iSize,int iBuffSize)
{
int             iStartPos;
int             iRead;
int             iOutsize,iCount;
unsigned char  *pData;
SmbFileEntry   *pFile;





    iRead      = SVAL(pIn,smb_vwv1);
    iStartPos  = IVAL(pIn,smb_vwv2);
    iOutsize   = SmbSetMessage(pOut,5,3,TRUE);
    iRead      = MIN(iBuffSize-iOutsize,iRead);
    pData      = smb_buf(pOut)+3;


    PRINT_SMB_MSG1((" FID=%i read %i bytes  ",pSession->wFid,iRead))
    /* if(is_locked(pFile){return SMB_ERROR(ERRDOS,ERRlock);*/


    if(iRead>0)
        {
            pFile=pSession->pFile;
        if( pFile->bType!=0)
            {
            PRINT_SMB_ERR(("SMB_ERROR wrong FID type"))
            return SMB_ERROR(ERRSRV,ERRinvnid);
            }

        if(SysSeek(pFile->hFile,iStartPos,SEEK_SET)<0)
            {
            PRINT_SMB_ERR(("SMB_ERROR can't seek file"))
            return SMB_ERROR(ERRDOS,ERRnoaccess);
            }

           iCount=SysRead(pFile->hFile,pData,iRead);
        if(iCount<0)
            {
            PRINT_SMB_ERR(("SMB_ERROR read"))
            return SMB_ERROR(ERRDOS,ERRnoaccess);
            }
        }
    else{
        iCount=0;
        }

    iOutsize += iCount;
    SSVAL(pOut,smb_vwv0,iCount);
    SSVAL(pOut,smb_vwv5,iCount+3);
    SCVAL(smb_buf(pOut),0,1);
    SSVAL(smb_buf(pOut),1,iCount);
    PRINT_SMB_MSG1(("<ok>"))


return  iOutsize;
}

//*****************************************************************************
//*
//*     ReplyWrite
//*
//*****************************************************************************
//  reply to a write    , write to a file
int ReplyWrite(SmbSession *pSession,unsigned char *pIn,unsigned char *pOut,int iSize,int iBuffSize)
{
int             iStartPos;
int             iWrite;
int             iOutsize,iCount;
unsigned char  *pData;
SmbFileEntry   *pFile;





    iWrite     = SVAL(pIn,smb_vwv1);
    iStartPos  = IVAL(pIn,smb_vwv2);
    pData      = smb_buf(pIn)+3;


    /* if(is_locked(pFile){return SMB_ERROR(ERRDOS,ERRlock);*/
    PRINT_SMB_MSG1((" FID=%i write %i bytes  ",pSession->wFid,iWrite))


    if(iWrite>0)
        {
            pFile=pSession->pFile;
        if( pFile->bType!=0)
            {
            PRINT_SMB_ERR(("SMB_ERROR wrong FID type"))
            return SMB_ERROR(ERRSRV,ERRinvnid);
            }

        if(SysSeek(pFile->hFile,iStartPos,SEEK_SET)<0)
            {
            PRINT_SMB_ERR(("SMB_ERROR can't seek file"))
            return SMB_ERROR(ERRDOS,ERRnoaccess);
            }

           iCount=SysWrite(pFile->hFile,pData,iWrite);
        if(iCount<=0)
            {
            PRINT_SMB_ERR(("SMB_ERROR write"))
            if(iCount==SYS_ERR_DISKFULL)
                    return SMB_ERROR(ERRHRD,ERRdiskfull);
            else    return SMB_ERROR(ERRDOS,ERRnoaccess);
            }
        }
    else{
        iCount=0;
        }


    iOutsize   = SmbSetMessage(pOut,1,0,TRUE);
    SSVAL(pOut,smb_vwv0,iCount);
    PRINT_SMB_MSG1(("<ok>"))


return  iOutsize;
}


//*****************************************************************************
//*
//*     ReplyLseek
//*
//*****************************************************************************
//  reply to a write    , write to a file
int ReplyLseek(SmbSession *pSession,unsigned char *pIn,unsigned char *pOut,int iSize,int iBuffSize)
{
int             iStartPos,iPos;
int             iMode;
int             iOutsize;
unsigned char  *pData;
SmbFileEntry   *pFile;





    iMode      = SVAL(pIn,smb_vwv1);
    iStartPos  = IVAL(pIn,smb_vwv2);
    pData      = smb_buf(pIn)+3;


        pFile=pSession->pFile;
    if( pFile->bType!=0)return SMB_ERROR(ERRSRV,ERRinvnid);

    if(SysSeek(pFile->hFile,iStartPos,iMode)<0)
        {
        PRINT_SMB_ERR(("SMB_ERROR can't seek file"))
        return SMB_ERROR(ERRDOS,ERRnoaccess);
        }

    iPos=SysTell(pFile->hFile);
    iOutsize = SmbSetMessage(pOut,2,0,TRUE);
    SSVAL(pOut,smb_vwv0,iPos);
    PRINT_SMB_MSG1((" <ok>"))


return  iOutsize;
}

//*****************************************************************************
//*
//*     ReplyLock
//*
//*****************************************************************************
//*  reply to a lock
int ReplyLock(SmbSession *pSession,unsigned char *pIn,unsigned char *pOut,int iSize,int iBuffSize)
{
int     iOutsize;
int     iOffset;
int     iCount;



    iOutsize = SmbSetMessage(pOut,0,0,FALSE);

    iCount  = IVAL(pIn,smb_vwv1);
    iOffset = IVAL(pIn,smb_vwv3);

    /*
    REM AZ   no lock in this version

    if(!do_lock(fsp, pSession, SVAL(pIn,smb_pid), count, offset, &eclass, &ecode))
        {
        return SMB_ERROR(ERRDOS,ERRlock);
        }
    */

    PRINT_SMB_MSG1(("<ok>"))

return iOutsize;
}



//*****************************************************************************
//*
//*     ReplyUnlock
//*
//*****************************************************************************
//  reply to a unlock
int ReplyUnlock(SmbSession *pSession,unsigned char *pIn,unsigned char *pOut,int iSize,int iBuffSize)
{
int     iOutsize;
int     iOffset;
int     iCount;



    iOutsize = SmbSetMessage(pOut,0,0,FALSE);

    iCount  = IVAL(pIn,smb_vwv1);
    iOffset = IVAL(pIn,smb_vwv3);

    /*
    REM AZ   no lock in this version

    if(!do_unlock(fsp, pSession, SVAL(pIn,smb_pid), count, offset, &eclass, &ecode))
        {
        return SMB_ERROR(ERRDOS,ERRlock);
        }
    */

    PRINT_SMB_MSG1(("<ok>"))

return iOutsize;
}


//*****************************************************************************
//*
//*     ReplyClose
//*
//*****************************************************************************
//  reply to a close
int ReplyClose(SmbSession *pSession,unsigned char *pIn,unsigned char *pOut,int iSize,int iBuffSize)
{
int iOutsize;


    PRINT_SMB_MSG1((" FID=%i ",pSession->wFid))

    iOutsize = SmbSetMessage(pOut,0,0,FALSE);
    SmbClearFile(pSession,pSession->wFid);
    pSession->pFile=0;
    pSession->wFid =0;

    PRINT_SMB_MSG1(("<ok>"))


return  iOutsize;
}


//*****************************************************************************
//*
//*     ReplyFclose
//*
//*****************************************************************************
//  reply to a fclose
int ReplyFClose(SmbSession *pSession,unsigned char *pIn,unsigned char *pOut,int iSize,int iBuffSize)
{
int             iOutsize,iStatusLen,iLen;
char           *pPath;
unsigned char  *pStatus;
unsigned short  wFid;



    pPath      = (char*)smb_buf(pIn)+1;
    iLen       = strlen(pPath);
    iStatusLen = SVAL(smb_buf(pIn),3+iLen);


    if(iStatusLen==0)
        {
        PRINT_SMB_ERR(("SMB_ERROR no status field found"))
        return(SMB_ERROR(ERRSRV,ERRsrverror));
        }


    pStatus    = smb_buf(pIn) + 1 + iLen + 4;
    wFid       = SVAL(pStatus,12);
    SmbClearFile(pSession,wFid);

    iOutsize = SmbSetMessage(pOut,1,0,TRUE);
    SSVAL(pOut,smb_vwv0,0);


return  iOutsize;
}


//*****************************************************************************
//*
//*     ReplyCTemp
//*
//*****************************************************************************
//  reply to a create temporary file
int ReplyCTemp(SmbSession *pSession,unsigned char *pIn,unsigned char *pOut,int iSize,int iBuffSize)
{
char            cName[MAX_PATHNAME_SIZE];
char           *pName;
int             iError;
int             iOutsize = 0;
int             iLen,iMode,iNum;
unsigned        uAttr,uTime;
unsigned short  wFid;
int             bError;
SysFile         hFile;



    pName = (char*)smb_buf(pIn)+1;
    iLen  = SmbPathName(pSession,cName,pName);

    if(iLen<0)
        {
        PRINT_SMB_ERR(("SMB_ERROR wrong file: \"%s\"",pName))
        return SMB_ERROR(ERRDOS,ERRbadpath);
        }

    if(iLen+14>MAX_PATHNAME_SIZE)
        {
        PRINT_SMB_ERR(("SMB_ERROR do long pathname: \"%s\"",pName))
        return SMB_ERROR(ERRDOS,ERRbadfile);
        }

    if(pSession->pTree->iConnectType==4)        // base connection
        {
        PRINT_SMB_ERR(("SMB_ERROR base connection used"))
        return SMB_ERROR(ERRDOS,ERRaccess);
        }


    iMode  = SVAL(pIn,smb_vwv0);
    uTime  = IVAL(pIn,smb_vwv1);
    bError = FALSE;
    uAttr  = SYS_WRITE|SYS_READ|SYS_CREATE|SYS_TRUNC|SYS_ARCHIVE;

    switch((iMode>>4)&0x07)
            {
    case 0:
    case 1:                                    break;
    case 2: uAttr|=SYS_SHARE_RD;               break;
    case 3: uAttr|=SYS_SHARE_WR;               break;
    case 4: uAttr|=SYS_SHARE_WR|SYS_SHARE_RD;  break;
    default:bError=TRUE;
            }


    for(iNum=0;iNum<1024;iNum++)                // create temp file
        {
        sprintf(cName+iLen,"\\%i.TMP",(iTempNum+iNum)&0x3FF);
        iTempNum++;
        hFile=SysOpenEx(cName,uAttr,&iError);
        if(hFile)break;
        }


    PRINT_SMB_MSG1((" file=\"%s\" ",cName))

    if(!hFile)
        {
        PRINT_SMB_ERR(("SMB_ERROR can't create file"))

        switch(iError)
            {
        case SYS_ERR_PATH_NOTFOUND:     return SMB_ERROR(ERRDOS,ERRbadpath);
        case SYS_ERR_INVALID_FILENAME:  return SMB_ERROR(ERRDOS,ERRbadpath);
        case SYS_ERR_FILE_NOT_FOUND:    return SMB_ERROR(ERRDOS,ERRbadfile);
        case SYS_ERR_NO_HANDLES:        return SMB_ERROR(ERRDOS,ERRnofids);
        default:                        return SMB_ERROR(ERRDOS,ERRnoaccess);
            }
        }

    SysSetFileTime(hFile,uTime,0,0);

        wFid=SmbCreateFile(pSession,hFile,0);
    if(!wFid)
        {
        PRINT_SMB_ERRS(("SYSERROR no SmbFree file id"));
        SysClose(hFile);
        return SMB_ERROR(ERRDOS,ERRnofids);
        }

    pSession->wFid  = wFid;
    pSession->pFile = SmbGetFile(pSession,wFid);


    iNum=strlen(cName+iLen)+1;
    iOutsize = SmbSetMessage(pOut,1,iNum,TRUE);
    SSVAL(pOut,smb_vwv0,wFid);
    pName=(char*)smb_buf(pOut);
    memcpy(pName,cName+iLen,iNum);
    PRINT_SMB_MSG1(("<ok>"))


return  iOutsize;
}



//*****************************************************************************
//*
//*     ReplyMkNew
//*
//*****************************************************************************
//  reply to a mknew or a create
int ReplyMkNew(SmbSession *pSession,unsigned char *pIn,unsigned char *pOut,int iSize,int iBuffSize)
{
char            cName[MAX_PATHNAME_SIZE];
char           *pName;
int             iOutsize = 0;
int             iMode,iError;
unsigned        uAttr,uTime;
unsigned short  wFid;
int             bError;
SysFile         hFile;



    pName=(char*)smb_buf(pIn)+1;

    if(SmbPathName(pSession,cName,pName)<0)
        {
        PRINT_SMB_ERR(("SMB_ERROR wrong file: \"%s\"",pName))
        return SMB_ERROR(ERRDOS,ERRbadpath);
        }

    PRINT_SMB_MSG1((" file=\"%s\" ",cName))
    iMode  = SVAL(pIn,smb_vwv0);
    uTime  = IVAL(pIn,smb_vwv1);
    bError = FALSE;


    if(pSession->pTree->iConnectType==4)        // base connection
        {
        PRINT_SMB_ERR(("SMB_ERROR wrong path"))
        return SMB_ERROR(ERRDOS,ERRaccess);
        }


    if(SVAL(pIn,smb_com)==SMBmknew)
        {
        if(SysGetAttributes(cName)>=0)
            {
            PRINT_SMB_ERR(("SMB_ERROR file allready exist: \"%s\"",pName))
            return SMB_ERROR(ERRDOS,ERRbadpath);
            }
        }

    switch(iMode&0x0F)
            {
    case 0:
    case 1:
    case 2: uAttr=SYS_WRITE|SYS_READ;  break;
    default:bError=TRUE;
            }

    switch((iMode>>4)&0x07)
            {
    case 0:
    case 1:                                     break;
    case 2: uAttr|=SYS_SHARE_RD;               break;
    case 3: uAttr|=SYS_SHARE_WR;               break;
    case 4: uAttr|=SYS_SHARE_WR|SYS_SHARE_RD;  break;
    default:bError=TRUE;
            }


    if(bError)
        {
        PRINT_SMB_ERR(("SMB_ERROR wrong attribute"))
        return SMB_ERROR(ERRDOS,ERRnoaccess);
        }


        hFile=SysOpenEx(cName,uAttr|SYS_CREATE|SYS_TRUNC|SYS_ARCHIVE,&iError);
    if(!hFile)
        {
        PRINT_SMB_ERR(("SMB_ERROR can't open"))

        switch(iError)
            {
        case SYS_ERR_NO_HANDLES:        return SMB_ERROR(ERRDOS,ERRnofids);
        case SYS_ERR_PATH_NOTFOUND:     return SMB_ERROR(ERRDOS,ERRbadpath);
        case SYS_ERR_INVALID_FILENAME:  return SMB_ERROR(ERRDOS,ERRbadpath);
        case SYS_ERR_FILE_NOT_FOUND:    return SMB_ERROR(ERRDOS,ERRbadfile);
        default:                        return SMB_ERROR(ERRDOS,ERRnoaccess);
            }
        }

    SysSetFileTime(hFile,uTime,0,0);

        wFid=SmbCreateFile(pSession,hFile,0);
    if(!wFid)
        {
        PRINT_SMB_ERRS(("SYSERROR no SmbFree file id"));
        SysClose(hFile);
        return SMB_ERROR(ERRDOS,ERRnofids);
        }

    pSession->wFid  = wFid;
    pSession->pFile = SmbGetFile(pSession,wFid);

    iOutsize = SmbSetMessage(pOut,1,0,TRUE);
    SSVAL(pOut,smb_vwv0,wFid);
    PRINT_SMB_MSG1(("<ok>"))



return  iOutsize;
}



//*****************************************************************************
//*
//*     ReplyCheckPath
//*
//*****************************************************************************
//  reply to a chkpth
int ReplyCheckPath(SmbSession *pSession,unsigned char *pIn,unsigned char *pOut,int iSize,int iBuffSize)
{
char            cName[MAX_PATHNAME_SIZE];
char           *pName;
int             iOutsize = 0;
int             iMode;
unsigned        uAttr;
int             bError;
SmbBase         hBase;
SysFindStruct   sFind;



    pName=(char*)smb_buf(pIn)+1;

    if(SmbPathName(pSession,cName,pName)<0)
        {
        PRINT_SMB_ERR(("SMB_ERROR wrong file: \"%s\"",pName))
        return SMB_ERROR(ERRDOS,ERRbadpath);
        }

    PRINT_SMB_MSG1((" file=\"%s\" ",cName))
    iMode  = SVAL(pIn,smb_vwv0);
    bError = FALSE;

    if(pSession->pTree->iConnectType==4)        // base connection
        {
        hBase=SmbBaseFirst(pSession,cName,&sFind);
        if(!hBase)return SMB_ERROR(ERRDOS,ERRaccess);
        SmbBaseClose(pSession,hBase);
        iOutsize = SmbSetMessage(pOut,0,0,FALSE);
        return iOutsize;
        }

       uAttr=SysGetAttributes(cName);
    if(uAttr<0)
        {
        PRINT_SMB_ERR(("SMB_ERROR bad path: \"%s\"",pName))
        return SMB_ERROR(ERRDOS,ERRbadpath);
        }

    if(!(uAttr&SYS_DIR))
        {
        PRINT_SMB_ERR(("SMB_ERROR in not a path: \"%s\"",pName))
        return SMB_ERROR(ERRDOS,ERRbadpath);
        }

    iOutsize = SmbSetMessage(pOut,0,0,FALSE);
    PRINT_SMB_MSG1(("<ok>"))


return iOutsize;
}




//*****************************************************************************
//*
//*     ReplyMkDir
//*
//*****************************************************************************
//  reply to a mkdir
int ReplyMkDir(SmbSession *pSession,unsigned char *pIn,unsigned char *pOut,int iSize,int iBuffSize)
{
char            cName[MAX_PATHNAME_SIZE];
char           *pName;
int             iOutsize;





    pName=(char*)smb_buf(pIn)+1;

    if(SmbPathName(pSession,cName,pName)<0)
        {
        PRINT_SMB_ERR(("SMB_ERROR wrong file: \"%s\"",pName))
        return SMB_ERROR(ERRDOS,ERRbadpath);
        }

    PRINT_SMB_MSG1((" dir=\"%s\"",cName))


    if(pSession->pTree->iConnectType==4)        // base connection
        {
        PRINT_SMB_ERR(("SMB_ERROR base connection used"))
        return SMB_ERROR(ERRDOS,ERRbadpath);
        }


    if(SysGetAttributes(cName)>=0)              // exist file ?
        {
        PRINT_SMB_ERR(("SMB_ERROR file already exist"))
        return SMB_ERROR(ERRDOS,ERRfilexists);
        }

    if(SysMkdir(cName)<0)                       // create directory
        {
        PRINT_SMB_ERR(("SMB_ERROR can't create directory"))
        return SMB_ERROR(ERRDOS,ERRbadpath);
        }


    iOutsize = SmbSetMessage(pOut,0,0,FALSE);
    PRINT_SMB_MSG1(("<ok>"))


return iOutsize;
}

//*****************************************************************************
//*
//*     ReplyRmDir
//*
//*****************************************************************************
//  reply to a rmdir
int ReplyRmDir(SmbSession *pSession,unsigned char *pIn,unsigned char *pOut,int iSize,int iBuffSize)
{
char            cName[MAX_PATHNAME_SIZE];
char           *pName;
int             iOutsize;





    pName=(char*)smb_buf(pIn)+1;

    if(SmbPathName(pSession,cName,pName)<0)
        {
        PRINT_SMB_ERR(("SMB_ERROR wrong file: \"%s\"",pName))
        return SMB_ERROR(ERRDOS,ERRbadpath);
        }

    PRINT_SMB_MSG1((" dir=\"%s\"",cName))


    if(pSession->pTree->iConnectType==4)        // base connection
        {
        PRINT_SMB_ERR(("SMB_ERROR base connection used"))
        return SMB_ERROR(ERRDOS,ERRbadpath);
        }

    if(SysRmdir(cName)<0)
        {
        PRINT_SMB_ERR(("SMB_ERROR can't remove directory"))
        return SMB_ERROR(ERRDOS,ERRbadpath);
        }


    iOutsize = SmbSetMessage(pOut,0,0,FALSE);
    PRINT_SMB_MSG1(("<ok>"))


return iOutsize;
}

//*****************************************************************************
//*
//*     ReplyFlush
//*
//*****************************************************************************
//  reply to a flush
int ReplyFlush(SmbSession *pSession,unsigned char *pIn,unsigned char *pOut,int iSize,int iBuffSize)
{
int iOutsize;




    if(SysFlush(pSession->pFile->hFile)<0)
        {
        PRINT_SMB_ERR(("SMB_ERROR can't flush pData"))
        return SMB_ERROR(ERRDOS,ERRnoaccess);
        }

    iOutsize   = SmbSetMessage(pOut,0,0,FALSE);
    PRINT_SMB_MSG1((" FID=%i <ok>",pSession->wFid))


return  iOutsize;
}

//*****************************************************************************
//*
//*     ReplyUnlink
//*
//*****************************************************************************
//  reply to a unlink , delete files
int ReplyUnlink(SmbSession *pSession,unsigned char *pIn,unsigned char *pOut,int iSize,int iBuffSize)
{
char            cName[MAX_PATHNAME_SIZE];
char           *pName;
int             iOutsize;
int             iError;
int             iCount;
int             iFound;
int             iLen;
SysFind         hFind;
SysFindStruct   sFind;



    pName = (char*)smb_buf(pIn)+1;
    iLen  = SmbPathName(pSession,cName,pName);

    if(iLen<0)
        {
        PRINT_SMB_ERR(("SMB_ERROR wrong file: \"%s\"",pName))
        return SMB_ERROR(ERRDOS,ERRbadpath);
        }

    PRINT_SMB_MSG1((" file=\"%s\" ",cName))

    if(pSession->pTree->iConnectType==4)        // base connection
        {
        PRINT_SMB_ERR(("SMB_ERROR base connection used"))
        return SMB_ERROR(ERRDOS,ERRbadpath);
        }


    for(iLen--;iLen>0;iLen--)if(cName[iLen]=='\\')break;
    iLen++;

    if(!strcmp(cName+iLen,"????????.???"))
        {
        strcpy(cName+iLen,"*");
        }

    iCount = 0;
    iFound = 0;
    hFind  = SysFindFirstEx(cName,&sFind,&iError);

    if(hFind)                                   // delete files
        {
        do  {
            iFound++;

            if(!(sFind.dwAttr&SYS_WRITE))continue;
            if(iLen+strlen(sFind.cName)>=MAX_PATHNAME_SIZE)continue;
            strcpy(cName+iLen,sFind.cName);
            if(!SysDelete(cName))
                {
                iCount++;
                }

            }while(!SysFindNext(hFind,&sFind));

        SysFindClose(hFind);
        }

    if(!iCount)
        {
        PRINT_SMB_ERR(("SMB_ERROR no file found"))

        if(iFound==1)return SMB_ERROR(ERRDOS,ERRnoaccess);

        switch(iError)
            {
        case SYS_ERR_INVALID_FILENAME:
        case SYS_ERR_PATH_NOTFOUND:     return SMB_ERROR(ERRDOS,ERRbadpath);
        default:                        return SMB_ERROR(ERRDOS,ERRbadfile);
            }
        }

    iOutsize = SmbSetMessage(pOut,0,0,FALSE);
    PRINT_SMB_MSG1(("<ok>"))


return iOutsize;
}

//*****************************************************************************
//*
//*     ReplyMove
//*
//*****************************************************************************
//  reply to a move
int ReplyMove(SmbSession *pSession,unsigned char *pIn,unsigned char *pOut,int iSize,int iBuffSize)
{
char            cName1[MAX_PATHNAME_SIZE];
char            cName2[MAX_PATHNAME_SIZE];
char           *pName;
int             iOutsize;





    pName=(char*)smb_buf(pIn)+1;

    if(SmbPathName(pSession,cName1,pName)<0)
        {
        PRINT_SMB_ERR(("SMB_ERROR wrong file: \"%s\"",pName))
        return SMB_ERROR(ERRDOS,ERRbadpath);
        }

    pName+=strlen(pName)+2;

    if(SmbPathName(pSession,cName2,pName)<0)
        {
        PRINT_SMB_ERR(("SMB_ERROR wrong file: \"%s\"",pName))
        return SMB_ERROR(ERRDOS,ERRbadpath);
        }


    PRINT_SMB_MSG1((" name=\"%s\"",cName1))
    PRINT_SMB_MSG1((" new=\"%s\" ",cName2))

    // REM AZ  wildcards support isn't implemented yet !!!

    if(pSession->pTree->iConnectType==4)        // base connection
        {
        PRINT_SMB_ERR(("SMB_ERROR base connection used"))
        return SMB_ERROR(ERRDOS,ERRaccess);
        }

    if(SysMove(cName1,cName2)<0)
        {
        PRINT_SMB_ERR(("SMB_ERROR can't move file"))
        return SMB_ERROR(ERRDOS,ERRbadpath);
        }


    iOutsize = SmbSetMessage(pOut,0,0,FALSE);
    PRINT_SMB_MSG1(("<ok>"))


return iOutsize;
}


//*****************************************************************************
//*
//*     ReplySetAttr
//*
//*****************************************************************************
//  reply to a get file attributs
int ReplySetAttr(SmbSession *pSession,unsigned char *pIn,unsigned char *pOut,int iSize,int iBuffSize)
{
int             iOutsize=0;
char            cName[MAX_PATHNAME_SIZE];
char           *pName;
int             iMode,iAttr;
unsigned        uTime;
SysFile         hHandle;



    pName  = (char*)smb_buf(pIn)+1;
    iMode  = SVAL(pIn,smb_vwv0);
    uTime  = IVAL(pIn,smb_vwv1);

    if(SmbPathName(pSession,cName,pName)<0)
        {
        PRINT_SMB_ERR(("SMB_ERROR wrong file: \"%s\"",pName))
        return SMB_ERROR(ERRDOS,ERRbadfile);
        }

    PRINT_SMB_MSG1((" file=\"%s\" Attr=%02X ",cName,iMode))

    if(pSession->pTree->iConnectType==4)            // base connection
        {
        PRINT_SMB_ERR(("SMB_ERROR base connection used"))
        return SMB_ERROR(ERRDOS,ERRaccess);
        }

       iAttr=SysGetAttributes(cName);
    if(iAttr<0)
        {
        PRINT_SMB_ERR(("SMB_ERROR can't find file"))
        return SMB_ERROR(ERRDOS,ERRbadfile);
        }

    if(iAttr&SYS_DIR)                               // is directory
        {
        PRINT_SMB_MSG1(("<ok>"))
        iOutsize = SmbSetMessage(pOut,0,0,FALSE);
        return iOutsize;
        }

    iAttr=AttrDosToSys(iMode);

    if(SysSetAttributes(cName,iAttr)<0)
        {
        PRINT_SMB_ERR(("SMB_ERROR base connection used"))
        return SMB_ERROR(ERRDOS,ERRaccess);
        }

    if(uTime)                                      // set file write time
        {
        	hHandle=SysOpen(cName,SYS_WRITE);
        if(!hHandle)
            {
            PRINT_SMB_ERR(("SMB_ERROR can't open file %s",cName))
            return SMB_ERROR(ERRDOS,ERRaccess);
            }

		if(uTime && SysSetFileTime(hHandle,uTime,0,0)<0)
            {
			SysClose(hHandle);
            PRINT_SMB_ERR(("SMB_ERROR can't set file time"))
            return SMB_ERROR(ERRDOS,ERRaccess);
            }

		SysClose(hHandle);
        }


    iOutsize = SmbSetMessage(pOut,0,0,FALSE);
    PRINT_SMB_MSG1(("<ok>"))



return iOutsize;
}


//*****************************************************************************
//*
//*     ReplyExit
//*
//*****************************************************************************
//  reply to a exit
int ReplyExit(SmbSession *pSession,unsigned char *pIn,unsigned char *pOut,int iSize,int iBuffSize)
{
int iOutsize;



    iOutsize = SmbSetMessage(pOut,0,0,FALSE);

    PRINT_SMB_MSG1(("<ok>"))


return iOutsize;
}


//*****************************************************************************
//*
//*     ReplyTdis
//*
//*****************************************************************************
//  reply to a tdis.
//  disconnect tree
int ReplyTdis(SmbSession *pSession,unsigned char *pIn,unsigned char *pOut,int iSize,int iBuffSize)
{
unsigned short  wTid,wUid;
int             iOutsize;
SmbTreeEntry   *pTree;


    wTid=SVAL(pIn,smb_tid);
    wUid=SVAL(pIn,smb_uid);

    pTree=pSession->pTree;
    pSession->wTid =0;
    pSession->pTree=0;


    //if(wUid)                                      // clear user
    /*  {
        PRINT_SMB_MSG1((" clear user %04X",wUid))
        SmbClearUser(pSession,wUid);
        if(pSession->wUid==wUid)
            {
            pSession->wUid=0;
            pSession->pUser=0;
            }
        }
    */

    if(wTid==0)                                     // no tree
        {
        return SMB_ERROR(ERRDOS,ERRinvnid);
        }

    if(wTid!=0xFFFF)                                // no pipe connection
        {
        if(!SmbGetTree(pSession,wTid))
            {
            return SMB_ERROR(ERRDOS,ERRinvnid);
            }

        SmbClearTree(pSession,wTid);
        }

    iOutsize = SmbSetMessage(pOut,0,0,FALSE);

    PRINT_SMB_MSG1((" <ok>"))


return iOutsize;
}

//*****************************************************************************
//*
//*     ReplyTrans
//*
//*****************************************************************************
//  reply to a SMBtrans.
int ReplyTrans(SmbSession *pSession,unsigned char *pIn,unsigned char *pOut,int iSize,int iBuffSize)
{
int             iOutsize=0,i;
char            cName[MAX_PATHNAME_SIZE];
int             iNameOffset;
char           *pData =NULL;
char           *pParam=NULL;
unsigned short *pSetup=NULL;
unsigned short  wUid;
int             iFlags;
int             iTimeout;
int             iTotalParamSend;
int             iTotalDataSend;
int             iMaxParamReturn;
int             iMaxDataReturn;
int             iMaxSetupReturn;
int             iParamSendCount;
int             iParamSendOffset;
int             iDataSendCount;
int             iDataSendOffset;
int             iSetupWordCount;
int             bCloseOn;
int             bOneWay;



    wUid                = SVAL(pIn,smb_uid);
    iTotalParamSend     = SVAL(pIn,smb_vwv0);
    iTotalDataSend      = SVAL(pIn,smb_vwv1);
    iMaxParamReturn     = SVAL(pIn,smb_vwv2);
    iMaxDataReturn      = SVAL(pIn,smb_vwv3);
    iMaxSetupReturn     = CVAL(pIn,smb_vwv4);
    iFlags              = CVAL(pIn,smb_vwv5);
    iTimeout            = IVAL(pIn,smb_vwv7);
    iParamSendCount     = SVAL(pIn,smb_vwv9);
    iParamSendOffset    = SVAL(pIn,smb_vwv10);
    iDataSendCount      = SVAL(pIn,smb_vwv11);
    iDataSendOffset     = SVAL(pIn,smb_vwv12);
    iSetupWordCount     = CVAL(pIn,smb_vwv13);

    bCloseOn            = iFlags&1;
    bOneWay             = iFlags&2;


    strncpy(cName,(char*)smb_buf(pIn),sizeof(cName));
    PRINT_SMB_MSG1((" file=\"%s\" ",cName))


    PRINT_SMB_MSG2(("\n\t\tTotalParamSend  = %i"  ,SVAL(pIn,smb_vwv0)))
    PRINT_SMB_MSG2(("\n\t\tTotalDataSend   = %i"  ,SVAL(pIn,smb_vwv1)))
    PRINT_SMB_MSG2(("\n\t\tMaxParamReturn  = %i"  ,SVAL(pIn,smb_vwv2)))
    PRINT_SMB_MSG2(("\n\t\tMaxDataReturn   = %i"  ,SVAL(pIn,smb_vwv3)))
    PRINT_SMB_MSG2(("\n\t\tMaxSetupReturn  = %i"  ,CVAL(pIn,smb_vwv4)))
    PRINT_SMB_MSG2(("\n\t\tFlags           = %Xh" ,CVAL(pIn,smb_vwv5)))
    PRINT_SMB_MSG2(("\n\t\tTimeout         = %i"  ,IVAL(pIn,smb_vwv7)))
    PRINT_SMB_MSG2(("\n\t\tParamSendCount  = %i"  ,SVAL(pIn,smb_vwv9)))
    PRINT_SMB_MSG2(("\n\t\tParamSendOffset = %i"  ,SVAL(pIn,smb_vwv10)))
    PRINT_SMB_MSG2(("\n\t\tDataSendCount   = %i"  ,SVAL(pIn,smb_vwv11)))
    PRINT_SMB_MSG2(("\n\t\tDataSendOffset  = %i"  ,SVAL(pIn,smb_vwv12)))
    PRINT_SMB_MSG2(("\n\t\tSetupWordCount  = %i"  ,CVAL(pIn,smb_vwv13)))
    PRINT_SMB_MSG2(("\n\t\t"))


    if(iDataSendCount>iTotalDataSend || iParamSendCount>iTotalParamSend)
        {
        PRINT_SMB_ERR(("SMB_ERROR invalid trans parameters"))
        SmbSessionExit(pSession);
        return -1;
        }


    if(iTotalDataSend)                                  // data puffer
        {
            pData=(char*)SmbAlloc(iTotalDataSend);
        if(!pData)return SMB_ERROR(ERRDOS,ERRnomem);
        memcpy(pData,smb_base(pIn)+iDataSendOffset,iDataSendCount);
        }

    if(iTotalParamSend)                                 // parameter buffer
        {
            pParam=(char*)SmbAlloc(iTotalParamSend);
        if(!pParam){if(pData)SmbFree(pData);return SMB_ERROR(ERRDOS,ERRnomem);}
        memcpy(pParam,smb_base(pIn)+iParamSendOffset,iParamSendCount);
        }

    if(iSetupWordCount)                                 // setup buffer
        {
            pSetup=(unsigned short*)SmbAlloc(iSetupWordCount*2);
        if(!pSetup){if(pParam)SmbFree(pParam);if(pData)SmbFree(pData);return SMB_ERROR(ERRDOS,ERRnomem);}
        for(i=0;i<iSetupWordCount;i++)pSetup[i]=SVAL(pIn,smb_vwv14+i*2);
        }

    if(iParamSendCount<iTotalParamSend || iDataSendCount<iTotalDataSend)
        {
        iOutsize = SmbSetMessage(pOut,0,0,FALSE);       // send an interim response
        if(!TcpPut(pSession->hTcp,pOut,iOutsize))
            {
            PRINT_SMB_ERRS(("\nSMB SYSERROR  ReplyTrans: send_smb failed."))
            if(pSetup)SmbFree(pSetup);
            if(pParam)SmbFree(pParam);
            if(pData )SmbFree(pData);
            SmbSessionExit(pSession);
			return -1;
            }

                                                        // receive the rest of the trans packet
        while(iParamSendCount<iTotalParamSend || iDataSendCount<iTotalDataSend)
            {
            int     iRet;
            int     iDataDisp ,iDataCount ,iDataOffset;
            int     iParamDisp,iParamCount,iParamOffset;


               iRet = SmbReadNextPacket(pSession->hTcp,pIn,pSession->iMaxResvSize,SMB_SECONDARY_WAIT);
            if(iRet<=0)
                {
                PRINT_SMB_ERR(("\nERROR ReplyTrans: error in getting secondary trans response."))
                if(pSetup)SmbFree(pSetup);
                if(pParam)SmbFree(pParam);
                if(pData )SmbFree(pData);
                return SMB_ERROR(ERRSRV,ERRerror);
                }

             pSession->iPacketCount++;

             if(CVAL(pIn,smb_com)!=SMBtranss)
                {
                PRINT_SMB_ERR(("\nSMB SMB_ERROR  nReplyTrans: Invalid secondary trans packet"))
                if(pSetup)SmbFree(pSetup);
                if(pParam)SmbFree(pParam);
                if(pData )SmbFree(pData);
                return SMB_ERROR(ERRSRV,ERRerror);
                }

            iTotalParamSend = SVAL(pIn,smb_vwv0);
            iTotalDataSend  = SVAL(pIn,smb_vwv1);
            iParamCount     = SVAL(pIn,smb_vwv2);
            iParamOffset    = SVAL(pIn,smb_vwv3);
            iParamDisp      = SVAL(pIn,smb_vwv4);
            iDataCount      = SVAL(pIn,smb_vwv5);
            iDataOffset     = SVAL(pIn,smb_vwv6);
            iDataDisp       = SVAL(pIn,smb_vwv7);

            iParamSendCount += iParamCount;
            iDataSendCount  += iDataCount;

            if(iDataSendCount>iTotalDataSend || iParamSendCount>iTotalParamSend)
                {
                PRINT_SMB_ERR(("invalid trans parameters"))
                if(pSetup)SmbFree(pSetup);
                if(pParam)SmbFree(pParam);
                if(pData )SmbFree(pData);
                SmbSessionExit(pSession);
				return -1;
                }

            if(iParamCount)memcpy(pParam+iParamDisp,smb_base(pIn)+iParamOffset,iParamCount);
            if(iDataCount )memcpy(pData +iDataDisp ,smb_base(pIn)+iDataOffset ,iDataCount);
            }
        }


    iNameOffset=0;


    if(cName[0] == '\\')                        // WinCE wierdness
        {
        i=strlen(pSession->cLocalMachine);
        if(cName[i+1]=='\\' && MemCmpI(cName+1,pSession->cLocalMachine,i)==0)
            {
            iNameOffset = i+1;
            }
        }

    if(memcmp(cName+iNameOffset,"\\PIPE",5)==0)
        {
        iNameOffset+=5;
        if(cName[iNameOffset]=='\\')iNameOffset++;

        iOutsize = SmbNamedPipe(pSession,wUid,pOut,cName+iNameOffset,
                                pSetup,pData,pParam,
                                iSetupWordCount,iTotalDataSend,iTotalParamSend,
                                iMaxSetupReturn,iMaxDataReturn,iMaxParamReturn);
        }
    else{
        PRINT_SMB_ERR(("invalid pipe name\n"))
        iOutsize=0;
        }


    if(pSetup)SmbFree(pSetup);
    if(pParam)SmbFree(pParam);
    if(pData )SmbFree(pData);

    if(bOneWay)return 0;
    if(iOutsize<0)return SMB_ERROR(ERRSRV,ERRnosupport);

    PRINT_SMB_MSG1(("<ok>"))


return iOutsize;
}


//*****************************************************************************
//*
//*     ReplyLockRead
//*
//*****************************************************************************
//  reply to a lockread (core+ protocol)
int ReplyLockRead(SmbSession *pSession,unsigned char *pIn,unsigned char *pOut,int iSize,int iBuffSize)
{
int             iStartPos;
int             iCount = -1;
int             iOutsize;
int             iRead;
unsigned char  *pData;
SmbFileEntry   *pFile;



    iRead     = SVAL(pIn,smb_vwv1);
    iStartPos = IVAL(pIn,smb_vwv2);
    iOutsize  = SmbSetMessage(pOut,5,3,TRUE);
    iRead     = MIN(iBuffSize-iOutsize,iRead);
    pData     = smb_buf(pOut) + 3;


    PRINT_SMB_MSG1((" FID=%i read %i bytes  ",pSession->wFid,iRead))

    /*
    REM AZ   no lock in this version

    if(!do_lock(fsp, pSession, SVAL(pIn,smb_pid), count, offset, &eclass, &ecode))
        {
        return SMB_ERROR(ERRDOS,ERRlock);
        }
    */

    if(iRead>0)
        {
            pFile=pSession->pFile;
        if( pFile->bType!=0)
            {
            PRINT_SMB_ERR(("SMB_ERROR wrong FID type"))
            return SMB_ERROR(ERRSRV,ERRinvnid);
            }

        if(SysSeek(pFile->hFile,iStartPos,SEEK_SET)<0)
            {
            PRINT_SMB_ERR(("SMB_ERROR can't seek file"))
            return SMB_ERROR(ERRDOS,ERRnoaccess);
            }

           iCount=SysRead(pFile->hFile,pData,iRead);
        if(iCount<0)
            {
            PRINT_SMB_ERR(("SMB_ERROR read"))
            return SMB_ERROR(ERRDOS,ERRnoaccess);
            }
        }
    else{
        iCount=0;
        }


    iOutsize += iCount;
    SSVAL(pOut,smb_vwv0,iCount);
    SSVAL(pOut,smb_vwv5,iCount+3);
    SCVAL(smb_buf(pOut),0,1);
    SSVAL(smb_buf(pOut),1,iCount);
    PRINT_SMB_MSG1(("<ok>"))



return iOutsize;
}


//*****************************************************************************
//*
//*     ReplyWriteUnlock
//*
//*****************************************************************************
//  reply to a writeunlock (core+)
int ReplyWriteUnlock(SmbSession *pSession,unsigned char *pIn,unsigned char *pOut, int size, int iBuffSize)
{
int             iStartPos;
int             iWrite;
int             iOutsize,iCount;
unsigned char  *pData;
SmbFileEntry   *pFile;





    iWrite     = SVAL(pIn,smb_vwv1);
    iStartPos  = IVAL(pIn,smb_vwv2);
    pData      = smb_buf(pIn)+3;


    PRINT_SMB_MSG1((" write %i bytes  ",iWrite))

    /*
    REM AZ   no lock in this version

    if(!do_unlock(fsp, pSession, SVAL(pIn,smb_pid), count, offset, &eclass, &ecode))
        {
        return SMB_ERROR(ERRDOS,ERRlock);
        }
    */


    if(iWrite>0)
        {
            pFile=pSession->pFile;
        if( pFile->bType!=0)
            {
            PRINT_SMB_ERR(("SMB_ERROR wrong FID type"))
            return SMB_ERROR(ERRSRV,ERRinvnid);
            }

        if(SysSeek(pFile->hFile,iStartPos,SEEK_SET)<0)
            {
            PRINT_SMB_ERR(("SMB_ERROR can't seek file"))
            return SMB_ERROR(ERRDOS,ERRnoaccess);
            }

           iCount=SysWrite(pFile->hFile,pData,iWrite);
        if(iCount<=0)
            {
            PRINT_SMB_ERR(("SMB_ERROR write"))
            if(iCount==SYS_ERR_DISKFULL)
                    return SMB_ERROR(ERRHRD,ERRdiskfull);
            else    return SMB_ERROR(ERRDOS,ERRnoaccess);
            }
        }
    else{
        iCount=0;
        }


    iOutsize   = SmbSetMessage(pOut,1,0,TRUE);
    SSVAL(pOut,smb_vwv0,iCount);
    PRINT_SMB_MSG1(("<ok>"))


return  iOutsize;
}


//*****************************************************************************
//*
//*     ReplyReadBRaw
//*
//*****************************************************************************
//  reply to a readbraw
int ReplyReadBRaw(SmbSession *pSession,unsigned char *pIn, unsigned char *pOut,int iSize,int iBuffSize)
{
SmbFileEntry   *pFile;
unsigned short  wFid;
int             iStartPos;
int             iMaxCount,iMinCount;
int             iCount;




    wFid  = SVAL(pIn,smb_vwv0);
    pFile = SmbGetFile(pSession,wFid);

    PRINT_SMB_MSG1((" FID=%i",pSession->wFid))


    if(!pFile)                                  // check fid
        {
        SIVAL(pOut,0,0);
        PRINT_SMB_ERR(("SMB_ERROR wrong FID"))
        if(!TcpPut(pSession->hTcp,pOut,4))
            {
            PRINT_SMB_ERRS(("SMB_ERROR tcp write"))
            SmbSessionExit(pSession);
			return -1;
            }

        return 0;
        }

    if(pFile->bType!=0)                         // is file handle
        {
        SIVAL(pOut,0,0);
        PRINT_SMB_ERR(("SMB_ERROR wrong FID type"))
        if(!TcpPut(pSession->hTcp,pOut,4))
            {
            PRINT_SMB_ERRS(("SMB_ERROR tcp write"))
            SmbSessionExit(pSession);
			return -1;
            }

        return 0;
        }


    iStartPos = IVAL(pIn,smb_vwv1);
    iMaxCount = SVAL(pIn,smb_vwv3);
    iMinCount = SVAL(pIn,smb_vwv4);
    iMaxCount = MAX(iMinCount,iMaxCount);


    if(CVAL(pIn,smb_wct) == 10)                 // is a large offset (64 bit)
        {
        if(IVAL(pIn,smb_vwv8)!=0 || iStartPos<0)
            {
            SIVAL(pOut,0,0);
            PRINT_SMB_ERR(("SMB_ERROR wrong start offset"))
            if(!TcpPut(pSession->hTcp,pOut,4))
                {
                PRINT_SMB_ERRS(("SMB_ERROR tcp write"))
                SmbSessionExit(pSession);
				return -1;
                }
            return 0;
            }
        }



    /* REM AZ  in this version lock isn't support
    if (!is_locked(fsp,pSession,(SMB_BIG_UINT)iMaxCount,(SMB_BIG_UINT)iStartPos, READ_LOCK,FALSE))
        {

        if (iStartPos >= size)
            nread = 0;
        else
            nread = MIN(iMaxCount,(size - iStartPos));
        }
    */

    if(SysSeek(pFile->hFile,iStartPos,SEEK_SET)<0)
        {
        SIVAL(pOut,0,0);
        PRINT_SMB_ERR(("SMB_ERROR can't seek"))
        if(!TcpPut(pSession->hTcp,pOut,4))
            {
            PRINT_SMB_ERRS(("SMB_ERROR tcp write"))
            SmbSessionExit(pSession);
			return -1;
            }
        return 0;
        }


    if(iMaxCount > 0)
        {
           iCount = SysRead(pFile->hFile,pOut+4,iMaxCount);
        if(iCount < iMinCount)iCount = 0;
        }
    else{
        iCount = 0;
        }


    PRINT_SMB_MSG1((" read %i bytes  ",iCount))

    SmbSetLen1(pOut,iCount);

    if(!TcpPut(pSession->hTcp,pOut,4+iCount))
        {
        PRINT_SMB_ERRS(("SMB_ERROR tcp write"))
        SmbSessionExit(pSession);
		return -1;
        }


    PRINT_SMB_MSG1(("<ok>"))


return 0;
}


//*****************************************************************************
//*
//*     ReplySetAttrE
//*
//*****************************************************************************
//  reply to a SMBsetattrE
int ReplySetAttrE(SmbSession *pSession,unsigned char *pIn,unsigned char *pOut,int iSize,int iBuffSize)
{
int              iOutsize;
unsigned         dwWrite,dwCreate,dwAccess;
SmbFileEntry    *pFile;



    dwCreate  = SVAL(pIn,smb_vwv1)<<16;
    dwCreate |= SVAL(pIn,smb_vwv2);
    dwAccess  = SVAL(pIn,smb_vwv3)<<16;
    dwAccess |= SVAL(pIn,smb_vwv4);
    dwWrite   = SVAL(pIn,smb_vwv5)<<16;
    dwWrite  |= SVAL(pIn,smb_vwv6);

    SysTimeConvertDS(dwCreate,&dwCreate);
    SysTimeConvertDS(dwAccess,&dwAccess);
    SysTimeConvertDS(dwWrite ,&dwWrite );

        pFile=pSession->pFile;
    if( pFile->bType!=0)
        {
        PRINT_SMB_ERR(("SMB_ERROR wrong FID type"))
        return SMB_ERROR(ERRSRV,ERRinvnid);
        }

    PRINT_SMB_MSG1((" FID=%i handle=%08Xh ",pSession->wFid,(unsigned)pFile->hFile))

    if(SysSetFileTime(pFile->hFile,dwWrite,dwCreate,dwAccess)<0)
        {
        PRINT_SMB_ERR(("SMB_ERROR can't set file time"))
        return SMB_ERROR(ERRDOS,ERRaccess);
        }

    iOutsize = SmbSetMessage(pOut,0,0,FALSE);
    PRINT_SMB_MSG1(("<ok>"))


return iOutsize;
}



//*****************************************************************************
//*
//*     ReplyGetAttrE
//*
//*****************************************************************************
//  reply to a SMBgetattrE
int ReplyGetAttrE(SmbSession *pSession,unsigned char *pIn,unsigned char *pOut,int iSize,int iBuffSize)
{
int              iOutsize,iMode;
SysFindStruct    sInfo;
SmbFileEntry    *pFile;
SysDW            dwCreate;
SysDW            dwAccess;
SysDW            dwWrite;


        pFile=pSession->pFile;
    if( pFile->bType!=0)
        {
        PRINT_SMB_ERR(("SMB_ERROR wrong FID type"))
        return SMB_ERROR(ERRSRV,ERRinvnid);
        }


    PRINT_SMB_MSG1((" FID=%i handle=%08Xh ",pSession->wFid,(unsigned)pFile->hFile))


    if(SysGetFileInfo(pFile->hFile,&sInfo)<0)
        {
        PRINT_SMB_ERR(("SMB_ERROR can't get file info"))
        return SMB_ERROR(ERRDOS,ERRaccess);
        }

    iOutsize = SmbSetMessage(pOut,11,0,TRUE);
    iMode=AttrSysToDos(sInfo.dwAttr);
    SIVAL(pOut,smb_vwv10,iMode);

    SysTimeConvertSD(sInfo.dwTimeCreate,&dwCreate);
    SysTimeConvertSD(sInfo.dwTimeAccess,&dwAccess);
    SysTimeConvertSD(sInfo.dwTimeWrite ,&dwWrite );

    SSVAL(pOut,smb_vwv0,dwCreate>>16);
    SSVAL(pOut,smb_vwv1,dwCreate    );
    SSVAL(pOut,smb_vwv2,dwAccess>>16);
    SSVAL(pOut,smb_vwv3,dwAccess    );
    SSVAL(pOut,smb_vwv4,dwWrite >>16);
    SSVAL(pOut,smb_vwv5,dwWrite     );


    if(iMode&aDIR)
        {
        SIVAL(pOut,smb_vwv6,0);
        SIVAL(pOut,smb_vwv8,0);
        }
    else{
        SIVAL(pOut,smb_vwv6, sInfo.dwSize);
        SIVAL(pOut,smb_vwv8,(sInfo.dwSize+0x03FF)&~0x03FF);
        }

    PRINT_SMB_MSG1(("<ok>"))


return iOutsize;
}


//*****************************************************************************
//*
//*     ReplyLockingX
//*
//*****************************************************************************
//  reply to a lockingX request
int ReplyLockingX(SmbSession *pSession,unsigned char *pIn,unsigned char *pOut,int iSize,int iBuffSize)
{


    // REM AZ locking isn't supported in this version

    SmbSetMessage(pOut,2,0,TRUE);
    PRINT_SMB_MSG1(("<ok>"))


return ChainReply(pSession,pIn,pOut,iSize,iBuffSize);
}



//*****************************************************************************
//*
//*     ReplyEcho
//*
//*****************************************************************************
//  reply to a echo
int ReplyEcho(SmbSession *pSession,unsigned char *pIn,unsigned char *pOut,int iSize,int iBuffSize)
{
int     iOutsize;
int     iCount;
int     iNum;
int     iLen;


    iLen     = smb_buflen(pIn);
    iCount   = SVAL(pIn,smb_vwv0);
    iOutsize = SmbSetMessage(pOut,1,iLen,TRUE);


    if(iCount>100)iCount=100;
    if(iLen>0)
        {
        memcpy(smb_buf(pOut),smb_buf(pIn),iLen);
        }


    for(iNum=1;iNum<=iCount;iNum++)                 // send echos
        {
        SSVAL(pOut,smb_vwv0,iNum);

        if(!TcpPut(pSession->hTcp,pOut,iOutsize))
            {
            PRINT_SMB_ERRS(("SMB_ERROR tcp write"))
            SmbSessionExit(pSession);
			return -1;
            }
        }



return 0;
}

//*****************************************************************************
//*
//*     ReplyWriteClose
//*
//*****************************************************************************
//  reply to a write and a close    , write to a file and cles it
int ReplyWriteClose(SmbSession *pSession,unsigned char *pIn,unsigned char *pOut,int iSize,int iBuffSize)
{
int             iStartPos;
int             iOutsize;
int             iWrite;
int             iCount;
unsigned char  *pData;
SmbFileEntry   *pFile;
unsigned        uTime;




    iWrite     = SVAL(pIn,smb_vwv1);
    iStartPos  = IVAL(pIn,smb_vwv2);
    uTime      = IVAL(pIn,smb_vwv4);

    pData      = smb_buf(pIn)+3;


    pFile=pSession->pFile;
    PRINT_SMB_MSG1((" FID=%i write %i bytes  ",pSession->wFid,iWrite))

    /* if(is_locked(pFile){return SMB_ERROR(ERRDOS,ERRlock);*/


    if(iWrite>0)
        {
            pFile=pSession->pFile;
        if( pFile->bType!=0)
            {
            PRINT_SMB_ERR(("SMB_ERROR wrong FID type"))
            return SMB_ERROR(ERRSRV,ERRinvnid);
            }

        if(SysSeek(pFile->hFile,iStartPos,SEEK_SET)<0)
            {
            PRINT_SMB_ERR(("SMB_ERROR can't seek file"))
            return SMB_ERROR(ERRDOS,ERRnoaccess);
            }

           iCount=SysWrite(pFile->hFile,pData,iWrite);
        if(iCount<=0)
            {
            PRINT_SMB_ERR(("SMB_ERROR write"))
            if(iCount==SYS_ERR_DISKFULL)
                    return SMB_ERROR(ERRHRD,ERRdiskfull);
            else    return SMB_ERROR(ERRDOS,ERRnoaccess);
            }
        }
    else{
        iCount=0;
        }


    PRINT_SMB_MSG1((" close FID=%i ",pSession->wFid))

    SmbClearFile(pSession,pSession->wFid);          // close file
    pSession->pFile=0;
    pSession->wFid =0;


    iOutsize = SmbSetMessage(pOut,1,0,TRUE);
    SSVAL(pOut,smb_vwv0,iCount);
    PRINT_SMB_MSG1(("<ok>"))


return  iOutsize;
}


//*****************************************************************************
//*
//*     ReplyOpenAndX
//*
//*****************************************************************************
//  reply to an open and X
int ReplyOpenAndX(SmbSession *pSession,unsigned char *pIn,unsigned char *pOut,int iSize,int iBuffSize)
{
char            cName[MAX_PATHNAME_SIZE];
char           *pName;
int             iAccess;
int             iAction;
int             iError;
int             iMode;
int             iOpen;
int             iAttr;
unsigned        uAttr;
unsigned short  wFid;
int             bError,bExist;
SysFile         hFile;
SysFindStruct   sInfo;




    pName=(char*)smb_buf(pIn);

    if(SmbPathName(pSession,cName,pName)<0)
        {
        PRINT_SMB_ERR(("SMB_ERROR wrong file: \"%s\"",pName))
        return SMB_ERROR(ERRDOS,ERRbadpath);
        }



    PRINT_SMB_MSG1((" file=\"%s\" ",cName))
    iMode  = SVAL(pIn,smb_vwv3);
    iAttr  = SVAL(pIn,smb_vwv5);
    iOpen  = SVAL(pIn,smb_vwv8);
    bError = FALSE;

    if(pSession->pTree->iConnectType!=0)        // wrong connection
        {
        return SMB_ERROR(ERRSRV,ERRaccess);
        }

    switch(iMode&0x07)
        {
    case 0: uAttr=SYS_READ;                    break;
    case 1: uAttr=SYS_WRITE;                   break;
    case 2: uAttr=SYS_WRITE|SYS_READ;          break;
    default:uAttr=SYS_READ;bError=TRUE;        break;
        }

    switch((iMode>>4)&0x07)
        {
    case 0:
    case 1:                                    break;
    case 2: uAttr|=SYS_SHARE_RD;               break;
    case 3: uAttr|=SYS_SHARE_WR;               break;
    case 4: uAttr|=SYS_SHARE_WR|SYS_SHARE_RD;  break;
    default:bError=TRUE;
        }

    if(iOpen&0x10)uAttr|=SYS_CREATE|SYS_ARCHIVE;

    bExist=SysGetAttributes(cName)>=0;
    PRINT_SMB_MSG1(("Exist=%i ",bExist));


    if(bExist)
    switch(iOpen&0x03)
        {
    case 0x00:  return SMB_ERROR(ERRDOS,ERRfilexists);  break;
    case 0x01:  uAttr &=~SYS_CREATE;                    break;
    case 0x02:  uAttr |= SYS_TRUNC;                     break;
    case 0x03:  bError=TRUE;                            break;
        }

    if(uAttr&SYS_CREATE)uAttr|=SYS_WRITE;

    if((uAttr&SYS_WRITE) && pSession->pTree->bReadOnly)
        {
        PRINT_SMB_ERR(("SMB_ERROR no writte access"))
        return SMB_ERROR(ERRDOS,ERRnoaccess);
        }


    if((uAttr&SYS_WRITE) && pSession->pTree->bReadOnly)
        {
        PRINT_SMB_ERR(("SMB_ERROR no writte access"))
        return SMB_ERROR(ERRDOS,ERRnoaccess);
        }

    switch(uAttr&(SYS_WRITE|SYS_READ))
        {
    case SYS_WRITE|SYS_READ:    iAccess=DOS_OPEN_RDWR;      break;
    case SYS_WRITE:             iAccess=DOS_OPEN_WRONLY;    break;
    case SYS_READ:              iAccess=DOS_OPEN_RDONLY;    break;
    default:bError=TRUE;
        }

    if(bError)return SMB_ERROR(ERRDOS,ERRnoaccess);

        hFile=SysOpenEx(cName,uAttr,&iError);
    if(!hFile)
        {
        PRINT_SMB_ERRS(("SMB_ERROR cant't open file '%s'",cName));

        switch(iError)
            {
        case SYS_ERR_NO_HANDLES:        return SMB_ERROR(ERRDOS,ERRnofids);
        case SYS_ERR_PATH_NOTFOUND:     return SMB_ERROR(ERRDOS,ERRbadpath);
        case SYS_ERR_INVALID_FILENAME:  return SMB_ERROR(ERRDOS,ERRbadpath);
        case SYS_ERR_FILE_NOT_FOUND:    return SMB_ERROR(ERRDOS,ERRbadfile);
        default:                        return SMB_ERROR(ERRDOS,ERRnoaccess);
            }
        }

    if(SysGetFileInfo(hFile,&sInfo)<0)
        {
        PRINT_SMB_ERRS(("SYSERROR cant't get file info"));
        SysClose(hFile);
        return SMB_ERROR(ERRDOS,ERRnoaccess);
        }

    bError = FALSE;

        wFid=SmbCreateFile(pSession,hFile,0);
    if(!wFid)
        {
        PRINT_SMB_ERRS(("SYSERROR no SmbFree file id"));
        SysClose(hFile);
        return SMB_ERROR(ERRDOS,ERRnofids);
        }


    pSession->wFid  = wFid;
    pSession->pFile = SmbGetFile(pSession,wFid);

    if(!bExist)
        {
        iAction=FILE_WAS_CREATED;
        PRINT_SMB_MSG1((" create "))
        }
    else{
        if(uAttr&SYS_TRUNC)
                iAction=FILE_WAS_OVERWRITTEN;
        else    iAction=FILE_WAS_OPENED;

        PRINT_SMB_MSG1(("%s",(uAttr&SYS_TRUNC)? " overwrite ":" opened "))
        }


    iAttr=AttrSysToDos(sInfo.dwAttr);
    SmbSetMessage(pOut,15,0,TRUE);
    SSVAL(pOut,smb_vwv2 ,wFid);
    SSVAL(pOut,smb_vwv3 ,iAttr);
    SIVAL(pOut,smb_vwv4 ,sInfo.dwTimeWrite);
    SIVAL(pOut,smb_vwv6 ,sInfo.dwSize);
    SSVAL(pOut,smb_vwv8 ,iMode);
    SSVAL(pOut,smb_vwv11,iAction);

    PRINT_SMB_MSG1((" FID=%i size=%u handle=%08Xh <ok>",wFid,sInfo.dwSize,(unsigned)hFile))


return ChainReply(pSession,pIn,pOut,iSize,iBuffSize);
}


//*****************************************************************************
//*
//*     ReplyReadAndX
//*
//*****************************************************************************
//  reply to a read , read from a file
int ReplyReadAndX(SmbSession *pSession,unsigned char *pIn,unsigned char *pOut,int iSize,int iBuffSize)
{
int             iStartPos;
int             iMinCount,iMaxCount;
int             iCount;
unsigned char  *pData;
SmbFileEntry   *pFile;







    iStartPos  = IVAL(pIn,smb_vwv3);
    iMaxCount  = SVAL(pIn,smb_vwv5);
    iMinCount  = SVAL(pIn,smb_vwv6);


    /* if(is_locked(pFile){return SMB_ERROR(ERRDOS,ERRlock);*/

    PRINT_SMB_MSG1((" FID=%i ",pSession->wFid))

    SmbSetMessage(pOut,12,0,TRUE);
    pData      = smb_buf(pOut);


    if(CVAL(pIn,smb_wct)==12)                   // is a large offset (64 bit)
        {
        if(IVAL(pIn,smb_vwv10))
            {
            PRINT_SMB_ERR(("SMB_ERROR wrong start offset"))
            return(SMB_ERROR(ERRDOS,ERRbadaccess));
            }
        }


    if(iMaxCount>0)
        {
            pFile=pSession->pFile;
        if( pFile->bType!=0)
            {
            PRINT_SMB_ERR(("SMB_ERROR wrong FID type"))
            return SMB_ERROR(ERRSRV,ERRinvnid);
            }

        if(SysSeek(pFile->hFile,iStartPos,SEEK_SET)<0)
            {
            PRINT_SMB_ERR(("SMB_ERROR can't seek file"))
            return SMB_ERROR(ERRDOS,ERRnoaccess);
            }

           iCount=SysRead(pFile->hFile,pData,iMaxCount);
        if(iCount<0)
            {
            PRINT_SMB_ERR(("SMB_ERROR read %i",iCount))
            return SMB_ERROR(ERRDOS,ERRnoaccess);
            }
        }
    else{
        iCount=0;
        }


    SSVAL(pOut,smb_vwv5,iCount);
    SSVAL(pOut,smb_vwv6,smb_offset(pData,pOut));
    SSVAL(smb_buf(pOut),-2,iCount);

    PRINT_SMB_MSG1((" read %i bytes  <ok>",iCount))



return ChainReply(pSession,pIn,pOut,iSize,iBuffSize);
}


//*****************************************************************************
//*
//*     ReplyWriteAndX
//*
//*****************************************************************************
//  reply to a write and X
int ReplyWriteAndX(SmbSession *pSession,unsigned char *pIn,unsigned char *pOut,int iSize,int iBuffSize)
{
int             iStartPos;
int             iDataOff;
int             iWrite;
int             iCount;
int             iLen;
char           *pData;
int             bLargeWr;
SmbFileEntry   *pFile;




    iStartPos   = IVAL(pIn,smb_vwv3);
    iWrite      = SVAL(pIn,smb_vwv10);
    iDataOff    = SVAL(pIn,smb_vwv11);
    iLen        = smb_len(pIn);
    bLargeWr    = ((CVAL(pIn,smb_wct)==14) && (iLen > 0xFFFF));

    PRINT_SMB_MSG1((" FID=%i",pSession->wFid))

    if(bLargeWr)
        {
        iWrite |= (SVAL(pIn,smb_vwv9)&1)<<16;
        }


    if(iDataOff>iLen || (iDataOff+iWrite>iLen))
        {
        PRINT_SMB_ERR(("SMB_ERROR bad memory size"))
        return SMB_ERROR(ERRDOS,ERRbadmem);
        }



    pData = smb_base(pIn)+iDataOff;

    if(CVAL(pIn,smb_wct) == 14)
        {
        if(IVAL(pIn,smb_vwv12) != 0)
            {
            PRINT_SMB_ERR(("SMB_ERROR wrong start offset"))
            return(SMB_ERROR(ERRDOS,ERRbadaccess));
            }
        }

    /* REM AZ
    if (is_locked(fsp,pSession,(SMB_BIG_UINT)iWrite,(SMB_BIG_UINT)iStartPos, WRITE_LOCK,FALSE))
        {
        return(SMB_ERROR(ERRDOS,ERRlock));
        }
    */

    if(iWrite>0)                                // write data
        {
            pFile=pSession->pFile;
        if( pFile->bType!=0)
            {
            PRINT_SMB_ERR(("SMB_ERROR wrong FID type"))
            return SMB_ERROR(ERRSRV,ERRinvnid);
            }

        if(SysSeek(pFile->hFile,iStartPos,SEEK_SET)<0)
            {
            PRINT_SMB_ERR(("SMB_ERROR can't seek file"))
            return SMB_ERROR(ERRDOS,ERRnoaccess);
            }

           iCount=SysWrite(pFile->hFile,pData,iWrite);
        if(iCount<=0)
            {
            PRINT_SMB_ERR(("SMB_ERROR write"))
            if(iCount==SYS_ERR_DISKFULL)
                    return SMB_ERROR(ERRHRD,ERRdiskfull);
            else    return SMB_ERROR(ERRDOS,ERRnoaccess);
            }
        }
    else{
        iCount=0;
        }


    SmbSetMessage(pOut,6,0,TRUE);

    SSVAL(pOut,smb_vwv2,iCount);
    if(bLargeWr)SSVAL(pOut,smb_vwv4,(iCount>>16)&1);

    if(iCount<iWrite)
        {
        PRINT_SMB_ERR(("SMB_ERROR disk full"))
        SCVAL(pOut,smb_rcls,ERRHRD);
        SSVAL(pOut,smb_err,ERRdiskfull);
        }

    PRINT_SMB_MSG1((" write %i bytes  <ok>",iCount))


return ChainReply(pSession,pIn,pOut,iSize,iBuffSize);
}


//*****************************************************************************
//*
//*     ReplyUlogoffX
//*
//*****************************************************************************
//  reply to a SMBulogoffX
int ReplyULogoffX(SmbSession *pSession,unsigned char *pIn,unsigned char *pOut,int iSize,int iBuffSize)
{
unsigned short          wUid;



    wUid = SVAL(pIn,smb_uid);
    SmbClearUser(pSession,wUid);

    pSession->wUid=0;
    pSession->pUser=0;

    SSVAL(pIn ,smb_uid,0);
    SSVAL(pOut,smb_uid,0);

    SmbSetMessage(pOut,2,0,TRUE);
    PRINT_SMB_MSG1((" UID=%i bytes  <ok>",wUid))


return ChainReply(pSession,pIn,pOut,iSize,iBuffSize);
}

//*****************************************************************************
//*
//*     ReplyDiskAttr
//*
//*****************************************************************************
//  reply to a get disk attribut
int ReplyDiskAttr(SmbSession *pSession,unsigned char *pIn,unsigned char *pOut,int iSize,int iBuffSize)
{
int             iOutsize;
SysVolumeInfo   sInfo;
SmbTreeEntry   *pTree;


       pTree=pSession->pTree;
    if(pTree->iConnectType!=0)
        {
        PRINT_SMB_ERR(("SMB_ERROR bad tree type"))
        return SMB_ERROR(ERRDOS,ERRbadpath);
        }

    if(SysGetVolumeInfo(pTree->cAddPath,&sInfo,1)<0)
        {
        PRINT_SMB_ERR(("SMB_ERROR can't get volume info"))
        return SMB_ERROR(ERRDOS,ERRbadpath);
        }


    iOutsize = SmbSetMessage(pOut,5,0,TRUE);

    SSVAL(pOut,smb_vwv0,sInfo.dwTotalUnits);
    SSVAL(pOut,smb_vwv1,sInfo.dwSectorsPerUnit);
    SSVAL(pOut,smb_vwv2,sInfo.dwBytesPerSector);
    SSVAL(pOut,smb_vwv3,sInfo.dwFreeUnits);
    PRINT_SMB_MSG1((" <ok>"))

return iOutsize;
}




//*****************************************************************************
//*
//*     ReplyWriteBRaw
//*
//*****************************************************************************
//  reply to a writebraw
int ReplyWriteBRaw(SmbSession *pSession,unsigned char *pIn,unsigned char *pOut,int iSize,int iBuffSize)
{
int             iOutsize = 0;
int             iWritten=0;
int             iWrittenTotal=0;
int             iNum;
int             iCount;
int             iStartPos;
int             bWriteThrough;
unsigned char  *pData;
SmbFileEntry   *pFile;



    iCount        = IVAL(pIn,smb_vwv1);
    iStartPos     = IVAL(pIn,smb_vwv3);
    bWriteThrough = CVAL(pIn,smb_vwv7)&1;

    PRINT_SMB_MSG1((" FID=%i",pSession->wFid))

       pFile=pSession->pFile;
    if(pFile->bType!=0)
        {
        PRINT_SMB_ERR(("SMB_ERROR wrong FID type"))
        return SMB_ERROR(ERRDOS,ERRbadfid);
        }


    if(pSession->iProtocol<=PROTOCOL_COREPLUS)
        {
        iNum  = SVAL(smb_buf(pIn),-2);
        pData = smb_buf(pIn);
        }
    else{
        iNum  = SVAL(pIn,smb_vwv10);
        pData = (unsigned char*)smb_base(pIn) + SVAL(pIn, smb_vwv11);
        }


    CVAL(pIn ,smb_com) = SMBwritec;
    CVAL(pOut,smb_com) = SMBwritec;

    /* REM AZ isn't supported
    if(is_locked(fsp,pSession,(SMB_BIG_UINT)iCount,(SMB_BIG_UINT)iStartPos, WRITE_LOCK,FALSE))
        {
        return(SMB_ERROR(ERRDOS,ERRlock));
        }
    */

    if(iNum>0)
        {
        if(SysSeek(pFile->hFile,iStartPos,SEEK_SET)<0)
            {
            PRINT_SMB_ERR(("SMB_ERROR can't seek file"))
            return SMB_ERROR(ERRDOS,ERRnoaccess);
            }
           iWritten=SysWrite(pFile->hFile,pData,iNum);
        if(iWritten<iNum)
            {
            PRINT_SMB_ERR(("SMB_ERROR can't write to file"))
            if(iWritten==SYS_ERR_ACCESS_DENIED)
                    return SMB_ERROR(ERRDOS,ERRnoaccess);
            else    return SMB_ERROR(ERRHRD,ERRdiskfull);
            }
        }

    iWrittenTotal = iWritten;

    // Return a message to the redirector to tell it to send more bytes
    SCVAL(pOut,smb_com,SMBwritebraw);
    SSVAL(pOut,smb_vwv0,-1);
    iOutsize = SmbSetMessage(pOut,(pSession->iProtocol>PROTOCOL_COREPLUS)? 1:0,0,TRUE);

    if(!TcpPut(pSession->hTcp,pOut,iOutsize))
        {
        PRINT_SMB_ERR(("SMB_ERROR can't write to tcp"))
        SmbSessionExit(pSession);
		return -1;
        }

    // Now read the raw pData into the buffer and write it
    if(SmbReadNextPacket(pSession->hTcp,pIn,iSize,SMB_SECONDARY_WAIT)<=0)
        {
        PRINT_SMB_ERR(("SMB_ERROR can't write to tcp"))
        SmbSessionExit(pSession);
		return -1;
        }

    pSession->iPacketCount++;
    iNum = smb_len(pIn);
    iOutsize = SmbSetMessage(pOut,1,0,TRUE);
    SCVAL(pOut,smb_com,SMBwritec);
    SSVAL(pOut,smb_vwv0,iWrittenTotal);

    if(iNum)
        {
        if(iNum>pSession->iMaxResvSize+1)
            {
            PRINT_SMB_ERR(("SMB_ERROR too big buffer"))
            SmbSessionExit(pSession);
			return -1;
            }

        if(SysSeek(pFile->hFile,iStartPos+iWritten,SEEK_SET)<0)
            {
            PRINT_SMB_ERR(("SMB_ERROR can't seek file"))
            SCVAL(pOut,smb_rcls,ERRDOS);
            SSVAL(pOut,smb_err ,ERRnoaccess);
            }
        else{
               iWritten=SysWrite(pFile->hFile,pIn+4,iNum);
            if(iWritten<iNum)
                {
                PRINT_SMB_ERR(("SMB_ERROR can't write to file"))
                if(iWritten==SYS_ERR_ACCESS_DENIED)
                    {
                    SCVAL(pOut,smb_rcls,ERRDOS);
                    SSVAL(pOut,smb_err ,ERRnoaccess);
                    }
                else{
                    SCVAL(pOut,smb_rcls,ERRHRD);
                    SSVAL(pOut,smb_err ,ERRdiskfull);
                    }
                }

            if(iWritten>0)iWrittenTotal += iWritten;
            }
        }

    if(!bWriteThrough && iWrittenTotal==iCount)
        {
        if(!TcpPut(pSession->hTcp,"\x85\x00\x00\x00",4))
            {
            PRINT_SMB_ERR(("SMB_ERROR can't write keepalive packet to tcp"))
            SmbSessionExit(pSession);
			return -1;
            }

        PRINT_SMB_MSG1((" <ok>"))
        return 0;
        }

    PRINT_SMB_MSG1((" <ok>"))



return iOutsize;
}

//*****************************************************************************
//*
//*     SmbNamedPipe
//*
//*****************************************************************************
//  handle named pipe commands
int SmbNamedPipe(   SmbSession *pSession,unsigned short wUid,unsigned char *pOut,
                    char *pPipeName,unsigned short *pSetup,char *pData,char *pParam,
                    int iSetupWordCount,int iTotalDataCount,int iTotalParamCount,
                    int iMaxSetupReturn,int iMaxDataReturn ,int iMaxParamReturn)
{



    if(!strcmp(pPipeName,"LANMAN"))
        {
        return LanReply(pSession,wUid,pOut,pData,pParam,iTotalDataCount,iTotalParamCount,iMaxDataReturn,iMaxParamReturn);
        }

    #if HAS_IPC

    // REM AZ experemntial code

    if (!strcmp(pPipeName,"WKSSVC") ||
        !strcmp(pPipeName,"SRVSVC") ||
        !strcmp(pPipeName,"WINREG") ||
        !strcmp(pPipeName,"SAMR"  ) ||
        !strcmp(pPipeName,"LSARPC") ||
        !*pPipeName)
        {
        return IpcReply(pSession,wUid,pOut,pSetup,pData,pParam,iSetupWordCount,iTotalDataCount,iTotalParamCount,iMaxDataReturn,iMaxParamReturn);
        }

    #endif

return -1;
}


//*****************************************************************************
//*
//*     ReplyNtCreateAndX
//*
//*****************************************************************************
//  reply to an open and X
// experemntial code
//  add in ReplyNegprot |CAP_NT_SMBS

/*

#define     FILE_READ_DATA          0x00000001
#define     FILE_WRITE_DATA         0x00000002
#define     FILE_APPEND_DATA        0x00000004
#define     GENERIC_ALL_ACCESS      0x10000000
#define     GENERIC_EXECUTE_ACCESS  0x20000000
#define     GENERIC_WRITE_ACCESS    0x40000000
#define     GENERIC_READ_ACCESS     0x80000000
#define     MAXIMUM_ALLOWED_ACCESS  0x02000000


int ReplyNtCreateAndX(SmbSession *pSession,unsigned char *pIn,unsigned char *pOut,int iSize,int iBuffSize)
{
char            cTemp[MAX_PATHNAME_SIZE];
char            cName[MAX_PATHNAME_SIZE];
char           *pName;
int             iAttr;
int             iRet;
int             iExist;
int 			iError;
int             iAction;
unsigned        uCreateOp;
unsigned        uDispose;
unsigned        uAccess;
unsigned        uAttrib;
unsigned        uShare;
unsigned        uFlags;
unsigned        uAttr;
unsigned short  wRoot;
unsigned short  wFid;
SysFile         hFile;
SysFindStruct   sInfo;



    #if !HAS_IPC
    // REM AZ experemntial code
    if(pSession->pTree->iConnectType==1)        // is it a IPC connection
        {
        PRINT_SMB_ERR(("SMB_ERROR no ipc connections supported"))
        return SMB_ERROR(ERRSRV,ERRnoipc);
        }
    #endif


    if(pSession->pTree->iConnectType!=0)
        {
        PRINT_SMB_ERR(("SMB_ERROR no access to this trre type %i",pSession->pTree->iConnectType))
        return SMB_ERROR(ERRSRV,ERRaccess);
        }

    if(CVAL(pIn,smb_wct)<24)                    // is the word count ok
        {
        PRINT_SMB_ERR(("SMB_ERROR wrong word cont in NtCreateAndX"))
        return SMB_ERROR(ERRDOS,ERRinvalidparam);
        }


    wRoot = SVAL(pIn,smb_vwv0+11);
    pName = (char*)smb_buf(pIn);

    if(wRoot)
        {
        //  REM XXX
        //  int CombinePath(...)
        //      {
        //          pPath = SmbGetPath(pSession,wRoot);
        //      if(!pPath)return 0;
        //
        //      strcpy(cTemp,pPath);
        //      strcat(cTemp,"/"  );
        //      strcat(cTemp,pName);
        //
        //      CheckPath(cTemp);
        //
        //      return 1;
        //      }
        //
        //if(!CombinePath(wRoot,pName,cTemp))
            {
            PRINT_SMB_ERR(("SMB_ERROR can't combine paths"))
            return SMB_ERROR(ERRDOS,ERRbadpath);
            }

        pName = cTemp;
        }


    if(SmbPathName(pSession,cName,pName)<0)
        {
        PRINT_SMB_ERR(("SMB_ERROR wrong file: \"%s\"",pName))
        return SMB_ERROR(ERRDOS,ERRbadpath);
        }



    uFlags      =  IVAL(pIn,smb_vwv0+7 );
    uAccess     =  IVAL(pIn,smb_vwv0+15);
    uAttrib     =  IVAL(pIn,smb_vwv0+27);
    uShare      =  IVAL(pIn,smb_vwv0+31);
    uDispose    =  IVAL(pIn,smb_vwv0+35);
    uCreateOp   =  IVAL(pIn,smb_vwv0+39);




    if(uCreateOp&NT_OPEN_BY_FILE_ID)
        {
        PRINT_SMB_ERR(("SMB_ERROR the option NT_OPEN_BY_FILE_ID is not supported"))
        return SMB_ERROR(ERRDOS,ERRunsup);
        }

    if(uAttrib&NT_ATTRIBUTE_TEMPORARY)
        {
        PRINT_SMB_ERR(("SMB_ERROR the attribut NT_ATTRIBUTE_TEMPORARY is not supported"))
        return SMB_ERROR(ERRDOS,ERRunsup);
        }



       iExist = SysGetAttributes(cName);
    if(iExist<0)iExist=0;


    switch(uDispose)
        {
    case 0:                                     // FILE_SUPERSEDE
            uAttr = (iExist)? SYS_TRUNC|SYS_WRITE:SYS_CREATE|SYS_ARCHIVE|SYS_WRITE;
            break;

    case 1:                                     // FILE_OPEN
            if(!iExist)return SMB_ERROR(ERRDOS,ERRbadpath);
            uAttr = 0;
            break;

    case 2:                                     // FILE_CREATE
            if(iExist)return SMB_ERROR(ERRDOS,ERRfilexists);
            uAttr = SYS_CREATE|SYS_ARCHIVE|SYS_WRITE;
            break;

    case 4:                                     // FILE_OPEN_IF
            uAttr = (iExist)? 0:SYS_CREATE|SYS_ARCHIVE|SYS_WRITE;
            break;

    case 5:                                     // FILE_OVERWRITE
            if(!iExist)return SMB_ERROR(ERRDOS,ERRbadpath);
            uAttr = SYS_TRUNC|SYS_WRITE;
            break;

    case 6:                                     // FILE_OVERWRITE_IF
            uAttr = (iExist)? SYS_TRUNC|SYS_WRITE:SYS_CREATE|SYS_ARCHIVE|SYS_WRITE;
            break;

    default:
            return SMB_ERROR(ERRDOS,ERRinvalidparam);
        }


                                                // user wants to read the file
    if(uAccess&(FILE_READ_DATA|GENERIC_READ_ACCESS|GENERIC_ALL_ACCESS|MAXIMUM_ALLOWED_ACCESS))
        {
        if(iExist && !(iExist&SYS_READ))
            {
            PRINT_SMB_ERR(("SMB_ERROR no read access"))
            return SMB_ERROR(ERRDOS,ERRnoaccess);
            }

        uAttr |= SYS_READ;
        }


                                                // user wants to write to the file
    if(uAccess&(FILE_WRITE_DATA|GENERIC_WRITE_ACCESS|GENERIC_ALL_ACCESS|MAXIMUM_ALLOWED_ACCESS|FILE_APPEND_DATA))
        {
        if(iExist && !(iExist&SYS_WRITE))
            {
            PRINT_SMB_ERR(("SMB_ERROR no writte access"))
            return SMB_ERROR(ERRDOS,ERRnoaccess);
            }

        uAttr |= SYS_WRITE;
        }

    if(uAttrib&NT_ATTRIBUTE_READONLY )uAttr&=~SYS_WRITE;
    if(uAttrib&NT_ATTRIBUTE_HIDDEN   )uAttr|= SYS_HIDDEN;
    if(uAttrib&NT_ATTRIBUTE_SYSTEM   )uAttr|= SYS_SYSTEM;
    if(uAttrib&NT_ATTRIBUTE_DIRECTORY)
        {
        if(iExist && !(iExist&SYS_DIR))
            {
            PRINT_SMB_ERR(("SMB_ERROR bad path"))
            return SMB_ERROR(ERRDOS,ERRbadpath);
            }

        uAttr |= SYS_DIR;
        }


    PRINT_SMB_MSG1((" file=\"%s\" ",cName))



    switch(uShare)
        {
    case 0:                                    break;   // FILE_SHARE_NONE
    case 1: uAttr|=SYS_SHARE_RD;               break;   // FILE_SHARE_READ
    case 2: uAttr|=SYS_SHARE_WR;               break;   // FILE_SHARE_WRITE
    case 4: uAttr|=SYS_SHARE_WR|SYS_SHARE_RD;  break;   // FILE_SHARE_DELETE
        }


    PRINT_SMB_MSG1(("exist= 0x%x ",iExist));

    if((uAttr&SYS_WRITE) && pSession->pTree->bReadOnly)
        {
        PRINT_SMB_ERR(("SMB_ERROR no writte access"))
        return SMB_ERROR(ERRDOS, ERRnoaccess);
        }

    if(!(uAttr&(SYS_WRITE|SYS_READ)))
        {
        return SMB_ERROR(ERRDOS,ERRnoaccess);
        }


    if((iExist&SYS_DIR) && (uCreateOp&NT_NON_DIRECTORY_FILE))
        {
        return SMB_ERROR(ERRDOS,ERRinvalidparam);
        }



    if(uCreateOp&NT_DIRECTORY_FILE)             // handle directory
        {
        if(uCreateOp&NT_NON_DIRECTORY_FILE)
            {
            return SMB_ERROR(ERRDOS,ERRinvalidparam);
            }

        uAttr &= ~(SYS_TRUNC|SYS_CREATE);
        uAttr |=   SYS_DIR;



        if(!iExist && (uAttr&SYS_CREATE))       // exists the directory
            {
            iRet = SysMkdir(cName);
            }
        else if(!iExist || !(iExist&SYS_DIR))
            {
            iRet = SYS_ERR_PATH_NOTFOUND;
            }
        else{
            iRet = 0;
            }

        if(iRet<0)
            {
            switch(iRet)
                {
            case SYS_ERR_PATH_NOTFOUND:     return SMB_ERROR(ERRDOS,ERRbadpath);
            case SYS_ERR_INVALID_FILENAME:  return SMB_ERROR(ERRDOS,ERRbadpath);
            case SYS_ERR_FILE_NOT_FOUND:    return SMB_ERROR(ERRDOS,ERRbadfile);
            case SYS_ERR_NO_HANDLES:        return SMB_ERROR(ERRDOS,ERRnofids);
            default:                        return SMB_ERROR(ERRDOS,ERRnoaccess);
                }
            }

        // REM XXX
        // here we muss allocate an path entry in the session
        //
        hFile = 8888;   // hFile = SmbCratePath(pSession,cName);
                        // if(hFile<0)SMB_ERROR(ERRDOS,ERRnofids);

        // SmbCreateFile and SmbClearFile must be enhance with the typ 3 for paths

            wFid = SmbCreateFile(pSession,hFile,3); // REM type 3 is not supported
        if(!wFid)
            {
            PRINT_SMB_ERRS(("SYSERROR no SmbFree file id"));
            SysClose(hFile);
            return SMB_ERROR(ERRDOS,ERRnofids);
            }


        pSession->wFid  = wFid;
        pSession->pFile = SmbGetFile(pSession,wFid);


           hFile = SysFindFirst(cName,&sInfo);
        if(hFile)
            {
            SysFindClose(hFile);
            }
        else{
            return SMB_ERROR(ERRDOS,ERRbadpath);
            }
        }
    else{                                       // handle files
        	hFile = SysOpenEx(cName,uAttr,&iError);
        if(!hFile)
            {
            PRINT_SMB_ERRS(("SMB_ERROR cant't open file '%s'",cName));

            switch(iError)
                {
            case SYS_ERR_PATH_NOTFOUND:     return SMB_ERROR(ERRDOS,ERRbadpath);
            case SYS_ERR_INVALID_FILENAME:  return SMB_ERROR(ERRDOS,ERRbadpath);
            case SYS_ERR_FILE_NOT_FOUND:    return SMB_ERROR(ERRDOS,ERRbadfile);
            case SYS_ERR_NO_HANDLES:        return SMB_ERROR(ERRDOS,ERRnofids);
            default:                        return SMB_ERROR(ERRDOS,ERRnoaccess);
                }
            }

        if(SysGetFileInfo(hFile,&sInfo)<0)      // get file info
            {
            PRINT_SMB_ERRS(("SYSERROR cant't get file info"));
            SysClose(hFile);
            return SMB_ERROR(ERRDOS,ERRnoaccess);
            }


            wFid = SmbCreateFile(pSession,hFile,0);
        if(!wFid)
            {
            PRINT_SMB_ERRS(("SYSERROR no SmbFree file id"));
            SysClose(hFile);
            return SMB_ERROR(ERRDOS,ERRnofids);
            }

        pSession->wFid  = wFid;
        pSession->pFile = SmbGetFile(pSession,wFid);
        }





    if(!iExist)
        {
        iAction = FILE_WAS_CREATED;
        PRINT_SMB_MSG1((" create "))
        }
    else{
        if(uAttr&SYS_TRUNC)
                iAction=FILE_WAS_OVERWRITTEN;
        else    iAction=FILE_WAS_OPENED;

        PRINT_SMB_MSG1(("%s",(uAttr&SYS_TRUNC)? " overwrite ":" opened "))
        }


    iAttr = (sInfo.dwAttr&SYS_WRITE)?  0:NT_ATTRIBUTE_READONLY;
    if(sInfo.dwAttr&SYS_HIDDEN )iAttr |= NT_ATTRIBUTE_HIDDEN;
    if(sInfo.dwAttr&SYS_SYSTEM )iAttr |= NT_ATTRIBUTE_SYSTEM;
    if(sInfo.dwAttr&SYS_ARCHIVE)iAttr |= NT_ATTRIBUTE_ARCHIVE;

    SmbSetMessage(pOut,34,0,TRUE);

    SCVAL(pOut,smb_wct,26);                                 // special case
    SCVAL(pOut,smb_vwv2,0);                                 // OplockLevel
    SSVAL(pOut,smb_vwv2+1,wFid );
    SSVAL(pOut,smb_vwv2+3,iAction);
    SysTimeConvertSF(sInfo.dwTimeCreate,pOut+smb_vwv2+ 5);
    SysTimeConvertSF(sInfo.dwTimeAccess,pOut+smb_vwv2+13);
    SysTimeConvertSF(sInfo.dwTimeWrite ,pOut+smb_vwv2+21);
    SysTimeConvertSF(sInfo.dwTimeWrite ,pOut+smb_vwv2+29);
    SIVAL(pOut,smb_vwv2+37,iAttr);
    SIVAL(pOut,smb_vwv2+41,sInfo.dwSize);
    SIVAL(pOut,smb_vwv2+45,0);
    SIVAL(pOut,smb_vwv2+49,sInfo.dwSize);
    SIVAL(pOut,smb_vwv2+53,0);
    SSVAL(pOut,smb_vwv2+57,0);                              // FileType
    SSVAL(pOut,smb_vwv2+59,0);                              // DeviceState
    SCVAL(pOut,smb_vwv2+59,0);                              // Directory

    PRINT_SMB_MSG1((" FID=%i size=%lu handle=%08Xh <ok>",wFid,sInfo.dwSize,(unsigned)hFile))




//  UCHAR WordCount;    Count of parameter words = 26
//  UCHAR AndXCommand;  Secondary command;  0xFF = None
//  UCHAR AndXReserved; MBZ
//  USHORT AndXOffset;  Offset to next command wordcount
//  UCHAR OplockLevel;  The oplock level granted
//  USHORT Fid; The file ID
//  ULONG CreateAction; The action taken
//  TIME CreationTime;  The time the file was created
//  TIME LastAccessTime;    The time the file was accessed
//  TIME LastWriteTime; The time the file was last written
//  TIME ChangeTime;    The time the file was last changed
//  ULONG FileAttributes;   The file attributes
//  LARGE_INTEGER AllocationSize;   The number of byes allocated
//  LARGE_INTEGER EndOfFile;    The end of file offset
//  USHORT FileType;
//  USHORT DeviceState; state of IPC device (e.g. pipe)
//  BOOLEAN Directory;  TRUE if this is a directory
//  USHORT ByteCount;   = 0



return ChainReply(pSession,pIn,pOut,iSize,iBuffSize);
}
//*/


