#ifndef INTERVAL_H
#define INTERVAL_H

/*
  TimerJinni - A general timing application
  Copyright (C) 2010  Tim Teulings

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <Lum/Audio/PlaySound.h>

#include <Lum/Object.h>

#include <Lum/Model/Action.h>
#include <Lum/Model/Boolean.h>
#include <Lum/Model/Number.h>
#include <Lum/Model/Table.h>

#include <Lum/Table.h>

#include "StopWatch.h"

class Interval : public Lum::Component
{
private:
  enum State {
    stateUninitialized,
    statePaused,
    stateStoped,
    stateRunning
  };

private:
  Lum::Model::ActionRef      startAction;
  Lum::Model::BooleanRef     paused;
  Lum::Model::ActionRef      pulseAction;
  Lum::Model::ActionRef      stopAction;
  Lum::Model::ActionRef      timer;
  Lum::Model::StringTableRef laps;

  Lum::Table*                lapTable;

  Lum::Base::Timer           time;
  State                      state;
  StopWatch                  *clock;

private:
  void SetValue();
  void AllowScreenBlanking(bool allow);
  void SetState(State state);

public:
  Interval();
  ~Interval();

  void CalcSize();

  void Resync(Lum::Base::Model* model, const Lum::Base::ResyncMsg& msg);
};

#endif
