/*
  TimerJinni - A general timing application
  Copyright (C) 2009  Tim Teulings

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "Configuration.h"

#include <algorithm>
#include <iostream>
#include <sstream>

#include <Lum/Base/Path.h>
#include <Lum/Base/String.h>

#include <Lum/Config/Config.h>

bool configurationChanged=false;

std::string TimeSpanToString(size_t seconds, long microseconds)
{
  std::stringstream buffer;

  buffer.imbue(std::locale(""));
  buffer.setf(std::ios::fixed);

  buffer << seconds/60;
  buffer << ":";
  buffer << (seconds%60)/10;
  buffer << seconds%10;
  buffer << ".";
  buffer << microseconds/(100000);

  return buffer.str();
}

std::wstring TimeSpanToWString(size_t seconds, long microseconds)
{
  return Lum::Base::StringToWString(TimeSpanToString(seconds,microseconds));
}

bool LoadConfig()
{
  Lum::Config::Node      *top;
  Lum::Config::ErrorList errors;
  Lum::Base::Path        path(Lum::Base::Path::GetApplicationConfigPath());

  top=Lum::Config::LoadConfigFromXMLFile(path.GetPath(),errors);

  if (top==NULL) {
    configurationChanged=true;
    return false;
  }

  if (top->GetName()!=L"TimerJinni") {
    std::cerr << "'" << Lum::Base::WStringToString(path.GetPath()) << "' is a valid config file!" << std::endl;
    delete top;
    configurationChanged=true;
    return false;
  }

  // TODO: Read configuration

  delete top;

  return true;
}

bool SaveConfig()
{
  Lum::Config::Node *top;
  Lum::Base::Path   path(Lum::Base::Path::GetApplicationConfigPath());
  std::wstring      config;
  bool              res;

  top=new Lum::Config::Node();
  top->SetName(L"TimerJinni");

  // TODO: Add configuration storing code

  Lum::Base::Status status;

  status=path.CreateDirRecursive();

  if (!status) {
    std::cerr << "Cannot create config directory '" << Lum::Base::WStringToString(path.GetDir()) << "': " << Lum::Base::WStringToString(status.GetDescription()) << std::endl;
    return false;
  }

  res=Lum::Config::SaveConfigToXMLFile(path.GetPath(),top);

  delete top;

  return res;
}

