/*
 * This file is part of TimedSilencer.
 *
 *  TimedSilencer is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  TimedSilencer is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with TimedSilencer.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <QMaemo5ValueButton>
#include <QMaemo5TimePickSelector>
#include <QMaemo5InformationBox>
#include <QVBoxLayout>
#include <QLabel>
#include <QSpacerItem>
#include <QSettings>
#include <QCheckBox>
#include <QPushButton>
#include <QHBoxLayout>
#include <QCloseEvent>
#include <QIcon>
#include "mainwindow.h"
#include "switchingeventlist.h"
#include "newalarmdlg.h"

MainWindow::MainWindow(QWidget *parent) : QMainWindow(parent) {
  setCentralWidget(new QWidget());
  QVBoxLayout *vLayout = new QVBoxLayout(centralWidget());
  addEventBtn = new QPushButton(QIcon::fromTheme("general_add"), tr("New profile switching event"));
  connect(addEventBtn, SIGNAL(clicked()), this, SLOT(addEvent()));
  vLayout->addWidget(addEventBtn);
  eventList = new SwitchingEventList;
  vLayout->addWidget(eventList);
  // Auto rotation
  setAttribute(Qt::WA_Maemo5AutoOrientation, true);
}

MainWindow::~MainWindow() {
  delete addEventBtn;
  delete eventList;
}

void MainWindow::loadSettings() {

}

void MainWindow::saveSettings() {

}

void MainWindow::addEvent() {
  NewAlarmDlg dlg(this);
  connect(&dlg, SIGNAL(newEvent(QVariant)), eventList, SLOT(addNewEvent(QVariant)));
  dlg.exec();
}

