/*
 * This file is part of TimedSilencer.
 *
 *  TimedSilencer is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  TimedSilencer is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with TimedSilencer.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <QtGui/QApplication>
#include <QTranslator>
#include <QLocale>
#include <iostream>
#include "mainwindow.h"
#include "alarmd_backend.h"

int main(int argc, char *argv[])
{
  QApplication a(argc, argv);

  // Load translation
  QTranslator translator;
  QString locale = QLocale::system().name();
  qDebug("Detected locale is: %s", qPrintable(locale));
  translator.load(":/lang/timedsilencer_"+locale);
  a.installTranslator(&translator);

  if(argc == 2) {
    QString param = QString::fromLocal8Bit(argv[1]);
    if(param == "--disable") {
      std::cout << "Disabling the timed silencer events..." << std::endl;
      AlarmdBackend::deleteAllEvents();
      return 0;
    }
  }

  // Show Main window
  MainWindow w;
#if defined(Q_WS_S60)
  w.showMaximized();
#else
  w.show();
#endif

  return a.exec();
}
