/*
 * This file is part of TimedSilencer.
 *
 *  TimedSilencer is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  TimedSilencer is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with TimedSilencer.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef SWITCHINGEVENTLIST_H
#define SWITCHINGEVENTLIST_H

#include <QTableView>
struct QStandardItemModel;
struct ProfileEvent;

enum EventCols {EV_STATUS, EV_FROM, EV_TO, EV_REPEAT, EV_ID};

class SwitchingEventList : public QTableView
{
    Q_OBJECT
public:
    explicit SwitchingEventList(QWidget *parent = 0);
    ~SwitchingEventList();
    int getRowFromID(QByteArray id);

signals:

public slots:
    void addNewEvent(QVariant event);
    void editEvent(QByteArray id, bool new_status);
    void deleteEvent(QByteArray id);

protected slots:
    void loadSavedEvents();
    void updateRow(int row, ProfileEvent *pe);
    void editEvent(QModelIndex index);

private:
    QStandardItemModel *model;
};

#endif // SWITCHINGEVENTLIST_H
