/*
 * This file is part of TimedSilencer.
 *
 *  TimedSilencer is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  TimedSilencer is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with TimedSilencer.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef NEWALARMDLG_H
#define NEWALARMDLG_H

#include <QDialog>
#include <QVariant>

struct QMaemo5ValueButton;
struct QAction;
struct QCheckBox;
struct QPushButton;
struct ProfileEvent;
struct QDialogButtonBox;

class NewAlarmDlg : public QDialog
{
  Q_OBJECT
public:
  explicit NewAlarmDlg(QWidget *parent = 0, QByteArray edited_id = QByteArray());
  ~NewAlarmDlg();

signals:
  void newEvent(QVariant event);
  void editedEvent(QByteArray id, bool new_status);
  void deletedEvent(QByteArray id);

public slots:
  ProfileEvent* saveEvent();
  void saveAndClose();
  void deleteAndClose();

private:
  QMaemo5ValueButton *from_button, *to_button, *repeat_button;
  QCheckBox *cb_enable;
  QPushButton *delete_btn;
  QPushButton *done_btn;
  QDialogButtonBox *button_box;
  ProfileEvent *pe;
};

#endif // NEWALARMDLG_H
