/*
 * This file is part of TimedSilencer.
 *
 *  TimedSilencer is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  TimedSilencer is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with TimedSilencer.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef DBUS_TALKER_H
#define DBUS_TALKER_H

#include <QDBusInterface>
#include <QDBusMessage>

#include "phone_profile.h"

class DBusBackend {

public:
  // DBus Command taken from http://wiki.maemo.org/Phone_control#Profiles
  // dbus-send --type=method_call --dest=com.nokia.profiled /com/nokia/profiled com.nokia.profiled.set_profile string:"general"
  // dbus-send --type=method_call --dest=com.nokia.profiled /com/nokia/profiled com.nokia.profiled.set_profile string:"silent"
  static bool setProfile(Profile p) {
    QDBusMessage msg = QDBusMessage::createMethodCall("com.nokia.profiled",
                                                      "/com/nokia/profiled",
                                                      "com.nokia.profiled",
                                                      "set_profile");
    if(p == SILENT)
      msg << "silent";
    else
      msg << "general";

    QDBusMessage ret = QDBusConnection::sessionBus().call(msg);
    return ret.type() != QDBusMessage::ErrorMessage;
  }
};

#endif // DBUS_TALKER_H
