#include "thriftydrinker.h"
#include "ui_thriftydrinker.h"
#include "stdio.h"
#define MILLERFACTOR 15.615

thriftydrinker::thriftydrinker(QWidget *parent)
    : QMainWindow(parent), ui(new Ui::thriftydrinker)
{

    ui->setupUi(this);
    connect(ui->doubleSpinBox,SIGNAL(valueChanged(double)),this,SLOT(calculate()));
    connect(ui->doubleSpinBox_2, SIGNAL(valueChanged(double)),this,SLOT(calculate()));
    connect(ui->comboBox,SIGNAL(currentIndexChanged(int)),this,SLOT(calculate()));
}


thriftydrinker::~thriftydrinker()
{
    delete ui;
}

void thriftydrinker::calculate()
{
    char test[80];
    float volumes[]= {354.882355 ,750 , 44.3602943, 58673.8827};//can,bottle,shot,keg
    //double result=0;
    float proof= ui->doubleSpinBox_2->value(); //0-200
    float volume = volumes[ui->comboBox->currentIndex()]; //mL
    float cost = ui->doubleSpinBox->value();
    if(cost)
	snprintf(test,80,"That is equivalent to paying $%.02lf for a can of Miller Lite!", cost/(proof/2*volume*.01)*MILLERFACTOR);
    ui->label_4->setText(test);
}
