import errno
import subprocess
import time
import pythonwifi.flags
from pythonwifi.iwlibs import Wireless, Iwrange, getNICnames

def main():
    ifname = "wlan0"
    wifi = Wireless(ifname)
    try:
        iwrange = Iwrange(wifi.ifname)
    except IOError, (error_number, error_string):
        sys.stderr.write("%s La interface no soporta escaneo.\n" % (
                            wifi.ifname))
    else:
        try:
            results = wifi.scan()
        except IOError, (error_number, error_string):
            if error_number != errno.EPERM:
                if error_number == 100:
                    subprocess.call(["/sbin/ifconfig", ifname, "up"])
                    time.sleep(1)
                    try:
                        results = wifi.scan()
                    except IOError, (error_number, error_string):
                        if error_number != errno.EPERM:
                            sys.stderr.write(
                                "%-8.16s  Interface doesn't support scanning : %s\n\n" %
                                (wifi.ifname, error_string))
                    else:
                        doPrint(results,wifi)
                else:
                    sys.stderr.write(
                        "%s  La interface no soporta escaneo: %s\n" %
                        (wifi.ifname, error_string))
        else:
            doPrint(results,wifi)

def doPrint(r,w):
    if (len(r) == 0):
        print "%s No hay resultados" % (w.ifname, )
    else:
        tx=""
        for ap in r:
            tx=tx+ap.essid+","
        print tx
	
if __name__ == "__main__":
    main()

