#ifndef MAINWINDOW_H
#define MAINWINDOW_H
#include <QtCore>
#include <QMainWindow>
#include <QProgressDialog>
#include <QColorDialog>
#include <QHash>
#include <QFile>
#include <QTextStream>
#include <QMessageBox>
#include <QRegExpValidator>
#include <QRegExp>

namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();

private:
    Ui::MainWindow *ui;
    QProgressDialog progress;
    QProgressDialog progress2;
    QColorDialog colors;
    void readdirs();
    void oldfonts();
    QStringList fonts;
    QHash<QString, QString> variables;
    void readSettings();
    void writeSettings();
    QString f1;
    QString f2;
    QString f3;
    QString f4;
    QString f5;
    QString f6;
    QString f7;
    QString f8;

private slots:
    void on_font8_editingFinished();
    void on_font7_editingFinished();
    void on_fontbuttonpressed_clicked();
    void on_fontbutton_clicked();
    void on_font6_editingFinished();
    void on_font5_editingFinished();
    void on_font4_editingFinished();
    void on_font3_editingFinished();
    void on_font2_editingFinished();
    void on_font1_editingFinished();
    void on_about_triggered();
    void on_fontimport_triggered();
    void on_fontdisabled_2_clicked();
    void on_fontpainted_clicked();
    void on_Snap_editingFinished();
    void on_horizontalSlider_3_valueChanged(int value);
    void on_checkBoxActivate_stateChanged(int );
    void on_lineEdit_2_editingFinished();
    void on_lineEdit_editingFinished();
    void on_horizontalSlider_2_valueChanged(int value);
    void on_fontdisabled_clicked();
    void on_fontactive_clicked();
    void on_fontsecondary_clicked();
    void on_fontprimary_clicked();
    void on_horizontalSlider_valueChanged(int);
    void on_pushButton_clicked();
    void processFinished(int exitCode);
    void process2Finished(int exitCode);
};

#endif // MAINWINDOW_H
