from PyQt4.QtCore import *
from PyQt4.QtGui import *
from xml.dom import minidom
import sys, re, urllib

iconDict = {"tube":"icon-tube.gif", "bus":"icon-buses.gif", "train":"icon-rail.gif", "dlr":"icon-dlr.gif",
            "coach":"icon-coach.gif", "cycle":"icon-cycle.gif", "tram":"icon-trams.gif", "walk":"icon-walk.gif",
            "river":"icon-rivers.gif"}

motLookup = {"99":"walk", "0": "train", "1":"dlr", "2":"tube", "4":"tram", "5":"bus", "7":"coach", "9":"river"}

maemo = True

class JourneyLeg(QMainWindow):
    def __init__(self, parent = None):
        super(JourneyLeg, self).__init__(parent)
        self.vbox = QVBoxLayout()
        
        self.setStyleSheet("QLabel {color:black; font-size: 20pt; background: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 #FFFFFF, stop: 1 #CCFFFF)} \n QListWidget::item:selected {border: 1px solid #6a6ea9; background: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 #FFFFFF, stop: 1 #66FFFF)}")
        self.label = QLabel()
        self.label.setTextFormat(Qt.RichText)
        self.label.setWordWrap(True)
        
        self.vbox.addWidget(self.label)
        #self.vbox.addStretch(1)
        
        self.button = QPushButton()
        self.button.setText("Click for Map (TODO!!)")
        self.vbox.addWidget(self.button)
        
        self.main_frame = QWidget()
        self.main_frame.setLayout(self.vbox)
        self.setCentralWidget(self.main_frame)
        
        self.connect(self.button, SIGNAL("clicked()"), self.loadMap)

    def parseText(self, dom):
        #print dom.toxml()
        infoText = ""
        self.label.setText("Hello")
        
        points = dom.getElementsByTagName("itdPoint")
        self.mapURL = points[0].getElementsByTagName("itdImage")[0].attributes["src"].value
        start = points[0].attributes["name"].value
        end = points[1].attributes["name"].value
        
        time = points[0].getElementsByTagName("itdTime")
        startTime = "%02d:%02d " % \
                    (int(time[0].attributes["hour"].value), int(time[0].attributes["minute"].value))
        time = points[1].getElementsByTagName("itdTime")
        endTime = " %02d:%02d" % \
                    (int(time[0].attributes["hour"].value), int(time[0].attributes["minute"].value))
                    
        duration = dom.attributes["timeMinute"].value
        
        motT = dom.getElementsByTagName("itdMeansOfTransport")
        try:
            motType = motT[0].attributes["motType"].value
        except:
            #no mot means it's a walk....
            motType = "99"
        mot = motLookup[motType]
        if mot == "walk":
            stop = points[0].attributes["platform"].value
            if stop == "":
                text = "Leave %s<br />Walk to %s.<br />Transfer time: %s minutes<br />" % \
                              (start, end, duration)
            else:
                text = "Leave %s stop %s <br />Walk to %s.<br />Transfer time: %s minutes<br />" % \
                              (start, stop, end, duration)
        elif mot == "train":
            trainC = motT[0].attributes["trainName"].value
            text ="%s<br />Take %s at %s towards %s.<br />Average journey Time: %smins<br />" % \
                            (start, trainC, startTime, end, duration)
        elif mot == "bus":
            route = motT[0].attributes["name"].value
            stop = points[0].attributes["platform"].value
            text ="%s<br />Take the Route %s from Stop %s towards %s.<br />Average journey Time: %smins<br />" % \
                            (start, route, stop, end, duration)
        elif mot == "tube":
            try:
                
                motL = dom.getElementsByTagName("itdMeansOfTransportList")
                motT = motL[0].getElementsByTagName("itdMeansOfTransport")
                text ="%s<br />Take the " % start
                for routes in motT:
                    route = routes.attributes["shortname"].value
                    dest = routes.attributes["destination"].value
                    addendum = "%s line towards %s.<br />" % (route, dest)
                    text = text + addendum + "or "
                
                text = text[:-3]
                addendum = "Average journey Time: %smins<br />" % duration
                text = text + addendum
                
                
            except:
                route = motT[0].attributes["shortname"].value
                dest = motT[0].attributes["destination"].value
                text = "%s<br />Take the %s line towards %s.<br />Average journey Time: %smins<br />" % \
                            (start, route, dest, duration)

        else:
            print "todo!!"
                
        try:
            addInfo = dom.getElementsByTagName("infoLink")
            for info in addInfo:
              infoText = "<br />"
              infoLink = info.getElementsByTagName("infoLinkText")
              infoText = infoText + infoLink[0].firstChild.data + "<br />"
        except:
              infoText = ""
                
        infoText = '<span style="color:#ff0000;">%s</span><br />' % (infoText)
        
        self.label.setText(text+infoText)

    def loadMap(self):
        #url = "http://journeyplanner.tfl.gov.uk/user/XSLT_REQUEST?language=en&itdLPxx_src=%s&sessionID=%s" % \
        url = "http://journeyplanner.tfl.gov.uk/user/%s Load Flags[LOAD_DOCUMENT_URI  LOAD_INITIAL_DOCUMENT_URI  ] Content Size[17923] Mime Type[application/pdf]" % \
                  (self.mapURL)
        #print self.parent().parent().sessionID
        #print self.mapURL
        QDesktopServices.openUrl(QUrl(url, QUrl.TolerantMode))


class JourneyDetailsWindow(QMainWindow):
    def __init__(self, uiList, parent = None):
        super(JourneyDetailsWindow, self).__init__(parent)
        self.list = uiList
        self.setStyleSheet("QListWidget::item {border: 1px solid #6a6ea9; background: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 #FFFFFF, stop: 1 #CCFFFF)} \n QListWidget::item:selected {border: 1px solid #6a6ea9; background: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 #FFFFFF, stop: 1 #66FFFF)}")

        self.setCentralWidget(self.list)
        self.partialRoute = []

        self.connect(self.list, SIGNAL("itemClicked(QListWidgetItem*)"), self.clicked)

    def listWidget(self, counter, jTypes, text):
        item = QListWidgetItem()
        itemLabel = JourneyResult(counter, jTypes, text, 15, self)
        item.setSizeHint(itemLabel.sizeHint())
        self.list.addItem(item)
        self.list.setItemWidget(item, itemLabel)
       
    def clicked(self, item):
        self.legDetails = JourneyLeg(self)

        index = int(self.list.itemWidget(item).labelList[0].text()) -1
        self.legDetails.setWindowTitle("Additional Info")
        
        dom = self.partialRoute[index]
        
        self.legDetails.parseText(dom)

        self.legDetails.show()

        try:
            self.legDetails.setAttribute(Qt.WA_Maemo5StackedWindow)
        except:
            maemo = False
            self.legDetails.setGeometry(0,0,800,400)        

    def parseRouteList(self, itdPartialRoute):
        for (counter, routePart) in enumerate(itdPartialRoute):
            self.partialRoute.append(routePart)
            
            points = routePart.getElementsByTagName("itdPoint")
            start = points[0].attributes["name"].value
            end = points[1].attributes["name"].value

            time = points[0].getElementsByTagName("itdTime")
            startTime = "%02d:%02d " % \
                        (int(time[0].attributes["hour"].value), int(time[0].attributes["minute"].value))
            time = points[1].getElementsByTagName("itdTime")
            endTime = " %02d:%02d" % \
                        (int(time[0].attributes["hour"].value), int(time[0].attributes["minute"].value))

            mot = routePart.getElementsByTagName("itdMeansOfTransport")
            try:
                motType = mot[0].attributes["motType"].value
            except:
                #no mot means it's a walk....
                motType = "99"

            self.listWidget(counter, [motLookup[motType]], [startTime+start, " --- ",end+endTime])

class JourneyResult(QWidget):
    def __init__(self, counter, journeyList, textList, font, parent = None):
        super(JourneyResult, self).__init__(parent)
        self.hbox = QHBoxLayout()

        self.labelList = []
        self.labelList.append(QLabel())
        self.labelList[0].setText(str(counter+1))
        self.labelList[0].setMinimumHeight(70)
        self.labelList[0].setStyleSheet("QLabel {color:black; font-size: %spt }"%font)
        self.hbox.addWidget(self.labelList[0])

        for jType in journeyList:
            pic = QLabel()
            pic.setPixmap(QPixmap(iconDict[jType]))
            self.hbox.addWidget(pic)

        for text in textList:
            self.labelList.append(QLabel())
            self.labelList[-1].setText(str(text))
            self.labelList[-1].setMinimumHeight(70)
            self.labelList[-1].setStyleSheet("QLabel {color:black; font-size: %spt }"%font)

            self.hbox.addWidget(self.labelList[-1])

        self.hbox.addStretch(1)

        self.setLayout(self.hbox)

    def setText(self, label, text):
        label.setText(str(text))
        
class CreateListView(QMainWindow):
    def __init__(self, uiList, parent = None):
        super(CreateListView, self).__init__(parent)
        self.vbox = QVBoxLayout()
                
        self.list = uiList
        #self.setStyleSheet("QListWidget {background:white; show-decoration-selected: 1; alternate-background-color: yellow;}")
        self.setStyleSheet("QListWidget::item {border: 1px solid #6a6ea9; background: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 #FFFFFF, stop: 1 #CCFFFF)} \n QListWidget::item:selected {border: 1px solid #6a6ea9; background: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 #FFFFFF, stop: 1 #66FFFF)}")


        self.vbox.addWidget(self.list)
        #self.vbox.addStretch(1)
        
        self.button = QPushButton()
        self.button.setText("More Results...")
        self.vbox.addWidget(self.button)
        
        self.main_frame = QWidget()
        self.main_frame.setLayout(self.vbox)
        self.setCentralWidget(self.main_frame)

        self.connect(self.list, SIGNAL("itemClicked(QListWidgetItem*)"), self.clicked)
        self.connect(self.button, SIGNAL("clicked()"), self.fetchMoreResults)
        self.routearray = []

    def listWidget(self, counter, jTypes, text):
        item = QListWidgetItem()
        itemLabel = JourneyResult(counter, jTypes, text, 25, self)
        item.setSizeHint(itemLabel.sizeHint())
        self.list.addItem(item)
        self.list.setItemWidget(item, itemLabel)
       
    def clicked(self, item):
        #self.list.itemWidget(item).setText(self.list.itemWidget(item).label, "clicked")
        try:
            self.setAttribute(Qt.WA_Maemo5ShowProgressIndicator )
            maemo = True
        except:
            maemo = False;
            print "not maemo"

        listjDetails = QListWidget()
        self.jDetails = JourneyDetailsWindow(listjDetails, self)

        if(maemo):
            self.jDetails.setAttribute(Qt.WA_Maemo5StackedWindow)

        index = int(self.list.itemWidget(item).labelList[0].text()) -1
        self.jDetails.setWindowTitle("Details of Route %s"% str(index+1))
        dom = self.routearray[index]
        
        self.jDetails.parseRouteList(dom)

        self.jDetails.show()
        if(maemo):
            self.setAttribute(Qt.WA_Maemo5ShowProgressIndicator, False )
        else:
            self.jDetails.setGeometry(0,0,800,400)
        
    def routeParse(self, url):
        routelist = []
        startTime = None
        dom = minidom.parse(url)
        
        req = dom.getElementsByTagName("itdRequest")
        self.sessionID = req[0].attributes["sessionID"].value
        
        self.options = dom.getElementsByTagName("itdRoute")

        for (counter, routes) in enumerate(self.options):
            duration = "Duration: "+routes.attributes["publicDuration"].value
            prouteList = routes.getElementsByTagName("itdPartialRouteList")
            routePart = prouteList[0].getElementsByTagName("itdPartialRoute")
            self.routearray.append(routePart)
            
            if startTime == None:
                time = routePart[0].getElementsByTagName("itdTime")
                startTime = "Depart: %02d:%02d" % \
                            (int(time[0].attributes["hour"].value), int(time[0].attributes["minute"].value))

            for parts in routePart:
                mot = parts.getElementsByTagName("itdMeansOfTransport")
                try:
                    motType = mot[0].attributes["motType"].value
                except:
                    #no mot means it's a walk....
                    motType = "99"

                routelist.append(motLookup[motType])

            self.listWidget(counter, routelist, [startTime, " --- ",duration])
            routelist = []
            startTime = None
            
    def fetchMoreResults(self):
        print "clicked"
        self.parent().fetchMoreResults(self.sessionID)
        self.deleteLater()


if __name__ == "__main__":
    app = QApplication(sys.argv)

    listWidget = QListWidget()
    journeyResults = CreateListView(listWidget)
    journeyResults.setGeometry(0,0,800,400)
    journeyResults.setWindowTitle("Journey Planner")
    #listWidget.setStyleSheet("QListWidget {background-color:white}")

    journeyResults.routeParse("test.xml")
    journeyResults.show()


    sys.exit(app.exec_())

