﻿#!/usr/bin/env python
# -*- coding: utf-8 -*-

from PyQt4 import QtGui, QtCore
from xml.dom import minidom
import urllib
import sys
from tubestatus import *
from tubemap import *
from tflapp_mainwindow import *
from tfloptions import *
import location

CURRENTVERSION = "0.1.2"

GOOG_TRANS_P1 = "http://maps.google.com/m/directions?dirflg=r&hl=en&saddr="
GOOG_TRANS_P2 = "&daddr="
GOOG_TRANS_P3 = "&dirflg=r"


class TflAppMain(QtGui.QMainWindow):
    tfl_params = {'language' : 'en', 'sessionID' : 0, 'requestID' : 0, 'ptOptionsActive' : 1,'itOptionsActive' : 1, 'imparedOptionsActive' : 1, 'ptAdvancedOptions' : 1, 'advOptActive_2' : 1, 'advOpt_2' : 1, 'execInst' : 'normal', 'command' : '', 'itdLPxx_request' : '', 'itdLPxx_view' : '', 'itdLPxx_tubeMap' : '', 'calculateDistance' : 1, 'name_origin' : '', 'nameState_origin' : 'notidentified', 'nameDefaultText_origin' : 'start', 'place_origin' : 'London', 'type_origin' : 'locator', 'name_destination' : 'NW12DB', 'nameState_destination' : 'notidentified', 'nameDefaultText_destination' : 'end', 'place_destination' : 'London', 'type_destination' : 'locator', 'itdTripDateTimeDepArr' : 'dep', 'Submit' : 'Search', 'routeType' : 'LEASTTIME', 'name_via' : 'Enter+location+(optional)', 'nameState_via' : 'notidentified', 'nameDefaultText_via' : 'Enter+location+(optional)', 'type_via' : 'stop', 'place_via' : 'London', 'placeDefaultText_via' : 'London', 'includedMeans' : 'checkbox', 'inclMOT_11' : 1, 'inclMOT_0' : 'on', 'inclMOT_1' : 'on', 'inclMOT_2' : 'on', 'inclMOT_4' : 'on', 'inclMOT_5' : 'on', 'inclMOT_7' : 'on', 'inclMOT_9' : 'on', 'trITMOTvalue101' : '60', 'trITMOTvalue' : 20, 'trITMOT' : 100, 'changeSpeed' : 'Fast'}

    def __init__(self, parent=None):
        #build parent user interface
        QtGui.QWidget.__init__(self, parent)
        self.ui = Ui_MainWindow()
        self.ui.setupUi(self)

        self.setup_settings()
        self.load_settings()

        self.tflstatus = TflStatus(self.settings, self)
        self.tubemap = TubeMapDisplay(self)
        self.tfloptions = TflOptionsDisplay(self.settings, self)
        self.setAttribute(QtCore.Qt.WA_Maemo5StackedWindow)
        self.tflstatus.setAttribute(QtCore.Qt.WA_Maemo5StackedWindow )
        self.tubemap.setAttribute(QtCore.Qt.WA_Maemo5StackedWindow )
        self.tfloptions.setAttribute(QtCore.Qt.WA_Maemo5StackedWindow)



        QtCore.QObject.connect(self.ui.pushButtonOpenStatus, QtCore.SIGNAL('clicked()'), self.doOpenStatusWindow)
        QtCore.QObject.connect(self.ui.pushButtonNavHome, QtCore.SIGNAL('clicked()'), self.doGetmeHome)
        QtCore.QObject.connect(self.ui.pushButtonTubeMap, QtCore.SIGNAL('clicked()'), self.showTubeMap)
        QtCore.QObject.connect(self.ui.pushButtontflOptions, QtCore.SIGNAL('clicked()'), self.showTflOptions)
        QtCore.QObject.connect(self.ui.lineEditHomePC, QtCore.SIGNAL('returnPressed()'), self.saveHome)
        QtCore.QObject.connect(self.ui.actionAbout, QtCore.SIGNAL('triggered()'), self.showAbout)


    def setup_settings(self):
        settings = QtCore.QSettings()
        QtCore.QCoreApplication.setOrganizationName('gman.me.uk')
        QtCore.QCoreApplication.setOrganizationDomain('gman.me.uk')
        QtCore.QCoreApplication.setApplicationName('Tfl App')
        self.settings = settings

    def load_settings(self):
        try:
            # load the save file into a temp dict
            self.dest = self.settings.value("home_Pcode").toString()
        except:
            print "firstRun... no Savefile found"
            
        if(self.dest == ""):
            self.dest = "EC1R4TN" #Sadlers Wells

        self.ui.lineEditHomePC.setText(self.dest)
        
        try:
            self.tfl_params = cPickle.loads(str(self.settings.value("tfl_params").toString()))
        except:
            print "no saved journey config found"
            
    def doOpenStatusWindow(self):
        self.tflstatus.show()
        self.tflstatus.showFullScreen()

        # Just get the UI to display before we start churning
        QtCore.QTimer.singleShot(0, self.tflstatus, QtCore.SLOT('doStuff()'));
        

    def doGetmeHome(self):
        """
        self.tfl_params['name_origin'] = 'SW184HL'
        self.tfl_params['name_destination'] = 'NW12DB'
        params = urllib.urlencode(self.tfl_params)
        finalUrl = "http://journeyplanner.tfl.gov.uk/user/XSLT_TRIP_REQUEST2?%s" % params
        QtGui.QDesktopServices.openUrl(QtCore.QUrl(finalUrl, QtCore.QUrl.TolerantMode))
        
        """
        self.showBusyIndicator()
        currentLoc = self.getCurrentPCode()
        self.progress.repaint()

        #check if current position is within London. If so, check if the destination is within London
        if( (51.286829 <= self.curLocLat <= 51.69232322) and (-0.510350 <= self.curLocLong <= 0.334030) ):
            destInLondon = self.checkDestInLond(self.dest)

        self.progress.destroy(True, True)

        if( currentLoc != ""):
          self.dest = self.ui.lineEditHomePC.text()
          #self.progress.setLabelText("Opening Journey Planner in external Browser")
          print "start: " + currentLoc +  "& dest:" + self.dest
          #If current loc and dest are in london, use tfl; else use google transit
          if( (51.286829 <= self.curLocLat <= 51.69232322) and (-0.510350 <= self.curLocLong <= 0.334030) and destInLondon ):
              self.tfl_params['name_origin'] = currentLoc
              self.tfl_params['name_destination'] = self.dest
              params = urllib.urlencode(self.tfl_params)
              finalUrl = "http://journeyplanner.tfl.gov.uk/user/XSLT_TRIP_REQUEST2?%s" % params

          else:
              os.system('dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"Start or destination is outside London. Maybe the Google gods can help instead"')

              finalUrl = GOOG_TRANS_P1 + currentLoc + GOOG_TRANS_P2 + self.dest + GOOG_TRANS_P3

          QtGui.QDesktopServices.openUrl(QtCore.QUrl(finalUrl, QtCore.QUrl.TolerantMode))


    def getCurrentPCode(self):
        self.progress.setLabelText("Getting approx location via cellID")
        self.getCurrentLoc()
        # check if recieved lat/long is within london's bounding box
        # from: http://isithackday.com/geoplanet-explorer/index.php?woeid=23416974
        #if( (51.286829 <= self.curLocLat <= 51.69232322) and (-0.510350 <= self.curLocLong <= 0.334030) ):
        if( (49.871159 <= self.curLocLat <= 55.811741) and (-6.379880 <= self.curLocLong <= 1.768960) ):
            self.progress.setLabelText("Geolocating postcode")
            pCode = self.doPCodeLocConv()
        else:
            infoText = "Sorry, but it appears that you're outside England. This app is not designed to work outside the UK\n This limitation may be removed at a later stage"
            QtGui.QMessageBox.information(self, "Whoops", infoText)
            pCode = ""
        
        return pCode

    def getCurrentLoc(self):
        control = location.GPSDControl.get_default()
        device = location.GPSDevice()
        control.set_properties(preferred_method=location.METHOD_ACWP,
                       preferred_interval=location.INTERVAL_DEFAULT)


        self.loop = gobject.MainLoop()
        control.connect("error-verbose", self.on_error, self.loop)
        device.connect("changed", self.on_changed, control)
        control.connect("gpsd-stopped", self.on_stop, self.loop)
        gobject.idle_add(self.start_location, control)

        self.loop.run()


    def doPCodeLocConv(self):
        openConn = ConnMan()
        openConn.startConnMan()

        url = "http://www.uk-postcodes.com/latlng/" + str(self.curLocLat) + "," + str(self.curLocLong) + ".xml"

        response = minidom.parse(urllib.urlopen(url))
        postcodeNode = response.getElementsByTagName('postcode')
        print "xml parsed response " + str(postcodeNode[0].firstChild.data)

        return str(postcodeNode[0].firstChild.data)

    def checkDestInLond(self, dest):
        url = "http://www.uk-postcodes.com/postcode/" + str(dest) + ".xml"

        response = minidom.parse(urllib.urlopen(url))
        latNode = response.getElementsByTagName('lat')
        lngNode = response.getElementsByTagName('lng')

        lat = float(latNode[0].firstChild.data)
        lng = float(lngNode[0].firstChild.data)

        if( (51.286829 <= lat <= 51.69232322) and (-0.510350 <= lng <= 0.334030) ):
            print "Destination is withn London"
            return True
        else:
            print "Destination is outside London"
            return False


    def showTflOptions(self):
        self.tfloptions.show()
        
    def showTubeMap(self):
        # Show busy indicator as the initial display seems to chug
        self.setAttribute(QtCore.Qt.WA_Maemo5ShowProgressIndicator )
        self.tubemap.setupWindow()
        self.tubemap.show()
        self.setAttribute(QtCore.Qt.WA_Maemo5ShowProgressIndicator, False )
        return

    #Note that this is only ever triggered if the user hits "return" on the keyboard
    def saveHome(self):
        print "saving settings"
        self.settings.setValue("home_Pcode", self.ui.lineEditHomePC.text() )


    def showBusyIndicator(self):
        self.progress = QtGui.QProgressDialog(self)
        self.progress.setWindowModality(QtCore.Qt.WindowModal)
        self.progress.setAutoReset(True)
        self.progress.setAutoClose(True)
        self.progress.setMinimum(0)
        self.progress.setMaximum(0)
        self.progress.resize(800,100)
        self.progress.setWindowTitle("Hang on....")
        self.progress.setLabelText("Initial setup")
        self.progress.show()



    def showAbout(self):
        aboutString = "Tfl App: v" + CURRENTVERSION + "\nGirish Gopi (maemo@gman.me.uk)\nMany thanks to all of t.m.o (& w.m.o) and the gaffa"
        QtGui.QMessageBox.information(self, "About Tfl App", aboutString)



#
# Copied pretty much verbatim from http://wiki.maemo.org/PyMaemo/Using_Location_API
#

    def on_error(self, control, error, data):
        print "location error: %d... quitting" % error
        data.quit()

    def on_changed(self, device, data):
        print "changed:"
        if not device:
            return
        if device.fix:
            if device.fix[1] & location.GPS_DEVICE_LATLONG_SET:
                print "lat = %f, long = %f" % device.fix[4:6]
                if((device.fix[4] != 55.3) and (device.fix[5] != 0) ):
                  self.curLocLat = device.fix[4]
                  self.curLocLong = device.fix[5]
                  data.stop()

    def on_stop(self, control, data):
        print "quitting"
        data.quit()

    def start_location(self, data):
        data.start()
        return False

if __name__ == "__main__":
    app = QtGui.QApplication(sys.argv)
    
    tflapp = TflAppMain()
    tflapp.show()
    #hildon.hildon_gtk_window_take_screenshot(tflapp.ui, True)
    sys.exit(app.exec_())
