﻿#!/usr/bin/env python
# -*- coding: utf-8 -*-

from PyQt4 import QtGui, QtCore
from tubestatus import *
from tubemap import *
from tflapp_mainwindow import *
import location

PLANNER_URL_PART1 = "http://journeyplanner.tfl.gov.uk/user/XSLT_TRIP_REQUEST2?language=en&sessionID=0&requestID=0&ptOptionsActive=1&itOptionsActive=1&imparedOptionsActive=1&ptAdvancedOptions=1&advOptActive_2=1&advOpt_2=1&execInst=normal&command=&itdLPxx_request=&itdLPxx_view=&itdLPxx_tubeMap=&calculateDistance=1&name_origin="
PLANNER_URL_PART2 = "&nameState_origin=notidentified&nameDefaultText_origin=start&place_origin=London&type_origin=locator&name_destination="
PLANNER_URL_PART3 ="&nameState_destination=notidentified&nameDefaultText_destination=end&place_destination=London&type_destination=locator&itdTripDateTimeDepArr=dep&Submit=Search&routeType=LEASTTIME&name_via=Enter+location+(optional)&nameState_via=notidentified&nameDefaultText_via=Enter+location+(optional)&type_via=stop&place_via=London&placeDefaultText_via=London&includedMeans=checkbox&inclMOT_11=1&inclMOT_0=on&inclMOT_1=on&inclMOT_2=on&inclMOT_4=on&inclMOT_5=on&inclMOT_7=on&inclMOT_9=on&trITMOTvalue101=60&trITMOTvalue=20&trITMOT=100&changeSpeed=Fast"


class TflAppMain(QtGui.QMainWindow):
    def __init__(self, parent=None):
        #build parent user interface
        QtGui.QWidget.__init__(self, parent)
        self.ui = Ui_MainWindow()
        self.ui.setupUi(self)

        self.tflstatus = TflStatus(self)
        self.tubemap = TubeMapDisplay(self)
        self.setAttribute(QtCore.Qt.WA_Maemo5StackedWindow)
        self.tflstatus.setAttribute(QtCore.Qt.WA_Maemo5StackedWindow )
        self.tubemap.setAttribute(QtCore.Qt.WA_Maemo5StackedWindow )



        QtCore.QObject.connect(self.ui.pushButtonOpenStatus, QtCore.SIGNAL('clicked()'), self.doOpenStatusWindow)
        QtCore.QObject.connect(self.ui.pushButtonNavHome, QtCore.SIGNAL('clicked()'), self.doGetmeHome)
        QtCore.QObject.connect(self.ui.pushButtonTubeMap, QtCore.SIGNAL('clicked()'), self.showTubeMap)

    def doOpenStatusWindow(self):
        self.tflstatus.show()
        self.tflstatus.showFullScreen()

        # Just get the UI to display before we start churning
        QtCore.QTimer.singleShot(0, self.tflstatus, QtCore.SLOT('doStuff()'));
        

    def doGetmeHome(self):
        currentLoc = self.getCurrentPCode()
        dest = self.ui.lineEditHomePC.text()
        finalUrl = PLANNER_URL_PART1 + currentLoc + PLANNER_URL_PART2 + dest + PLANNER_URL_PART3
        QtGui.QDesktopServices.openUrl(QtCore.QUrl(finalUrl, QtCore.QUrl.TolerantMode))

    def getCurrentPCode(self):
        self.getCurrentLoc()
        pCode = self.getCurrentPCodeFromLoc()
        os.popen('dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"NOT FULLY IMPLEMENTED - Just a test route for now"')

        return pCode

    def getCurrentLoc(self):
        control = location.GPSDControl.get_default()
        device = location.GPSDevice()
        control.set_properties(preferred_method=location.METHOD_ACWP,
                       preferred_interval=location.INTERVAL_DEFAULT)


        self.loop = gobject.MainLoop()
        control.connect("error-verbose", self.on_error, self.loop)
        device.connect("changed", self.on_changed, control)
        control.connect("gpsd-stopped", self.on_stop, self.loop)
        gobject.idle_add(self.start_location, control)

        self.loop.run()


    def getCurrentPCodeFromLoc(self):
        return "NW1 2DB"

    def showTubeMap(self):
        self.tubemap.setupWindow()
        self.tubemap.show()
        return



    def on_error(self, control, error, data):
        print "location error: %d... quitting" % error
        data.quit()

    def on_changed(self, device, data):
        print "changed:"
        if not device:
            return
        if device.fix:
            if device.fix[1] & location.GPS_DEVICE_LATLONG_SET:
                print "lat = %f, long = %f" % device.fix[4:6]
                self.curLocLat = device.fix[4]
                self.curLocLong = device.fix[6]
                data.stop()

    def on_stop(self, control, data):
        print "quitting"
        data.quit()

    def start_location(self, data):
        data.start()
        return False

if __name__ == "__main__":
    app = QtGui.QApplication(sys.argv)
    
    tflapp = TflAppMain()
    tflapp.show()
    
    sys.exit(app.exec_())
