﻿#!/usr/bin/env python
# -*- coding: utf-8 -*-

import urllib
import sys
import os, time, cPickle
import threading
from xml.dom import minidom
from tubestatus_gui import *
from PyQt4 import QtGui, QtCore

import conic
import dbus
import gobject
import dbus.glib

TUBESTATUS_URL = 'http://api.tubeupdates.com/?method=get.status&lines=all&format=xml'
CACHE_TIMEOUT = 300

url = TUBESTATUS_URL


class TflForm(QtGui.QMainWindow):

    tubeStatus_list = {}
    tubeMessages_list = {}
    tubeStatus_list_test = {"Jubilee" : "part closure", "Bakerloo" : "good service", "Central" : "good service", 
			    "Metropolitan" : "part closure", "District" : "part closure", "Piccadilly" : "part closure", 
			    "Overground" : "good service", "Victoria" : "good service", "DLR": "part closure", 
			    "Waterloo & City" : "good service", "Northern" : "part closure", "Circle" : "planned closure", 
			    "H'smith & City" : "part closure" }

    tubeColour_list = {"Jubilee" : "grey", "Bakerloo" : "brown", "Central" : "red", 
			    "Metropolitan" : "purple", "District" : "green", "Piccadilly" : "darkblue", 
			    "Overground" : "orange", "Victoria" : "lightblue", "DLR": "white", 
			    "Waterloo & City" : "turquoise", "Northern" : "black", "Circle" : "yellow", 
			    "H'smith & City" : "pink" }

    def __init__(self, parent=None):
        #build parent user interface
        QtGui.QWidget.__init__(self, parent)
        self.ui = Ui_MainWindow()
        self.ui.setupUi(self)
        QtCore.QObject.connect(self.ui.pushButtonQuit, QtCore.SIGNAL('clicked()'), QtGui.qApp, QtCore.SLOT('quit()'))

    @QtCore.pyqtSlot()
    def doStuff(self):
        print "it begins!"
        self.showBusyIndicator()
        self.setup_settings()
        self.load_settings()
        
        labelList = self.ui.centralwidget.findChildren(QtGui.QLabel)
        statusList = self.ui.centralwidget.findChildren(QtGui.QLineEdit)

        self.progress.setLabelText("Checking last update")
        
        if( (time.time() - self.lastUpdate) > CACHE_TIMEOUT ):
	    counter = 0;
	    for names in self.tubeColour_list.keys():
		labelList[counter].setText(str(names))
		statusList[counter].setText("Connecting...")
		labelList[counter].setAutoFillBackground(True)
		labelList[counter].setPalette(QtGui.QPalette(QtGui.QColor(self.tubeColour_list[names])))
		counter += 1
            
	    self.progress.setLabelText("Checking internet connectivity")
	    print "start conn manager"
	    self.loop = gobject.MainLoop()
	    self.bus = dbus.SystemBus(private=True)
	    self.connection = self.connStatus_start()
	    self.loop.run()

	    if (self.connStatus != "CONNECTED"):
	        self.progress.setLabelText("Connecting to default IAP")
		self.loop = gobject.MainLoop()
		self.bus = dbus.SystemBus(private=True)
		gobject.idle_add(self.connectNew)
		self.loop.run()

	    self.getStatus()

        counter = 0;
        for names in self.tubeStatus_list.keys():
	    self.progress.setLabelText("Updating GUI")
	    labelList[counter].setText(str(names))
	    statusList[counter].setText(str(self.tubeStatus_list[names]))
            labelList[counter].setAutoFillBackground(True)
            labelList[counter].setPalette(QtGui.QPalette(QtGui.QColor(self.tubeColour_list[names])))
	    counter += 1

        self.progress.destroy(True, True)

	counter = 0;
	for names in self.tubeColour_list.keys():
	    labelList[counter].setContextMenuPolicy(QtCore.Qt.CustomContextMenu)
	    QtCore.QObject.connect(labelList[counter], QtCore.SIGNAL("customContextMenuRequested(const QPoint)"), self.contextMenu)
	    counter += 1



    def contextMenu(self, pos):
      callerLabel = self.sender()
      try:
	additionalText = self.tubeMessages_list[str(callerLabel.text())]
      except:
	additionalText = "No further info for this line"
      QtGui.QMessageBox.information(self, "Additional Info for " + callerLabel.text() + " Line", additionalText)

    def showBusyIndicator(self):
        self.progress = QtGui.QProgressDialog(self)
        self.progress.setWindowModality(QtCore.Qt.WindowModal)
        self.progress.setAutoReset(True)
        self.progress.setAutoClose(True)
        self.progress.setMinimum(0)
        self.progress.setMaximum(0)
        self.progress.resize(800,100)
        self.progress.setWindowTitle("Hang on....")
        self.progress.setLabelText("Initial setup")
        self.progress.show()


    def setup_settings(self):
        settings = QtCore.QSettings()
        QtCore.QCoreApplication.setOrganizationName('gman.me.uk')
        QtCore.QCoreApplication.setOrganizationDomain('gman.me.uk')
        QtCore.QCoreApplication.setApplicationName('Tube Status')
        self.settings = settings

    def load_settings(self):
        # check to see if there is a save file
        self.lastUpdate = 0

        try:
            # load the save file into a temp dict
            self.tubeStatus_list = cPickle.loads(str(self.settings.value("tubeStatus_list").toString()))
            temp = cPickle.loads(str(self.settings.value("tubeMessages_list").toString()))
            if(temp):
	      self.tubeMessages_list = temp
            self.lastUpdate = cPickle.loads(str(self.settings.value("Update Time").toString()))
        except:
            print "firstRun... no Savefile found"
	
	
    def getStatus(self):
        if( (time.time() - self.lastUpdate) > CACHE_TIMEOUT ):
	    print "refresh cache"
	    self.progress.setLabelText("Getting current status")
	    response = minidom.parse(urllib.urlopen(url))
	    lineNode = response.getElementsByTagName('line')
	    for nodes in range(lineNode.length):
		names = lineNode[nodes].getElementsByTagName('name')
		status = lineNode[nodes].getElementsByTagName('status')
		messageNode = lineNode[nodes].getElementsByTagName('messages')
		fullMessage = ""
		for messages in range(messageNode.length):
		    message = messageNode[messages].getElementsByTagName('name')
		    if(message):
			#self.tubeMessages_list[names[0].firstChild.data] = self.tubeMessages_list[names[0].firstChild.data] + "\n" + message[0].firstChild.data
			fullMessage = fullMessage + "\n" + message[0].firstChild.data
		if (fullMessage != ""):
		  self.tubeMessages_list[names[0].firstChild.data] = fullMessage
		print names[0].firstChild.data + " : " + fullMessage
		self.tubeStatus_list[names[0].firstChild.data] = status[0].firstChild.data

            self.progress.setLabelText("Saving refreshed values")
	    saveData = cPickle.dumps(self.tubeStatus_list)
	    saveMsgData = cPickle.dumps(self.tubeMessages_list)
	    currentTime = cPickle.dumps(time.time())
	    self.settings.setValue("tubeStatus_list", saveData)
	    self.settings.setValue("tubeMessages_list", saveMsgData)
	    self.settings.setValue("Update Time", currentTime)
 

    def connStatus_cb(self, connection, event):
      print "connection_cb(%s, %s)" % (connection, event)
      
      status = event.get_status()
      error = event.get_error()
      iap_id = event.get_iap_id()
      bearer = event.get_bearer_type()
      
      if status == conic.STATUS_CONNECTED:
	  print "1: (CONNECTED (%s, %s, %i, %i)" % (iap_id, bearer, status, error)
      elif status == conic.STATUS_DISCONNECTED:
	  print "1: (DISCONNECTED (%s, %s, %i, %i)" % (iap_id, bearer, status, error)
      elif status == conic.STATUS_DISCONNECTING:
	  print "1: (DISCONNECTING (%s, %s, %i, %i)" % (iap_id, bearer, status, error)



    def connStatus_start(self):
	connection = conic.Connection()
	connection.connect("connection-event", self.connStatus_cb)
	connection.set_property("automatic-connection-events", True)
	
	return connection

	
    def connStatus_stop(self, connection, loop):
	connection.set_property("automatic-connection-events", False)
	loop.quit()
	

    def connStatus_cb(self, connection, event):
	print "connection_cb(%s, %s)" % (connection, event)
	
	status = event.get_status()
	error = event.get_error()
	iap_id = event.get_iap_id()
	bearer = event.get_bearer_type()
	
        if status == conic.STATUS_CONNECTED:
	    print "1: (CONNECTED (%s, %s, %i, %i)" % (iap_id, bearer, status, error)
	    self.connStatus = "CONNECTED"
	    self.connStatus_stop(connection, self.loop)
	elif status == conic.STATUS_DISCONNECTED:
	    print "1: (DISCONNECTED (%s, %s, %i, %i)" % (iap_id, bearer, status, error)
	    self.connStatus = "DISCONNECTED"
	    self.loop.quit()
	elif status == conic.STATUS_DISCONNECTING:
	    print "1: (DISCONNECTING (%s, %s, %i, %i)" % (iap_id, bearer, status, error)
	    self.connStatus = "DISCONNECTING"
	    self.loop.quit()
	    
    def connectNew(self):
	magic = 0xAA55

	# Creates the connection object and attach the handler.
	connection = conic.Connection()
	connection.connect("connection-event", self.connStatus_cb, magic)
	
	# The request_connection method should be called to initialize
	# some fields of the instance
	assert(connection.request_connection(conic.CONNECT_FLAG_NONE))

	return False

if __name__ == "__main__":
    app = QtGui.QApplication(sys.argv)
    myapp = TflForm()
    myapp.show()
    myapp.showFullScreen()

    # Just get the UI to display before we do all this
    #QtCore.QTimer.singleShot(100, self, QtCore.SLOT('doStuff()'));
    QtCore.QTimer.singleShot(0, myapp, QtCore.SLOT('doStuff()'));

    sys.exit(app.exec_())
