#ifndef THUMBNAILLOADER_H
#define THUMBNAILLOADER_H

#include <QDeclarativeItem>
#include "thumbnailjob.h"
#include "webpreviewelem.h"

class webPreviewElem;

class ThumbnailLoader : public QDeclarativeItem
{
    Q_OBJECT
    Q_PROPERTY(int queued READ getQueued NOTIFY queuedChanged);
    Q_PROPERTY(int active READ getActive NOTIFY activeChanged);
    Q_PROPERTY(int concurrency READ getConcurrency WRITE setConcurrency);
//    Q_PROPERTY(int count READ getCount NOTIFY countChanged);
public:
    explicit ThumbnailLoader(QDeclarativeItem *parent = 0);

    int     getQueued() const;
    int     getActive() const;
    int     getConcurrency() const;

    void    setConcurrency(int);
    void    loadThumbnail(webPreviewElem *);


signals:
    void    queuedChanged();
    void    activeChanged();

public slots:
    void    jobDone(thumbnailJob *);
private :
    int     thumbQueue;
    int     thumbActive;
    int     thumbConcurrency;

    QList<thumbnailJob *>   loadedJobs;
    QList<thumbnailJob *>   queuedJobs;

    void    checkThumbnailState(webPreviewElem *, thumbnailJob *);
    void    process();

};

#endif // THUMBNAILLOADER_H
