#include "thumbnailloader.h"

ThumbnailLoader::ThumbnailLoader(QDeclarativeItem *parent) :
    QDeclarativeItem(parent)
{
    this->thumbQueue = 0;
    this->thumbActive = 0;
    this->thumbConcurrency = 2;
}

int     ThumbnailLoader::getQueued() const
{
    return this->thumbQueue;
}

int     ThumbnailLoader::getActive() const
{
    return this->thumbActive;
}

int     ThumbnailLoader::getConcurrency() const
{
    return this->thumbConcurrency;
}

void    ThumbnailLoader::setConcurrency(int a)
{
    this->thumbConcurrency = a;
}

void    ThumbnailLoader::process()
{
    while (this->queuedJobs.count() > 0 &&
           this->thumbActive < this->thumbConcurrency)
    {
        thumbnailJob *j = this->queuedJobs.takeFirst();
        QObject::connect(j, SIGNAL(jobDone(thumbnailJob*)), this, SLOT(jobDone(thumbnailJob*)));
        this->loadedJobs.append(j);
        this->thumbActive++;
        emit (activeChanged());
        j->startJob(256, 256);
    }
}

void    ThumbnailLoader::loadThumbnail(webPreviewElem *w)
{
    foreach(thumbnailJob * job, this->loadedJobs)
    {
        if (job->getUrl() == w->getUrl())
        {
            this->checkThumbnailState(w, job);
            return ;
        }
    }
    foreach(thumbnailJob * job, this->queuedJobs)
    {
        if (job->getUrl() == w->getUrl())
        {
            this->checkThumbnailState(w, job);
            return ;
        }
    }
    thumbnailJob * job = new thumbnailJob(w->getUrl());
    this->checkThumbnailState(w, job);
    this->queuedJobs.append(job);
    this->process();
}

void    ThumbnailLoader::checkThumbnailState(webPreviewElem *w, thumbnailJob *j)
{
    switch(j->getState())
    {
    case thumbnailJob::Loaded:
    {
        w->finished(j->getPixmap());
        break;
    }
    case thumbnailJob::Error:
    {
        w->error();
        break;
    }
    default:
    {
        QObject::connect(j, SIGNAL(started()), w, SLOT(started()));
        QObject::connect(j, SIGNAL(progress(int)), w, SLOT(progress(int)));
        QObject::connect(j, SIGNAL(finished(const QPixmap&)), w, SLOT(finished(const QPixmap &)));
        QObject::connect(j, SIGNAL(error()), w, SLOT(error()));
    }
    }
}

void    ThumbnailLoader::jobDone(thumbnailJob *j)
{
    QObject::disconnect(j, SIGNAL(jobDone(thumbnailJob*)), this, SLOT(jobDone(thumbnailJob*)));
    this->thumbActive--;
    emit (activeChanged());
    this->process();
}
