#ifndef THUMBNAILJOB_H
#define THUMBNAILJOB_H

#include <QObject>
#include <QPixmap>
#include <QUrl>
#include <QImage>
#include <QPainter>
#include <QtWebKit/QWebPage>
#include <QtWebKit/QWebFrame>

class thumbnailJob : public QObject
{
    Q_OBJECT
public :
    explicit thumbnailJob(QUrl url, QObject *parent = 0);
    ~thumbnailJob();

    enum State
    {
        Queued,
        Loading,
        Loaded,
        Error
    };

    QUrl        getUrl() const;
    const QPixmap&     getPixmap() const;
    int         getState()  const;
    void        startJob(int, int);

private :
    QUrl        curUrl;
    int         curState;
    QWebPage    *netPage;
    QPixmap     pixImg;

signals:
    void        started();
    void        progress(int);
    void        finished(const QPixmap&);
    void        error();
    void        jobDone(thumbnailJob *);

public slots:
    void        pageLoadFinished(bool);
};

#endif // THUMBNAILJOB_H
